//
//	VidyoClientDispatcher.js
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

var VidyoClientLib;
(function (VidyoClientLib) {
	var VidyoClient = (function (plugInDivId, onStatus){
		function VidyoClient(plugInDivId, onStatus)
		{
			var contextObj = this;

			this.CreateVidyoCalendarManager = function(feedback) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('feedback')){
						var params = vcUtilsParam({calendarMgr: this.objId, feedback: (arguments[0].feedback ? arguments[0].feedback.objId : 0)});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['feedback'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
					var params = vcUtilsParam({calendarMgr: this.objId, feedback: (arguments[0] ? arguments[0].objId : 0)});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoCalendarManager = new contextObj.VidyoCalendarManager(response.data.VidyoCalendarManager);	// copy construct
						objects[vidyoCalendarManager.objId] = vidyoCalendarManager;
						resolve(vidyoCalendarManager);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoCalendarManagerConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoCalendarManager = function(feedback) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoCalendarManager"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('feedback')){
							var params = vcUtilsParam({calendarMgr: this.objId, feedback: (arguments[0].feedback ? arguments[0].feedback.objId : 0)});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['feedback'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({calendarMgr: this.objId, feedback: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoCalendarManagerConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoCalendarManager);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoCalendarManagerDestruct?" + vcUtilsParam({ calendarMgr: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Creates a VidyoCalendar which is returned through VidyoCalendarManagerFeedbackCalendarCreated. Will be identifiable through the service ID and calendarName.
				 * @param feedback Calendar feeback handle
				 * @param pluginServiceId The plugin service Id string that was used to register the plugin dll using VidyoCalendarManagerRegisterCalendarService
				 * @param calendarName Name of the calendar or calendar folder that will be used to operate against for the service. An empty string indicates that the default calendar should be used.
				 */
				this.CreateCalendarInstance = function(feedback, pluginServiceId, calendarName, createToken) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('feedback') && arguments[0].hasOwnProperty('pluginServiceId') && arguments[0].hasOwnProperty('calendarName') && arguments[0].hasOwnProperty('createToken')){
							var params = vcUtilsParam({calMgr: this.objId, feedback: (arguments[0].feedback ? arguments[0].feedback.objId : 0), pluginServiceId: arguments[0].pluginServiceId, calendarName: arguments[0].calendarName, createToken: arguments[0].createToken});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['feedback', 'pluginServiceId', 'calendarName', 'createToken'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string")){
						var params = vcUtilsParam({calMgr: this.objId, feedback: (arguments[0] ? arguments[0].objId : 0), pluginServiceId: arguments[1], calendarName: arguments[2], createToken: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarManagerCreateCalendarInstance?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Cleans up and removes the VidyoCalendar calendar instance passed in. NOTE.... IMPORTANT: This method must be called against any constructed instance of the cal endar instance before destructing the calendar manager. If the the instance is not destructed a memory leak will occur and-or side affects will appear from the underlying plugin not being destructed before a shutdown.
				 * @param cal Calendar handle
				 */
				this.DestroyCalendarInstance = function(cal) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('cal')){
							var params = vcUtilsParam({calMgr: this.objId, cal: (arguments[0].cal ? arguments[0].cal.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['cal'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({calMgr: this.objId, cal: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarManagerDestroyCalendarInstance?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieves the list of calendar service strings that were successfully added to the calendar manager.
				 * @param cm Instance of the calendar manager.
				 * @param svcNames Will be populated with the list of service name strings of the plug-in modules that were successfully added to the calendar manager.
				 */
				this.GetCalendarRegisteredServices = function(svcNames) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('svcNames')){
							var params = vcUtilsParam({cm: this.objId, svcNames: JSON.stringify({"svcNames": arguments[0].svcNames})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['svcNames'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({cm: this.objId, svcNames: JSON.stringify({"svcNames": arguments[0]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(svcNames&& response.data.svcNames)
								vcUtilsExtend(svcNames, response.data.svcNames);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarManagerGetCalendarRegisteredServices?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieves the list of calendar service strings that were successfully added to the calendar manager.
				 * @param cm Instance of the calendar manager.
				 * @param onComplete The callback that is triggered when getting calendar service completes.
				 */
				this.GetCalendarRegisteredServicesAsync = function(onComplete) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onComplete')){
							this.VidyoCalendarManagerOnGetServicesComplete = arguments[0].onComplete;
							var params = vcUtilsParam({cm: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onComplete'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoCalendarManagerOnGetServicesComplete = onComplete;
						var params = vcUtilsParam({cm: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarManagerGetCalendarRegisteredServicesAsync?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retreives the user data pointer that was previousely set by Calendaring VidyoCalendarManagerSetUserData.
				 * @param cm Pointer to the VidyoCalendarManager object.
				 * @param pluginServiceName Service name string that will be used for to reference the service that will be provided by the dll being loaded. This name will be used as an argument for creating the calendar instance in VidyoCalendarManagerCreateCalendarInstance.
				 * @param dllName Full file name for calendar plugin dll that needs to be loaded for the pluginServiceName
				 */
				this.RegisterCalendarService = function(pluginServiceName, dllName) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('pluginServiceName') && arguments[0].hasOwnProperty('dllName')){
							var params = vcUtilsParam({cm: this.objId, pluginServiceName: arguments[0].pluginServiceName, dllName: arguments[0].dllName});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['pluginServiceName', 'dllName'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({cm: this.objId, pluginServiceName: arguments[0], dllName: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarManagerRegisterCalendarService?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoCalendarManagerFeedback = function(calendarCreated, calendarDestroyed) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('calendarCreated') && arguments[0].hasOwnProperty('calendarDestroyed')){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['calendarCreated', 'calendarDestroyed'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
					var params = vcUtilsParam({f: this.objId});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoCalendarManagerFeedback = new contextObj.VidyoCalendarManagerFeedback(response.data.VidyoCalendarManagerFeedback);	// copy construct
						if(args.length === 1 && (typeof(args[0]) === "object") && !args[0].objId){
							vidyoCalendarManagerFeedback.VidyoCalendarManagerFeedbackCalendarCreated = args[0].calendarCreated;
							vidyoCalendarManagerFeedback.VidyoCalendarManagerFeedbackCalendarDestroyed = args[0].calendarDestroyed;
						} else {
							vidyoCalendarManagerFeedback.VidyoCalendarManagerFeedbackCalendarCreated = calendarCreated;
							vidyoCalendarManagerFeedback.VidyoCalendarManagerFeedbackCalendarDestroyed = calendarDestroyed;
						}
						objects[vidyoCalendarManagerFeedback.objId] = vidyoCalendarManagerFeedback;
						resolve(vidyoCalendarManagerFeedback);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoCalendarManagerFeedbackConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoCalendarManagerFeedback = function(calendarCreated, calendarDestroyed) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoCalendarManagerFeedback"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('calendarCreated') && arguments[0].hasOwnProperty('calendarDestroyed')){
							this.VidyoCalendarManagerFeedbackCalendarCreated = arguments[0].calendarCreated;
							this.VidyoCalendarManagerFeedbackCalendarDestroyed = arguments[0].calendarDestroyed;
							var params = vcUtilsParam({f: this.objId});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['calendarCreated', 'calendarDestroyed'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoCalendarManagerFeedbackCalendarCreated = calendarCreated;
						this.VidyoCalendarManagerFeedbackCalendarDestroyed = calendarDestroyed;
						var params = vcUtilsParam({f: this.objId});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoCalendarManagerFeedbackConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoCalendarManagerFeedback);
					objects[this.objId] = this;

				}

				return this;
			}

			this.VidyoCalendar = function(){

				this.Destruct = function() {
					GetRequest("VidyoCalendarDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * <p>Initiates a connection of the calendar service to its resource for data. This can include both a local resource or a server based one. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackConnectResult </p>
				 * @param connProperties Property values
				 */
				this.Connect = function(connProperties) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('connProperties')){
							var params = vcUtilsParam({c: this.objId, connProperties: JSON.stringify({"connProperties": arguments[0].connProperties})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['connProperties'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, connProperties: JSON.stringify({"connProperties": arguments[0]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarConnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Create a meeting using an id value returned in a VidyoMeetingInfo object. VidyoMeeting object is returned in the VidyoCalendarFeedbackMeetingCreated callback
				 * @param c Pointer to the VidyoCalendar object.
				 * @param id The id value given in the VidyoMeetingInfo structure that uniquely identifies the meeting
				 */
				this.CreateMeetingWithId = function(id, feedback, createToken) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('feedback') && arguments[0].hasOwnProperty('createToken')){
							var params = vcUtilsParam({c: this.objId, id: arguments[0].id, feedback: (arguments[0].feedback ? arguments[0].feedback.objId : 0), createToken: arguments[0].createToken});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['id', 'feedback', 'createToken'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({c: this.objId, id: arguments[0], feedback: (arguments[1] ? arguments[1].objId : 0), createToken: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarCreateMeetingWithId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * <p>Initiates a connection of the calendar service to its resource for data. This can include both a local resource or a server based one. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackDisconnected </p>
				 */
				this.Disconnect = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarDisconnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets capabilities from the CalendarPlugin. If requestedCapabilities is empty, this causes the feedback to just return a list of the plugin's capabilities with no values list. If requestedCapabilities is a list of capabilities, the plugin will respond with values it has for those capabilities.
				 * @param c The CalendarPlugin's calendar.
				 * @param requestedCapabilities Empty to get just the capability keys. Set with capability keys to get associated values.
				 */
				this.GetCapabilities = function(requestedCapabilities) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestedCapabilities')){
							var params = vcUtilsParam({c: this.objId, requestedCapabilities: JSON.stringify({"requestedCapabilities": arguments[0].requestedCapabilities})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestedCapabilities'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, requestedCapabilities: JSON.stringify({"requestedCapabilities": arguments[0]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarGetCapabilities?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieve unique calendar id value
				 * @param c VidyoCalendar object
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retreives the service state for the calendar.
				 * @param c Pointer to the VidyoCalendar object.
				 */
				this.GetServiceState = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarGetServiceState?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retreives the service type for the calendar.
				 * @param c Pointer to the VidyoCalendar object.
				 */
				this.GetServiceType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarGetServiceType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * <p>Search a calendar for meetings based on a search string and a begin - end date.</p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackGetMeetingsResult </p>
				 * @param searchText If a string is supplied here, the resulting records will be filtered by this string if it is contained within any of the following meeting fields: - Subject - Location - Body - Meeting Owner email and name - Required attendees name and email - Optional attendees name and email
				 * @param beginDateTime Date and time to start search from
				 * @param endDateTime End date and time for search
				 * @param index Zero based index of the starting record in the search results, to use when returning the callback results.
				 * @param pageSize Number of records to return in the callback results, based off of the starting record index argument. NOTE... A value of zero will return all records starting from the index
				 */
				this.SearchMeetings = function(searchText, beginDateTime, endDateTime, index, pageSize) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('searchText') && arguments[0].hasOwnProperty('beginDateTime') && arguments[0].hasOwnProperty('endDateTime') && arguments[0].hasOwnProperty('index') && arguments[0].hasOwnProperty('pageSize')){
							var params = vcUtilsParam({c: this.objId, searchText: arguments[0].searchText, beginDateTime: arguments[0].beginDateTime, endDateTime: arguments[0].endDateTime, index: arguments[0].index, pageSize: arguments[0].pageSize});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['searchText', 'beginDateTime', 'endDateTime', 'index', 'pageSize'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						var params = vcUtilsParam({c: this.objId, searchText: arguments[0], beginDateTime: arguments[1], endDateTime: arguments[2], index: arguments[3], pageSize: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarSearchMeetings?" + params, OnComplete, OnError);
					});
				}

				/**
				 * <p>Get a list of meetings by day. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackGetMeetingsResult </p>
				 * @param c Vidyo calendar service object.
				 * @param year 4 digit year to search for the meetings within - (yyyy).
				 * @param month 1-2 digit month to search for the meetings within - ((mm) - no zero padding required).
				 * @param day 1-2 digit day to search for meetings within - ((dd) - no zero padding required).
				 * @param createToken A unique string token to match this method call with the resulting asynchronous callback
				 */
				this.SearchMeetingsByDay = function(year, month, day, createToken) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('year') && arguments[0].hasOwnProperty('month') && arguments[0].hasOwnProperty('day') && arguments[0].hasOwnProperty('createToken')){
							var params = vcUtilsParam({c: this.objId, year: arguments[0].year, month: arguments[0].month, day: arguments[0].day, createToken: arguments[0].createToken});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['year', 'month', 'day', 'createToken'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "string")){
						var params = vcUtilsParam({c: this.objId, year: arguments[0], month: arguments[1], day: arguments[2], createToken: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarSearchMeetingsByDay?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enables SSO in the CalendarPlugin.
				 * @param c VidyoCalendar to enbale SSO on.
				 * @param setSingleSignOn Whether or not to sign on using SSO.
				 */
				this.SetSingleSignOn = function(setSingleSignOn) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('setSingleSignOn')){
							var params = vcUtilsParam({c: this.objId, setSingleSignOn: arguments[0].setSingleSignOn});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['setSingleSignOn'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, setSingleSignOn: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCalendarSetSingleSignOn?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoCalendarFeedback = function(connectState, disconnected, capabilities, meetingReminder, meetingCreatedById, meetingCreatedByService, meetingUpdatedByService, meetingRemovedByService, getMeetingResults, seriesUpdate) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('connectState') && arguments[0].hasOwnProperty('disconnected') && arguments[0].hasOwnProperty('capabilities') && arguments[0].hasOwnProperty('meetingReminder') && arguments[0].hasOwnProperty('meetingCreatedById') && arguments[0].hasOwnProperty('meetingCreatedByService') && arguments[0].hasOwnProperty('meetingUpdatedByService') && arguments[0].hasOwnProperty('meetingRemovedByService') && arguments[0].hasOwnProperty('getMeetingResults') && arguments[0].hasOwnProperty('seriesUpdate')){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['connectState', 'disconnected', 'capabilities', 'meetingReminder', 'meetingCreatedById', 'meetingCreatedByService', 'meetingUpdatedByService', 'meetingRemovedByService', 'getMeetingResults', 'seriesUpdate'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 10 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function") && (typeof(arguments[4]) === "function") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function") && (typeof(arguments[7]) === "function") && (typeof(arguments[8]) === "function") && (typeof(arguments[9]) === "function")){
					var params = vcUtilsParam({f: this.objId});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoCalendarFeedback = new contextObj.VidyoCalendarFeedback(response.data.VidyoCalendarFeedback);	// copy construct
						if(args.length === 1 && (typeof(args[0]) === "object") && !args[0].objId){
							vidyoCalendarFeedback.VidyoCalendarFeedbackConnectResult = args[0].connectState;
							vidyoCalendarFeedback.VidyoCalendarFeedbackDisconnected = args[0].disconnected;
							vidyoCalendarFeedback.VidyoCalendarFeedbackGetCapabilitiesResult = args[0].capabilities;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingReminder = args[0].meetingReminder;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingCreatedById = args[0].meetingCreatedById;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingCreatedByService = args[0].meetingCreatedByService;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingUpdatedByService = args[0].meetingUpdatedByService;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingRemovedByService = args[0].meetingRemovedByService;
							vidyoCalendarFeedback.VidyoCalendarFeedbackGetMeetingsResult = args[0].getMeetingResults;
							vidyoCalendarFeedback.VidyoCalendarFeedbackSeriesUpdate = args[0].seriesUpdate;
						} else {
							vidyoCalendarFeedback.VidyoCalendarFeedbackConnectResult = connectState;
							vidyoCalendarFeedback.VidyoCalendarFeedbackDisconnected = disconnected;
							vidyoCalendarFeedback.VidyoCalendarFeedbackGetCapabilitiesResult = capabilities;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingReminder = meetingReminder;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingCreatedById = meetingCreatedById;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingCreatedByService = meetingCreatedByService;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingUpdatedByService = meetingUpdatedByService;
							vidyoCalendarFeedback.VidyoCalendarFeedbackMeetingRemovedByService = meetingRemovedByService;
							vidyoCalendarFeedback.VidyoCalendarFeedbackGetMeetingsResult = getMeetingResults;
							vidyoCalendarFeedback.VidyoCalendarFeedbackSeriesUpdate = seriesUpdate;
						}
						objects[vidyoCalendarFeedback.objId] = vidyoCalendarFeedback;
						resolve(vidyoCalendarFeedback);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoCalendarFeedbackConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoCalendarFeedback = function(connectState, disconnected, capabilities, meetingReminder, meetingCreatedById, meetingCreatedByService, meetingUpdatedByService, meetingRemovedByService, getMeetingResults, seriesUpdate) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoCalendarFeedback"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('connectState') && arguments[0].hasOwnProperty('disconnected') && arguments[0].hasOwnProperty('capabilities') && arguments[0].hasOwnProperty('meetingReminder') && arguments[0].hasOwnProperty('meetingCreatedById') && arguments[0].hasOwnProperty('meetingCreatedByService') && arguments[0].hasOwnProperty('meetingUpdatedByService') && arguments[0].hasOwnProperty('meetingRemovedByService') && arguments[0].hasOwnProperty('getMeetingResults') && arguments[0].hasOwnProperty('seriesUpdate')){
							this.VidyoCalendarFeedbackConnectResult = arguments[0].connectState;
							this.VidyoCalendarFeedbackDisconnected = arguments[0].disconnected;
							this.VidyoCalendarFeedbackGetCapabilitiesResult = arguments[0].capabilities;
							this.VidyoCalendarFeedbackMeetingReminder = arguments[0].meetingReminder;
							this.VidyoCalendarFeedbackMeetingCreatedById = arguments[0].meetingCreatedById;
							this.VidyoCalendarFeedbackMeetingCreatedByService = arguments[0].meetingCreatedByService;
							this.VidyoCalendarFeedbackMeetingUpdatedByService = arguments[0].meetingUpdatedByService;
							this.VidyoCalendarFeedbackMeetingRemovedByService = arguments[0].meetingRemovedByService;
							this.VidyoCalendarFeedbackGetMeetingsResult = arguments[0].getMeetingResults;
							this.VidyoCalendarFeedbackSeriesUpdate = arguments[0].seriesUpdate;
							var params = vcUtilsParam({f: this.objId});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['connectState', 'disconnected', 'capabilities', 'meetingReminder', 'meetingCreatedById', 'meetingCreatedByService', 'meetingUpdatedByService', 'meetingRemovedByService', 'getMeetingResults', 'seriesUpdate'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 10 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function") && (typeof(arguments[4]) === "function") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function") && (typeof(arguments[7]) === "function") && (typeof(arguments[8]) === "function") && (typeof(arguments[9]) === "function")){
						this.VidyoCalendarFeedbackConnectResult = connectState;
						this.VidyoCalendarFeedbackDisconnected = disconnected;
						this.VidyoCalendarFeedbackGetCapabilitiesResult = capabilities;
						this.VidyoCalendarFeedbackMeetingReminder = meetingReminder;
						this.VidyoCalendarFeedbackMeetingCreatedById = meetingCreatedById;
						this.VidyoCalendarFeedbackMeetingCreatedByService = meetingCreatedByService;
						this.VidyoCalendarFeedbackMeetingUpdatedByService = meetingUpdatedByService;
						this.VidyoCalendarFeedbackMeetingRemovedByService = meetingRemovedByService;
						this.VidyoCalendarFeedbackGetMeetingsResult = getMeetingResults;
						this.VidyoCalendarFeedbackSeriesUpdate = seriesUpdate;
						var params = vcUtilsParam({f: this.objId});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoCalendarFeedbackConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoCalendarFeedback);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoCalendarFeedbackDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				return this;
			}

			this.CreateVidyoConnector = function(viewId, viewStyle, remoteParticipants, logFileFilter, logFileName, userData) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('viewStyle') && arguments[0].hasOwnProperty('remoteParticipants') && arguments[0].hasOwnProperty('logFileFilter') && arguments[0].hasOwnProperty('logFileName') && arguments[0].hasOwnProperty('userData')){
						arguments[0].viewId = UpdateViewOnDOM({uiEvent:"create", viewId:arguments[0].viewId, viewStyle:arguments[0].viewStyle, remoteParticipants:arguments[0].remoteParticipants, logFileFilter:arguments[0].logFileFilter, logFileName:arguments[0].logFileName, userData:arguments[0].userData});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, viewStyle: arguments[0].viewStyle, remoteParticipants: arguments[0].remoteParticipants, logFileFilter: arguments[0].logFileFilter, logFileName: arguments[0].logFileName, userData: arguments[0].userData});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'viewStyle', 'remoteParticipants', 'logFileFilter', 'logFileName', 'userData'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 6 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "number")){
					arguments[0] = UpdateViewOnDOM({uiEvent:"create", viewId:viewId, viewStyle:viewStyle, remoteParticipants:remoteParticipants, logFileFilter:logFileFilter, logFileName:logFileName, userData:userData});
					var params = vcUtilsParam({c: this.objId, viewId: arguments[0], viewStyle: arguments[1], remoteParticipants: arguments[2], logFileFilter: arguments[3], logFileName: arguments[4], userData: arguments[5]});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoConnector = new contextObj.VidyoConnector(response.data.VidyoConnector);	// copy construct
						objects[vidyoConnector.objId] = vidyoConnector;
						resolve(vidyoConnector);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoConnectorConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoConnector = function(viewId, viewStyle, remoteParticipants, logFileFilter, logFileName, userData) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoConnector"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('viewStyle') && arguments[0].hasOwnProperty('remoteParticipants') && arguments[0].hasOwnProperty('logFileFilter') && arguments[0].hasOwnProperty('logFileName') && arguments[0].hasOwnProperty('userData')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"constructor", viewId:arguments[0].viewId, viewStyle:arguments[0].viewStyle, remoteParticipants:arguments[0].remoteParticipants, logFileFilter:arguments[0].logFileFilter, logFileName:arguments[0].logFileName, userData:arguments[0].userData});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, viewStyle: arguments[0].viewStyle, remoteParticipants: arguments[0].remoteParticipants, logFileFilter: arguments[0].logFileFilter, logFileName: arguments[0].logFileName, userData: arguments[0].userData});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['viewId', 'viewStyle', 'remoteParticipants', 'logFileFilter', 'logFileName', 'userData'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"constructor", viewId:viewId, viewStyle:viewStyle, remoteParticipants:remoteParticipants, logFileFilter:logFileFilter, logFileName:logFileName, userData:userData});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], viewStyle: arguments[1], remoteParticipants: arguments[2], logFileFilter: arguments[3], logFileName: arguments[4], userData: arguments[5]});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoConnectorConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoConnector);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoConnectorDestruct?" + vcUtilsParam({ c: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * This is a synchronous interface. Adds audio device to whitelist. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param deviceName The name of audio device that will be whitelisted.
				 */
				this.AddAudioDeviceToWhitelist = function(deviceName) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('deviceName')){
							var params = vcUtilsParam({c: this.objId, deviceName: arguments[0].deviceName});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['deviceName'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, deviceName: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAddAudioDeviceToWhitelist?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Add message class that application should receive. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param messageClass Name of message class. MSGCLASS_HUNTER is added by default so application will receive only these message class.
				 */
				this.AddMessageClass = function(messageClass) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('messageClass')){
							var params = vcUtilsParam({c: this.objId, messageClass: arguments[0].messageClass});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['messageClass'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, messageClass: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAddMessageClass?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. The Moderator can send a moderation request to approve a raised hand, in which case the participant whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param participant Selected participant whose raised hand request is approved.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.ApproveRaisedHand = function(participant, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorApproveRaisedHand?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Composites the preview and remote participants in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disconnecting. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param viewStyle Type of the composite renderer which represents the visual style and behaviour.
				 * @param remoteParticipants Number of remote participants to composite into the window. Setting the value to 0 will render preview only.
				 */
				this.AssignViewToCompositeRenderer = function(viewId, viewStyle, remoteParticipants) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('viewStyle') && arguments[0].hasOwnProperty('remoteParticipants')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToCompositeRenderer", viewId:arguments[0].viewId, viewStyle:arguments[0].viewStyle, remoteParticipants:arguments[0].remoteParticipants});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, viewStyle: arguments[0].viewStyle, remoteParticipants: arguments[0].remoteParticipants});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'viewStyle', 'remoteParticipants'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToCompositeRenderer", viewId:viewId, viewStyle:viewStyle, remoteParticipants:remoteParticipants});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], viewStyle: arguments[1], remoteParticipants: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToCompositeRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Assigns the view in which to show the preview from a local camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param localCamera The VidyoLocalCamera that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToLocalCamera = function(viewId, localCamera, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('localCamera') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToLocalCamera", viewId:arguments[0].viewId, localCamera:arguments[0].localCamera, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, localCamera: (arguments[0].localCamera ? arguments[0].localCamera.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'localCamera', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToLocalCamera", viewId:viewId, localCamera:localCamera, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], localCamera: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToLocalCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Shows a VidyoLocalMonitor in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the VidyoLocalMonitor will be rendered.
				 * @param localMonitor The VidyoLocalMonitor that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToLocalMonitor = function(viewId, localMonitor, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('localMonitor') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToLocalMonitor", viewId:arguments[0].viewId, localMonitor:arguments[0].localMonitor, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, localMonitor: (arguments[0].localMonitor ? arguments[0].localMonitor.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'localMonitor', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToLocalMonitor", viewId:viewId, localMonitor:localMonitor, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], localMonitor: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(localMonitor&& response.data.localMonitor)
								vcUtilsExtend(localMonitor, response.data.localMonitor);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToLocalMonitor?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Shows a VidyoLocalWindowShare in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the VidyoLocalWindowShare will be rendered.
				 * @param localWindowShare The VidyoLocalWindowShare that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToLocalWindowShare = function(viewId, localWindowShare, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('localWindowShare') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToLocalWindowShare", viewId:arguments[0].viewId, localWindowShare:arguments[0].localWindowShare, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, localWindowShare: (arguments[0].localWindowShare ? arguments[0].localWindowShare.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'localWindowShare', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToLocalWindowShare", viewId:viewId, localWindowShare:localWindowShare, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], localWindowShare: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(localWindowShare&& response.data.localWindowShare)
								vcUtilsExtend(localWindowShare, response.data.localWindowShare);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToLocalWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Assigns the view in which to show the remote camera of one of the other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param remoteCamera The VidyoRemoteCamera that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToRemoteCamera = function(viewId, remoteCamera, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('remoteCamera') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteCamera", viewId:arguments[0].viewId, remoteCamera:arguments[0].remoteCamera, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, remoteCamera: (arguments[0].remoteCamera ? arguments[0].remoteCamera.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'remoteCamera', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteCamera", viewId:viewId, remoteCamera:remoteCamera, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], remoteCamera: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToRemoteCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Shows a VidyoRemoteWindowShare in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the VidyoRemoteWindowShare will be rendered.
				 * @param remoteWindowShare The VidyoRemoteWindowShare that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToRemoteWindowShare = function(viewId, remoteWindowShare, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('remoteWindowShare') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteWindowShare", viewId:arguments[0].viewId, remoteWindowShare:arguments[0].remoteWindowShare, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, remoteWindowShare: (arguments[0].remoteWindowShare ? arguments[0].remoteWindowShare.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'remoteWindowShare', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteWindowShare", viewId:viewId, remoteWindowShare:remoteWindowShare, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], remoteWindowShare: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToRemoteWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Shows a VidyoVirtualVideoSource in a view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID where the VidyoVirtualVideoSource will be rendered.
				 * @param virtualVideoSource The VidyoVirtualVideoSource that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToVirtualVideoSource = function(viewId, virtualVideoSource, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('virtualVideoSource') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToVirtualVideoSource", viewId:arguments[0].viewId, virtualVideoSource:arguments[0].virtualVideoSource, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, virtualVideoSource: (arguments[0].virtualVideoSource ? arguments[0].virtualVideoSource.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'virtualVideoSource', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToVirtualVideoSource", viewId:viewId, virtualVideoSource:virtualVideoSource, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], virtualVideoSource: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorAssignViewToVirtualVideoSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an synchronous interface. This API provides the ability to cancels invitation of a participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param contact VidyoContactInfo object.
				 */
				this.CancelInviteParticipant = function(contact) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('contact')){
							var params = vcUtilsParam({c: this.objId, contact: JSON.stringify(arguments[0].contact)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['contact'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, contact: JSON.stringify(arguments[0])});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorCancelInviteParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Connects to a live conference with the specified resourceId. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param host Host to which the connection will be made.
				 * @param token Token generated by the backend that contains the user ID and other metadata that will be used for authentication.
				 * @param displayName A display name that will be used in the UI.
				 * @param resourceId An alphanumeric string. This resourceId does not need to be pre-provisioned but in order to create a connection between multiple participants, the same resourceId has to be specified.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.Connect = function(host, token, displayName, resourceId, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('token') && arguments[0].hasOwnProperty('displayName') && arguments[0].hasOwnProperty('resourceId') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoConnectorOnSuccess = arguments[0].onSuccess;
							this.VidyoConnectorOnFailure = arguments[0].onFailure;
							this.VidyoConnectorOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({c: this.objId, host: arguments[0].host, token: arguments[0].token, displayName: arguments[0].displayName, resourceId: arguments[0].resourceId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'token', 'displayName', 'resourceId', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 7 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "function") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function")){
						this.VidyoConnectorOnSuccess = onSuccess;
						this.VidyoConnectorOnFailure = onFailure;
						this.VidyoConnectorOnDisconnected = onDisconnected;
						var params = vcUtilsParam({c: this.objId, host: arguments[0], token: arguments[1], displayName: arguments[2], resourceId: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorConnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Connects to a live conference as guest with the specified room key on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param host Host to which the connection will be made.
				 * @param displayName A display name that will be used in the UI.
				 * @param roomKey Room key.
				 * @param roomPin Room Pin / Password to enter the room.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.ConnectToRoomAsGuest = function(host, displayName, roomKey, roomPin, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('displayName') && arguments[0].hasOwnProperty('roomKey') && arguments[0].hasOwnProperty('roomPin') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoConnectorOnSuccess = arguments[0].onSuccess;
							this.VidyoConnectorOnFailure = arguments[0].onFailure;
							this.VidyoConnectorOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({c: this.objId, host: arguments[0].host, displayName: arguments[0].displayName, roomKey: arguments[0].roomKey, roomPin: arguments[0].roomPin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'displayName', 'roomKey', 'roomPin', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 7 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "function") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function")){
						this.VidyoConnectorOnSuccess = onSuccess;
						this.VidyoConnectorOnFailure = onFailure;
						this.VidyoConnectorOnDisconnected = onDisconnected;
						var params = vcUtilsParam({c: this.objId, host: arguments[0], displayName: arguments[1], roomKey: arguments[2], roomPin: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorConnectToRoomAsGuest?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Connects to a live conference with the specified room ID on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param host Host to which the connection will be made.
				 * @param userName User name.
				 * @param password Password.
				 * @param roomId Room ID.
				 * @param roomPin Room Pin/Password to enter the room.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.ConnectToRoomWithId = function(host, userName, password, roomId, roomPin, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('userName') && arguments[0].hasOwnProperty('password') && arguments[0].hasOwnProperty('roomId') && arguments[0].hasOwnProperty('roomPin') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoConnectorOnSuccess = arguments[0].onSuccess;
							this.VidyoConnectorOnFailure = arguments[0].onFailure;
							this.VidyoConnectorOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({c: this.objId, host: arguments[0].host, userName: arguments[0].userName, password: arguments[0].password, roomId: arguments[0].roomId, roomPin: arguments[0].roomPin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'userName', 'password', 'roomId', 'roomPin', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 8 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function") && (typeof(arguments[7]) === "function")){
						this.VidyoConnectorOnSuccess = onSuccess;
						this.VidyoConnectorOnFailure = onFailure;
						this.VidyoConnectorOnDisconnected = onDisconnected;
						var params = vcUtilsParam({c: this.objId, host: arguments[0], userName: arguments[1], password: arguments[2], roomId: arguments[3], roomPin: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorConnectToRoomWithId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Connects to a live conference with the specified room key on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param host Host to which the connection will be made.
				 * @param userName User name.
				 * @param password Password.
				 * @param roomKey Room key.
				 * @param roomPin Room Pin/Password to enter the room.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.ConnectToRoomWithKey = function(host, userName, password, roomKey, roomPin, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('userName') && arguments[0].hasOwnProperty('password') && arguments[0].hasOwnProperty('roomKey') && arguments[0].hasOwnProperty('roomPin') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoConnectorOnSuccess = arguments[0].onSuccess;
							this.VidyoConnectorOnFailure = arguments[0].onFailure;
							this.VidyoConnectorOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({c: this.objId, host: arguments[0].host, userName: arguments[0].userName, password: arguments[0].password, roomKey: arguments[0].roomKey, roomPin: arguments[0].roomPin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'userName', 'password', 'roomKey', 'roomPin', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 8 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function") && (typeof(arguments[7]) === "function")){
						this.VidyoConnectorOnSuccess = onSuccess;
						this.VidyoConnectorOnFailure = onFailure;
						this.VidyoConnectorOnDisconnected = onDisconnected;
						var params = vcUtilsParam({c: this.objId, host: arguments[0], userName: arguments[1], password: arguments[2], roomKey: arguments[3], roomPin: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorConnectToRoomWithKey?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Connects to a live conference with the specified room ID on VidyoCloud. This API is not supported on Vidyo.io. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param host Host to which the connection will be made.
				 * @param userName User name.
				 * @param token Access Token.
				 * @param roomId Room ID.
				 * @param roomPin Room Pin/Password to enter the room.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.ConnectToRoomWithTokenAndId = function(host, userName, token, roomId, roomPin, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('userName') && arguments[0].hasOwnProperty('token') && arguments[0].hasOwnProperty('roomId') && arguments[0].hasOwnProperty('roomPin') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoConnectorOnSuccess = arguments[0].onSuccess;
							this.VidyoConnectorOnFailure = arguments[0].onFailure;
							this.VidyoConnectorOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({c: this.objId, host: arguments[0].host, userName: arguments[0].userName, token: arguments[0].token, roomId: arguments[0].roomId, roomPin: arguments[0].roomPin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'userName', 'token', 'roomId', 'roomPin', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 8 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function") && (typeof(arguments[7]) === "function")){
						this.VidyoConnectorOnSuccess = onSuccess;
						this.VidyoConnectorOnFailure = onFailure;
						this.VidyoConnectorOnDisconnected = onDisconnected;
						var params = vcUtilsParam({c: this.objId, host: arguments[0], userName: arguments[1], token: arguments[2], roomId: arguments[3], roomPin: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorConnectToRoomWithTokenAndId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Connects to a live conference with the specified room key. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param host Host to which the connection will be made.
				 * @param userName User name.
				 * @param token Access Token.
				 * @param roomKey Room Key.
				 * @param roomPin Room Pin/Password used to enter the room.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.ConnectToRoomWithTokenAndKey = function(host, userName, token, roomKey, roomPin, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('userName') && arguments[0].hasOwnProperty('token') && arguments[0].hasOwnProperty('roomKey') && arguments[0].hasOwnProperty('roomPin') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoConnectorOnSuccess = arguments[0].onSuccess;
							this.VidyoConnectorOnFailure = arguments[0].onFailure;
							this.VidyoConnectorOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({c: this.objId, host: arguments[0].host, userName: arguments[0].userName, token: arguments[0].token, roomKey: arguments[0].roomKey, roomPin: arguments[0].roomPin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'userName', 'token', 'roomKey', 'roomPin', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 8 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function") && (typeof(arguments[7]) === "function")){
						this.VidyoConnectorOnSuccess = onSuccess;
						this.VidyoConnectorOnFailure = onFailure;
						this.VidyoConnectorOnDisconnected = onDisconnected;
						var params = vcUtilsParam({c: this.objId, host: arguments[0], userName: arguments[1], token: arguments[2], roomKey: arguments[3], roomPin: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorConnectToRoomWithTokenAndKey?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Create virtual audio source. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceAdded will trigger.
				 * @param c The VidyoConnector object.
				 * @param name The name for the virtual audio source.
				 * @param id The id for the virtual audio source.
				 * @param configuration The string in JSON format that contain audio configuration that will be used for virtual audio source. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
				 */
				this.CreateVirtualAudioSource = function(name, id, configuration) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('name') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('configuration')){
							var params = vcUtilsParam({c: this.objId, name: arguments[0].name, id: arguments[0].id, configuration: arguments[0].configuration});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['name', 'id', 'configuration'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({c: this.objId, name: arguments[0], id: arguments[1], configuration: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorCreateVirtualAudioSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Create virtual video source. The user can create a maximum of 10 virtual video sources. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param type Type of the virtual video source.
				 * @param id Unique ID.
				 * @param name Name of the virtual video source.
				 */
				this.CreateVirtualVideoSource = function(type, id, name) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('type') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('name')){
							var params = vcUtilsParam({c: this.objId, type: arguments[0].type, id: arguments[0].id, name: arguments[0].name});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['type', 'id', 'name'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({c: this.objId, type: arguments[0], id: arguments[1], name: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorCreateVirtualVideoSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Cycles camera selection to the next available camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.CycleCamera = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorCycleCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Cycles microphone selection to the next available microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.CycleMicrophone = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorCycleMicrophone?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Cycles speaker selection to the next available speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.CycleSpeaker = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorCycleSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Destroy virtual audio source. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceRemoved will trigger.
				 * @param c The VidyoConnector object.
				 * @param virtualAudioSource The virtual audio source that will be destroyed.
				 */
				this.DestroyVirtualAudioSource = function(virtualAudioSource) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualAudioSource')){
							var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0].virtualAudioSource ? arguments[0].virtualAudioSource.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualAudioSource'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDestroyVirtualAudioSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Destroy virtual video source. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param virtualVideoSource The virtual video source that will be destroyed.
				 */
				this.DestroyVirtualVideoSource = function(virtualVideoSource) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualVideoSource')){
							var params = vcUtilsParam({c: this.objId, virtualVideoSource: (arguments[0].virtualVideoSource ? arguments[0].virtualVideoSource.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualVideoSource'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualVideoSource: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDestroyVirtualVideoSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Disables connector object, releases all devices as precursor to destruct. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disconnecting. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.Disable = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisable?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set disable audio state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param disable Set to LMI_TRUE to stop all participants' audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableAudioForAll = function(disable, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('disable') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, disable: arguments[0].disable, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['disable', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "boolean") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, disable: arguments[0], requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableAudioForAll?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set disable audio state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param participant VidyoParticipant Object whose audio is revoked/resumed.
				 * @param disable Set to LMI_TRUE to stop the participant's audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableAudioForParticipant = function(participant, disable, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('disable') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), disable: arguments[0].disable, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'disable', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), disable: arguments[1], requestId: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableAudioForParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set disable audio silence state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableAudioSilenceForAll = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableAudioSilenceForAll?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set disable audio silence state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param participant VidyoParticipant object whose audio is revoked/resumed.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableAudioSilenceForParticipant = function(participant, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableAudioSilenceForParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Disable debug mode. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.DisableDebug = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableDebug?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set video disable state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param disable Set to LMI_TRUE to stop all participants' video. Video cannot be resumed until another call with revoke set to LMI_FALSE.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableVideoForAll = function(disable, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('disable') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, disable: arguments[0].disable, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['disable', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "boolean") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, disable: arguments[0], requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableVideoForAll?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set video disable state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param participant VidyoParticipant object whose audio is revoked/resumed.
				 * @param disable Set to LMI_TRUE to stop the participant's video. Video cannot be resumed until another call with revoke set to LMI_FALSE.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableVideoForParticipant = function(participant, disable, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('disable') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), disable: arguments[0].disable, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'disable', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), disable: arguments[1], requestId: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableVideoForParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set disable video silence state for all participants in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableVideoSilenceForAll = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableVideoSilenceForAll?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set disable video silence state for a selected participant in the room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param participant VidyoParticipant Object whose video is revoked/resumed.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DisableVideoSilenceForParticipant = function(participant, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisableVideoSilenceForParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Disconnects a live conference. The onDisconnected callback will be called on successful execution. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.Disconnect = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data && response.data.hasOwnProperty('retValue') ? response.data.retValue : true);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDisconnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. The Moderator or the Presenter can send a moderation request to reject all hands raised, in which case all participants whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DismissAllRaisedHands = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDismissAllRaisedHands?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. The Moderator or the Presenter can send a moderation request to decline a raised hands, in which case the participant whose hand was raised will be notified. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param participants List of selected participants whose raised hand request is going to dismiss.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.DismissRaisedHand = function(participants, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participants') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participants: JSON.stringify({"participants": arguments[0].participants}), requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participants', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participants: JSON.stringify({"participants": arguments[0]}), requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDismissRaisedHand?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Drop all participant out of a room, including the moderator used this API. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param reason A message explaining the reason for the dropping. This can be NULL if no message is desired.
				 */
				this.DropAllParticipants = function(reason) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('reason')){
							var params = vcUtilsParam({c: this.objId, reason: arguments[0].reason});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['reason'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, reason: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDropAllParticipants?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Drop one participant out of a room. Application needs to register VidyoConnectorRegisterModerationResultEventListener to get the result. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param participant VidyoParticipant Object.
				 * @param reason A message explaining the reason for the booting. This can be NULL if no message is desired.
				 */
				this.DropParticipant = function(participant, reason) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('reason')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), reason: arguments[0].reason});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'reason'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), reason: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorDropParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enabled debug mode which will start debug logging and enable statistics. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param port Local listening port for debugging.
				 * @param logFilter Log filter to use on the debug port. Default log filter will be use if null or empty string is passed. <p>Example: warning debug@VidyoClient debug@VidyoConnector all@LmiPortalSession all@LmiPortalMembership debug@LmiResourceManager all@LmiIce all@LmiSignaling.</p>
				 */
				this.EnableDebug = function(port, logFilter) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('port') && arguments[0].hasOwnProperty('logFilter')){
							var params = vcUtilsParam({c: this.objId, port: arguments[0].port, logFilter: arguments[0].logFilter});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['port', 'logFilter'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, port: arguments[0], logFilter: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorEnableDebug?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Get the NetworkInterface for media and signaling. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onGetActiveNetworkInterfaceCallback Callback called upon completion.
				 */
				this.GetActiveNetworkInterface = function(onGetActiveNetworkInterfaceCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetActiveNetworkInterfaceCallback')){
							this.VidyoConnectorOnGetActiveNetworkInterface = arguments[0].onGetActiveNetworkInterfaceCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetActiveNetworkInterfaceCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetActiveNetworkInterface = onGetActiveNetworkInterfaceCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetActiveNetworkInterface?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets audio bitrate multiplier which is used when calculating the audio bitrate. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
				 * @param c The VidyoConnector object.
				 */
				this.GetAudioBitrateMultiplier = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAudioBitrateMultiplier?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets the audio mode for both the audio devices (speaker and microphone). This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORAUDIOMODE_Unknown.
				 * @param c The VidyoConnector object.
				 */
				this.GetAudioMode = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAudioMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets time interval between two packet of audio in miliseconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
				 * @param c The VidyoConnector object.
				 */
				this.GetAudioPacketInterval = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAudioPacketInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets audio loss percantage - value that is used to configure encoder. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
				 * @param c The VidyoConnector object.
				 */
				this.GetAudioPacketLossPercentage = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAudioPacketLossPercentage?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets state of auto-reconnect. It's either enabled or disabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetAutoReconnect = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAutoReconnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets back off for next reconnect attempt. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetAutoReconnectAttemptBackOff = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAutoReconnectAttemptBackOff?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets maximum attempts to be done for reconnecting. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetAutoReconnectMaxAttempts = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAutoReconnectMaxAttempts?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Gets the auto-reconnect settings. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onGetAutoReconnectSettingCallback Callback called upon completion.
				 */
				this.GetAutoReconnectSetting = function(onGetAutoReconnectSettingCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetAutoReconnectSettingCallback')){
							this.VidyoConnectorOnGetAutoReconnectSetting = arguments[0].onGetAutoReconnectSettingCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetAutoReconnectSettingCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetAutoReconnectSetting = onGetAutoReconnectSettingCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetAutoReconnectSetting?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a asynchronous interface. Gets the current configuration of camera background effect. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
				 * @param c The VidyoConnector object.
				 * @param onGetEffectInfo Callback that reports the current configuration of camera background effect to the application. In case some error occurs NULL will be reported.
				 */
				this.GetCameraBackgroundEffect = function(onGetEffectInfo) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetEffectInfo')){
							this.VidyoConnectorOnGetCameraBackgroundEffectInfo = arguments[0].onGetEffectInfo;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetEffectInfo'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetCameraBackgroundEffectInfo = onGetEffectInfo;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetCameraBackgroundEffect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets conference number - a special identifier that is showed up in the Portal CDR record for the conference. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and empty string returned.
				 * @param c The VidyoConnector object.
				 */
				this.GetConferenceNumber = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetConferenceNumber?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Get current CPU tradeoff profile setting. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetCpuTradeOffProfile = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetCpuTradeOffProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets state of video on low bandwidth. It's either enabled or disabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetDisableVideoOnLowBandwidth = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetDisableVideoOnLowBandwidth?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets number of audio streams requested while video is shut off. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetDisableVideoOnLowBandwidthAudioStreams = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetDisableVideoOnLowBandwidthAudioStreams?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets time it takes to recover when video is shut off. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetDisableVideoOnLowBandwidthRecoveryTime = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetDisableVideoOnLowBandwidthRecoveryTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets time it takes to shut off video due to low bandwidth. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetDisableVideoOnLowBandwidthResponseTime = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetDisableVideoOnLowBandwidthResponseTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets how often checking for low bandwidth happens. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetDisableVideoOnLowBandwidthSampleTime = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetDisableVideoOnLowBandwidthSampleTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets low bandwidth threshold. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetDisableVideoOnLowBandwidthThreshold = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetDisableVideoOnLowBandwidthThreshold?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Get the analytics event table. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onGetGoogleAnalyticsEventTable Callback called upon completion.
				 */
				this.GetGoogleAnalyticsEventTable = function(onGetGoogleAnalyticsEventTable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetGoogleAnalyticsEventTable')){
							this.VidyoConnectorOnGetGoogleAnalyticsEventTable = arguments[0].onGetGoogleAnalyticsEventTable;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetGoogleAnalyticsEventTable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetGoogleAnalyticsEventTable = onGetGoogleAnalyticsEventTable;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetGoogleAnalyticsEventTable?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a asynchronous interface. It returns google analytics configured options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onGetGoogleAnalyticsOptions Callback called upon completion.
				 */
				this.GetGoogleAnalyticsOptions = function(onGetGoogleAnalyticsOptions) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetGoogleAnalyticsOptions')){
							this.VidyoConnectorOnGetGoogleAnalyticsOptions = arguments[0].onGetGoogleAnalyticsOptions;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetGoogleAnalyticsOptions'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetGoogleAnalyticsOptions = onGetGoogleAnalyticsOptions;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetGoogleAnalyticsOptions?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. It returns Insights Url if service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetInsightsServiceUrl = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetInsightsServiceUrl?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Allow application to get log level i.e production or debug. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORLOGLEVEL_INVALID.
				 * @param c The VidyoConnector object.
				 * @param loggerType logger type ( console, file, feedback, http).
				 */
				this.GetLogLevel = function(loggerType) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('loggerType')){
							var params = vcUtilsParam({c: this.objId, loggerType: arguments[0].loggerType});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['loggerType'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, loggerType: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetLogLevel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Return the max receive bit rate configured by application. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetMaxReceiveBitRate = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetMaxReceiveBitRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Return the max send bit rate configured by application. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetMaxSendBitRate = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetMaxSendBitRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets maximum microphone boost level that is applied only in the conference for the selected microphone in case the system is set to the higher value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
				 * @param c The VidyoConnector object.
				 */
				this.GetMicrophoneMaxBoostLevel = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetMicrophoneMaxBoostLevel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets minimum microphone value that is applied only in the conference for the selected microphone in case the system is set to the lower value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
				 * @param c The VidyoConnector object.
				 */
				this.GetMinMicrophoneVolume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetMinMicrophoneVolume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Retrieves VidyoConnector options in JSON format. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetOptions = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetOptions?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets preferred audio codec name. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return VIDYO_CONNECTORPREFERREDAUDIOCODEC_Unknown.
				 * @param c The VidyoConnector object.
				 */
				this.GetPreferredAudioCodec = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetPreferredAudioCodec?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Asynchronously retrieves a vector of available recording profiles. Each element of this vector is a LmiString that contains a description of a recording profile as provided by the active recording server. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. Calls a callback upon completion.
				 * @param c Pointer to the VidyoConnector object.
				 * @param onGetRecordingProfilesCallback Callback called upon completion.
				 */
				this.GetRecordingServiceProfiles = function(onGetRecordingProfilesCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetRecordingProfilesCallback')){
							this.VidyoConnectorOnGetRecordingServiceProfiles = arguments[0].onGetRecordingProfilesCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetRecordingProfilesCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetRecordingServiceProfiles = onGetRecordingProfilesCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetRecordingServiceProfiles?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Get the local renderer and conference tiles displaying options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform-specific view ID.
				 */
				this.GetRendererOptionsForViewId = function(viewId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"GetRendererOptionsForViewId", viewId:arguments[0].viewId});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"GetRendererOptionsForViewId", viewId:viewId});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetRendererOptionsForViewId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Retrieves the state of the VidyoConnector.
				 * @param c The VidyoConnector object.
				 */
				this.GetState = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetState?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets whether SVC is enabled. The default is false. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetStaticShareSvcState = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetStaticShareSvcState?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Gets conference room statistics gather interval in seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return -1.
				 * @param c The VidyoConnector object.
				 */
				this.GetStatisticRate = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetStatisticRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Retrieves VidyoConnector statistics in JSON format. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.GetStatsJson = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetStatsJson?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Retrieves version of the VidyoConnector library.
				 * @param c The VidyoConnector object.
				 */
				this.GetVersion = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetVersion?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Retrieves version of the VidyoConnector library wihtout the build number.
				 * @param c The VidyoConnector object.
				 */
				this.GetVersionWithoutBuildNumber = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetVersionWithoutBuildNumber?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Gets the names of the audio devices that are whitelisted. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onGetCallback Callback that will report an array with the names of audio devices that are whitelisted.
				 */
				this.GetWhitelistedAudioDevices = function(onGetCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetCallback')){
							this.VidyoConnectorOnGetWhitelistedAudioDevices = arguments[0].onGetCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnGetWhitelistedAudioDevices = onGetCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGetWhitelistedAudioDevices?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Control type of event action and categories of google analytics. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param eventCategory Type of event category. refer VidyoConnectorGoogleAnalyticsEventCategory.
				 * @param eventAction Type of event action. refer VidyoConnectorGoogleAnalyticsEventAction.
				 * @param enable Event action state flag.
				 */
				this.GoogleAnalyticsControlEventAction = function(eventCategory, eventAction, enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('eventCategory') && arguments[0].hasOwnProperty('eventAction') && arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, eventCategory: arguments[0].eventCategory, eventAction: arguments[0].eventAction, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['eventCategory', 'eventAction', 'enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, eventCategory: arguments[0], eventAction: arguments[1], enable: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorGoogleAnalyticsControlEventAction?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Hides a view which is used for custom layout of sources. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId The view ID of the view to hide.
				 */
				this.HideView = function(viewId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"HideView", viewId:arguments[0].viewId});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"HideView", viewId:viewId});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorHideView?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Notify the events as a part of analytics service. The event data will be sent to Loki analytics server if analytics service is started with VIDYO_CONNECTORANALYTICSSERVICETYPE_VidyoInsights. Event is automatically timestamped. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param eventName Event name.
				 * @param parameters Pointer to string vector event parameters. Can be NULL if no parameters are needed.
				 */
				this.InsightsNotifyEvent = function(eventName, parameters) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('eventName') && arguments[0].hasOwnProperty('parameters')){
							var params = vcUtilsParam({c: this.objId, eventName: arguments[0].eventName, parameters: JSON.stringify({"parameters": arguments[0].parameters})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['eventName', 'parameters'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object")){
						var params = vcUtilsParam({c: this.objId, eventName: arguments[0], parameters: JSON.stringify({"parameters": arguments[1]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorInsightsNotifyEvent?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This API provides the ability to the room owner, admin or moderators to invite other users to join this room for conference. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param contact VidyoContactInfo Object.
				 * @param message Invitation Message.
				 * @param onInviteResult Callback to be triggered for invitation result.
				 */
				this.InviteParticipant = function(contact, message, onInviteResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('contact') && arguments[0].hasOwnProperty('message') && arguments[0].hasOwnProperty('onInviteResult')){
							this.VidyoConnectorOnInviteResult = arguments[0].onInviteResult;
							var params = vcUtilsParam({c: this.objId, contact: JSON.stringify(arguments[0].contact), message: arguments[0].message});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['contact', 'message', 'onInviteResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnInviteResult = onInviteResult;
						var params = vcUtilsParam({c: this.objId, contact: JSON.stringify(arguments[0]), message: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorInviteParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Checks whether Google Analytics service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.IsGoogleAnalyticsServiceEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorIsGoogleAnalyticsServiceEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Checks whether Insights service is running. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.IsInsightsServiceEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorIsInsightsServiceEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This api provides the ability lock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param onLockRoomResult Callback to be triggered for lock room result.
				 */
				this.LockRoom = function(onLockRoomResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onLockRoomResult')){
							this.VidyoConnectorOnLockRoomResult = arguments[0].onLockRoomResult;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onLockRoomResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnLockRoomResult = onLockRoomResult;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorLockRoom?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c Pointer to the VidyoConnector object.
				 * @param onRecordingServicePauseResultCallback Callback called upon completion.
				 */
				this.PauseRecording = function(onRecordingServicePauseResultCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onRecordingServicePauseResultCallback')){
							this.VidyoConnectorOnRecordingServicePauseResult = arguments[0].onRecordingServicePauseResultCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onRecordingServicePauseResultCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnRecordingServicePauseResult = onRecordingServicePauseResultCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorPauseRecording?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Pin a participant's video. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param participant A participant that will pinned/unpinned.
				 * @param pin LMI_TRUE to pin participant, LMI_FALSE to unpin.
				 */
				this.PinParticipant = function(participant, pin) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('pin')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), pin: arguments[0].pin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'pin'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), pin: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorPinParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
				 * @param c The VidyoConnector object.
				 * @param raiseHandResponse Callback that is triggered each time when response of hand raise request.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.RaiseHand = function(raiseHandResponse, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('raiseHandResponse') && arguments[0].hasOwnProperty('requestId')){
							this.VidyoConnectorOnRaiseHandResponse = arguments[0].raiseHandResponse;
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['raiseHandResponse', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "string")){
						this.VidyoConnectorOnRaiseHandResponse = raiseHandResponse;
						var params = vcUtilsParam({c: this.objId, requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRaiseHand?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Application can register a callback to get notified about bot participants. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onJoined Callback that is triggered when bot participant joins a conference.
				 * @param onLeft Callback that is triggered when an existing bot participant leaves a conference.
				 */
				this.RegisterBotEventListener = function(onJoined, onLeft) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onJoined') && arguments[0].hasOwnProperty('onLeft')){
							this.VidyoConnectorOnBotJoined = arguments[0].onJoined;
							this.VidyoConnectorOnBotLeft = arguments[0].onLeft;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onJoined', 'onLeft'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoConnectorOnBotJoined = onJoined;
						this.VidyoConnectorOnBotLeft = onLeft;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterBotEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers callback to notify the user in case of any errors occur during enabling camera effect.
				 * @param c The VidyoConnector object.
				 * @param onError The callback that will reports camera effect errors.
				 */
				this.RegisterCameraEffectErrorListener = function(onError) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onError')){
							this.VidyoConnectorOnCameraEffectError = arguments[0].onError;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onError'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnCameraEffectError = onError;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterCameraEffectErrorListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param conferenceModeChanged The VidyoConnectorOnConferenceModeChanged status as lecture,lobby or group.
				 */
				this.RegisterConferenceModeEventListener = function(conferenceModeChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('conferenceModeChanged')){
							this.VidyoConnectorOnConferenceModeChanged = arguments[0].conferenceModeChanged;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['conferenceModeChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnConferenceModeChanged = conferenceModeChanged;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterConferenceModeEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified when a connection properties is changed. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onConnectionPropertiesChanged Callback that is triggered when a connection properties is changed.
				 */
				this.RegisterConnectionPropertiesEventListener = function(onConnectionPropertiesChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onConnectionPropertiesChanged')){
							this.VidyoConnectorOnConnectionPropertiesChanged = arguments[0].onConnectionPropertiesChanged;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onConnectionPropertiesChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnConnectionPropertiesChanged = onConnectionPropertiesChanged;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterConnectionPropertiesEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers the advanced error event listeners.
				 * @param c The VidyoConnector object.
				 * @param onErrorCallback Callback that is triggered when an error occurs.
				 */
				this.RegisterErrorEventListener = function(onErrorCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onErrorCallback')){
							this.VidyoConnectorOnError = arguments[0].onErrorCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onErrorCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnError = onErrorCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterErrorEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param hostStatus The VidyoConnectorOnConferenceHostStatusChanged status i..e host joined or left
				 */
				this.RegisterHostEventListener = function(hostStatus) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('hostStatus')){
							this.VidyoConnectorOnConferenceHostStatusChanged = arguments[0].hostStatus;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['hostStatus'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnConferenceHostStatusChanged = hostStatus;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterHostEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the callback which will be triggered during a conference, these events may not stop the conferece but may degrade quality of call. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param cb The callback which will be triggered when error occur in conference.
				 */
				this.RegisterInCallEventListener = function(cb) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('cb')){
							this.VidyoConnectorOnInCallEvents = arguments[0].cb;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['cb'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnInCallEvents = cb;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterInCallEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers the Lecture mode feature callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param presenterChanged Callback that is triggered when presenter changed.
				 * @param handRaised Callback that is triggered for Moderator when some hand raised.
				 */
				this.RegisterLectureModeEventListener = function(presenterChanged, handRaised) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('presenterChanged') && arguments[0].hasOwnProperty('handRaised')){
							this.VidyoConnectorOnPresenterChanged = arguments[0].presenterChanged;
							this.VidyoConnectorOnHandRaised = arguments[0].handRaised;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['presenterChanged', 'handRaised'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoConnectorOnPresenterChanged = presenterChanged;
						this.VidyoConnectorOnHandRaised = handRaised;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLectureModeEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about local camera events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered for every new or existing camera added.
				 * @param onRemoved Callback that is triggered when the camera is removed.
				 * @param onSelected Callback that is triggered when a camera is selected for use.
				 * @param onStateUpdated Callback that is triggered when a camera state is updated.
				 */
				this.RegisterLocalCameraEventListener = function(onAdded, onRemoved, onSelected, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnLocalCameraAdded = arguments[0].onAdded;
							this.VidyoConnectorOnLocalCameraRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnLocalCameraSelected = arguments[0].onSelected;
							this.VidyoConnectorOnLocalCameraStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onSelected', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnLocalCameraAdded = onAdded;
						this.VidyoConnectorOnLocalCameraRemoved = onRemoved;
						this.VidyoConnectorOnLocalCameraSelected = onSelected;
						this.VidyoConnectorOnLocalCameraStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalCameraEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about camera frames. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a remote camera.
				 * @param localCamera The VidyoLocalCamera for which to receive the frames.
				 * @param width Approximate width of the requested frame.
				 * @param height Approximate height of the requested frame.
				 * @param frameInterval Approximate frame interval of the requested frame.
				 */
				this.RegisterLocalCameraFrameListener = function(onFrame, localCamera, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('localCamera') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							this.VidyoConnectorOnLocalCameraFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0].localCamera ? arguments[0].localCamera.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'localCamera', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						this.VidyoConnectorOnLocalCameraFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, localCamera: (arguments[1] ? arguments[1].objId : 0), width: arguments[2], height: arguments[3], frameInterval: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalCameraFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about microphone energies. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onEnergy Callback that is triggered for every frame from a microphone that has energy.
				 */
				this.RegisterLocalMicrophoneEnergyListener = function(onEnergy) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onEnergy')){
							this.VidyoConnectorOnLocalMicrophoneEnergy = arguments[0].onEnergy;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onEnergy'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnLocalMicrophoneEnergy = onEnergy;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalMicrophoneEnergyListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about local microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered for every new or existing microphone added.
				 * @param onRemoved Callback that is triggered when the microphone is removed.
				 * @param onSelected Callback that is triggered when a microphone is selected for use.
				 * @param onStateUpdated Callback that is triggered when a microphone state is updated.
				 */
				this.RegisterLocalMicrophoneEventListener = function(onAdded, onRemoved, onSelected, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnLocalMicrophoneAdded = arguments[0].onAdded;
							this.VidyoConnectorOnLocalMicrophoneRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnLocalMicrophoneSelected = arguments[0].onSelected;
							this.VidyoConnectorOnLocalMicrophoneStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onSelected', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnLocalMicrophoneAdded = onAdded;
						this.VidyoConnectorOnLocalMicrophoneRemoved = onRemoved;
						this.VidyoConnectorOnLocalMicrophoneSelected = onSelected;
						this.VidyoConnectorOnLocalMicrophoneStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalMicrophoneEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about microphone frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a microphone.
				 * @param localMicrophone The VidyoLocalMicrophone for which to receive the frames.
				 */
				this.RegisterLocalMicrophoneFrameListener = function(onFrame, localMicrophone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('localMicrophone')){
							this.VidyoConnectorOnLocalMicrophoneFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0].localMicrophone ? arguments[0].localMicrophone.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'localMicrophone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object")){
						this.VidyoConnectorOnLocalMicrophoneFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[1] ? arguments[1].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalMicrophoneFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about local monitor events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered for every new or existing monitor added.
				 * @param onRemoved Callback that is triggered when the monitor is removed.
				 * @param onSelected Callback that is triggered when a monitor is selected for use.
				 * @param onStateUpdated Callback that is triggered when a monitor state is updated.
				 */
				this.RegisterLocalMonitorEventListener = function(onAdded, onRemoved, onSelected, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnLocalMonitorAdded = arguments[0].onAdded;
							this.VidyoConnectorOnLocalMonitorRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnLocalMonitorSelected = arguments[0].onSelected;
							this.VidyoConnectorOnLocalMonitorStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onSelected', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnLocalMonitorAdded = onAdded;
						this.VidyoConnectorOnLocalMonitorRemoved = onRemoved;
						this.VidyoConnectorOnLocalMonitorSelected = onSelected;
						this.VidyoConnectorOnLocalMonitorStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalMonitorEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about monitor frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a monitor.
				 * @param localMonitor The VidyoLocalMonitor for which to receive the frames.
				 * @param width Approximate width of the requested frame.
				 * @param height Approximate height of the requested frame.
				 * @param frameInterval Approximate frame interval of the requested frame.
				 */
				this.RegisterLocalMonitorFrameListener = function(onFrame, localMonitor, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('localMonitor') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							this.VidyoConnectorOnLocalMonitorFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0].localMonitor ? arguments[0].localMonitor.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'localMonitor', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						this.VidyoConnectorOnLocalMonitorFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[1] ? arguments[1].objId : 0), width: arguments[2], height: arguments[3], frameInterval: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalMonitorFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about local speaker events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered for every new or existing speaker added.
				 * @param onRemoved Callback that is triggered when the speaker is removed.
				 * @param onSelected Callback that is triggered when a speaker is selected for use.
				 * @param onStateUpdated Callback that is triggered when a speaker state is updated.
				 */
				this.RegisterLocalSpeakerEventListener = function(onAdded, onRemoved, onSelected, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnLocalSpeakerAdded = arguments[0].onAdded;
							this.VidyoConnectorOnLocalSpeakerRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnLocalSpeakerSelected = arguments[0].onSelected;
							this.VidyoConnectorOnLocalSpeakerStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onSelected', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnLocalSpeakerAdded = onAdded;
						this.VidyoConnectorOnLocalSpeakerRemoved = onRemoved;
						this.VidyoConnectorOnLocalSpeakerSelected = onSelected;
						this.VidyoConnectorOnLocalSpeakerStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalSpeakerEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about local shareable-window events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered for every new or existing window added.
				 * @param onRemoved Callback that is triggered when the window is removed.
				 * @param onSelected Callback that is triggered when a window is selected for use.
				 * @param onStateUpdated Callback that is triggered when a window state is updated.
				 */
				this.RegisterLocalWindowShareEventListener = function(onAdded, onRemoved, onSelected, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnLocalWindowShareAdded = arguments[0].onAdded;
							this.VidyoConnectorOnLocalWindowShareRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnLocalWindowShareSelected = arguments[0].onSelected;
							this.VidyoConnectorOnLocalWindowShareStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onSelected', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnLocalWindowShareAdded = onAdded;
						this.VidyoConnectorOnLocalWindowShareRemoved = onRemoved;
						this.VidyoConnectorOnLocalWindowShareSelected = onSelected;
						this.VidyoConnectorOnLocalWindowShareStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalWindowShareEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about window frames. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a window.
				 * @param localWindowShare The VidyoLocalWindowShare for which to receive the frames.
				 * @param width Approximate width of the requested frame.
				 * @param height Approximate height of the requested frame.
				 * @param frameInterval Approximate frame interval of the requested frame.
				 */
				this.RegisterLocalWindowShareFrameListener = function(onFrame, localWindowShare, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('localWindowShare') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							this.VidyoConnectorOnLocalWindowShareFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0].localWindowShare ? arguments[0].localWindowShare.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'localWindowShare', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						this.VidyoConnectorOnLocalWindowShareFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[1] ? arguments[1].objId : 0), width: arguments[2], height: arguments[3], frameInterval: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLocalWindowShareFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about log events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onLog Callback that is triggered for every new log record.
				 * @param filter <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and 45categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p>
				 */
				this.RegisterLogEventListener = function(onLog, filter) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onLog') && arguments[0].hasOwnProperty('filter')){
							this.VidyoConnectorOnLog = arguments[0].onLog;
							var params = vcUtilsParam({c: this.objId, filter: arguments[0].filter});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onLog', 'filter'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "string")){
						this.VidyoConnectorOnLog = onLog;
						var params = vcUtilsParam({c: this.objId, filter: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterLogEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about message events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onChatMessageReceived Callback that is triggered when a chat message is received from a participant.
				 */
				this.RegisterMessageEventListener = function(onChatMessageReceived) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onChatMessageReceived')){
							this.VidyoConnectorOnChatMessageReceived = arguments[0].onChatMessageReceived;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onChatMessageReceived'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnChatMessageReceived = onChatMessageReceived;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterMessageEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Register a callback to receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param onModerationCommand Callback to be triggered upon receive moderation command from the server.
				 */
				this.RegisterModerationCommandEventListener = function(onModerationCommand) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onModerationCommand')){
							this.VidyoConnectorOnModerationCommandReceived = arguments[0].onModerationCommand;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onModerationCommand'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnModerationCommandReceived = onModerationCommand;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterModerationCommandEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about result of moderation APIs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onModerationResult Callback that is triggered when the moderation API is complete.
				 */
				this.RegisterModerationResultEventListener = function(onModerationResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onModerationResult')){
							this.VidyoConnectorOnModerationResult = arguments[0].onModerationResult;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onModerationResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnModerationResult = onModerationResult;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterModerationResultEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Register a callback to receive the final response for the Next Generation Renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param onNGRResult Callback to be triggered upon receive the final response from next generation renderer library.
				 */
				this.RegisterNGRResultEventListener = function(onNGRResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onNGRResult')){
							this.VidyoConnectorOnNGRResult = arguments[0].onNGRResult;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onNGRResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnNGRResult = onNGRResult;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterNGRResultEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about network interface events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered for every new or existing network interface added.
				 * @param onRemoved Callback that is triggered when the network interface is removed.
				 * @param onSelected Callback that is triggered when a network interface is selected for use.
				 * @param onStateUpdated Callback that is triggered when a network interface state changes.
				 */
				this.RegisterNetworkInterfaceEventListener = function(onAdded, onRemoved, onSelected, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnNetworkInterfaceAdded = arguments[0].onAdded;
							this.VidyoConnectorOnNetworkInterfaceRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnNetworkInterfaceSelected = arguments[0].onSelected;
							this.VidyoConnectorOnNetworkInterfaceStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onSelected', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnNetworkInterfaceAdded = onAdded;
						this.VidyoConnectorOnNetworkInterfaceRemoved = onRemoved;
						this.VidyoConnectorOnNetworkInterfaceSelected = onSelected;
						this.VidyoConnectorOnNetworkInterfaceStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterNetworkInterfaceEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about participant events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onJoined Callback that is triggered when another participant joins a conference.
				 * @param onLeft Callback that is triggered when an existing participant leaves a conference.
				 * @param onDynamicChanged Callback that is triggered when the order of participants has changed, based on their importance according to active speech detection.
				 * @param onLoudestChanged Callback that is triggered when a new participant becomes the loudest, based on active speech detection.
				 */
				this.RegisterParticipantEventListener = function(onJoined, onLeft, onDynamicChanged, onLoudestChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onJoined') && arguments[0].hasOwnProperty('onLeft') && arguments[0].hasOwnProperty('onDynamicChanged') && arguments[0].hasOwnProperty('onLoudestChanged')){
							this.VidyoConnectorOnParticipantJoined = arguments[0].onJoined;
							this.VidyoConnectorOnParticipantLeft = arguments[0].onLeft;
							this.VidyoConnectorOnDynamicParticipantChanged = arguments[0].onDynamicChanged;
							this.VidyoConnectorOnLoudestParticipantChanged = arguments[0].onLoudestChanged;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onJoined', 'onLeft', 'onDynamicChanged', 'onLoudestChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnParticipantJoined = onJoined;
						this.VidyoConnectorOnParticipantLeft = onLeft;
						this.VidyoConnectorOnDynamicParticipantChanged = onDynamicChanged;
						this.VidyoConnectorOnLoudestParticipantChanged = onLoudestChanged;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterParticipantEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers plugin. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return NULL.
				 * @param c The VidyoConnector object.
				 * @param plugin Plugin to register.
				 */
				this.RegisterPlugin = function(plugin) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('plugin')){
							var params = vcUtilsParam({c: this.objId, plugin: arguments[0].plugin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['plugin'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, plugin: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterPlugin?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about reconnecting events. Note: You should not perform long action in the callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onReconnecting Callback that is triggered each time the new attempt to reconnect will be started.
				 * @param onReconnected Callback that is triggered when reconnecting was successful.
				 * @param onConferenceLost Callback that is triggered when reconnecting failed.
				 */
				this.RegisterReconnectEventListener = function(onReconnecting, onReconnected, onConferenceLost) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onReconnecting') && arguments[0].hasOwnProperty('onReconnected') && arguments[0].hasOwnProperty('onConferenceLost')){
							this.VidyoConnectorOnReconnecting = arguments[0].onReconnecting;
							this.VidyoConnectorOnReconnected = arguments[0].onReconnected;
							this.VidyoConnectorOnConferenceLost = arguments[0].onConferenceLost;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onReconnecting', 'onReconnected', 'onConferenceLost'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnReconnecting = onReconnecting;
						this.VidyoConnectorOnReconnected = onReconnected;
						this.VidyoConnectorOnConferenceLost = onConferenceLost;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterReconnectEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified when a recorder joins or leaves the call. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onRecorderInCallChanged Callback that is triggered when a recorder joins or leaves the call.
				 */
				this.RegisterRecorderInCallEventListener = function(onRecorderInCallChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onRecorderInCallChanged')){
							this.VidyoConnectorRecorderInCall = arguments[0].onRecorderInCallChanged;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onRecorderInCallChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorRecorderInCall = onRecorderInCallChanged;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRecorderInCallEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about remote camera events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered each time one of the other participants adds a remote camera into a conference.
				 * @param onRemoved Callback that is triggered each time one of the other participants removes a remote camera from a conference.
				 * @param onStateUpdated Callback that is triggered each time one of the other participants remote camera chagnes state in a conference.
				 */
				this.RegisterRemoteCameraEventListener = function(onAdded, onRemoved, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnRemoteCameraAdded = arguments[0].onAdded;
							this.VidyoConnectorOnRemoteCameraRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnRemoteCameraStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnRemoteCameraAdded = onAdded;
						this.VidyoConnectorOnRemoteCameraRemoved = onRemoved;
						this.VidyoConnectorOnRemoteCameraStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteCameraEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about camera frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a remote camera.
				 * @param remoteCamera The VidyoRemoteCamera for which to receive the frames.
				 * @param width Approximate width of the requested frame.
				 * @param height Approximate height of the requested frame.
				 * @param frameInterval Approximate frame interval of the requested frame.
				 */
				this.RegisterRemoteCameraFrameListener = function(onFrame, remoteCamera, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('remoteCamera') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							this.VidyoConnectorOnRemoteCameraFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, remoteCamera: (arguments[0].remoteCamera ? arguments[0].remoteCamera.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'remoteCamera', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						this.VidyoConnectorOnRemoteCameraFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, remoteCamera: (arguments[1] ? arguments[1].objId : 0), width: arguments[2], height: arguments[3], frameInterval: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteCameraFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about microphone energies from other participants. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onEnergy Callback that is triggered for every frame with energy from a remote microphone.
				 */
				this.RegisterRemoteMicrophoneEnergyListener = function(onEnergy) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onEnergy')){
							this.VidyoConnectorOnRemoteMicrophoneEnergy = arguments[0].onEnergy;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onEnergy'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnRemoteMicrophoneEnergy = onEnergy;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteMicrophoneEnergyListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about remote microphone events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered when another participant adds a microphone into a conference.
				 * @param onRemoved Callback that is triggered when another participant removes a microphone from a conference.
				 * @param onStateUpdated Callback that is triggered when another participant microphone changes state in a conference.
				 */
				this.RegisterRemoteMicrophoneEventListener = function(onAdded, onRemoved, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnRemoteMicrophoneAdded = arguments[0].onAdded;
							this.VidyoConnectorOnRemoteMicrophoneRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnRemoteMicrophoneStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnRemoteMicrophoneAdded = onAdded;
						this.VidyoConnectorOnRemoteMicrophoneRemoved = onRemoved;
						this.VidyoConnectorOnRemoteMicrophoneStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteMicrophoneEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about microphone frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a remote microphone.
				 * @param remoteMicrophone The VidyoRemoteMicrophone for which to receive the frames.
				 */
				this.RegisterRemoteMicrophoneFrameListener = function(onFrame, remoteMicrophone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('remoteMicrophone')){
							this.VidyoConnectorOnRemoteMicrophoneFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, remoteMicrophone: (arguments[0].remoteMicrophone ? arguments[0].remoteMicrophone.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'remoteMicrophone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object")){
						this.VidyoConnectorOnRemoteMicrophoneFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, remoteMicrophone: (arguments[1] ? arguments[1].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteMicrophoneFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about remote renderer events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered when server is ready to accept video stream from local camera.
				 * @param onRemoved Callback that is triggered when server stops receiving video stream from local camera.
				 * @param onStateUpdated Callback that is triggered when server makes a state change on accepting video stream.
				 */
				this.RegisterRemoteRendererEventListener = function(onAdded, onRemoved, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnRemoteRendererAdded = arguments[0].onAdded;
							this.VidyoConnectorOnRemoteRendererRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnRemoteRendererStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnRemoteRendererAdded = onAdded;
						this.VidyoConnectorOnRemoteRendererRemoved = onRemoved;
						this.VidyoConnectorOnRemoteRendererStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteRendererEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about remote speaker events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered when server is ready to accept audio stream from local microphone.
				 * @param onRemoved Callback that is triggered when server stops receiving audio stream from local microphone.
				 * @param onStateUpdated Callback that is triggered when server makes a state change on accepting audio stream.
				 */
				this.RegisterRemoteSpeakerEventListener = function(onAdded, onRemoved, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnRemoteSpeakerAdded = arguments[0].onAdded;
							this.VidyoConnectorOnRemoteSpeakerRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnRemoteSpeakerStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnRemoteSpeakerAdded = onAdded;
						this.VidyoConnectorOnRemoteSpeakerRemoved = onRemoved;
						this.VidyoConnectorOnRemoteSpeakerStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteSpeakerEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about remote shreable-window events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered when another participant adds a window-share into a conference.
				 * @param onRemoved Callback that is triggered when another participant removes a window-share from a conference.
				 * @param onStateUpdated Callback that is triggered when another participant window-share changes state in a conference.
				 */
				this.RegisterRemoteWindowShareEventListener = function(onAdded, onRemoved, onStateUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated')){
							this.VidyoConnectorOnRemoteWindowShareAdded = arguments[0].onAdded;
							this.VidyoConnectorOnRemoteWindowShareRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnRemoteWindowShareStateUpdated = arguments[0].onStateUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function")){
						this.VidyoConnectorOnRemoteWindowShareAdded = onAdded;
						this.VidyoConnectorOnRemoteWindowShareRemoved = onRemoved;
						this.VidyoConnectorOnRemoteWindowShareStateUpdated = onStateUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteWindowShareEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about window-share frames from other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onFrame Callback that is triggered for every frame from a remote window share.
				 * @param remoteWindowShare The VidyoRemoteWindowShare for which to receive the frames.
				 * @param width Approximate width of the requested frame.
				 * @param height Approximate height of the requested frame.
				 * @param frameInterval Approximate frame interval of the requested frame.
				 */
				this.RegisterRemoteWindowShareFrameListener = function(onFrame, remoteWindowShare, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame') && arguments[0].hasOwnProperty('remoteWindowShare') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							this.VidyoConnectorOnRemoteWindowShareFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId, remoteWindowShare: (arguments[0].remoteWindowShare ? arguments[0].remoteWindowShare.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame', 'remoteWindowShare', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						this.VidyoConnectorOnRemoteWindowShareFrame = onFrame;
						var params = vcUtilsParam({c: this.objId, remoteWindowShare: (arguments[1] ? arguments[1].objId : 0), width: arguments[2], height: arguments[3], frameInterval: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterRemoteWindowShareFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about resource-management events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAvailableResourcesChanged Callback that is triggered when local resource availability changes.
				 * @param onMaxRemoteSourcesChanged Callback that is triggered when the maximum number of decoded sources changes.
				 */
				this.RegisterResourceManagerEventListener = function(onAvailableResourcesChanged, onMaxRemoteSourcesChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAvailableResourcesChanged') && arguments[0].hasOwnProperty('onMaxRemoteSourcesChanged')){
							this.VidyoConnectorOnAvailableResourcesChanged = arguments[0].onAvailableResourcesChanged;
							this.VidyoConnectorOnMaxRemoteSourcesChanged = arguments[0].onMaxRemoteSourcesChanged;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAvailableResourcesChanged', 'onMaxRemoteSourcesChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoConnectorOnAvailableResourcesChanged = onAvailableResourcesChanged;
						this.VidyoConnectorOnMaxRemoteSourcesChanged = onMaxRemoteSourcesChanged;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterResourceManagerEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous and private interface, for usage please contact vidyo api support team. Application can register a private callback to receive tokens from the vidyo portal. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onTokenReceived Callback that is triggered when the tokens are received from the vidyo portal.
				 */
				this.RegisterTokenReceivedEventListener = function(onTokenReceived) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onTokenReceived')){
							this.VidyoConnectorOnTokenReceived = arguments[0].onTokenReceived;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onTokenReceived'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnTokenReceived = onTokenReceived;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterTokenReceivedEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about virtual audio source events. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered each time when virtual audio source is created.
				 * @param onRemoved Callback that is triggered each time when virtual audio source is removed.
				 * @param onStateUpdated Callback that is triggered each time when virtual audio source chagnes state.
				 * @param onSelected Callback that is triggered each time when virtual audio source is selected.
				 * @param onExternalMediaBufferReleased Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw audio frame data.
				 */
				this.RegisterVirtualAudioSourceEventListener = function(onAdded, onRemoved, onStateUpdated, onSelected, onExternalMediaBufferReleased) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated') && arguments[0].hasOwnProperty('onSelected') && arguments[0].hasOwnProperty('onExternalMediaBufferReleased')){
							this.VidyoConnectorOnVirtualAudioSourceAdded = arguments[0].onAdded;
							this.VidyoConnectorOnVirtualAudioSourceRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnVirtualAudioSourceStateUpdated = arguments[0].onStateUpdated;
							this.VidyoConnectorOnVirtualAudioSourceSelected = arguments[0].onSelected;
							this.VidyoConnectorOnVirtualAudioSourceExternalMediaBufferReleased = arguments[0].onExternalMediaBufferReleased;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated', 'onSelected', 'onExternalMediaBufferReleased'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function") && (typeof(arguments[4]) === "function")){
						this.VidyoConnectorOnVirtualAudioSourceAdded = onAdded;
						this.VidyoConnectorOnVirtualAudioSourceRemoved = onRemoved;
						this.VidyoConnectorOnVirtualAudioSourceStateUpdated = onStateUpdated;
						this.VidyoConnectorOnVirtualAudioSourceSelected = onSelected;
						this.VidyoConnectorOnVirtualAudioSourceExternalMediaBufferReleased = onExternalMediaBufferReleased;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterVirtualAudioSourceEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about virtual video source events. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onAdded Callback that is triggered each time when virtual video source is added into a conference.
				 * @param onRemoved Callback that is triggered each time when virtual video source is added from a conference.
				 * @param onStateUpdated Callback that is triggered each time when virtual video source chagnes state in a conference.
				 * @param onExternalMediaBufferReleased Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.
				 */
				this.RegisterVirtualVideoSourceEventListener = function(onAdded, onRemoved, onStateUpdated, onExternalMediaBufferReleased) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onAdded') && arguments[0].hasOwnProperty('onRemoved') && arguments[0].hasOwnProperty('onStateUpdated') && arguments[0].hasOwnProperty('onExternalMediaBufferReleased')){
							this.VidyoConnectorOnVirtualVideoSourceAdded = arguments[0].onAdded;
							this.VidyoConnectorOnVirtualVideoSourceRemoved = arguments[0].onRemoved;
							this.VidyoConnectorOnVirtualVideoSourceStateUpdated = arguments[0].onStateUpdated;
							this.VidyoConnectorOnVirtualVideoSourceExternalMediaBufferReleased = arguments[0].onExternalMediaBufferReleased;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onAdded', 'onRemoved', 'onStateUpdated', 'onExternalMediaBufferReleased'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnVirtualVideoSourceAdded = onAdded;
						this.VidyoConnectorOnVirtualVideoSourceRemoved = onRemoved;
						this.VidyoConnectorOnVirtualVideoSourceStateUpdated = onStateUpdated;
						this.VidyoConnectorOnVirtualVideoSourceExternalMediaBufferReleased = onExternalMediaBufferReleased;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterVirtualVideoSourceEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Registers to get notified about web proxy events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param onWebProxyCredentialsRequest Callback that is triggered when web proxy credentials are requested.
				 */
				this.RegisterWebProxyEventListener = function(onWebProxyCredentialsRequest) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onWebProxyCredentialsRequest')){
							this.VidyoConnectorOnWebProxyCredentialsRequest = arguments[0].onWebProxyCredentialsRequest;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onWebProxyCredentialsRequest'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnWebProxyCredentialsRequest = onWebProxyCredentialsRequest;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRegisterWebProxyEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Removes audio device from whitelist. This interface is allowed to be called in all VidyoConnector states except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param deviceName The name of audio device that will be removed from whitelist.
				 */
				this.RemoveAudioDeviceFromWhitelist = function(deviceName) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('deviceName')){
							var params = vcUtilsParam({c: this.objId, deviceName: arguments[0].deviceName});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['deviceName'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, deviceName: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRemoveAudioDeviceFromWhitelist?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This API provides the ability for the room owner to remove authentication scheme for moderator functionality. Once moderator pin is removed, other users will not be able to moderate call on that room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.RemoveModeratorPIN = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRemoveModeratorPIN?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This API provides the ability to remove moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param onRemoveModeratorRoleResult Callback to be triggered when remove of moderator role is completed
				 */
				this.RemoveModeratorRole = function(onRemoveModeratorRoleResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onRemoveModeratorRoleResult')){
							this.VidyoConnectorOnRemoveModeratorRoleResult = arguments[0].onRemoveModeratorRoleResult;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onRemoveModeratorRoleResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnRemoveModeratorRoleResult = onRemoveModeratorRoleResult;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRemoveModeratorRole?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Remove presenter rights from a specific participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.RemovePresenter = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRemovePresenter?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param onRemoveRoomPinResult Callback to be triggered for remove room pin result.
				 */
				this.RemoveRoomPIN = function(onRemoveRoomPinResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onRemoveRoomPinResult')){
							this.VidyoConnectorOnRemoveRoomPINResult = arguments[0].onRemoveRoomPinResult;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onRemoveRoomPinResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnRemoveRoomPINResult = onRemoveRoomPinResult;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRemoveRoomPIN?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. By default, local participant joining/leaving are not reported to applicaiotn. Use this function to report those events. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param reportLocalParticipant Set to LMI_TRUE if application is interested in local participant to be included in participant event callbacks. Otherwise set to LMI_FALSE. Default is LMI_FALSE
				 */
				this.ReportLocalParticipantOnJoined = function(reportLocalParticipant) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('reportLocalParticipant')){
							var params = vcUtilsParam({c: this.objId, reportLocalParticipant: arguments[0].reportLocalParticipant});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['reportLocalParticipant'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, reportLocalParticipant: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorReportLocalParticipantOnJoined?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This API provides the ability to request moderator privilege for the regular user. If the room is owned by this user or user is Admin/operator moderator pin can be empty string. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param moderatorPIN set authentication scheme (moderator pIN) to get the moderatore role functionality. Empty string for admin/host.
				 * @param onRequestModeratorRoleResult Callback to be triggered when request of moderator role is completed
				 */
				this.RequestModeratorRole = function(moderatorPIN, onRequestModeratorRoleResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('moderatorPIN') && arguments[0].hasOwnProperty('onRequestModeratorRoleResult')){
							this.VidyoConnectorOnRequestModeratorRoleResult = arguments[0].onRequestModeratorRoleResult;
							var params = vcUtilsParam({c: this.objId, moderatorPIN: arguments[0].moderatorPIN});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['moderatorPIN', 'onRequestModeratorRoleResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "function")){
						this.VidyoConnectorOnRequestModeratorRoleResult = onRequestModeratorRoleResult;
						var params = vcUtilsParam({c: this.objId, moderatorPIN: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRequestModeratorRole?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Request to resume sending video after sever paused video stream from selected local camera. Will resume both local and remote streams and show preview in case it is on. Allowed only in case of soft mute. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.RequestToResumeVideo = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRequestToResumeVideo?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Request to speak after sever paused audio stream from selected local microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.RequestToSpeak = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRequestToSpeak?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Requests video for remote camera before assign. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param remoteCamera The VidyoRemoteCamera for which to receive the video.
				 * @param width Approximate width of the requested video.
				 * @param height Approximate height of the requested video.
				 * @param frameInterval Approximate frame interval of the requested video.
				 * @param onFirstFrameReceived Callback that is triggered when first frame from a remote camera received.
				 */
				this.RequestVideoForRemoteCamera = function(remoteCamera, width, height, frameInterval, onFirstFrameReceived) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteCamera') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval') && arguments[0].hasOwnProperty('onFirstFrameReceived')){
							this.VidyoConnectorOnRemoteCameraFirstFrameReceived = arguments[0].onFirstFrameReceived;
							var params = vcUtilsParam({c: this.objId, remoteCamera: (arguments[0].remoteCamera ? arguments[0].remoteCamera.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteCamera', 'width', 'height', 'frameInterval', 'onFirstFrameReceived'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "function")){
						this.VidyoConnectorOnRemoteCameraFirstFrameReceived = onFirstFrameReceived;
						var params = vcUtilsParam({c: this.objId, remoteCamera: (arguments[0] ? arguments[0].objId : 0), width: arguments[1], height: arguments[2], frameInterval: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRequestVideoForRemoteCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Requests video for remote window share before assign. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param remoteWindowShare The VidyoRemoteWindowShare for which to receive the video.
				 * @param width Approximate width of the requested video.
				 * @param height Approximate height of the requested video.
				 * @param frameInterval Approximate frame interval of the requested video.
				 * @param onFirstFrameReceived Callback that is triggered when first frame from a remote window share received.
				 */
				this.RequestVideoForRemoteWindowShare = function(remoteWindowShare, width, height, frameInterval, onFirstFrameReceived) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteWindowShare') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval') && arguments[0].hasOwnProperty('onFirstFrameReceived')){
							this.VidyoConnectorOnRemoteWindowShareFirstFrameReceived = arguments[0].onFirstFrameReceived;
							var params = vcUtilsParam({c: this.objId, remoteWindowShare: (arguments[0].remoteWindowShare ? arguments[0].remoteWindowShare.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteWindowShare', 'width', 'height', 'frameInterval', 'onFirstFrameReceived'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "function")){
						this.VidyoConnectorOnRemoteWindowShareFirstFrameReceived = onFirstFrameReceived;
						var params = vcUtilsParam({c: this.objId, remoteWindowShare: (arguments[0] ? arguments[0].objId : 0), width: arguments[1], height: arguments[2], frameInterval: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorRequestVideoForRemoteWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c Pointer to the VidyoConnector object.
				 * @param onRecordingServiceResumeResultCallback Callback called upon completion.
				 */
				this.ResumeRecording = function(onRecordingServiceResumeResultCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onRecordingServiceResumeResultCallback')){
							this.VidyoConnectorOnRecordingServiceResumeResult = arguments[0].onRecordingServiceResumeResultCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onRecordingServiceResumeResultCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnRecordingServiceResumeResult = onRecordingServiceResumeResultCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorResumeRecording?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Search for users in conference mode.
				 * @param c The VidyoConnector object pointer.
				 * @param searchText The search text to search users.
				 * @param startIndex The starting index from where the result should be retrieved.
				 * @param maxRecords The max number of records in the result.
				 * @param onUserSearchResults The callback which will receive the results.
				 */
				this.SearchUsers = function(searchText, startIndex, maxRecords, onUserSearchResults) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('searchText') && arguments[0].hasOwnProperty('startIndex') && arguments[0].hasOwnProperty('maxRecords') && arguments[0].hasOwnProperty('onUserSearchResults')){
							this.VidyoConnectorOnUserSearchResults = arguments[0].onUserSearchResults;
							var params = vcUtilsParam({c: this.objId, searchText: arguments[0].searchText, startIndex: arguments[0].startIndex, maxRecords: arguments[0].maxRecords});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['searchText', 'startIndex', 'maxRecords', 'onUserSearchResults'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "function")){
						this.VidyoConnectorOnUserSearchResults = onUserSearchResults;
						var params = vcUtilsParam({c: this.objId, searchText: arguments[0], startIndex: arguments[1], maxRecords: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSearchUsers?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local microphone to use for audio content share. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localMicrophone Local microphone to select for audio content share. NULL if none of them should be selected.
				 */
				this.SelectAudioContentShare = function(localMicrophone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localMicrophone')){
							var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0].localMicrophone ? arguments[0].localMicrophone.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localMicrophone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectAudioContentShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Resets the camera selection to pick the Default camera. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.SelectDefaultCamera = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectDefaultCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Resets the microphone selection to pick the Default microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.SelectDefaultMicrophone = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectDefaultMicrophone?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the default ANY network interface to be used for Media. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.SelectDefaultNetworkInterfaceForMedia = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectDefaultNetworkInterfaceForMedia?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the default ANY network interface to be used for Signaling. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.SelectDefaultNetworkInterfaceForSignaling = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectDefaultNetworkInterfaceForSignaling?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Resets the speaker selection to pick the Default speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.SelectDefaultSpeaker = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectDefaultSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local camera to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localCamera Local camera to select. NULL if none of them should be selected.
				 */
				this.SelectLocalCamera = function(localCamera) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localCamera')){
							var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0].localCamera ? arguments[0].localCamera.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localCamera'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local microphone to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localMicrophone Local microphone to select. NULL if none of them should be selected.
				 */
				this.SelectLocalMicrophone = function(localMicrophone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localMicrophone')){
							var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0].localMicrophone ? arguments[0].localMicrophone.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localMicrophone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalMicrophone?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localMonitor Local monitor to share in a conference. NULL if none of them should be shared.
				 */
				this.SelectLocalMonitor = function(localMonitor) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localMonitor')){
							var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0].localMonitor ? arguments[0].localMonitor.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localMonitor'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalMonitor?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local monitor to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localMonitor Local monitor to share in a conference. NULL if none of them should be shared.
				 * @param options A structure that represent the sharing options.
				 */
				this.SelectLocalMonitorAdvanced = function(localMonitor, options) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localMonitor') && arguments[0].hasOwnProperty('options')){
							var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0].localMonitor ? arguments[0].localMonitor.objId : 0), options: JSON.stringify(arguments[0].options)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localMonitor', 'options'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object")){
						var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0] ? arguments[0].objId : 0), options: JSON.stringify(arguments[1])});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(options&& response.data.options)
								vcUtilsExtend(options, response.data.options);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalMonitorAdvanced?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local speaker to use. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localSpeaker Local speaker to select. NULL if none of them should be selected.
				 */
				this.SelectLocalSpeaker = function(localSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localSpeaker')){
							var params = vcUtilsParam({c: this.objId, localSpeaker: (arguments[0].localSpeaker ? arguments[0].localSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localWindowShare Local window to share in a conference. NULL if none of them should be shared.
				 */
				this.SelectLocalWindowShare = function(localWindowShare) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localWindowShare')){
							var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0].localWindowShare ? arguments[0].localWindowShare.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localWindowShare'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local window to share in a conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localWindowShare Local window to share in a conference. NULL if none of them should be shared.
				 * @param options A structure that represent the sharing options.
				 */
				this.SelectLocalWindowShareAdvanced = function(localWindowShare, options) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localWindowShare') && arguments[0].hasOwnProperty('options')){
							var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0].localWindowShare ? arguments[0].localWindowShare.objId : 0), options: JSON.stringify(arguments[0].options)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localWindowShare', 'options'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object")){
						var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0] ? arguments[0].objId : 0), options: JSON.stringify(arguments[1])});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(options&& response.data.options)
								vcUtilsExtend(options, response.data.options);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectLocalWindowShareAdvanced?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the network interface to be used for Media. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param networkInterface Network interface to be selected.
				 */
				this.SelectNetworkInterfaceForMedia = function(networkInterface) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('networkInterface')){
							var params = vcUtilsParam({c: this.objId, networkInterface: (arguments[0].networkInterface ? arguments[0].networkInterface.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['networkInterface'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, networkInterface: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectNetworkInterfaceForMedia?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the network interface to be used for Signaling. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param networkInterface Network interface to be selected.
				 */
				this.SelectNetworkInterfaceForSignaling = function(networkInterface) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('networkInterface')){
							var params = vcUtilsParam({c: this.objId, networkInterface: (arguments[0].networkInterface ? arguments[0].networkInterface.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['networkInterface'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, networkInterface: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectNetworkInterfaceForSignaling?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Selects the local camera to use for video content share. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localCamera Local camera to select. NULL if none of them should be selected.
				 */
				this.SelectVideoContentShare = function(localCamera) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localCamera')){
							var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0].localCamera ? arguments[0].localCamera.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localCamera'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectVideoContentShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Selects the virtual audio source which will be used for content share. The selected microphone which currently using for content share will be unselected. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceStateUpdated will trigger.
				 * @param c The VidyoConnector object.
				 * @param virtualAudioSource The virtual audio source that will be used for content share.
				 */
				this.SelectVirtualAudioContentShare = function(virtualAudioSource) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualAudioSource')){
							var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0].virtualAudioSource ? arguments[0].virtualAudioSource.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualAudioSource'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectVirtualAudioContentShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the virtual video source which is camera that will be shown to remote participants. The real camera will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param virtualCamera The virtual video source that will be shown to remote participants.
				 */
				this.SelectVirtualCamera = function(virtualCamera) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualCamera')){
							var params = vcUtilsParam({c: this.objId, virtualCamera: (arguments[0].virtualCamera ? arguments[0].virtualCamera.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualCamera'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualCamera: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectVirtualCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Selects the virtual audio source which will be used as microphone. The real miicrophone will be unselected if it's selected. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceStateUpdated will trigger.
				 * @param c The VidyoConnector object.
				 * @param virtualAudioSource The virtual audio source that will be used as microphone.
				 */
				this.SelectVirtualMicrophone = function(virtualAudioSource) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualAudioSource')){
							var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0].virtualAudioSource ? arguments[0].virtualAudioSource.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualAudioSource'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectVirtualMicrophone?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the virtual renderer to receive all events required for rendering. On, iOS, this API must be called from main(UI) thread. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param renderer The virtual renderer object to select, NULL to unselect.
				 */
				this.SelectVirtualRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({c: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectVirtualRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Selects the virtual video source which is window share that will be shown to remote participants. The local window share will be unselected if it's selected. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param virtualWindowShare The virtual video source that will be shown to remote participants.
				 */
				this.SelectVirtualSourceWindowShare = function(virtualWindowShare) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualWindowShare')){
							var params = vcUtilsParam({c: this.objId, virtualWindowShare: (arguments[0].virtualWindowShare ? arguments[0].virtualWindowShare.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualWindowShare'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualWindowShare: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSelectVirtualSourceWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sends a message to all the other participants. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param message A message to send to all the other participants.
				 */
				this.SendChatMessage = function(message) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('message')){
							var params = vcUtilsParam({c: this.objId, message: arguments[0].message});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['message'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, message: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSendChatMessage?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sends a message to the specific participant. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param participant A participant that will receive message.
				 * @param message A message to send to the specific participants.
				 */
				this.SendPrivateChatMessage = function(participant, message) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('message')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), message: arguments[0].message});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'message'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), message: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSendPrivateChatMessage?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sends already constructed audio frame to selected virtual audio source and then send it to local and/or remote streams. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param virtualAudioSource The virtual audio source.
				 * @param audioFrame The audio frame to be sent.
				 */
				this.SendVirtualAudioSourceFrame = function(virtualAudioSource, audioFrame) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualAudioSource') && arguments[0].hasOwnProperty('audioFrame')){
							var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0].virtualAudioSource ? arguments[0].virtualAudioSource.objId : 0), audioFrame: (arguments[0].audioFrame ? arguments[0].audioFrame.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualAudioSource', 'audioFrame'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object")){
						var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0] ? arguments[0].objId : 0), audioFrame: (arguments[1] ? arguments[1].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSendVirtualAudioSourceFrame?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Pass raw buffer to selected virtual audio source, based on which the audio frame will be constructed and then send it to local and/or remote streams. This is an asynchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE. The VidyoConnectorOnVirtualAudioSourceExternalMediaBufferReleased will trigger when buffer is not needed anymore.
				 * @param c The VidyoConnector object.
				 * @param virtualAudioSource The virtual audio source.
				 * @param buffer The buffer with audio data to be sent.
				 * @param nbSamples The number of sample frames that will be represented in the audio data.
				 * @param elapsedTime The elapsed time.
				 */
				this.SendVirtualAudioSourceFrameWithExternalData = function(virtualAudioSource, buffer, nbSamples, elapsedTime) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('virtualAudioSource') && arguments[0].hasOwnProperty('buffer') && arguments[0].hasOwnProperty('nbSamples') && arguments[0].hasOwnProperty('elapsedTime')){
							var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0].virtualAudioSource ? arguments[0].virtualAudioSource.objId : 0), buffer: arguments[0].buffer, nbSamples: arguments[0].nbSamples, elapsedTime: arguments[0].elapsedTime});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['virtualAudioSource', 'buffer', 'nbSamples', 'elapsedTime'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({c: this.objId, virtualAudioSource: (arguments[0] ? arguments[0].objId : 0), buffer: arguments[1], nbSamples: arguments[1], elapsedTime: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSendVirtualAudioSourceFrameWithExternalData?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Allow application to set advanced log options in addition to standard ones. The given log levels and categories string will be added to current log level the application is running with. The string should be valid for this API to work correctly. e.g debug@VidyoConnector debug@VidyoClient.
				 * @param c The VidyoConnector object.
				 * @param loggerType The loggerType console, file, feedback, http.
				 * @param advancedLogFilter advanced log options in addition to standard ones. <p>A space-separated (or comma-separated) sequence of names of log levels, each optionally followed by a category. Categories are separated from levels by the character '@'.</p> <p>Either a level or category may be specified as 'all' or '*' (interchangeably), meaning all levels or categories. A level specified without a category is equivalent to a level@*.</p> <p>The levels are: 'fatal', 'error', 'warning', 'info', 'debug', 'sent', 'received', 'enter', and 'leave'.</p> <p>The level may be prefixed by '-' or '!' (interchangeably), meaning to remove the given level (or levels, see below) from the given category. The string 'none' is equivalent to '-all'.</p> <p>The first level in the list may be prefixed by '+'. If the first level begins with a '+' or '-'/'!', the string is used to modify the listener's existing levels and categories. Otherwise, unless the <code>add</code> parameter is true, the levels and categories specified in the string replace all existing levels and categories for the listener. The leading character '+' may be present before other levels, but is ignored.</p> <p>Unless they are preceded by '=', level names imply other levels as well. In particular, each of the levels 'fatal', 'error', 'warning', 'info', and 'debug' implies the levels higher than it, when specified positively; 'sent' and 'received' always imply each other; and 'enter' and 'leave' always imply each other.</p> <p>See VidyoConnectorGetLogCategories for determining the names and descriptions of registered categories.</p> <p>Level names are case-insensitive; category names are case-sensitive.</p> <p>Example: "all" - all levels, all categories.</p> <p>Example: "all -enter" - all categories, all levels but enter and leave.</p> <p>Example: "*@VidyoClient" - all levels for the VidyoClient category.</p> <p>Example: "-*@VidyoClient" - remove all levels from the VidyoClient category.</p> <p>Example: "debug" - all categories, fatal, error, warning, info, and debug levels.</p> <p>Example: "=debug" - all categories, debug level only.</p> <p>Example: "all -=enter" - all categories, all levels but enter (leave is still included).</p> <p>Example: "error@VidyoClient" - fatal and error only for the VidyoClient category.</p> <p>Example: "warning debug@VidyoClient" - fatal, error, and warning for all categories; additionally, info and debug for the VidyoClient category.</p>
				 */
				this.SetAdvancedLogOptions = function(loggerType, advancedLogFilter) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('loggerType') && arguments[0].hasOwnProperty('advancedLogFilter')){
							var params = vcUtilsParam({c: this.objId, loggerType: arguments[0].loggerType, advancedLogFilter: arguments[0].advancedLogFilter});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['loggerType', 'advancedLogFilter'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, loggerType: arguments[0], advancedLogFilter: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAdvancedLogOptions?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets up advanced options on the VidyoConnector API. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param options The experimental optons in JSON format.
				 */
				this.SetAdvancedOptions = function(options) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('options')){
							var params = vcUtilsParam({c: this.objId, options: arguments[0].options});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['options'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, options: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAdvancedOptions?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets multiplier value to be used when calculating the audio bitrate. Default is 2. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param bitrateMultiplier Bitrate multiplier for which possible values are 0, 1 and 2.
				 */
				this.SetAudioBitrateMultiplier = function(bitrateMultiplier) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('bitrateMultiplier')){
							var params = vcUtilsParam({c: this.objId, bitrateMultiplier: arguments[0].bitrateMultiplier});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['bitrateMultiplier'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, bitrateMultiplier: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAudioBitrateMultiplier?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enables or disables usage of audio devices (speaker and microphone) in different audio modes. By default SharedModeBoth is enabled. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param audioMode Indicates which audio mode is enabled/disabled for both audio devices. For possible values of the audio mode, refer VidyoConnectorAudioMode.
				 */
				this.SetAudioMode = function(audioMode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('audioMode')){
							var params = vcUtilsParam({c: this.objId, audioMode: arguments[0].audioMode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['audioMode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, audioMode: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAudioMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets time interval between two packet of audio in miliseconds. Default is 40 ms. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param packetInterval Packet interval for which possible values are 20, and 40 ms.
				 */
				this.SetAudioPacketInterval = function(packetInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('packetInterval')){
							var params = vcUtilsParam({c: this.objId, packetInterval: arguments[0].packetInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['packetInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, packetInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAudioPacketInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets value that is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Default is 10%. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param lossPercentage Loss percantage for which possible values are [0, 10, 20, 30] in percentage.
				 */
				this.SetAudioPacketLossPercentage = function(lossPercentage) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('lossPercentage')){
							var params = vcUtilsParam({c: this.objId, lossPercentage: arguments[0].lossPercentage});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['lossPercentage'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, lossPercentage: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAudioPacketLossPercentage?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enables or disables auto-reconnect. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param enable Indicates whether auto-reconnect is enabled or not.
				 */
				this.SetAutoReconnect = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAutoReconnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets back off for next reconnect attempt. By default, it is set to 5 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param backOff Time in seconds before next reconnect attempt. Min value is 2 and the max is 20 seconds.
				 */
				this.SetAutoReconnectAttemptBackOff = function(backOff) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('backOff')){
							var params = vcUtilsParam({c: this.objId, backOff: arguments[0].backOff});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['backOff'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, backOff: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAutoReconnectAttemptBackOff?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets maximum attempts to be done for reconnecting. By default, it is set to 3. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param maxAttempts Number of maximum attempts to be done for reconnecting. Min value is 1 and the max is 4.
				 */
				this.SetAutoReconnectMaxAttempts = function(maxAttempts) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxAttempts')){
							var params = vcUtilsParam({c: this.objId, maxAttempts: arguments[0].maxAttempts});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxAttempts'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, maxAttempts: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetAutoReconnectMaxAttempts?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the intensity of the background blur effect. It is allowed to change blur intensity while the effect is enabled. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
				 * @param c The VidyoConnector object.
				 * @param intensity The intensity of the background blur effect. Valid valies is [3-8]. Default value is 5.
				 */
				this.SetBlurIntensity = function(intensity) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('intensity')){
							var params = vcUtilsParam({c: this.objId, intensity: arguments[0].intensity});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['intensity'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, intensity: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetBlurIntensity?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enables the specified by VidyoConnectorCameraEffectType camera background effect or disables active effect if VIDYO_CONNECTORCAMERAEFFECTTYPE_None passed. The application must provide token to enable this feature as part of VidyoConnectorCameraEffectInfo structure. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
				 * @param c The VidyoConnector object.
				 * @param effectInfo Represents the configuration of camera background effect.
				 */
				this.SetCameraBackgroundEffect = function(effectInfo) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('effectInfo')){
							var params = vcUtilsParam({c: this.objId, effectInfo: JSON.stringify(arguments[0].effectInfo)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['effectInfo'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, effectInfo: JSON.stringify(arguments[0])});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetCameraBackgroundEffect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets camera PTZ nudge configuration. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param cameraNudgeConfig Camera PTZ nudge configuration in JSON format.
				 */
				this.SetCameraNudgeConfiguration = function(cameraNudgeConfig) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('cameraNudgeConfig')){
							var params = vcUtilsParam({c: this.objId, cameraNudgeConfig: arguments[0].cameraNudgeConfig});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['cameraNudgeConfig'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, cameraNudgeConfig: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetCameraNudgeConfiguration?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Sets the flag to show/hide the local camera for remote participants for composite/custom layout and local camera preview for composite layout only. Will also unmute a soft mute(Hunter only). On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param privacy Flag to show/hide the local camera.
				 */
				this.SetCameraPrivacy = function(privacy) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('privacy')){
							var params = vcUtilsParam({c: this.objId, privacy: arguments[0].privacy});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['privacy'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, privacy: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetCameraPrivacy?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the file that contains certificate authority's certificates used to authenticate a TLS connection. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param certificateAuthorityFile The string representing Certificate Authority file. Note: The string must containt full path and name of file.
				 */
				this.SetCertificateAuthorityFile = function(certificateAuthorityFile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('certificateAuthorityFile')){
							var params = vcUtilsParam({c: this.objId, certificateAuthorityFile: arguments[0].certificateAuthorityFile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['certificateAuthorityFile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, certificateAuthorityFile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetCertificateAuthorityFile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the list of certificate authority's certificates used to authenticate a TLS connection. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param certificateAuthorityList The string representing Certificate Authority lists. Note: If the string 'default' is passed here, VidyoConnector will use a built-in Certificate Authority list.
				 */
				this.SetCertificateAuthorityList = function(certificateAuthorityList) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('certificateAuthorityList')){
							var params = vcUtilsParam({c: this.objId, certificateAuthorityList: arguments[0].certificateAuthorityList});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['certificateAuthorityList'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, certificateAuthorityList: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetCertificateAuthorityList?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets conference number - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param conferenceNumber Conference number to be set.
				 */
				this.SetConferenceNumber = function(conferenceNumber) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('conferenceNumber')){
							var params = vcUtilsParam({c: this.objId, conferenceNumber: arguments[0].conferenceNumber});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['conferenceNumber'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, conferenceNumber: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetConferenceNumber?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Set CPU tradeoff profile. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param profile The tradeoff profile.
				 */
				this.SetCpuTradeOffProfile = function(profile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('profile')){
							var params = vcUtilsParam({c: this.objId, profile: arguments[0].profile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['profile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, profile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetCpuTradeOffProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. When enabled, all video feeds (video and content share) will be shut off to the client when the user experiences prolonged low network bandwidth. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param enable Indicates whether disable video on low bandwidth is enabled or not.
				 */
				this.SetDisableVideoOnLowBandwidth = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetDisableVideoOnLowBandwidth?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets number of audio streams requested while video is shut off. By default, it is set to 3. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param audioStreams Number of audio streams requested while video is shut off. Min value is 1 and max is 3.
				 */
				this.SetDisableVideoOnLowBandwidthAudioStreams = function(audioStreams) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('audioStreams')){
							var params = vcUtilsParam({c: this.objId, audioStreams: arguments[0].audioStreams});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['audioStreams'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, audioStreams: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetDisableVideoOnLowBandwidthAudioStreams?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets time it takes to recover when video is shut off. By default, it is set to 0 seconds which means never. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param recoveryTime Time it takes to recover when video is shut off. Recovery can only happen when there are no available video sources.
				 */
				this.SetDisableVideoOnLowBandwidthRecoveryTime = function(recoveryTime) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('recoveryTime')){
							var params = vcUtilsParam({c: this.objId, recoveryTime: arguments[0].recoveryTime});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['recoveryTime'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, recoveryTime: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetDisableVideoOnLowBandwidthRecoveryTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets time it takes to shut off video due to low bandwidth. By default, it is set to 30 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param responseTime Time it takes to shut off video due to low bandwidth.
				 */
				this.SetDisableVideoOnLowBandwidthResponseTime = function(responseTime) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('responseTime')){
							var params = vcUtilsParam({c: this.objId, responseTime: arguments[0].responseTime});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['responseTime'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, responseTime: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetDisableVideoOnLowBandwidthResponseTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets how often to check for low bandwidth. By default, it is set to 5 seconds. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param sampleTime How often to check for low bandwidth. Must divide evenly into responseTime.
				 */
				this.SetDisableVideoOnLowBandwidthSampleTime = function(sampleTime) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('sampleTime')){
							var params = vcUtilsParam({c: this.objId, sampleTime: arguments[0].sampleTime});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['sampleTime'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, sampleTime: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetDisableVideoOnLowBandwidthSampleTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets low bandwidth threshold. By default, it is set to 100kpbs. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle,VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param kbps Threshold for low bandwidth in kilobits/sec.
				 */
				this.SetDisableVideoOnLowBandwidthThreshold = function(kbps) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('kbps')){
							var params = vcUtilsParam({c: this.objId, kbps: arguments[0].kbps});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['kbps'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, kbps: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetDisableVideoOnLowBandwidthThreshold?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets log file size limit, how often to initiate the wrap, and number of log files. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param maxSize The number of bytes of logged messages to save.
				 * @param wrapPeriod How often to initiate the wrap in nanoseconds. If this value is LMI_TIME_INFINITE, the log file will not be wrapped based on time.
				 * @param wrapCount The maximum number of files to keep.
				 */
				this.SetFileLoggerRotationParameters = function(maxSize, wrapPeriod, wrapCount) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxSize') && arguments[0].hasOwnProperty('wrapPeriod') && arguments[0].hasOwnProperty('wrapCount')){
							var params = vcUtilsParam({c: this.objId, maxSize: arguments[0].maxSize, wrapPeriod: arguments[0].wrapPeriod, wrapCount: arguments[0].wrapCount});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxSize', 'wrapPeriod', 'wrapCount'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({c: this.objId, maxSize: arguments[0], wrapPeriod: arguments[1], wrapCount: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetFileLoggerRotationParameters?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Set font file name. On, iOS, this API must be called from main(UI) thread. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param fontFileName Pointer to char array that contains font file name. Note: on Windows this must be the name of a system TrueType font. For example "Microsoft YaHei"
				 */
				this.SetFontFileName = function(fontFileName) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('fontFileName')){
							var params = vcUtilsParam({c: this.objId, fontFileName: arguments[0].fontFileName});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['fontFileName'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, fontFileName: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetFontFileName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the geographic location of the endpoint using the VidyoConnector. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param latitude Latitude of the geographic coordinate.
				 * @param longitude Longitude of the geographic coordinate.
				 */
				this.SetLocation = function(latitude, longitude) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('latitude') && arguments[0].hasOwnProperty('longitude')){
							var params = vcUtilsParam({c: this.objId, latitude: arguments[0].latitude, longitude: arguments[0].longitude});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['latitude', 'longitude'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({c: this.objId, latitude: arguments[0], longitude: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetLocation?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets new path to log file. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param filename The name of the file to log to. Note: Can be passed just filename or with full path so that location will be changed.
				 */
				this.SetLogFilePath = function(filename) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('filename')){
							var params = vcUtilsParam({c: this.objId, filename: arguments[0].filename});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['filename'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, filename: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetLogFilePath?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Allow application to replace log level of logger(console, file, feedback, http) as production or debug. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param loggerType loggerType console, file, feedback, http.
				 * @param logLevel log level production or debug.
				 */
				this.SetLogLevel = function(loggerType, logLevel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('loggerType') && arguments[0].hasOwnProperty('logLevel')){
							var params = vcUtilsParam({c: this.objId, loggerType: arguments[0].loggerType, logLevel: arguments[0].logLevel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['loggerType', 'logLevel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, loggerType: arguments[0], logLevel: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetLogLevel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the max send bit rate for all sources. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param bitRate The max send bit rate for all sources.
				 */
				this.SetMaxBitRate = function(bitRate) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('bitRate')){
							var params = vcUtilsParam({c: this.objId, bitRate: arguments[0].bitRate});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['bitRate'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, bitRate: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMaxBitRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Request server to limit bit rate sent to this client. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CNNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param bitRate The maximum receiving bit rate request sent to server, in bps.
				 */
				this.SetMaxReceiveBitRate = function(bitRate) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('bitRate')){
							var params = vcUtilsParam({c: this.objId, bitRate: arguments[0].bitRate});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['bitRate'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, bitRate: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMaxReceiveBitRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the max send bit rate for all sources. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param bitRate The max send bit rate for all sources, in bps.
				 */
				this.SetMaxSendBitRate = function(bitRate) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('bitRate')){
							var params = vcUtilsParam({c: this.objId, bitRate: arguments[0].bitRate});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['bitRate'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, bitRate: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMaxSendBitRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param boostLevel Boost level for which possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.
				 */
				this.SetMicrophoneMaxBoostLevel = function(boostLevel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('boostLevel')){
							var params = vcUtilsParam({c: this.objId, boostLevel: arguments[0].boostLevel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['boostLevel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, boostLevel: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMicrophoneMaxBoostLevel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Sets the flag to mute/unmute the microphone. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param privacy Flag to mute/unmute the microphone.
				 */
				this.SetMicrophonePrivacy = function(privacy) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('privacy')){
							var params = vcUtilsParam({c: this.objId, privacy: arguments[0].privacy});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['privacy'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, privacy: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMicrophonePrivacy?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param volumePercent Volume percent for which possible values are 0 - 100 percentage. Default is 50 percent.
				 */
				this.SetMinMicrophoneVolume = function(volumePercent) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('volumePercent')){
							var params = vcUtilsParam({c: this.objId, volumePercent: arguments[0].volumePercent});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['volumePercent'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, volumePercent: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMinMicrophoneVolume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the operating mode of the VidyoConnector. This API have to be called before renderer is destructed: i.e. VidyoConnectorHideView will be called in case VIDYO_CONNECTORMODE_Background and after renderer is constructed: i.e. VidyoConnectorAssignViewToCompositeRenderer, VidyoConnectorAssignViewToLocalCamera, VidyoConnectorAssignViewToRemoteCamera will be called in case VIDYO_CONNECTORMODE_Foreground. This API is required only when user in the conference. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector. It won't do anything in VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead states of VidyoConnector but it will still return LMI_TRUE.
				 * @param c The VidyoConnector object.
				 * @param mode Desired operating mode.
				 */
				this.SetMode = function(mode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('mode')){
							var params = vcUtilsParam({c: this.objId, mode: arguments[0].mode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['mode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, mode: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This API provides the ability to allow a room owner to set an authentication scheme (moderator pin) for moderator functionality. The same authentication scheme must be used by other users by calling VidyoConnectorRequestModeratorRole to get moderator privilege. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param moderatorPIN authentication scheme (moderator pin) for moderator functionality.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.SetModeratorPIN = function(moderatorPIN, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('moderatorPIN') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, moderatorPIN: arguments[0].moderatorPIN, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['moderatorPIN', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, moderatorPIN: arguments[0], requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetModeratorPIN?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets up options on the VidyoConnector API. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param options The options in JSON format. <p>conferenceReferenceNumber - a special identifier that will show up in the Portal CDR record for the conference. Should be set before joining the conference.</p> <p>Example: {'conferenceReferenceNumber' : 'reference number'}.</p> <p>microphoneMaxBoostLevel - sets max boost level that will be applied only in the conference for the selected microphone in case the system is set to the higher value. Possible values are devices specific, e.g. 0 - 20 dB. Default is 12 dB.</p> <p>Example: {'microphoneMaxBoostLevel' : 10}.</p> <p>minMicrophoneVolume - sets min volume that will be applied only in the conference for the selected microphone in case the system is set to the lower value. Possible values are 0 - 100 percentage. Default is 50 per cent.</p> <p>Example: {'minMicrophoneVolume' : 70}.</p> <p>Possible values for audio device modes are : audioSharedModeBoth - use both audio devices (Speaker and Microphone) in shared mode. audioExclusiveModeBoth - use both audio devices (Speaker and Microphone) in exclusive mode. audioExclusiveModeMic - use microphone in exclusive mode and speaker in shared mode. By default VidyoClient is working with audioSharedModeBoth. A new mode will be applied only for the next conference or in case another device is selected.</p> <p>Example: {'audioSharedModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeBoth' : true}.</p> <p>Example: {'audioExclusiveModeMic' : true}.</p> <p>preferredAudioCodec - sets VidyoClient to use preferred audio codec. Possible value are OPUS RED, OPUS and SPEEX RED. Default is OPUS RED.</p> <p>Example: {'preferredAudioCodec' : 'SPEEX RED'}.</p> <p>AudioBitrateMultiplier - A multiplier to be used when calculating the audio bitrate. Possible values are 0, 1 and 2. Default is 2.</p> <p>Example: {'AudioBitrateMultiplier':1}.</p> <p>AudioPacketInterval - It decies audio frame duration to encoder. It sets time interval between two packet of audio in miliseconds Possible values are 20, and 40 ms. Default is 40 ms.</p> <p>Example: {'AudioPacketInterval':40}.</p> <p>AudioPacketLossPercentage - it values is used to configure encoder. If given higher value then encoder is configured to resistant to loss on the expense of quality. Possible values are [0, 10, 20, 30] in percentage. Default is 10%.</p> <p>Example: {'AudioPacketLossPercentage':20}.</p> <p>statRate - sets VidyoRoom statistics gather interval in seconds. Possible values are 2, 5, 10, 20 and 30. Default is 10.</p> <p>Example: {'statRate':10}.</p> <p>enableStaticShareSvc - Specifies whether SVC will be enabled or disabled for static sharing. Possible values are true or false. The default is false. Note: SVC is enabled by default for interactive video and high frame rate sharing.</p> <p>Example: {'enableStaticShareSvc' : true}.</p>
				 */
				this.SetOptions = function(options) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('options')){
							var params = vcUtilsParam({c: this.objId, options: arguments[0].options});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['options'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, options: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetOptions?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets a specific media pool to use for audio and video. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param name Name of the pool.
				 */
				this.SetPool = function(name) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('name')){
							var params = vcUtilsParam({c: this.objId, name: arguments[0].name});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['name'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, name: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetPool?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets VidyoClient to use preferred audio codec. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param preferredAudioCodec Preferred audio codec to be set. For possible values of the audio codec, refer VidyoConnectorPreferredAudioCodec.
				 */
				this.SetPreferredAudioCodec = function(preferredAudioCodec) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('preferredAudioCodec')){
							var params = vcUtilsParam({c: this.objId, preferredAudioCodec: arguments[0].preferredAudioCodec});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['preferredAudioCodec'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, preferredAudioCodec: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetPreferredAudioCodec?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Set a specific participant as a presenter. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param participant The VidyoParticipant object who will be a new presenter.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.SetPresenter = function(participant, requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('participant') && arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, participant: (arguments[0].participant ? arguments[0].participant.objId : 0), requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['participant', 'requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, participant: (arguments[0] ? arguments[0].objId : 0), requestId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetPresenter?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the product information. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param productInfo Sets the product information. Supported Properties- ApplicationName, ApplicationVersion
				 */
				this.SetProductInfo = function(productInfo) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('productInfo')){
							var params = vcUtilsParam({c: this.objId, productInfo: JSON.stringify({"productInfo": arguments[0].productInfo})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['productInfo'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, productInfo: JSON.stringify({"productInfo": arguments[0]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetProductInfo?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets up the local renderer and conference tiles displaying options. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform-specific view ID.
				 * @param options A char array that contains options in the JSON format. <p>EnableVerticalVideoCentering - Enable or disable the vertical centering of the video screen. Default is true.</p> <p>Example: {'EnableVerticalVideoCentering':true}.</p> <p>EnableFECCIconCustomLayout - Enable or disable the displaying of custom FECC icon in the right bottom corner. Default is false.</p> <p>Example: {'EnableFECCIconCustomLayout':false}.</p> <p>ViewingDistance - Sets viewing distance in feet. Default is 2.5. Minimum and Maximum values are 1f & 15f respectively.</p> <p>Example: {'ViewingDistance':2.5}.</p> <p>ShowAudioTiles - Enable or disable the showing of audio tiles. Default is true.</p> <p>Example: {'ShowAudioTiles':false}.</p> <p>SetPipPosition - Sets the position of the preview when it is displayed using picture-in-picture mode. Possible values for x: "PipPositionLeft", "PipPositionCenter", "PipPositionRight". Possible values for y: "PipPositionBottom", "PipPositionCenter", "PipPositionTop". lockPip is a boolean indicating whether to lock the preview in this position (by default is false). When false, the user may drag the preview to another location using the mouse or a touch. setPipSize - Sets the size of the preview in picture-in-picture mode. The value is a positive integer representing the percentage of the screen size (1 to 50). Default value is 1. setPipToTileAfterNTiles - Sets the number of tiles after which the preview will be displayed as a tile instead of picture-in-picture. (default value is 2) A value of 0 means the preview will always be visible in picture-in-picture mode whereas N means that the preview will be visible as tile if the number of tiles is greater than N (where N is a positive integer).</p> <p>Example: {'SetPipPosition':{'x':'PipPositionRight', 'y': 'PipPositionTop', 'lockPip':true, 'setPipSize':1, 'setPipToTileAfterNTiles':2}}.</p> <p>SetPixelDensity - Sets the rendering environment's pixel density.</p> <p>Example: {'SetPixelDensity':326.0f. However for latest rendering environment, being released for iOS only, this option is used to choose surface density with possible values as 0.5 (everything will be smaller) / 1.0 (default) / 2.0 (everything will be larger).}</p> <p>SetTouchAsInputDevice - Enable or disable touch as a input device. Default is false.</p> <p>Example: {'SetTouchAsInputDevice':false}.</p> <p>EnableExpandedCameraControl - Enable or disable expanded camera control. Default is true for mobile devices and false for non-mobile devices.</p> <p>Example: {'EnableExpandedCameraControl':false}.</p> <p>BorderStyle - Sets the border style of the preview. None: Do not put a border on any tiles. Same: Put the same colored border on each tile. Highlight: Put a border on each tile, but tiles associated with the highest ranked participant will have a different colored border than the others. Flash: Tiles associated with the highest ranked participant have a different colored border than the others, When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily. Possible values for BorderStyle: "None", "Same", "Highlight", "Flash"</p> <p>Example: {'BorderStyle':'Same'</p>} <p>enablePreviewMirroring - Specifies whether mirroring will be enabled or disabled for local cameras. Possible values are true or false. The default is true.</p> <p>Example: {'EnablePreviewMirroring' : true}.</p>
				 */
				this.SetRendererOptionsForViewId = function(viewId, options) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('options')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"SetRendererOptionsForViewId", viewId:arguments[0].viewId, options:arguments[0].options});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, options: arguments[0].options});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'options'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"SetRendererOptionsForViewId", viewId:viewId, options:options});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], options: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetRendererOptionsForViewId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param roomPIN Pin to be set as room PIN or set NULL to remove existing room PIN
				 * @param onSetRoomPinResult Callback to be triggered for set room pin result.
				 */
				this.SetRoomPIN = function(roomPIN, onSetRoomPinResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('roomPIN') && arguments[0].hasOwnProperty('onSetRoomPinResult')){
							this.VidyoConnectorOnSetRoomPINResult = arguments[0].onSetRoomPinResult;
							var params = vcUtilsParam({c: this.objId, roomPIN: arguments[0].roomPIN});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['roomPIN', 'onSetRoomPinResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "function")){
						this.VidyoConnectorOnSetRoomPINResult = onSetRoomPinResult;
						var params = vcUtilsParam({c: this.objId, roomPIN: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetRoomPIN?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Sets the flag to mute/unmute the speaker. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param privacy Flag to mute/unmute the speaker.
				 */
				this.SetSpeakerPrivacy = function(privacy) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('privacy')){
							var params = vcUtilsParam({c: this.objId, privacy: arguments[0].privacy});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['privacy'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, privacy: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetSpeakerPrivacy?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enables or disables SVC. By default SVC is disabled. Note: For interactive video and high frame rate sharing SVC is enabled by default. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param enable Indicates whether enable SVC or not.
				 */
				this.SetStaticShareSvcState = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetStaticShareSvcState?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets conference room statistics gather interval in seconds. Default is 10. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Disabling & VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param statRate Statistics gather interval for which possible values are 2, 5, 10, 20 and 30.
				 */
				this.SetStatisticRate = function(statRate) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('statRate')){
							var params = vcUtilsParam({c: this.objId, statRate: arguments[0].statRate});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['statRate'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, statRate: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetStatisticRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enable the use of TCP Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param enable Enable the tranport.
				 */
				this.SetTCPTransport = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetTCPTransport?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Set TURN server and credentials information. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param turnAddress TURN server FQDN or IP address.
				 * @param port TURN server port.
				 * @param username TURN server user name.
				 * @param password TURN server password.
				 * @param baseTransport Base transport type.
				 */
				this.SetTURNAddressCredentials = function(turnAddress, port, username, password, baseTransport) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('turnAddress') && arguments[0].hasOwnProperty('port') && arguments[0].hasOwnProperty('username') && arguments[0].hasOwnProperty('password') && arguments[0].hasOwnProperty('baseTransport')){
							var params = vcUtilsParam({c: this.objId, turnAddress: arguments[0].turnAddress, port: arguments[0].port, username: arguments[0].username, password: arguments[0].password, baseTransport: arguments[0].baseTransport});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['turnAddress', 'port', 'username', 'password', 'baseTransport'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string")){
						var params = vcUtilsParam({c: this.objId, turnAddress: arguments[0], port: arguments[1], username: arguments[2], password: arguments[3], baseTransport: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetTURNAddressCredentials?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Set TURN server certificate requirement. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param required LMI_TRUE if TURN server certificate is required.
				 */
				this.SetTURNServerCertificateRequired = function(required) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('required')){
							var params = vcUtilsParam({c: this.objId, required: arguments[0].required});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['required'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, required: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetTURNServerCertificateRequired?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enable the use of UDP Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param enable Enable the tranport.
				 */
				this.SetUDPTransport = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetUDPTransport?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the speed of transition animation for windows moving around inside the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID to be positioned.
				 * @param speedPercentage Percentage of animation speed with default of 50, 100 for slowest and 0 for instant.
				 */
				this.SetViewAnimationSpeed = function(viewId, speedPercentage) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('speedPercentage')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"SetViewAnimationSpeed", viewId:arguments[0].viewId, speedPercentage:arguments[0].speedPercentage});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, speedPercentage: arguments[0].speedPercentage});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'speedPercentage'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"SetViewAnimationSpeed", viewId:viewId, speedPercentage:speedPercentage});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], speedPercentage: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetViewAnimationSpeed?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Set the background color of the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID to be positioned.
				 * @param red Red component of the color 0-255.
				 * @param green Green component of the color 0-255.
				 * @param blue Blue component of the color 0-255.
				 */
				this.SetViewBackgroundColor = function(viewId, red, green, blue) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('red') && arguments[0].hasOwnProperty('green') && arguments[0].hasOwnProperty('blue')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"SetViewBackgroundColor", viewId:arguments[0].viewId, red:arguments[0].red, green:arguments[0].green, blue:arguments[0].blue});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, red: arguments[0].red, green: arguments[0].green, blue: arguments[0].blue});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'red', 'green', 'blue'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"SetViewBackgroundColor", viewId:viewId, red:red, green:green, blue:blue});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], red: arguments[1], green: arguments[2], blue: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetViewBackgroundColor?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets path and file name to the picture that will be used for the virtual background effect. It is allowed to change picture while the effect is enabled. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE. This functionality is supported only for macOS 10.14 and above, iOS 10.0 and above and Windows VC++ 15 and above.
				 * @param c The VidyoConnector object.
				 * @param pathToPicture Path and file name to the picture. Currently, only PNG and JPG is supported.
				 */
				this.SetVirtualBackgroundPicture = function(pathToPicture) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('pathToPicture')){
							var params = vcUtilsParam({c: this.objId, pathToPicture: arguments[0].pathToPicture});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['pathToPicture'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, pathToPicture: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetVirtualBackgroundPicture?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets web proxy server address and credentials. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param proxyAddress The web proxy server address.
				 * @param username The web proxy server user name.
				 * @param password The web proxy server password.
				 */
				this.SetWebProxyAddressCredentials = function(proxyAddress, username, password) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('proxyAddress') && arguments[0].hasOwnProperty('username') && arguments[0].hasOwnProperty('password')){
							var params = vcUtilsParam({c: this.objId, proxyAddress: arguments[0].proxyAddress, username: arguments[0].username, password: arguments[0].password});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['proxyAddress', 'username', 'password'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({c: this.objId, proxyAddress: arguments[0], username: arguments[1], password: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetWebProxyAddressCredentials?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enable the use of WebProxy Transport when connecting. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param enable Enable the tranport.
				 */
				this.SetWebProxyTransport = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({c: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetWebProxyTransport?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Enable the use of WebProxy Transport with provided web proxy server address. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param name The name of web proxy server, it may also may be prefixed by a scheme ('http://proxy.company.com')
				 * @param port The port that web proxy server is running on
				 */
				this.SetWebProxyTransportAddress = function(name, port) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('name') && arguments[0].hasOwnProperty('port')){
							var params = vcUtilsParam({c: this.objId, name: arguments[0].name, port: arguments[0].port});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['name', 'port'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({c: this.objId, name: arguments[0], port: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSetWebProxyTransportAddress?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Shows or hides the audio meters in the view. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID to be positioned.
				 * @param showMeters Boolean to show or hide the audio meters.
				 */
				this.ShowAudioMeters = function(viewId, showMeters) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('showMeters')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"ShowAudioMeters", viewId:arguments[0].viewId, showMeters:arguments[0].showMeters});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, showMeters: arguments[0].showMeters});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'showMeters'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"ShowAudioMeters", viewId:viewId, showMeters:showMeters});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], showMeters: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowAudioMeters?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the flag to show/hide the local camera preview for composite layout only. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param preview Flag to show/hide the local camera preview.
				 */
				this.ShowPreview = function(preview) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('preview')){
							var params = vcUtilsParam({c: this.objId, preview: arguments[0].preview});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['preview'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, preview: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowPreview?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface to display statistics dialog box for a conference on desktop devices. It is not applicable for handheld devices. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param showStatisticsDialog Boolean value that indicate to show or hide the statistics dialog.
				 */
				this.ShowStatisticsDialog = function(showStatisticsDialog) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('showStatisticsDialog')){
							var params = vcUtilsParam({c: this.objId, showStatisticsDialog: arguments[0].showStatisticsDialog});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['showStatisticsDialog'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, showStatisticsDialog: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowStatisticsDialog?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID to be positioned.
				 * @param x X coordinate.
				 * @param y Y coordinate.
				 * @param width Width of the view.
				 * @param height Height of the view.
				 */
				this.ShowViewAt = function(viewId, x, y, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"ShowViewAt", viewId:arguments[0].viewId, x:arguments[0].x, y:arguments[0].y, width:arguments[0].width, height:arguments[0].height});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'x', 'y', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"ShowViewAt", viewId:viewId, x:x, y:y, width:width, height:height});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowViewAt?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the position of the view every time it's changed on the screen. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID to be positioned.
				 * @param x X coordinate (in points).
				 * @param y Y coordinate (in points).
				 * @param width Width of the view (in points).
				 * @param height Height of the view (in points).
				 */
				this.ShowViewAtPoints = function(viewId, x, y, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"ShowViewAtPoints", viewId:arguments[0].viewId, x:arguments[0].x, y:arguments[0].y, width:arguments[0].width, height:arguments[0].height});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'x', 'y', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"ShowViewAtPoints", viewId:viewId, x:x, y:y, width:width, height:height});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowViewAtPoints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Shows or hides the label on the view which displays the participant name or preview. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param viewId A platform specific view ID to be positioned.
				 * @param showLabel Boolean to show or hide the label.
				 */
				this.ShowViewLabel = function(viewId, showLabel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('showLabel')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"ShowViewLabel", viewId:arguments[0].viewId, showLabel:arguments[0].showLabel});
							var params = vcUtilsParam({c: this.objId, viewId: arguments[0].viewId, showLabel: arguments[0].showLabel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'showLabel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"ShowViewLabel", viewId:viewId, showLabel:showLabel});
						var params = vcUtilsParam({c: this.objId, viewId: arguments[0], showLabel: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowViewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Sets the flag to show/hide the window share preview. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param preview Flag to show/hide the window share preview.
				 */
				this.ShowWindowSharePreview = function(preview) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('preview')){
							var params = vcUtilsParam({c: this.objId, preview: arguments[0].preview});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['preview'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, preview: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorShowWindowSharePreview?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Start google analytics service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param options A structure that represent the google analytics options, plz refer VidyoConnectorGoogleAnalyticsOptions. If the user set to NULL, Vidyo Client will use default option to use google analytics.
				 */
				this.StartGoogleAnalyticsService = function(options) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('options')){
							var params = vcUtilsParam({c: this.objId, options: JSON.stringify(arguments[0].options)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['options'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, options: JSON.stringify(arguments[0])});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStartGoogleAnalyticsService?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Start insights service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param serverUrl Url of Insights server.
				 */
				this.StartInsightsService = function(serverUrl) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('serverUrl')){
							var params = vcUtilsParam({c: this.objId, serverUrl: arguments[0].serverUrl});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['serverUrl'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, serverUrl: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStartInsightsService?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Switch room mode to the Lecture mode. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.StartLectureMode = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStartLectureMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Stops logging into current file and start logging to the next one. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.StartNextLogFile = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStartNextLogFile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c Pointer to the VidyoConnector object.
				 * @param recordingProfilePrefix Recording profile prefix to start the recording with. Can be one of those provided by VidyoConnectorGetRecordingServiceProfiles or NULL - a default profile will be used.
				 * @param onRecordingServiceStartCallback Callback called upon completion.
				 */
				this.StartRecording = function(recordingProfilePrefix, onRecordingServiceStartCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('recordingProfilePrefix') && arguments[0].hasOwnProperty('onRecordingServiceStartCallback')){
							this.VidyoConnectorOnRecordingServiceStartResult = arguments[0].onRecordingServiceStartCallback;
							var params = vcUtilsParam({c: this.objId, recordingProfilePrefix: arguments[0].recordingProfilePrefix});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['recordingProfilePrefix', 'onRecordingServiceStartCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "function")){
						this.VidyoConnectorOnRecordingServiceStartResult = onRecordingServiceStartCallback;
						var params = vcUtilsParam({c: this.objId, recordingProfilePrefix: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStartRecording?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Stop google analytics service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.StopGoogleAnalyticsService = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStopGoogleAnalyticsService?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Stop insights service. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.StopInsightsService = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStopInsightsService?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Switch room mode to the Group mode. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.StopLectureMode = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStopLectureMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c Pointer to the VidyoConnector object.
				 * @param onRecordingServiceStopResultCallback Callback called upon completion.
				 */
				this.StopRecording = function(onRecordingServiceStopResultCallback) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onRecordingServiceStopResultCallback')){
							this.VidyoConnectorOnRecordingServiceStopResult = arguments[0].onRecordingServiceStopResultCallback;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onRecordingServiceStopResultCallback'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnRecordingServiceStopResult = onRecordingServiceStopResultCallback;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorStopRecording?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Swap streams of the remote video sources between views. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param first A platform specific view ID where the first remote video sources is displayed.
				 * @param second A platform specific view ID where the second remote video sources is displayed.
				 */
				this.SwapStreamsBetweenViews = function(first, second) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('first') && arguments[0].hasOwnProperty('second')){
							// arguments[0].firstarguments[0].second = UpdateViewOnDOM({uiEvent:"SwapStreamsBetweenViews", first:arguments[0].first, second:arguments[0].second});
							var params = vcUtilsParam({c: this.objId, first: arguments[0].first, second: arguments[0].second});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['first', 'second'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						// arguments[0]arguments[1] = UpdateViewOnDOM({uiEvent:"SwapStreamsBetweenViews", first:first, second:second});
						var params = vcUtilsParam({c: this.objId, first: arguments[0], second: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorSwapStreamsBetweenViews?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. This api provides the ability unlock the current room. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another states, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 * @param onUnlockRoomResult Callback to be triggered for UnlockRoom Result.
				 */
				this.UnlockRoom = function(onUnlockRoomResult) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onUnlockRoomResult')){
							this.VidyoConnectorOnUnlockRoomResult = arguments[0].onUnlockRoomResult;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onUnlockRoomResult'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoConnectorOnUnlockRoomResult = onUnlockRoomResult;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnlockRoom?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is an asynchronous interface. Each participant can send a moderation request to remove his raised hand to cancel the request to be unmuted. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param requestId Application provide identifier to track this request.
				 */
				this.UnraiseHand = function(requestId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('requestId')){
							var params = vcUtilsParam({c: this.objId, requestId: arguments[0].requestId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['requestId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, requestId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnraiseHand?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Application can unregister callback to stop bot participant event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterBotEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterBotEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters callback to notify the user in case of any errors occur during enabling camera effect.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterCameraEffectErrorListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterCameraEffectErrorListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Un-Registers the conference mode event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterConferenceModeEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterConferenceModeEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters event listener, application will not receive an event about connection properties changes. This API is allowed only in VIDYO_CONNECTORSTATE_Ready state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterConnectionPropertiesEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterConnectionPropertiesEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters advanced error event notifications.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterErrorEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterErrorEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Un-Registers the host event listeners. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterHostEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterHostEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Resets the callback for in call event. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterInCallEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterInCallEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters the Lecture mode part callbacks. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLectureModeEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLectureModeEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local camera event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLocalCameraEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalCameraEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local camera frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localCamera The VidyoLocalCamera for which to stop notifications.
				 */
				this.UnregisterLocalCameraFrameListener = function(localCamera) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localCamera')){
							var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0].localCamera ? arguments[0].localCamera.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localCamera'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localCamera: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalCameraFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local microphone energy notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLocalMicrophoneEnergyListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalMicrophoneEnergyListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local microphone event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLocalMicrophoneEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalMicrophoneEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local microphone frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localMicrophone The VidyoLocalMicrophone for which to stop notifications.
				 */
				this.UnregisterLocalMicrophoneFrameListener = function(localMicrophone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localMicrophone')){
							var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0].localMicrophone ? arguments[0].localMicrophone.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localMicrophone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localMicrophone: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalMicrophoneFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local monitor event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLocalMonitorEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalMonitorEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local monitor frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localMonitor The VidyoLocalMonitor for which to stop notifications.
				 */
				this.UnregisterLocalMonitorFrameListener = function(localMonitor) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localMonitor')){
							var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0].localMonitor ? arguments[0].localMonitor.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localMonitor'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localMonitor: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalMonitorFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local speaker event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLocalSpeakerEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalSpeakerEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local window share event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLocalWindowShareEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalWindowShareEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters local window share frame notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param localWindowShare The VidyoLocalWindowShare for which to stop notifications.
				 */
				this.UnregisterLocalWindowShareFrameListener = function(localWindowShare) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localWindowShare')){
							var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0].localWindowShare ? arguments[0].localWindowShare.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localWindowShare'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localWindowShare: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLocalWindowShareFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters log event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterLogEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterLogEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters message event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterMessageEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterMessageEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregister a callback to do not receive moderation commands sent from the server. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 */
				this.UnregisterModerationCommandEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterModerationCommandEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregistering notifications about moderation result events. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterModerationResultEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterModerationResultEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregister the callback to stop receiving the final response for the next generation renderer action. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c VidyoConnector object.
				 */
				this.UnregisterNGRResultEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterNGRResultEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters network interface event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterNetworkInterfaceEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterNetworkInterfaceEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters participant event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterParticipantEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterParticipantEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters plugin. This interface is allowed to be called in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle, VIDYO_CONNECTORSTATE_Dead and VIDYO_CONNECTORSTATE_Disabling. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param plugin Plugin to unregister.
				 */
				this.UnregisterPlugin = function(plugin) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('plugin')){
							var params = vcUtilsParam({c: this.objId, plugin: arguments[0].plugin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['plugin'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, plugin: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterPlugin?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters reconnecting event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterReconnectEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterReconnectEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters recorder in call event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRecorderInCallEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRecorderInCallEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote camera event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRemoteCameraEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteCameraEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote camera frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param remoteCamera The VidyoRemoteCamera for which to stop notifications.
				 */
				this.UnregisterRemoteCameraFrameListener = function(remoteCamera) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteCamera')){
							var params = vcUtilsParam({c: this.objId, remoteCamera: (arguments[0].remoteCamera ? arguments[0].remoteCamera.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteCamera'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, remoteCamera: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteCameraFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote microphone frame notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRemoteMicrophoneEnergyListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteMicrophoneEnergyListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote microphone event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRemoteMicrophoneEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteMicrophoneEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote microphone frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param remoteMicrophone The VidyoRemoteMicrophone for which to stop notifications.
				 */
				this.UnregisterRemoteMicrophoneFrameListener = function(remoteMicrophone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteMicrophone')){
							var params = vcUtilsParam({c: this.objId, remoteMicrophone: (arguments[0].remoteMicrophone ? arguments[0].remoteMicrophone.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteMicrophone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, remoteMicrophone: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteMicrophoneFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote renderer event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRemoteRendererEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteRendererEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote speaker event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRemoteSpeakerEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteSpeakerEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote window share event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterRemoteWindowShareEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteWindowShareEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters remote window share frame notifications. This API is allowed only in VIDYO_CONNECTORSTATE_Connected state of VidyoConnector. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 * @param remoteWindowShare The VidyoRemoteWindowShare for which to stop notifications.
				 */
				this.UnregisterRemoteWindowShareFrameListener = function(remoteWindowShare) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteWindowShare')){
							var params = vcUtilsParam({c: this.objId, remoteWindowShare: (arguments[0].remoteWindowShare ? arguments[0].remoteWindowShare.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteWindowShare'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, remoteWindowShare: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterRemoteWindowShareFrameListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters resource manager event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterResourceManagerEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterResourceManagerEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous and private interface, for usage please contact vidyo api support team. Application can unregister private callback to stop receiving tokens from the vidyo portal. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterTokenReceivedEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterTokenReceivedEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters virtual audio source event notifications. This is a synchronous interface. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterVirtualAudioSourceEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterVirtualAudioSourceEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters virtual video source event notifications. On, iOS, this API must be called from main(UI) thread. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterVirtualVideoSourceEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterVirtualVideoSourceEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This is a synchronous interface. Unregisters web proxy event notifications. This API is allowed in all states of VidyoConnector except VIDYO_CONNECTORSTATE_Idle and VIDYO_CONNECTORSTATE_Dead. If used in another state, no action will be taken and return LMI_FALSE.
				 * @param c The VidyoConnector object.
				 */
				this.UnregisterWebProxyEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoConnectorUnregisterWebProxyEventListener?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoGateway = function(){

				this.Destruct = function() {
					GetRequest("VidyoGatewayDestruct?" + vcUtilsParam({ gateway: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Connects to a gateway to a live conference with the specified resourceId.
				 * @param gateway The VidyoGateway object.
				 * @param host Host to which the connection will be made.
				 * @param token Token generated by the backend that contains the user ID and other metadata that will be used for authentication.
				 * @param displayName A display name that will be used in the UI.
				 * @param resourceId An alphanumeric string. This resourceId does does not need to be pre-provisioned but in order to create a connection between multiple participants, the same resource ID has to be specified.
				 * @param onSuccess Callback that is triggered when the connection is successfully established.
				 * @param onFailure Callback that is triggered when the connection establishemnt failed.
				 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
				 */
				this.Connect = function(host, token, displayName, resourceId, onSuccess, onFailure, onDisconnected) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('host') && arguments[0].hasOwnProperty('token') && arguments[0].hasOwnProperty('displayName') && arguments[0].hasOwnProperty('resourceId') && arguments[0].hasOwnProperty('onSuccess') && arguments[0].hasOwnProperty('onFailure') && arguments[0].hasOwnProperty('onDisconnected')){
							this.VidyoGatewayOnSuccess = arguments[0].onSuccess;
							this.VidyoGatewayOnFailure = arguments[0].onFailure;
							this.VidyoGatewayOnDisconnected = arguments[0].onDisconnected;
							var params = vcUtilsParam({gateway: this.objId, host: arguments[0].host, token: arguments[0].token, displayName: arguments[0].displayName, resourceId: arguments[0].resourceId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['host', 'token', 'displayName', 'resourceId', 'onSuccess', 'onFailure', 'onDisconnected'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 7 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "function") && (typeof(arguments[5]) === "function") && (typeof(arguments[6]) === "function")){
						this.VidyoGatewayOnSuccess = onSuccess;
						this.VidyoGatewayOnFailure = onFailure;
						this.VidyoGatewayOnDisconnected = onDisconnected;
						var params = vcUtilsParam({gateway: this.objId, host: arguments[0], token: arguments[1], displayName: arguments[2], resourceId: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoGatewayConnect?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Disconnects a live gateway call.
				 * @param gateway The VidyoGateway object.
				 */
				this.Disconnect = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({gateway: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({gateway: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoGatewayDisconnect?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoAudioFrame = function(){

				this.Destruct = function() {
					GetRequest("VidyoAudioFrameDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetBitsPerSample = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetBitsPerSample?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetData = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetData?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetDiscontinuity = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetDiscontinuity?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetDiscontinuityBitPresent = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetDiscontinuityBitPresent?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetElapsedTime = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetElapsedTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetEnergy = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetEnergy?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetEnergyBitPresent = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetEnergyBitPresent?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the frame format.
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetFormat = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetFormat?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetNumberOfChannels = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetNumberOfChannels?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetNumberOfSamples = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetNumberOfSamples?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetSampleRate = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetSampleRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetSize = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetSize?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetSpeech = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetSpeech?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetSpeechBitPresent = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetSpeechBitPresent?" + params, OnComplete, OnError);
					});
				}

				/**
				 * .
				 * @param f The VidyoAudioFrame object.
				 */
				this.GetTimestamp = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoAudioFrameGetTimestamp?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoDevice = function(){

				this.Destruct = function() {
					GetRequest("VidyoDeviceDestruct?" + vcUtilsParam({ device: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Compare the values of two derived devices for equality.
				 * @param obj The VidyoDevice object comparing against.
				 * @param other The VidyoDevice object comparing.
				 */
				this.DerivedEqual = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({obj: this.objId, other: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({obj: this.objId, other: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoDeviceDerivedEqual?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the device id.
				 * @param d The VidyoDevice object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({d: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({d: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoDeviceGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the device name.
				 * @param d The VidyoDevice object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({d: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({d: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoDeviceGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the device type.
				 * @param d The VidyoDevice object.
				 */
				this.GetType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({d: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({d: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoDeviceGetType?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoLocalCamera = function(){

				this.Destruct = function() {
					GetRequest("VidyoLocalCameraDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.AddToLocalRenderer = function(localRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer')){
							var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraAddToLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.AddToRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({c: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraAddToRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Allows the PTZ conrol of the camera by remote participants.
				 * @param c The VidyoLocalCamera object.
				 * @param allow Allow or prohibit camera control.
				 */
				this.AllowRemoteCameraControl = function(allow) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('allow')){
							var params = vcUtilsParam({c: this.objId, allow: arguments[0].allow});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['allow'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, allow: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraAllowRemoteCameraControl?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Send the PTZ Nudge commands to the local camera.
				 * @param c The VidyoLocalCamera object.
				 * @param pan Number of nudges to pan the camera.
				 * @param tilt Number of nudges to tilt the camera.
				 * @param zoom Number of nudges to zoom the camera.
				 */
				this.ControlPTZ = function(pan, tilt, zoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('pan') && arguments[0].hasOwnProperty('tilt') && arguments[0].hasOwnProperty('zoom')){
							var params = vcUtilsParam({c: this.objId, pan: arguments[0].pan, tilt: arguments[0].tilt, zoom: arguments[0].zoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['pan', 'tilt', 'zoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({c: this.objId, pan: arguments[0], tilt: arguments[1], zoom: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraControlPTZ?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Send PTZ Start command to the local camera.
				 * @param c The VidyoLocalCamera object.
				 * @param cmd PTZ command.
				 * @param timeout Amount of time in nanoseconds at which camera will be moving in the specified direction.
				 */
				this.ControlPTZStart = function(cmd, timeout) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('cmd') && arguments[0].hasOwnProperty('timeout')){
							var params = vcUtilsParam({c: this.objId, cmd: arguments[0].cmd, timeout: arguments[0].timeout});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['cmd', 'timeout'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({c: this.objId, cmd: arguments[0], timeout: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraControlPTZStart?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Send PTZ Stop command to the local camera.
				 * @param c The VidyoLocalCamera object.
				 */
				this.ControlPTZStop = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraControlPTZStop?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the backlight compensation state.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetBacklightCompensation = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetBacklightCompensation?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets camera control capabilities.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetControlCapabilities = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetControlCapabilities?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the frame rate v.s. video quality tradeoff profile.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetFramerateTradeOffProfile = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetFramerateTradeOffProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the camera.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the camera.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the position of the camera.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetPosition = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetPosition?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the preview label of the camera.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetPreviewLabel = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetPreviewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the resolution v.s. video quality tradeoff profile.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetResolutionTradeOffProfile = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetResolutionTradeOffProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Returns the current torch mode of camera. This function is only available if VidyoLocalCameraHasTorch returns true.
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetTorchMode = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetTorchMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.GetVideoCapabilities = function(capabilities) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('capabilities')){
							var params = vcUtilsParam({c: this.objId, capabilities: JSON.stringify({"capabilities": arguments[0].capabilities})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['capabilities'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, capabilities: JSON.stringify({"capabilities": arguments[0]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(capabilities&& response.data.capabilities)
								vcUtilsExtend(capabilities, response.data.capabilities);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetVideoCapabilities?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets supported video capabilities.
				 * @param c The VidyoLocalCamera object.
				 * @param onComplete The callback that is triggered when getting video capabilities completes.
				 */
				this.GetVideoCapabilitiesAsync = function(onComplete) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onComplete')){
							this.VidyoLocalCameraOnGetVideoCapabilitiesComplete = arguments[0].onComplete;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onComplete'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoLocalCameraOnGetVideoCapabilitiesComplete = onComplete;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraGetVideoCapabilitiesAsync?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Determines whether the camera has a torch.
				 * @param c The VidyoLocalCamera object.
				 */
				this.HasTorch = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraHasTorch?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks if the camera control to digital only.
				 * @param c The VidyoLocalCamera object.
				 */
				this.IsControlDigital = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraIsControlDigital?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.IsPaused = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraIsPaused?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks if the camera is suspended.
				 * @param c The VidyoLocalCamera object.
				 */
				this.IsSuspended = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraIsSuspended?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Determines whether camera supports a particular torch mode. This function is only available if VidyoLocalCameraHasTorch returns true.
				 * @param c The VidyoLocalCamera object.
				 * @param mode Torch mode.
				 */
				this.IsTorchModeSupported = function(mode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('mode')){
							var params = vcUtilsParam({c: this.objId, mode: arguments[0].mode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['mode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, mode: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraIsTorchModeSupported?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.RemoveFromLocalRenderer = function(localRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer')){
							var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraRemoveFromLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.RemoveFromRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({c: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraRemoveFromRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.Resume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraResume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the aspect ratio constraint on the camera which will adjust local camera frames to match.
				 * @param c The VidyoLocalCamera object.
				 * @param aspectRatioWidth Width of the aspect ratio.
				 * @param aspectRatioHeight Height of the aspect ration.
				 */
				this.SetAspectRatioConstraint = function(aspectRatioWidth, aspectRatioHeight) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('aspectRatioWidth') && arguments[0].hasOwnProperty('aspectRatioHeight')){
							var params = vcUtilsParam({c: this.objId, aspectRatioWidth: arguments[0].aspectRatioWidth, aspectRatioHeight: arguments[0].aspectRatioHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['aspectRatioWidth', 'aspectRatioHeight'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({c: this.objId, aspectRatioWidth: arguments[0], aspectRatioHeight: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetAspectRatioConstraint?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the backlight compensation which improves the dynamic range of the image when the subject is dark but the background is bright.
				 * @param c The VidyoLocalCamera object.
				 * @param backlightCompensation Compensate for the bright backlighting.
				 */
				this.SetBacklightCompensation = function(backlightCompensation) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('backlightCompensation')){
							var params = vcUtilsParam({c: this.objId, backlightCompensation: arguments[0].backlightCompensation});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['backlightCompensation'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, backlightCompensation: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetBacklightCompensation?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 */
				this.SetBoundsConstraint = function(minWidth, minHeight, maxWidth, maxHeight, maxFrameInterval, minFrameInterval, aspectRatioWidth, aspectRatioHeight, temporalSpatialTradeOff) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('minWidth') && arguments[0].hasOwnProperty('minHeight') && arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('aspectRatioWidth') && arguments[0].hasOwnProperty('aspectRatioHeight') && arguments[0].hasOwnProperty('temporalSpatialTradeOff')){
							var params = vcUtilsParam({c: this.objId, minWidth: arguments[0].minWidth, minHeight: arguments[0].minHeight, maxWidth: arguments[0].maxWidth, maxHeight: arguments[0].maxHeight, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, aspectRatioWidth: arguments[0].aspectRatioWidth, aspectRatioHeight: arguments[0].aspectRatioHeight, temporalSpatialTradeOff: arguments[0].temporalSpatialTradeOff});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['minWidth', 'minHeight', 'maxWidth', 'maxHeight', 'maxFrameInterval', 'minFrameInterval', 'aspectRatioWidth', 'aspectRatioHeight', 'temporalSpatialTradeOff'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 9 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number") && (typeof(arguments[6]) === "number") && (typeof(arguments[7]) === "number") && (typeof(arguments[8]) === "number")){
						var params = vcUtilsParam({c: this.objId, minWidth: arguments[0], minHeight: arguments[1], maxWidth: arguments[2], maxHeight: arguments[3], maxFrameInterval: arguments[4], minFrameInterval: arguments[5], aspectRatioWidth: arguments[6], aspectRatioHeight: arguments[7], temporalSpatialTradeOff: arguments[8]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetBoundsConstraint?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.SetCapabilitiesConstraint = function(capabilities, temporalSpatialTradeOff) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('capabilities') && arguments[0].hasOwnProperty('temporalSpatialTradeOff')){
							var params = vcUtilsParam({c: this.objId, capabilities: JSON.stringify({"capabilities": arguments[0].capabilities}), temporalSpatialTradeOff: arguments[0].temporalSpatialTradeOff});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['capabilities', 'temporalSpatialTradeOff'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({c: this.objId, capabilities: JSON.stringify({"capabilities": arguments[0]}), temporalSpatialTradeOff: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetCapabilitiesConstraint?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 */
				this.SetConstraints = function(minWidth, minHeight, maxWidth, maxHeight, maxFrameInterval, minFrameInterval, aspectRatioWidth, aspectRatioHeight, temporalSpatialTradeOff, capabilities) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('minWidth') && arguments[0].hasOwnProperty('minHeight') && arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('aspectRatioWidth') && arguments[0].hasOwnProperty('aspectRatioHeight') && arguments[0].hasOwnProperty('temporalSpatialTradeOff') && arguments[0].hasOwnProperty('capabilities')){
							var params = vcUtilsParam({c: this.objId, minWidth: arguments[0].minWidth, minHeight: arguments[0].minHeight, maxWidth: arguments[0].maxWidth, maxHeight: arguments[0].maxHeight, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, aspectRatioWidth: arguments[0].aspectRatioWidth, aspectRatioHeight: arguments[0].aspectRatioHeight, temporalSpatialTradeOff: arguments[0].temporalSpatialTradeOff, capabilities: JSON.stringify({"capabilities": arguments[0].capabilities})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['minWidth', 'minHeight', 'maxWidth', 'maxHeight', 'maxFrameInterval', 'minFrameInterval', 'aspectRatioWidth', 'aspectRatioHeight', 'temporalSpatialTradeOff', 'capabilities'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 10 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number") && (typeof(arguments[6]) === "number") && (typeof(arguments[7]) === "number") && (typeof(arguments[8]) === "number") && (typeof(arguments[9]) === "object")){
						var params = vcUtilsParam({c: this.objId, minWidth: arguments[0], minHeight: arguments[1], maxWidth: arguments[2], maxHeight: arguments[3], maxFrameInterval: arguments[4], minFrameInterval: arguments[5], aspectRatioWidth: arguments[6], aspectRatioHeight: arguments[7], temporalSpatialTradeOff: arguments[8], capabilities: JSON.stringify({"capabilities": arguments[9]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets camera control capabilities.
				 * @param c The VidyoLocalCamera object.
				 * @param caps The VidyoCameraControlCapabilities object.
				 */
				this.SetControlCapabilities = function(caps) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('caps')){
							var params = vcUtilsParam({c: this.objId, caps: JSON.stringify(arguments[0].caps)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['caps'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, caps: JSON.stringify(arguments[0])});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetControlCapabilities?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the camera control to digital only.
				 * @param c The VidyoLocalCamera object.
				 * @param digital Forces digital control.
				 */
				this.SetControlDigital = function(digital) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('digital')){
							var params = vcUtilsParam({c: this.objId, digital: arguments[0].digital});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['digital'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, digital: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetControlDigital?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the frame rate v.s. video quality tradeoff profile.
				 * @param c The VidyoLocalCamera object.
				 * @param profile Frame-rate tradeoff profile.
				 */
				this.SetFramerateTradeOffProfile = function(profile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('profile')){
							var params = vcUtilsParam({c: this.objId, profile: arguments[0].profile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['profile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, profile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetFramerateTradeOffProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the maximum resolution and framerate constraint on the local camera. This overrides the defaults which are based on the CPU profile of the endpoint. The maximum if not an exact match for the camera resolution will be chosen by the aproximate closest resolution based on calculations that include the width, height and frameInterval.
				 * @param c The VidyoLocalCamera object.
				 * @param width Maximum width.
				 * @param height Maximum height.
				 * @param frameInterval Maximum frame interval. Setting to 0 selects the fastest frame rate.
				 */
				this.SetMaxConstraint = function(width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({c: this.objId, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({c: this.objId, width: arguments[0], height: arguments[1], frameInterval: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetMaxConstraint?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the time delta that the camera moves left/right (pan), up/down (tilt), and/or in/out (zoom) for each nudge if the camera supports only start/stop (relative) behavior.
				 * @param c The VidyoLocalCamera object.
				 * @param panTime The time delta to pan the camera per nudge.
				 * @param tiltTime The time delta to tilt the camera per nudge.
				 * @param zoomTime The time delta to zoom the camera per nudge.
				 */
				this.SetNudgeTimes = function(panTime, tiltTime, zoomTime) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('panTime') && arguments[0].hasOwnProperty('tiltTime') && arguments[0].hasOwnProperty('zoomTime')){
							var params = vcUtilsParam({c: this.objId, panTime: arguments[0].panTime, tiltTime: arguments[0].tiltTime, zoomTime: arguments[0].zoomTime});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['panTime', 'tiltTime', 'zoomTime'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({c: this.objId, panTime: arguments[0], tiltTime: arguments[1], zoomTime: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetNudgeTimes?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets relative orientation of a local camera.
				 * @param c The VidyoLocalCamera object.
				 * @param orientation Orientation of the camera.
				 * @param lockOrientation Lock the camera in the specified orientation.
				 */
				this.SetOrientation = function(orientation, lockOrientation) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('orientation') && arguments[0].hasOwnProperty('lockOrientation')){
							var params = vcUtilsParam({c: this.objId, orientation: arguments[0].orientation, lockOrientation: arguments[0].lockOrientation});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['orientation', 'lockOrientation'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, orientation: arguments[0], lockOrientation: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetOrientation?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoLocalCamera object.
				 */
				this.SetPositionInLocalRenderer = function(localRenderer, x, y, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'x', 'y', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4], frameInterval: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetPositionInLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the preview label of the camera.
				 * @param c The VidyoLocalCamera object.
				 * @param previewLabel Display name to set on the camera.
				 */
				this.SetPreviewLabel = function(previewLabel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('previewLabel')){
							var params = vcUtilsParam({c: this.objId, previewLabel: arguments[0].previewLabel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['previewLabel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, previewLabel: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetPreviewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the preview label of the camera stream.
				 * @param c The VidyoLocalCamera object.
				 * @param previewLabel Display name to set on the camera stream. Camera and Content labels are stored separately.
				 */
				this.SetPreviewStreamLabel = function(previewLabel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('previewLabel')){
							var params = vcUtilsParam({c: this.objId, previewLabel: arguments[0].previewLabel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['previewLabel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, previewLabel: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetPreviewStreamLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the resolution v.s. video quality trade off profile.
				 * @param c The VidyoLocalCamera object.
				 * @param profile Resolution tradeoff profile.
				 */
				this.SetResolutionTradeOffProfile = function(profile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('profile')){
							var params = vcUtilsParam({c: this.objId, profile: arguments[0].profile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['profile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, profile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetResolutionTradeOffProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the target send bit rate for a local camera.
				 * @param c The VidyoLocalCamera object.
				 * @param bitRate The target send bit rate in bits per second.
				 */
				this.SetTargetBitRate = function(bitRate) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('bitRate')){
							var params = vcUtilsParam({c: this.objId, bitRate: arguments[0].bitRate});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['bitRate'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, bitRate: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetTargetBitRate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the torch mode for camera. This function is only available if VidyoLocalCameraHasTorch returns true and VidyoLocalCameraGetTorchMode called with the torch mode returns true.
				 * @param c The VidyoLocalCamera object.
				 * @param mode Torch mode.
				 */
				this.SetTorchMode = function(mode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('mode')){
							var params = vcUtilsParam({c: this.objId, mode: arguments[0].mode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['mode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, mode: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraSetTorchMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows camera control when rendering preview.
				 * @param c The VidyoLocalCamera object.
				 * @param show Show or hide camera controls.
				 */
				this.ShowCameraControl = function(show) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('show')){
							var params = vcUtilsParam({c: this.objId, show: arguments[0].show});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['show'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, show: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalCameraShowCameraControl?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoLocalMicrophone = function(){

				this.Destruct = function() {
					GetRequest("VidyoLocalMicrophoneDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.AddToLocalSpeaker = function(speaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('speaker')){
							var params = vcUtilsParam({m: this.objId, speaker: (arguments[0].speaker ? arguments[0].speaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['speaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, speaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneAddToLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.AddToRemoteSpeaker = function(remoteSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteSpeaker')){
							var params = vcUtilsParam({m: this.objId, remoteSpeaker: (arguments[0].remoteSpeaker ? arguments[0].remoteSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, remoteSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneAddToRemoteSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.DisableDebugRecording = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneDisableDebugRecording?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.EnableDebugRecording = function(dir) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('dir')){
							var params = vcUtilsParam({m: this.objId, dir: arguments[0].dir});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['dir'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({m: this.objId, dir: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneEnableDebugRecording?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetAutoGain = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetAutoGain?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get the microphone boost for the local microphone.
				 * @param m The local microphone object.
				 */
				this.GetBoost = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetBoost?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get echo cancellation status for particular microphone.
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetEchoCancellation = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetEchoCancellation?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the microphone.
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the microphone.
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets signal type of the microphone, which affects how the audio is processed.
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetSignalType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetSignalType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the type of the microphone.
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetVoiceProcessing = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetVoiceProcessing?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.GetVolume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneGetVolume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Hides an audio debug dialog for the local microphone.
				 * @param microphone The local microphone object to extract stats.
				 */
				this.HideDebugDialog = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({microphone: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({microphone: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneHideDebugDialog?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.IsDebugRecordingEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneIsDebugRecordingEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.IsPaused = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneIsPaused?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.Pause = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophonePause?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.PlayTone = function(dtmfTone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('dtmfTone')){
							var params = vcUtilsParam({m: this.objId, dtmfTone: arguments[0].dtmfTone});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['dtmfTone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({m: this.objId, dtmfTone: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophonePlayTone?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.RemoveFromLocalSpeaker = function(speaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('speaker')){
							var params = vcUtilsParam({m: this.objId, speaker: (arguments[0].speaker ? arguments[0].speaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['speaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, speaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneRemoveFromLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.RemoveFromRemoteSpeaker = function(remoteSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteSpeaker')){
							var params = vcUtilsParam({m: this.objId, remoteSpeaker: (arguments[0].remoteSpeaker ? arguments[0].remoteSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, remoteSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneRemoveFromRemoteSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Restart the local microphone.
				 * @param microphone The local microphone object to restart.
				 */
				this.Restart = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({microphone: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({microphone: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneRestart?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.Resume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneResume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable AGC for a microphone. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
				 * @param m The VidyoLocalMicrophone object.
				 * @param autoGain LMI_TRUE to enable AGC, LMI_FALSE to disable AGC.
				 */
				this.SetAutoGain = function(autoGain) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('autoGain')){
							var params = vcUtilsParam({m: this.objId, autoGain: arguments[0].autoGain});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['autoGain'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({m: this.objId, autoGain: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneSetAutoGain?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the microphone boost for the local microphone.
				 * @param m The local microphone object.
				 * @param value The microphone boost in dB.
				 */
				this.SetBoost = function(value) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('value')){
							var params = vcUtilsParam({m: this.objId, value: arguments[0].value});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['value'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({m: this.objId, value: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneSetBoost?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.SetEchoCancellation = function(speaker, isEnable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('speaker') && arguments[0].hasOwnProperty('isEnable')){
							var params = vcUtilsParam({m: this.objId, speaker: (arguments[0].speaker ? arguments[0].speaker.objId : 0), isEnable: arguments[0].isEnable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['speaker', 'isEnable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean")){
						var params = vcUtilsParam({m: this.objId, speaker: (arguments[0] ? arguments[0].objId : 0), isEnable: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneSetEchoCancellation?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the signal type of the microhone which changes how the auido is processed. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
				 * @param m The VidyoLocalMicrophone object.
				 * @param signalType The signal type of the microphone.
				 */
				this.SetSignalType = function(signalType) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('signalType')){
							var params = vcUtilsParam({m: this.objId, signalType: arguments[0].signalType});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['signalType'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({m: this.objId, signalType: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneSetSignalType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable voice processing and set voice processing mode. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
				 * @param m The VidyoLocalMicrophone object.
				 * @param voiceProcessing LMI_TRUE to enable the voice processing, LMI_FALSE to disable the voice processing.
				 * @param mode The voice processing mode.
				 */
				this.SetVoiceProcessing = function(voiceProcessing, mode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('voiceProcessing') && arguments[0].hasOwnProperty('mode')){
							var params = vcUtilsParam({m: this.objId, voiceProcessing: arguments[0].voiceProcessing, mode: arguments[0].mode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['voiceProcessing', 'mode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "boolean") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({m: this.objId, voiceProcessing: arguments[0], mode: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneSetVoiceProcessing?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMicrophone object.
				 */
				this.SetVolume = function(volumePercent) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('volumePercent')){
							var params = vcUtilsParam({m: this.objId, volumePercent: arguments[0].volumePercent});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['volumePercent'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({m: this.objId, volumePercent: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneSetVolume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows an audio debug dialog for the local microphone.
				 * @param microphone The local microphone object to extract stats.
				 */
				this.ShowDebugDialog = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({microphone: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({microphone: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMicrophoneShowDebugDialog?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoLocalMonitor = function(){

				this.Destruct = function() {
					GetRequest("VidyoLocalMonitorDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 */
				this.AddToLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({m: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorAddToLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 */
				this.AddToRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({m: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorAddToRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Clears existing constraints and set them to default values 3840x2160@3fps.
				 * @param m The VidyoLocalMonitor object.
				 */
				this.ClearConstraints = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorClearConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable/disable window exclude. Only top-level window related to the current process can be excluded.
				 * @param monitor The VidyoLocalMonitor object.
				 * @param window The VidyoLocalWindowShare object.
				 * @param exclude The variable indicates whether the window will be excluded or not.
				 */
				this.ExcludeWindow = function(window, exclude) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('window') && arguments[0].hasOwnProperty('exclude')){
							var params = vcUtilsParam({monitor: this.objId, window: (arguments[0].window ? arguments[0].window.objId : 0), exclude: arguments[0].exclude});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['window', 'exclude'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean")){
						var params = vcUtilsParam({monitor: this.objId, window: (arguments[0] ? arguments[0].objId : 0), exclude: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorExcludeWindow?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the monitor.
				 * @param m The VidyoLocalMonitor object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the monitor.
				 * @param m The VidyoLocalMonitor object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 * @param maxWidth Maximum width of the preview image.
				 * @param maxHeight Maximum height of the preview image.
				 * @param videoFrame Video Frame to which the image will be assigned.
				 */
				this.GetPreviewFrameDataUri = function(maxWidth, maxHeight, videoFrame) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('videoFrame')){
							var params = vcUtilsParam({m: this.objId, maxWidth: arguments[0].maxWidth, maxHeight: arguments[0].maxHeight, videoFrame: arguments[0].videoFrame});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxWidth', 'maxHeight', 'videoFrame'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({m: this.objId, maxWidth: arguments[0], maxHeight: arguments[1], videoFrame: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorGetPreviewFrameDataUri?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param maxWidth Maximum width of the preview image.
				 * @param maxHeight Maximum height of the preview image.
				 * @param onComplete Callback that is triggered when a preview frame is captured.
				 */
				this.GetPreviewFrameDataUriAsync = function(maxWidth, maxHeight, onComplete) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('onComplete')){
							this.VidyoLocalMonitorOnPreviewDataUriComplete = arguments[0].onComplete;
							var params = vcUtilsParam({m: this.objId, maxWidth: arguments[0].maxWidth, maxHeight: arguments[0].maxHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxWidth', 'maxHeight', 'onComplete'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "function")){
						this.VidyoLocalMonitorOnPreviewDataUriComplete = onComplete;
						var params = vcUtilsParam({m: this.objId, maxWidth: arguments[0], maxHeight: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorGetPreviewFrameDataUriAsync?" + params, OnComplete, OnError);
					});
				}

				this.IsPrimary = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorIsPrimary?" + params, OnComplete, OnError);
					});
				}

				this.PrecludeApplication = function(w) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('w')){
							var params = vcUtilsParam({m: this.objId, w: (arguments[0].w ? arguments[0].w.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['w'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, w: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorPrecludeApplication?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 */
				this.PrecludeWindow = function(w) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('w')){
							var params = vcUtilsParam({m: this.objId, w: (arguments[0].w ? arguments[0].w.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['w'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, w: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorPrecludeWindow?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 */
				this.RemoveFromLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({m: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorRemoveFromLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 */
				this.RemoveFromRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({m: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorRemoveFromRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions
				 * @param m The VidyoLocalMonitor object.
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param maxWidth Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit
				 * @param minWidth Unused
				 * @param maxHeight Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit
				 * @param minHeight Unusued
				 */
				this.SetBoundsConstraints = function(maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('minWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('minHeight')){
							var params = vcUtilsParam({m: this.objId, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, maxWidth: arguments[0].maxWidth, minWidth: arguments[0].minWidth, maxHeight: arguments[0].maxHeight, minHeight: arguments[0].minHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxFrameInterval', 'minFrameInterval', 'maxWidth', 'minWidth', 'maxHeight', 'minHeight'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({m: this.objId, maxFrameInterval: arguments[0], minFrameInterval: arguments[1], maxWidth: arguments[2], minWidth: arguments[3], maxHeight: arguments[4], minHeight: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetBoundsConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set frame interval(fps) for capturer.
				 * @param m The VidyoLocalMonitor object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. By default will be calculated based on encoder configuration.
				 */
				this.SetCaptureInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({m: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({m: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetCaptureInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used
				 * @param m The VidyoLocalMonitor object.
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param width The width of the stream after the stream is reconfigured
				 * @param height The height of the stream after the stream is reconfigured
				 * @param scaleFactor This should be 1
				 */
				this.SetDiscreteConstraints = function(maxFrameInterval, minFrameInterval, width, height, scaleFactor) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('scaleFactor')){
							var params = vcUtilsParam({m: this.objId, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, width: arguments[0].width, height: arguments[0].height, scaleFactor: arguments[0].scaleFactor});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxFrameInterval', 'minFrameInterval', 'width', 'height', 'scaleFactor'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						var params = vcUtilsParam({m: this.objId, maxFrameInterval: arguments[0], minFrameInterval: arguments[1], width: arguments[2], height: arguments[3], scaleFactor: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetDiscreteConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. Default is 333333333 which is 3 frames per second.
				 */
				this.SetFrameInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({m: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({m: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetFrameInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the low latency profile of the monitor which treats the stream as a regular video source. This prioritizes latency over quality.
				 * @param m The VidyoLocalMonitor object.
				 * @param profile Low latency profile toggle. Default is LMI_FALSE.
				 */
				this.SetLowLatencyProfile = function(profile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('profile')){
							var params = vcUtilsParam({m: this.objId, profile: arguments[0].profile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['profile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({m: this.objId, profile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetLowLatencyProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the monitor is in landscape mode width and height will be applied as max constraints, if the monitor is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
				 * @param m The VidyoLocalMonitor object
				 * @param width Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.
				 * @param height Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
				 */
				this.SetMaxConstraints = function(width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({m: this.objId, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({m: this.objId, width: arguments[0], height: arguments[1], frameInterval: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetMaxConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a minimum frame interval(maximum fps) for the encoded stream.
				 * @param m The VidyoLocalMonitor object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
				 */
				this.SetMinFrameInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({m: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({m: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetMinFrameInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoLocalMonitor object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames.
				 */
				this.SetPositionInLocalRenderer = function(localRenderer, x, y, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({m: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'x', 'y', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({m: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4], frameInterval: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitorSetPositionInLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
				 * @param monitor The VidyoLocalMonitor object.
				 * @param onGetCapabilities The callback to which we will pass the most optimal capabilities.
				 */
				this.eGetCapabilities = function(onGetCapabilities) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetCapabilities')){
							this.VidyoLocalMonitorOnGetCapabilities = arguments[0].onGetCapabilities;
							var params = vcUtilsParam({monitor: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetCapabilities'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoLocalMonitorOnGetCapabilities = onGetCapabilities;
						var params = vcUtilsParam({monitor: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalMonitoreGetCapabilities?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoLocalRenderer = function(){

				this.Destruct = function() {
					GetRequest("VidyoLocalRendererDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				this.Disable = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererDisable?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the expanded camera control to composite renderer.
				 * @param r The VidyoLocalRenderer object.
				 * @param enable LMI_TRUE to enable the expanded camera control to composite renderer, LMI_FALSE to disable expanded camera control to composite renderer.
				 */
				this.EnableExpandedCameraControl = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({r: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnableExpandedCameraControl?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the displaying of custom FECC icon in the right bottom corner.
				 * @param r The VidyoLocalRenderer object.
				 * @param enable LMI_TRUE to show custom FECC icon in the right bottom corner, LMI_FALSE to show default FECC icon in the right top corner.
				 */
				this.EnableFECCIconCustomLayout = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({r: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnableFECCIconCustomLayout?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the preview mirroring to composite renderer.
				 * @param r The VidyoLocalRenderer object.
				 * @param enable LMI_TRUE to enable the preview mirroring to composite renderer, LMI_FALSE to disable preview mirroring to composite renderer.
				 */
				this.EnablePreviewMirroring = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({r: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnablePreviewMirroring?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the displaying of picture-in-picture in a custom way.
				 * @param renderer The local renderer object.
				 * @param enable LMI_TRUE to always show picture-in-picture, LMI_FALSE to show picture-in-picture with two tiles.
				 */
				this.EnableSelfViewCustomLayout = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({renderer: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({renderer: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnableSelfViewCustomLayout?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the show audio tiles to composite renderer.
				 * @param r The VidyoLocalRenderer object.
				 * @param enable LMI_TRUE to enable the audio tiles to composite renderer, LMI_FALSE to disable audio tiles to composite renderer.
				 */
				this.EnableShowAudioTiles = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({r: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnableShowAudioTiles?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable touch as a input device.
				 * @param r The VidyoLocalRenderer object.
				 * @param isTouchInputDevice To indicate input method of this device is TOUCH (vs default MOUSE input).
				 */
				this.EnableTouchInputDevice = function(isTouchInputDevice) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('isTouchInputDevice')){
							var params = vcUtilsParam({r: this.objId, isTouchInputDevice: arguments[0].isTouchInputDevice});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['isTouchInputDevice'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, isTouchInputDevice: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnableTouchInputDevice?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the vertical centering of the video screen.
				 * @param r The VidyoLocalRenderer object.
				 * @param enable LMI_TRUE to show the center of video screen vertically if it's bigger than tile, LMI_FALSE to show the top of video screen vertically.
				 */
				this.EnableVerticalVideoCentering = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({r: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererEnableVerticalVideoCentering?" + params, OnComplete, OnError);
					});
				}

				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererGetId?" + params, OnComplete, OnError);
					});
				}

				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the rendering environment's pixel density.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.GetPixelDensity = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererGetPixelDensity?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get the viewing distance. This is the distance from the viewer's eye to the screen.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.GetViewingDistance = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererGetViewingDistance?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieves the status of the expanded camera control on composite renderer.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsExpandedCameraControlEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsExpandedCameraControlEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get state of custom FECC icon.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsFECCIconCustomLayoutEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsFECCIconCustomLayoutEnabled?" + params, OnComplete, OnError);
					});
				}

				this.IsPaused = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsPaused?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieves the status of the preview mirroring on composite renderer.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsPreviewMirroringEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsPreviewMirroringEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Query whether the currently-selected tile, if any, is in far-end camera-control (FECC) mode.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsSelectedTileControllingRemoteCamera = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsSelectedTileControllingRemoteCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieves the status of the show audio tiles on composite renderer.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsShowAudioTilesEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsShowAudioTilesEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieves the status of the touch input device.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsTouchInputDeviceEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsTouchInputDeviceEnabled?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get if the video screen is vertically centered.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.IsVerticalVideoCenteringEnabled = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererIsVerticalVideoCenteringEnabled?" + params, OnComplete, OnError);
					});
				}

				this.Pause = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererPause?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Pin or un-pin target participant camera. Pinned participant camera stream is always displayed unless muted. A single participant can be pinned at a time; subsequent pin will unpin previously pinned participant.
				 * @param r The VidyoLocalRenderer object.
				 * @param p The target participant.
				 * @param pin LMI_TRUE enable, LMI_FALSE for disable participant pin.
				 */
				this.PinParticipant = function(p, pin) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('p') && arguments[0].hasOwnProperty('pin')){
							var params = vcUtilsParam({r: this.objId, p: (arguments[0].p ? arguments[0].p.objId : 0), pin: arguments[0].pin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['p', 'pin'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, p: (arguments[0] ? arguments[0].objId : 0), pin: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererPinParticipant?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified when a a call is being recorded.
				 * @param r The VidyoLocalRenderer object.
				 * @param onPipLocationChanged .
				 */
				this.RegisterPipEventListener = function(onPipLocationChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onPipLocationChanged')){
							this.VidyoLocalRendererOnPipLocationChanged = arguments[0].onPipLocationChanged;
							var params = vcUtilsParam({r: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onPipLocationChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoLocalRendererOnPipLocationChanged = onPipLocationChanged;
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererRegisterPipEventListener?" + params, OnComplete, OnError);
					});
				}

				this.Resume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererResume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set whether content tiles are allowed on the screen.
				 */
				this.SetAllowContentMultiScreen = function(allow, displayIndex) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('allow') && arguments[0].hasOwnProperty('displayIndex')){
							var params = vcUtilsParam({r: this.objId, allow: arguments[0].allow, displayIndex: arguments[0].displayIndex});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['allow', 'displayIndex'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "boolean") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({r: this.objId, allow: arguments[0], displayIndex: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetAllowContentMultiScreen?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set whether preview tiles are allowed on the screen.
				 */
				this.SetAllowPreviewMultiScreen = function(allow, displayIndex) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('allow') && arguments[0].hasOwnProperty('displayIndex')){
							var params = vcUtilsParam({r: this.objId, allow: arguments[0].allow, displayIndex: arguments[0].displayIndex});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['allow', 'displayIndex'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "boolean") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({r: this.objId, allow: arguments[0], displayIndex: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetAllowPreviewMultiScreen?" + params, OnComplete, OnError);
					});
				}

				/**
				 * If supported, sets the speed of transition animaiton 100 for slow, 0 for instant transition.
				 * @param renderer The local renderer object to extract stats.
				 * @param speedPercentage Percentage of animation speed.
				 */
				this.SetAnimationSpeed = function(speedPercentage) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('speedPercentage')){
							var params = vcUtilsParam({renderer: this.objId, speedPercentage: arguments[0].speedPercentage});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['speedPercentage'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({renderer: this.objId, speedPercentage: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetAnimationSpeed?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the background color of the renderer.
				 * @param renderer The local renderer object to extract stats.
				 * @param red Red component of the color 0-255.
				 * @param green Green component of the color 0-255.
				 * @param blue Blue component of the color 0-255.
				 */
				this.SetBackgroundColor = function(red, green, blue) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('red') && arguments[0].hasOwnProperty('green') && arguments[0].hasOwnProperty('blue')){
							var params = vcUtilsParam({renderer: this.objId, red: arguments[0].red, green: arguments[0].green, blue: arguments[0].blue});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['red', 'green', 'blue'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({renderer: this.objId, red: arguments[0], green: arguments[1], blue: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetBackgroundColor?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Controls the use of tile borders in the scene. See VidyoLocalRendererBorderStyle.
				 * @param ct The VidyoLocalRenderer object.
				 * @param style The new border style.
				 */
				this.SetBorderStyle = function(style) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('style')){
							var params = vcUtilsParam({ct: this.objId, style: arguments[0].style});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['style'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({ct: this.objId, style: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetBorderStyle?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the video screams to be croped in the renderer.
				 * @param renderer The local renderer object to extract stats.
				 * @param cropped Crop if LMI_TRUE, letter box if LMI_FALSE.
				 */
				this.SetCropped = function(cropped) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('cropped')){
							var params = vcUtilsParam({renderer: this.objId, cropped: arguments[0].cropped});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['cropped'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({renderer: this.objId, cropped: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetCropped?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This function sets the maximum percentage of a dimension that can be cropped from a video.
				 * @param r The VidyoLocalRenderer object.
				 * @param maxCropPct When fitting a video into a tile, this sets the maximum percentage that can be cropped to achieve a better fit.
				 */
				this.SetMaxCropping = function(maxCropPct) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxCropPct')){
							var params = vcUtilsParam({r: this.objId, maxCropPct: arguments[0].maxCropPct});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxCropPct'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, maxCropPct: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetMaxCropping?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the maximum number of streams that can be displayed in the renderer.
				 */
				this.SetMaxStreams = function(numStreams) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('numStreams')){
							var params = vcUtilsParam({r: this.objId, numStreams: arguments[0].numStreams});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['numStreams'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, numStreams: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetMaxStreams?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the maximum number of streams that can be displayed in the renderer.
				 */
				this.SetMaxStreamsMultiScreen = function(numStreams, displayIndex) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('numStreams') && arguments[0].hasOwnProperty('displayIndex')){
							var params = vcUtilsParam({r: this.objId, numStreams: arguments[0].numStreams, displayIndex: arguments[0].displayIndex});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['numStreams', 'displayIndex'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({r: this.objId, numStreams: arguments[0], displayIndex: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetMaxStreamsMultiScreen?" + params, OnComplete, OnError);
					});
				}

				/**
				 * This function sets the number of preferred participants in the tile layout.
				 * @param r The VidyoLocalRenderer object.
				 * @param numPreferred number of preferred participants. Default is -1 which means auto. Otherwise value is 0 - 96.
				 */
				this.SetNumPreferred = function(numPreferred) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('numPreferred')){
							var params = vcUtilsParam({r: this.objId, numPreferred: arguments[0].numPreferred});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['numPreferred'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, numPreferred: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetNumPreferred?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set renderer parameters for high DPI devices.
				 * @param r The VidyoLocalRenderer object.
				 * @param pixelsPerInch The number of pixels per inch.
				 * @param viewingDistance The distance between user's eye to the device (in foot).
				 * @param isTouchInputDevice To indicate input method of this device is TOUCH (vs default MOUSE input).
				 */
				this.SetParametersForHighDPIDevice = function(pixelsPerInch, viewingDistance, isTouchInputDevice) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('pixelsPerInch') && arguments[0].hasOwnProperty('viewingDistance') && arguments[0].hasOwnProperty('isTouchInputDevice')){
							var params = vcUtilsParam({r: this.objId, pixelsPerInch: arguments[0].pixelsPerInch, viewingDistance: arguments[0].viewingDistance, isTouchInputDevice: arguments[0].isTouchInputDevice});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['pixelsPerInch', 'viewingDistance', 'isTouchInputDevice'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, pixelsPerInch: arguments[0], viewingDistance: arguments[1], isTouchInputDevice: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetParametersForHighDPIDevice?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the position of the preview when it is displayed using picture-in-picture mode.
				 * @param r The VidyoLocalRenderer object.
				 * @param x The horizontal position of the preview.
				 * @param y The vertical position of the preview.
				 * @param lockPip A boolean indicating whether to lock the preview in this position. When false, the user may drag the preview to another location using the mouse or a touch.
				 */
				this.SetPipPosition = function(x, y, lockPip) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('lockPip')){
							var params = vcUtilsParam({r: this.objId, x: arguments[0].x, y: arguments[0].y, lockPip: arguments[0].lockPip});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['x', 'y', 'lockPip'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, x: arguments[0], y: arguments[1], lockPip: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetPipPosition?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the size of the preview in picture-in-picture mode.
				 * @param r The VidyoLocalRenderer object.
				 * @param size The size of the preview in picture-in-picture mode. The value is a positive integer representing the percentage of the screen size (1 to 50) default value is 1.
				 */
				this.SetPipSize = function(size) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('size')){
							var params = vcUtilsParam({r: this.objId, size: arguments[0].size});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['size'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, size: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetPipSize?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the number of tiles after which the preview will be displayed as a tile instead of picture-in-picture.
				 * @param r The VidyoLocalRenderer object.
				 * @param numTiles The number of tiles after which the preview will be displayed as a tile instead of picture-in-picture. A value of 0 means the preview will always be visible in picture-in-picture mode whereas N means that the preview will be visible as tile if the number of tiles is greater than N (where N is a positive integer).
				 */
				this.SetPipToTileAfterNTiles = function(numTiles) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('numTiles')){
							var params = vcUtilsParam({r: this.objId, numTiles: arguments[0].numTiles});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['numTiles'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, numTiles: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetPipToTileAfterNTiles?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the rendering environment's pixel density.
				 * @param r The VidyoLocalRenderer object.
				 * @param pixelsPerInch The pixel density in pixels per inch.
				 */
				this.SetPixelDensity = function(pixelsPerInch) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('pixelsPerInch')){
							var params = vcUtilsParam({r: this.objId, pixelsPerInch: arguments[0].pixelsPerInch});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['pixelsPerInch'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, pixelsPerInch: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetPixelDensity?" + params, OnComplete, OnError);
					});
				}

				this.SetPosition = function(x, y, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							var params = vcUtilsParam({r: this.objId, x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['x', 'y', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number")){
						var params = vcUtilsParam({r: this.objId, x: arguments[0], y: arguments[1], width: arguments[2], height: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetPosition?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the priority of one of the screens. Screens that have a smaller priority value will be considered higher priority, and will be given more important items to display.
				 */
				this.SetPriorityMultiScreen = function(priority, displayIndex) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('priority') && arguments[0].hasOwnProperty('displayIndex')){
							var params = vcUtilsParam({r: this.objId, priority: arguments[0].priority, displayIndex: arguments[0].displayIndex});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['priority', 'displayIndex'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({r: this.objId, priority: arguments[0], displayIndex: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetPriorityMultiScreen?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set if renderer will automatically pin the share when added and pin/unpin share if already exist.
				 * @param r The VidyoLocalRenderer object.
				 * @param autoPin LMI_TRUE to automatically pin the share when added and pin the first share from list if exist. LMI_FALSE to do not pin the share automatically when added and unpin the share if exist and already pinned.
				 */
				this.SetRemoteWindowSharePinMode = function(autoPin) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('autoPin')){
							var params = vcUtilsParam({r: this.objId, autoPin: arguments[0].autoPin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['autoPin'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, autoPin: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetRemoteWindowSharePinMode?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the background color of the tiles.
				 * @param renderer The local renderer object.
				 * @param red Red component of the color 0-255.
				 * @param green Green component of the color 0-255.
				 * @param blue Blue component of the color 0-255.
				 */
				this.SetTilesBackgroundColor = function(red, green, blue) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('red') && arguments[0].hasOwnProperty('green') && arguments[0].hasOwnProperty('blue')){
							var params = vcUtilsParam({renderer: this.objId, red: arguments[0].red, green: arguments[0].green, blue: arguments[0].blue});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['red', 'green', 'blue'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({renderer: this.objId, red: arguments[0], green: arguments[1], blue: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetTilesBackgroundColor?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the viewing distance. This is the distance from the viewer's eye to the screen.
				 * @param r The VidyoLocalRenderer object.
				 * @param viewingDistanceFt The viewing distance in feet.
				 */
				this.SetViewingDistance = function(viewingDistanceFt) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewingDistanceFt')){
							var params = vcUtilsParam({r: this.objId, viewingDistanceFt: arguments[0].viewingDistanceFt});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewingDistanceFt'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, viewingDistanceFt: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererSetViewingDistance?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows or hides the audio meters.
				 * @param renderer The local renderer object to show or hide the audio meters.
				 * @param showMeters Show or hide audio meters.
				 */
				this.ShowAudioMeters = function(showMeters) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('showMeters')){
							var params = vcUtilsParam({renderer: this.objId, showMeters: arguments[0].showMeters});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['showMeters'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({renderer: this.objId, showMeters: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererShowAudioMeters?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows debuggin statistics in the renderer window.
				 * @param renderer The local renderer object to extract stats.
				 * @param showStats Show or hide statistics.
				 */
				this.ShowDebugStats = function(showStats) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('showStats')){
							var params = vcUtilsParam({renderer: this.objId, showStats: arguments[0].showStats});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['showStats'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({renderer: this.objId, showStats: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererShowDebugStats?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a label with the participant name.
				 * @param renderer The local renderer object to show or hide the label.
				 * @param showLabel Show or hide participant label.
				 */
				this.ShowLabel = function(showLabel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('showLabel')){
							var params = vcUtilsParam({renderer: this.objId, showLabel: arguments[0].showLabel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['showLabel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({renderer: this.objId, showLabel: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererShowLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters recorder in call event notifications.
				 * @param r The VidyoLocalRenderer object.
				 */
				this.UnregisterPipEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalRendererUnregisterPipEventListener?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoLocalSpeaker = function(){

				this.Destruct = function() {
					GetRequest("VidyoLocalSpeakerDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Disables recording of speaker output to the files.
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.DisableDebugRecordings = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerDisableDebugRecordings?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enables recording of speaker output to the files at the specified location.
				 * @param s The VidyoLocalSpeaker object.
				 * @param dir The directory where recordings will be stored.
				 */
				this.EnableDebugRecordings = function(dir) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('dir')){
							var params = vcUtilsParam({s: this.objId, dir: arguments[0].dir});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['dir'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({s: this.objId, dir: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerEnableDebugRecordings?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the speaker.
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the speaker.
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the current speaker stream type. Supported on Android only.
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.GetStreamType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerGetStreamType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the type of the speaker.
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.GetType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerGetType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.GetVolume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerGetVolume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.IsPaused = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerIsPaused?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.Pause = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerPause?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Plays the provided audio frame on the local speaker.
				 * @param s The VidyoLocalSpeaker object.
				 * @param sound The VidyoAudioFrame object to be played.
				 * @param loop Determine whether the audio frame should be repeatedly played.
				 */
				this.PlaySound = function(sound, loop) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('sound') && arguments[0].hasOwnProperty('loop')){
							var params = vcUtilsParam({s: this.objId, sound: (arguments[0].sound ? arguments[0].sound.objId : 0), loop: arguments[0].loop});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['sound', 'loop'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "boolean")){
						var params = vcUtilsParam({s: this.objId, sound: (arguments[0] ? arguments[0].objId : 0), loop: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(sound&& response.data.sound)
								vcUtilsExtend(sound, response.data.sound);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerPlaySound?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.PlayTone = function(dtmfTone) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('dtmfTone')){
							var params = vcUtilsParam({s: this.objId, dtmfTone: arguments[0].dtmfTone});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['dtmfTone'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({s: this.objId, dtmfTone: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerPlayTone?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.Resume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerResume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the current speaker stream type for the device.
				 * @param s The VidyoLocalSpeaker object.
				 * @param streamType Speaker stream type to be set.
				 */
				this.SetStreamType = function(streamType) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('streamType')){
							var params = vcUtilsParam({s: this.objId, streamType: arguments[0].streamType});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['streamType'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({s: this.objId, streamType: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerSetStreamType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 * @param volumePercent The volume percent to be set. (0 for silence 500 for loudest.)
				 */
				this.SetVolume = function(volumePercent) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('volumePercent')){
							var params = vcUtilsParam({s: this.objId, volumePercent: arguments[0].volumePercent});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['volumePercent'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({s: this.objId, volumePercent: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerSetVolume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoLocalSpeaker object.
				 */
				this.StopSound = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalSpeakerStopSound?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoLocalWindowShare = function(){

				this.Destruct = function() {
					GetRequest("VidyoLocalWindowShareDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.AddToLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({w: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({w: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareAddToLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.AddToRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({w: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({w: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareAddToRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Clears existing constraints and set them to default values 3840x2160@3fps.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.ClearConstraints = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareClearConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 * @param maxWidth Maximum width of the icon image.
				 * @param maxHeight Maximum height of the icon image.
				 * @param onComplete Callback that is triggered when a icon frame is captured.
				 */
				this.GetApplicationIconFrameDataUriAsync = function(maxWidth, maxHeight, onComplete) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('onComplete')){
							this.VidyoLocalWindowShareOnApplicationIconDataUriComplete = arguments[0].onComplete;
							var params = vcUtilsParam({w: this.objId, maxWidth: arguments[0].maxWidth, maxHeight: arguments[0].maxHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxWidth', 'maxHeight', 'onComplete'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "function")){
						this.VidyoLocalWindowShareOnApplicationIconDataUriComplete = onComplete;
						var params = vcUtilsParam({w: this.objId, maxWidth: arguments[0], maxHeight: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetApplicationIconFrameDataUriAsync?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the application that owns the window.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.GetApplicationName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetApplicationName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
				 * @param windowShare The VidyoLocalWindowShare object.
				 * @param onGetCapabilities The callback to which we will pass the most optimal capabilities.
				 */
				this.GetCapabilities = function(onGetCapabilities) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onGetCapabilities')){
							this.VidyoLocalWindowShareOnGetCapabilities = arguments[0].onGetCapabilities;
							var params = vcUtilsParam({windowShare: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onGetCapabilities'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoLocalWindowShareOnGetCapabilities = onGetCapabilities;
						var params = vcUtilsParam({windowShare: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetCapabilities?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 * @param maxWidth Maximum width of the preview image.
				 * @param maxHeight Maximum height of the preview image.
				 * @param onComplete Callback that is triggered when a preview frame is captured.
				 */
				this.GetPreviewFrameDataUriAsync = function(maxWidth, maxHeight, onComplete) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('onComplete')){
							this.VidyoLocalWindowShareOnPreviewDataUriComplete = arguments[0].onComplete;
							var params = vcUtilsParam({w: this.objId, maxWidth: arguments[0].maxWidth, maxHeight: arguments[0].maxHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxWidth', 'maxHeight', 'onComplete'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "function")){
						this.VidyoLocalWindowShareOnPreviewDataUriComplete = onComplete;
						var params = vcUtilsParam({w: this.objId, maxWidth: arguments[0], maxHeight: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetPreviewFrameDataUriAsync?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the preview label of the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.GetPreviewLabel = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetPreviewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the ID of the process that owns the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.GetProcessId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetProcessId?" + params, OnComplete, OnError);
					});
				}

				this.GetProcessName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetProcessName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Retrieved the up to date name of the Window which might have changed since it was created.
				 */
				this.GetUpdatedName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetUpdatedName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets window state of the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.GetWindowState = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareGetWindowState?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks if the name of the application name is set.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.IsApplicationNameSet = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareIsApplicationNameSet?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks if the name of the window share is set.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.IsNameSet = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareIsNameSet?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.RemoveFromLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({w: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({w: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareRemoveFromLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.RemoveFromRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({w: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({w: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareRemoveFromRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param maxWidth Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit
				 * @param minWidth Unused
				 * @param maxHeight Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit
				 * @param minHeight Unused
				 */
				this.SetBoundsConstraints = function(maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('minWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('minHeight')){
							var params = vcUtilsParam({w: this.objId, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, maxWidth: arguments[0].maxWidth, minWidth: arguments[0].minWidth, maxHeight: arguments[0].maxHeight, minHeight: arguments[0].minHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxFrameInterval', 'minFrameInterval', 'maxWidth', 'minWidth', 'maxHeight', 'minHeight'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({w: this.objId, maxFrameInterval: arguments[0], minFrameInterval: arguments[1], maxWidth: arguments[2], minWidth: arguments[3], maxHeight: arguments[4], minHeight: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetBoundsConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 * @param frameInterval Set as an override of minimum frame interval for discrete and bounds constraints
				 */
				this.SetCapability = function(frameInterval, showCursor, redactOccludedAreas) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval') && arguments[0].hasOwnProperty('showCursor') && arguments[0].hasOwnProperty('redactOccludedAreas')){
							var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0].frameInterval, showCursor: arguments[0].showCursor, redactOccludedAreas: arguments[0].redactOccludedAreas});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval', 'showCursor', 'redactOccludedAreas'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "boolean") && (typeof(arguments[2]) === "boolean")){
						var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0], showCursor: arguments[1], redactOccludedAreas: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetCapability?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set frame interval(fps) for capturer.
				 * @param w The VidyoLocalWindowShare object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. By default will be calculated based on encoder configuration.
				 */
				this.SetCaptureInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetCaptureInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the visibility of the cursor in the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.SetCursorVisibility = function(showCursor) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('showCursor')){
							var params = vcUtilsParam({w: this.objId, showCursor: arguments[0].showCursor});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['showCursor'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({w: this.objId, showCursor: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetCursorVisibility?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param width The width of the stream after the stream is reconfigured
				 * @param height The height of the stream after the stream is reconfigured
				 * @param scaleFactor This should be 1
				 */
				this.SetDiscreteConstraints = function(maxFrameInterval, minFrameInterval, width, height, scaleFactor) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('scaleFactor')){
							var params = vcUtilsParam({w: this.objId, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, width: arguments[0].width, height: arguments[0].height, scaleFactor: arguments[0].scaleFactor});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxFrameInterval', 'minFrameInterval', 'width', 'height', 'scaleFactor'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						var params = vcUtilsParam({w: this.objId, maxFrameInterval: arguments[0], minFrameInterval: arguments[1], width: arguments[2], height: arguments[3], scaleFactor: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetDiscreteConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the maximum frame interval that will be used to scrapte the window share
				 * @param w The VidyoLocalWindowShare object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. Default is 333333333 which is 3 frames per second.
				 */
				this.SetFrameInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetFrameInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the low latency profile of the window share which treats the stream as a regular video source. This prioritizes latency over quality.
				 * @param w The VidyoLocalWindowShare object.
				 * @param profile Low latency profile toggle. Default is LMI_FALSE.
				 */
				this.SetLowLatencyProfile = function(profile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('profile')){
							var params = vcUtilsParam({w: this.objId, profile: arguments[0].profile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['profile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({w: this.objId, profile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetLowLatencyProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the window is in landscape mode width and height will be applied as max constraints, if the window is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
				 * @param w The VidyoLocalWindowShare object
				 * @param width Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.
				 * @param height Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
				 */
				this.SetMaxConstraints = function(width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({w: this.objId, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({w: this.objId, width: arguments[0], height: arguments[1], frameInterval: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetMaxConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a minimum frame interval(maximum fps) for the encoded stream.
				 * @param w The VidyoLocalWindowShare object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
				 */
				this.SetMinFrameInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({w: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetMinFrameInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoLocalWindowShare object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames.
				 */
				this.SetPositionInLocalRenderer = function(localRenderer, x, y, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({w: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'x', 'y', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({w: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4], frameInterval: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetPositionInLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the preview label of the window share.
				 * @param w The VidyoLocalWindowShare object.
				 * @param previewLabel Display name to set on the window share.
				 */
				this.SetPreviewLabel = function(previewLabel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('previewLabel')){
							var params = vcUtilsParam({w: this.objId, previewLabel: arguments[0].previewLabel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['previewLabel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({w: this.objId, previewLabel: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetPreviewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the flag which redacts the occluded areas from the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.SetRedactOccludedAreas = function(redactOccludedAreas) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('redactOccludedAreas')){
							var params = vcUtilsParam({w: this.objId, redactOccludedAreas: arguments[0].redactOccludedAreas});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['redactOccludedAreas'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({w: this.objId, redactOccludedAreas: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetRedactOccludedAreas?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the scale factor by which to down-scale the window share.
				 * @param w The VidyoLocalWindowShare object.
				 */
				this.SetScaleFactor = function(scaleFactor) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('scaleFactor')){
							var params = vcUtilsParam({w: this.objId, scaleFactor: arguments[0].scaleFactor});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['scaleFactor'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({w: this.objId, scaleFactor: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoLocalWindowShareSetScaleFactor?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoRemoteCamera = function(){

				this.Destruct = function() {
					GetRequest("VidyoRemoteCameraDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Send the preset index to the remote camera.
				 * @param c The VidyoRemoteCamera object.
				 * @param index Represents the preset index.
				 */
				this.ActivatePreset = function(index) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('index')){
							var params = vcUtilsParam({c: this.objId, index: arguments[0].index});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['index'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, index: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraActivatePreset?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoRemoteCamera object.
				 */
				this.AddToLocalRenderer = function(localRenderer, mode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('mode')){
							var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), mode: arguments[0].mode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'mode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), mode: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraAddToLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Send the PTZ Nudge commands to the remote camera.
				 * @param c The VidyoRemoteCamera object.
				 * @param pan Number of nudges to pan the camera.
				 * @param tilt Number of nudges to tilt the camera.
				 * @param zoom Number of nudges to zoom the camera.
				 */
				this.ControlPTZNudge = function(pan, tilt, zoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('pan') && arguments[0].hasOwnProperty('tilt') && arguments[0].hasOwnProperty('zoom')){
							var params = vcUtilsParam({c: this.objId, pan: arguments[0].pan, tilt: arguments[0].tilt, zoom: arguments[0].zoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['pan', 'tilt', 'zoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({c: this.objId, pan: arguments[0], tilt: arguments[1], zoom: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraControlPTZNudge?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Send the PTZ Start commands to the remote camera.
				 * @param c The VidyoRemoteCamera object.
				 * @param direction The VidyoCameraControlDirection enum that indicates direction of move.
				 * @param timeout Amount of time in nanoseconds at which camera will be moving in the specified directions.
				 */
				this.ControlPTZStart = function(direction, timeout) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('direction') && arguments[0].hasOwnProperty('timeout')){
							var params = vcUtilsParam({c: this.objId, direction: arguments[0].direction, timeout: arguments[0].timeout});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['direction', 'timeout'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({c: this.objId, direction: arguments[0], timeout: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraControlPTZStart?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Send the PTZ Stop commands to the remote camera.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.ControlPTZStop = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraControlPTZStop?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets camera control capabilities.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.GetControlCapabilities = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraGetControlCapabilities?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the camera.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoRemoteCamera object.
				 */
				this.GetLocalRenderingStreamId = function(index) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('index')){
							var params = vcUtilsParam({c: this.objId, index: arguments[0].index});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['index'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({c: this.objId, index: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraGetLocalRenderingStreamId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the camera.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the position of the camera.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.GetPosition = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraGetPosition?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks if the remote camera is controllable.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.IsControllable = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraIsControllable?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about a new remote camera frame.
				 * @param c The VidyoRemoteCamera object.
				 * @param onFrame Callback that is triggered each time a remote camera produces a video frame.
				 */
				this.RegisterFrameEventListener = function(onFrame) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame')){
							this.VidyoRemoteCameraOnRemoteCameraFrame = arguments[0].onFrame;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoRemoteCameraOnRemoteCameraFrame = onFrame;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraRegisterFrameEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about camera frame size changes.
				 * @param c The VidyoRemoteCamera object.
				 * @param onFrameSizeUpdate Callback that is triggered whenever frame size changes.
				 */
				this.RegisterFrameSizeListener = function(onFrameSizeUpdate) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrameSizeUpdate')){
							this.VidyoRemoteCameraOnFrameSizeUpdate = arguments[0].onFrameSizeUpdate;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrameSizeUpdate'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoRemoteCameraOnFrameSizeUpdate = onFrameSizeUpdate;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraRegisterFrameSizeListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers a callback to receive notifications about camera preset information.
				 * @param c The VidyoRemoteCamera object.
				 * @param onPresetUpdated Callback that is triggered whenever camera preset information changes.
				 */
				this.RegisterPresetEventListener = function(onPresetUpdated) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onPresetUpdated')){
							this.VidyoRemoteCameraOnPresetUpdated = arguments[0].onPresetUpdated;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onPresetUpdated'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoRemoteCameraOnPresetUpdated = onPresetUpdated;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraRegisterPresetEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoRemoteCamera object.
				 */
				this.RemoveFromLocalRenderer = function(localRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer')){
							var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraRemoveFromLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param c The VidyoRemoteCamera object.
				 */
				this.SetPositionInLocalRenderer = function(localRenderer, x, y, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'x', 'y', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({c: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4], frameInterval: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraSetPositionInLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows camera control when rendering remote camera.
				 * @param c The VidyoRemoteCamera object.
				 * @param show Show or hide camera controls.
				 */
				this.ShowCameraControl = function(show) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('show')){
							var params = vcUtilsParam({c: this.objId, show: arguments[0].show});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['show'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({c: this.objId, show: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraShowCameraControl?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters remote camera frame notifications.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.UnregisterFrameEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraUnregisterFrameEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters frame size event notifications.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.UnregisterFrameSizeListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraUnregisterFrameSizeListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters callback to get notified about camera preset information.
				 * @param c The VidyoRemoteCamera object.
				 */
				this.UnregisterPresetEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraUnregisterPresetEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sends the visca message to the remote camera.
				 * @param c The VidyoRemoteCamera object.
				 * @param viscaCmd Represents the visca command, with maximum length as 128 characters. This should be any valid visca command.For example: "81 01 04 3f 02 02 ff"
				 * @param viscaCmdId Represents the visca command identifier, with maximum length as 128 characters. Application can set NULL OR any valid string identifier, which can be used at remote end for debugging.
				 */
				this.ViscaControl = function(viscaCmd, viscaCmdId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viscaCmd') && arguments[0].hasOwnProperty('viscaCmdId')){
							var params = vcUtilsParam({c: this.objId, viscaCmd: arguments[0].viscaCmd, viscaCmdId: arguments[0].viscaCmdId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viscaCmd', 'viscaCmdId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({c: this.objId, viscaCmd: arguments[0], viscaCmdId: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteCameraViscaControl?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoRemoteMicrophone = function(){

				this.Destruct = function() {
					GetRequest("VidyoRemoteMicrophoneDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param m The VidyoRemoteMicrophone object.
				 */
				this.AddToLocalSpeaker = function(speaker, mode) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('speaker') && arguments[0].hasOwnProperty('mode')){
							var params = vcUtilsParam({m: this.objId, speaker: (arguments[0].speaker ? arguments[0].speaker.objId : 0), mode: arguments[0].mode});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['speaker', 'mode'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({m: this.objId, speaker: (arguments[0] ? arguments[0].objId : 0), mode: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteMicrophoneAddToLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the microphone.
				 * @param m The VidyoRemoteMicrophone object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteMicrophoneGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the microphone.
				 * @param m The VidyoRemoteMicrophone object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteMicrophoneGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets signal type of the microphone, which affects how the audio is processed.
				 * @param m The VidyoRemoteMicrophone object.
				 */
				this.GetSignalType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({m: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({m: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteMicrophoneGetSignalType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param m The VidyoRemoteMicrophone object.
				 */
				this.RemoveFromLocalSpeaker = function(speaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('speaker')){
							var params = vcUtilsParam({m: this.objId, speaker: (arguments[0].speaker ? arguments[0].speaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['speaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, speaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteMicrophoneRemoveFromLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoRemoteRenderer = function(){

				this.Destruct = function() {
					GetRequest("VidyoRemoteRendererDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteRendererGetId?" + params, OnComplete, OnError);
					});
				}

				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteRendererGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param r The VidyoRemoteRenderer object.
				 */
				this.IsClientCanResume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteRendererIsClientCanResume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param r The VidyoRemoteRenderer object.
				 */
				this.IsPaused = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteRendererIsPaused?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param r The VidyoRemoteRenderer object.
				 */
				this.Pause = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteRendererPause?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param r The VidyoRemoteRenderer object.
				 */
				this.Resume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteRendererResume?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoRemoteSpeaker = function(){

				this.Destruct = function() {
					GetRequest("VidyoRemoteSpeakerDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteSpeakerGetId?" + params, OnComplete, OnError);
					});
				}

				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteSpeakerGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoRemoteSpeaker object.
				 */
				this.IsClientCanResume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteSpeakerIsClientCanResume?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoRemoteSpeaker object.
				 */
				this.IsPaused = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteSpeakerIsPaused?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoRemoteSpeaker object.
				 */
				this.Pause = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteSpeakerPause?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoRemoteSpeaker object.
				 */
				this.Resume = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteSpeakerResume?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoRemoteWindowShare = function(){

				this.Destruct = function() {
					GetRequest("VidyoRemoteWindowShareDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param w The VidyoRemoteWindowShare object.
				 */
				this.AddToLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({w: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({w: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareAddToLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the window share.
				 * @param w The VidyoRemoteWindowShare object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the window share.
				 * @param w The VidyoRemoteWindowShare object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about new remote window share frame.
				 * @param w The VidyoRemoteWindowShare object.
				 * @param onFrame Callback that is triggered each time when we get a remote window share frame.
				 */
				this.RegisterFrameEventListener = function(onFrame) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onFrame')){
							this.VidyoRemoteWindowShareOnRemoteWindowShareFrame = arguments[0].onFrame;
							var params = vcUtilsParam({w: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onFrame'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoRemoteWindowShareOnRemoteWindowShareFrame = onFrame;
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareRegisterFrameEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoRemoteWindowShare object.
				 */
				this.RemoveFromLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({w: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({w: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareRemoveFromLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param w The VidyoRemoteWindowShare object.
				 */
				this.SetPositionInLocalRenderer = function(localRenderer, x, y, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({w: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'x', 'y', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({w: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4], frameInterval: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareSetPositionInLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters remote window share frame notifications.
				 * @param w The VidyoRemoteWindowShare object.
				 */
				this.UnregisterFrameEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({w: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({w: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoRemoteWindowShareUnregisterFrameEventListener?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoVideoFrame = function(format, buffer, size, releaseCallback, width, height) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('format') && arguments[0].hasOwnProperty('buffer') && arguments[0].hasOwnProperty('size') && arguments[0].hasOwnProperty('releaseCallback') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
						var params = vcUtilsParam({x: this.objId, format: arguments[0].format, buffer: arguments[0].buffer, size: arguments[0].size, width: arguments[0].width, height: arguments[0].height});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['format', 'buffer', 'size', 'releaseCallback', 'width', 'height'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
					var params = vcUtilsParam({x: this.objId, format: arguments[0], buffer: arguments[1], size: arguments[1], width: arguments[3], height: arguments[4]});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoVideoFrame = new contextObj.VidyoVideoFrame(response.data.VidyoVideoFrame);	// copy construct
						if(args.length === 1 && (typeof(args[0]) === "object") && !args[0].objId){
							vidyoVideoFrame.VidyoVideoFrameReleaseCallback = args[0].releaseCallback;
						} else {
							vidyoVideoFrame.VidyoVideoFrameReleaseCallback = releaseCallback;
						}
						objects[vidyoVideoFrame.objId] = vidyoVideoFrame;
						resolve(vidyoVideoFrame);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoVideoFrameConstructFromKnownFormatWithExternalBuffer?" + params, OnComplete, OnError);
				});
			}
			this.VidyoVideoFrame = function(format, buffer, size, releaseCallback, width, height) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoVideoFrame"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('format') && arguments[0].hasOwnProperty('buffer') && arguments[0].hasOwnProperty('size') && arguments[0].hasOwnProperty('releaseCallback') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							this.VidyoVideoFrameReleaseCallback = arguments[0].releaseCallback;
							var params = vcUtilsParam({x: this.objId, format: arguments[0].format, buffer: arguments[0].buffer, size: arguments[0].size, width: arguments[0].width, height: arguments[0].height});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['format', 'buffer', 'size', 'releaseCallback', 'width', 'height'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						this.VidyoVideoFrameReleaseCallback = releaseCallback;
						var params = vcUtilsParam({x: this.objId, format: arguments[0], buffer: arguments[1], size: arguments[1], width: arguments[3], height: arguments[4]});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoVideoFrameConstructFromKnownFormatWithExternalBuffer?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoVideoFrame);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoVideoFrameDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Gets the pointer to the frame's payload.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetData = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetData?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the pointer to the frame's payload of the Cb plane.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetDataCb = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetDataCb?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the pointer to the frame's payload of the Cr plane.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetDataCr = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetDataCr?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the pointer to the frame's payload of the Y plane.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetDataY = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetDataY?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the elapsed time since the beginning of frame capture that is increased by the duration of each frame.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetElapsedTime = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetElapsedTime?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the format of the frame.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetFormat = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetFormat?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the height of the frame.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetHeight = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetHeight?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the height in bytes of the frame's Cb pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetHeightCb = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetHeightCb?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the height in bytes of the frame's Cr pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetHeightCr = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetHeightCr?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the height in bytes of the frame's Y pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetHeightY = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetHeightY?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the number of bytes from the Cb plane's payload to the start of the pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetOffsetCb = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetOffsetCb?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the number of bytes from the Cr plane's payload to the start of the pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetOffsetCr = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetOffsetCr?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the number of bytes from the Y plane's payload to the start of the pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetOffsetY = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetOffsetY?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the number of bytes between consecutive pixels in a row of the Cb plane.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetPitchCb = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetPitchCb?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the number of bytes between consecutive pixels in a row of the Cr plane.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetPitchCr = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetPitchCr?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the number of bytes between consecutive pixels in a row of the Y plane
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetPitchY = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetPitchY?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the size in bytes of the frame's payload.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetSize = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetSize?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the size in bytes of the plane's payload.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetSizeCb = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetSizeCb?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the size in bytes of the Cr plane's payload.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetSizeCr = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetSizeCr?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the size in bytes of the plane's payload.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetSizeY = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetSizeY?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the wallclock timestamp associated with the creation of the audio frame object.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetTimestamp = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetTimestamp?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the width of the frame.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetWidth = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetWidth?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the width in bytes of the frame's Cb pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetWidthCb = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetWidthCb?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the width in bytes of the frame's Cr pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetWidthCr = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetWidthCr?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the width in bytes of the frame's Y pixel data.
				 * @param f The VidyoVideoFrame object.
				 */
				this.GetWidthY = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({f: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({f: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameGetWidthY?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets elapsedTime and timestamp of the video frame. In case elapsedTime and timestamp are equal to zero will set current monotonic and wall time.
				 * @param f The VidyoVideoFrame object.
				 * @param elapsedTime The elapsed time of the video frame. If zero will set current monotonic time.
				 * @param timestamp Video frame timestamp. If zero will set current wall time.
				 */
				this.SetTimeProperties = function(elapsedTime, timestamp) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('elapsedTime') && arguments[0].hasOwnProperty('timestamp')){
							var params = vcUtilsParam({f: this.objId, elapsedTime: arguments[0].elapsedTime, timestamp: arguments[0].timestamp});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['elapsedTime', 'timestamp'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({f: this.objId, elapsedTime: arguments[0], timestamp: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVideoFrameSetTimeProperties?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoVirtualAudioSource = function(endpoint, name, id, configuration) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('name') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('configuration')){
						var params = vcUtilsParam({virtualAudioSource: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), name: arguments[0].name, id: arguments[0].id, configuration: arguments[0].configuration});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'name', 'id', 'configuration'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 4 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string")){
					var params = vcUtilsParam({virtualAudioSource: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), name: arguments[1], id: arguments[2], configuration: arguments[3]});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoVirtualAudioSource = new contextObj.VidyoVirtualAudioSource(response.data.VidyoVirtualAudioSource);	// copy construct
						objects[vidyoVirtualAudioSource.objId] = vidyoVirtualAudioSource;
						resolve(vidyoVirtualAudioSource);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoVirtualAudioSourceConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoVirtualAudioSource = function(endpoint, name, id, configuration) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoVirtualAudioSource"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('name') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('configuration')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), name: arguments[0].name, id: arguments[0].id, configuration: arguments[0].configuration});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['endpoint', 'name', 'id', 'configuration'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), name: arguments[1], id: arguments[2], configuration: arguments[3]});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoVirtualAudioSourceConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoVirtualAudioSource);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoVirtualAudioSourceDestruct?" + vcUtilsParam({ virtualAudioSource: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Add the virtual audio source to the local speaker stream. The VidyoVirtualAudioSourceStartCallback will trigger if needed.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param localSpeaker The VidyoLocalSpeaker object.
				 */
				this.AddToLocalSpeaker = function(localSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localSpeaker')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, localSpeaker: (arguments[0].localSpeaker ? arguments[0].localSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, localSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceAddToLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Add the virtual audio source to the remote speaker stream. The VidyoVirtualAudioSourceStartCallback will trigger if needed.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param remoteSpeaker The VidyoLocalSpeaker object.
				 */
				this.AddToRemoteSpeaker = function(remoteSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteSpeaker')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, remoteSpeaker: (arguments[0].remoteSpeaker ? arguments[0].remoteSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, remoteSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceAddToRemoteSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the audio configs for the virtual audio source.
				 * @param virtualAudioSource The VidyoVirtualVideoSource object.
				 */
				this.GetConfiguration = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceGetConfiguration?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the virtual audio source id.
				 * @param virtualAudioSource The VidyoVirtualVideoSource object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the virtual audio source name.
				 * @param virtualAudioSource The VidyoVirtualVideoSource object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Check if source is selected.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 */
				this.IsSelected = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceIsSelected?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about virtual audio source events.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param onStart The callback invoked to notify that virtual audio source started.
				 * @param onStop The callback invoked to notify that virtual audio source stoped.
				 * @param onReconfigure The callback invoked if the virtual audio source configuration changed.
				 * @param onBufferRelease The callback invoked each time when VidyoClient is done with an application allocated buffer that holds raw audio frame.
				 */
				this.RegisterEventListener = function(onStart, onStop, onReconfigure, onBufferRelease) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onStart') && arguments[0].hasOwnProperty('onStop') && arguments[0].hasOwnProperty('onReconfigure') && arguments[0].hasOwnProperty('onBufferRelease')){
							this.VidyoVirtualAudioSourceStartCallback = arguments[0].onStart;
							this.VidyoVirtualAudioSourceStopCallback = arguments[0].onStop;
							this.VidyoVirtualAudioSourceReconfigureCallback = arguments[0].onReconfigure;
							this.VidyoVirtualAudioSourceExternalMediaBufferReleaseCallback = arguments[0].onBufferRelease;
							var params = vcUtilsParam({virtualAudioSource: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onStart', 'onStop', 'onReconfigure', 'onBufferRelease'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoVirtualAudioSourceStartCallback = onStart;
						this.VidyoVirtualAudioSourceStopCallback = onStop;
						this.VidyoVirtualAudioSourceReconfigureCallback = onReconfigure;
						this.VidyoVirtualAudioSourceExternalMediaBufferReleaseCallback = onBufferRelease;
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceRegisterEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Remove the virtual audio source from the local speaker stream. The VidyoVirtualAudioSourceStopCallback will trigger if needed.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param localSpeaker The VidyoLocalSpeaker object.
				 */
				this.RemoveFromLocalSpeaker = function(localSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localSpeaker')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, localSpeaker: (arguments[0].localSpeaker ? arguments[0].localSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, localSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceRemoveFromLocalSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Remove the virtual audio source from the remote speaker stream. The VidyoVirtualAudioSourceStopCallback will trigger if needed.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param remoteSpeaker The VidyoRemoteSpeaker object.
				 */
				this.RemoveFromRemoteSpeaker = function(remoteSpeaker) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteSpeaker')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, remoteSpeaker: (arguments[0].remoteSpeaker ? arguments[0].remoteSpeaker.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteSpeaker'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, remoteSpeaker: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceRemoveFromRemoteSpeaker?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sends already constructed audio frame to selected virtual audio source and then send it to local and/or remote streams.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param audioFrame The audio frame.
				 */
				this.SendFrame = function(audioFrame) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('audioFrame')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, audioFrame: (arguments[0].audioFrame ? arguments[0].audioFrame.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['audioFrame'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, audioFrame: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceSendFrame?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Pass raw buffer to selected virtual audio source, based on which the audio frame will be constructed and then send it to local and/or remote streams. The VidyoVirtualAudioSourceExternalMediaBufferReleaseCallback will trigger. This is an asynchronous interface.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param buffer The audio frame.
				 * @param nbSamples The number of samples.
				 * @param elapsedTime The elapsed time.
				 */
				this.SendFrameWithExternalData = function(buffer, nbSamples, elapsedTime) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('buffer') && arguments[0].hasOwnProperty('nbSamples') && arguments[0].hasOwnProperty('elapsedTime')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, buffer: arguments[0].buffer, nbSamples: arguments[0].nbSamples, elapsedTime: arguments[0].elapsedTime});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['buffer', 'nbSamples', 'elapsedTime'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, buffer: arguments[0], nbSamples: arguments[0], elapsedTime: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceSendFrameWithExternalData?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Enable or disable the content share.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param enable The audio content share status.
				 */
				this.SetAudioContentShare = function(enable) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('enable')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, enable: arguments[0].enable});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['enable'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, enable: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceSetAudioContentShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the audio configs for the virtual audio source. The VidyoVirtualAudioSourceReconfigureCallback will trigger.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 * @param configuration The string in JSON format with virtual audio source configuration. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
				 */
				this.SetConfiguration = function(configuration) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('configuration')){
							var params = vcUtilsParam({virtualAudioSource: this.objId, configuration: arguments[0].configuration});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['configuration'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({virtualAudioSource: this.objId, configuration: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceSetConfiguration?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters virtual audio source event notifications.
				 * @param virtualAudioSource The VidyoVirtualAudioSource object.
				 */
				this.UnregisterEventListener = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({virtualAudioSource: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualAudioSourceUnregisterEventListener?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoVirtualDeviceManager = function(){

				this.Destruct = function() {
					GetRequest("VidyoVirtualDeviceManagerDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				this.LocalCameraEvent = function(endpoint, camera, state) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('camera') && arguments[0].hasOwnProperty('state')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), camera: (arguments[0].camera ? arguments[0].camera.objId : 0), state: arguments[0].state});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'camera', 'state'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), camera: (arguments[1] ? arguments[1].objId : 0), state: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualDeviceManagerLocalCameraEvent?" + params, OnComplete, OnError);
					});
				}

				this.LocalMicrophoneEvent = function(endpoint, microphone, state) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('microphone') && arguments[0].hasOwnProperty('state')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), microphone: (arguments[0].microphone ? arguments[0].microphone.objId : 0), state: arguments[0].state});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'microphone', 'state'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), microphone: (arguments[1] ? arguments[1].objId : 0), state: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualDeviceManagerLocalMicrophoneEvent?" + params, OnComplete, OnError);
					});
				}

				this.LocalSpeakerEvent = function(endpoint, speaker, state) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('speaker') && arguments[0].hasOwnProperty('state')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), speaker: (arguments[0].speaker ? arguments[0].speaker.objId : 0), state: arguments[0].state});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'speaker', 'state'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), speaker: (arguments[1] ? arguments[1].objId : 0), state: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualDeviceManagerLocalSpeakerEvent?" + params, OnComplete, OnError);
					});
				}

				this.MediaFailedEvent = function(endpoint) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualDeviceManagerMediaFailedEvent?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoVirtualRenderer = function(id, name) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('name')){
						var params = vcUtilsParam({r: this.objId, id: arguments[0].id, name: arguments[0].name});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['id', 'name'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
					var params = vcUtilsParam({r: this.objId, id: arguments[0], name: arguments[1]});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoVirtualRenderer = new contextObj.VidyoVirtualRenderer(response.data.VidyoVirtualRenderer);	// copy construct
						objects[vidyoVirtualRenderer.objId] = vidyoVirtualRenderer;
						resolve(vidyoVirtualRenderer);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoVirtualRendererConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoVirtualRenderer = function(id, name) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoVirtualRenderer"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('name')){
							var params = vcUtilsParam({r: this.objId, id: arguments[0].id, name: arguments[0].name});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['id', 'name'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({r: this.objId, id: arguments[0], name: arguments[1]});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoVirtualRendererConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoVirtualRenderer);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoVirtualRendererDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Gets the id of the virtual renderer.
				 * @param r The VidyoVirtualRenderer object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the virtual renderer.
				 * @param r The VidyoVirtualRenderer object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({r: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({r: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers virtual renderer callbacks to receive notifications about participants.
				 * @param r The VidyoVirtualRenderer object.
				 * @param userData The user data, returned in callback.
				 * @param onParticipantAdded Notifies the application that the participant added and sends its information.
				 * @param onParticipantRemoved Notifies the application that the participant removed.
				 * @param onLoudestParticipantChanged Notifies the application that the loudest speaker was changed.
				 * @param onDynamicParticipantChanged Reports the list of new dynamic participants.
				 * @param onAudioLevelChanged Notifies the application the audio level of participant was changed.
				 */
				this.RegisterParticipantsEventListener = function(userData, onParticipantAdded, onParticipantRemoved, onLoudestParticipantChanged, onDynamicParticipantChanged, onAudioLevelChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('userData') && arguments[0].hasOwnProperty('onParticipantAdded') && arguments[0].hasOwnProperty('onParticipantRemoved') && arguments[0].hasOwnProperty('onLoudestParticipantChanged') && arguments[0].hasOwnProperty('onDynamicParticipantChanged') && arguments[0].hasOwnProperty('onAudioLevelChanged')){
							this.VidyoVirtualRendererOnParticipantAdded = arguments[0].onParticipantAdded;
							this.VidyoVirtualRendererOnParticipantRemoved = arguments[0].onParticipantRemoved;
							this.VidyoVirtualRendererOnLoudestParticipantChanged = arguments[0].onLoudestParticipantChanged;
							this.VidyoVirtualRendererOnDynamicParticipantChanged = arguments[0].onDynamicParticipantChanged;
							this.VidyoVirtualRendererOnAudioLevelChanged = arguments[0].onAudioLevelChanged;
							var params = vcUtilsParam({r: this.objId, userData: arguments[0].userData});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['userData', 'onParticipantAdded', 'onParticipantRemoved', 'onLoudestParticipantChanged', 'onDynamicParticipantChanged', 'onAudioLevelChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function") && (typeof(arguments[4]) === "function") && (typeof(arguments[5]) === "function")){
						this.VidyoVirtualRendererOnParticipantAdded = onParticipantAdded;
						this.VidyoVirtualRendererOnParticipantRemoved = onParticipantRemoved;
						this.VidyoVirtualRendererOnLoudestParticipantChanged = onLoudestParticipantChanged;
						this.VidyoVirtualRendererOnDynamicParticipantChanged = onDynamicParticipantChanged;
						this.VidyoVirtualRendererOnAudioLevelChanged = onAudioLevelChanged;
						var params = vcUtilsParam({r: this.objId, userData: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererRegisterParticipantsEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers virtual renderer callbacks to receive notifications about streams.
				 * @param r The VidyoVirtualRenderer object.
				 * @param userData The user data, returned in callback.
				 * @param onStreamAdded Notifies the application that the stream added and sends its information.
				 * @param onStreamRemoved Notifies the application that the stream removed.
				 * @param onStreamsFrame Notifies the application that the video frame received for stream.
				 * @param onFECCCapabilitiesChanged Notifies the application about the camera control capabilities.
				 */
				this.RegisterStreamsEventListener = function(userData, onStreamAdded, onStreamRemoved, onStreamsFrame, onFECCCapabilitiesChanged) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('userData') && arguments[0].hasOwnProperty('onStreamAdded') && arguments[0].hasOwnProperty('onStreamRemoved') && arguments[0].hasOwnProperty('onStreamsFrame') && arguments[0].hasOwnProperty('onFECCCapabilitiesChanged')){
							this.VidyoVirtualRendererOnStreamAdded = arguments[0].onStreamAdded;
							this.VidyoVirtualRendererOnStreamRemoved = arguments[0].onStreamRemoved;
							this.VidyoVirtualRendererOnStreamFrameReceived = arguments[0].onStreamsFrame;
							this.VidyoVirtualRendererOnFECCCapabilitiesChanged = arguments[0].onFECCCapabilitiesChanged;
							var params = vcUtilsParam({r: this.objId, userData: arguments[0].userData});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['userData', 'onStreamAdded', 'onStreamRemoved', 'onStreamsFrame', 'onFECCCapabilitiesChanged'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function") && (typeof(arguments[4]) === "function")){
						this.VidyoVirtualRendererOnStreamAdded = onStreamAdded;
						this.VidyoVirtualRendererOnStreamRemoved = onStreamRemoved;
						this.VidyoVirtualRendererOnStreamFrameReceived = onStreamsFrame;
						this.VidyoVirtualRendererOnFECCCapabilitiesChanged = onFECCCapabilitiesChanged;
						var params = vcUtilsParam({r: this.objId, userData: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererRegisterStreamsEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sends the camera control commands.
				 * @param r The VidyoVirtualRenderer object.
				 * @param streamId The unique ID of stream.
				 * @param cmds Camera control commands.
				 */
				this.SendFECCCommands = function(streamId, cmds) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('streamId') && arguments[0].hasOwnProperty('cmds')){
							var params = vcUtilsParam({r: this.objId, streamId: arguments[0].streamId, cmds: JSON.stringify({"cmds": arguments[0].cmds})});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['streamId', 'cmds'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "object")){
						var params = vcUtilsParam({r: this.objId, streamId: arguments[0], cmds: JSON.stringify({"cmds": arguments[1]})});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(cmds&& response.data.cmds)
								vcUtilsExtend(cmds, response.data.cmds);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererSendFECCCommands?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Requests frames for the specific stream with specified parameters or updates stream parameters if frames have already been requested. Parameters are used to request the most suitable video stream for this source. It is set based on tile size..
				 * @param r The VidyoVirtualRenderer object.
				 * @param streamId The unique ID of stream.
				 * @param width Desired stream width.
				 * @param height Desired stream height.
				 * @param frameInterval Desired stream frame interval.
				 * @param pin LMI_TRUE to pin stream to always receive the video frames. LMI_FALSE to make the stream behavior default.
				 */
				this.StreamStart = function(streamId, width, height, frameInterval, pin) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('streamId') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval') && arguments[0].hasOwnProperty('pin')){
							var params = vcUtilsParam({r: this.objId, streamId: arguments[0].streamId, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval, pin: arguments[0].pin});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['streamId', 'width', 'height', 'frameInterval', 'pin'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "boolean")){
						var params = vcUtilsParam({r: this.objId, streamId: arguments[0], width: arguments[1], height: arguments[2], frameInterval: arguments[3], pin: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamStart?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Stops receiving frames for a specific stream.
				 * @param r The VidyoVirtualRenderer object.
				 * @param streamId The unique ID of stream.
				 */
				this.StreamStop = function(streamId) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('streamId')){
							var params = vcUtilsParam({r: this.objId, streamId: arguments[0].streamId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['streamId'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, streamId: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamStop?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Unregisters virtual renderer callbacks to receive notifications about participants and streams.
				 * @param r The VidyoVirtualRenderer object.
				 * @param token Token for callbacks that should be unregister.
				 */
				this.UnregisterEventListener = function(token) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('token')){
							var params = vcUtilsParam({r: this.objId, token: arguments[0].token});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['token'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({r: this.objId, token: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererUnregisterEventListener?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoVirtualRendererParticipant = function(){

				this.Destruct = function() {
					GetRequest("VidyoVirtualRendererParticipantDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Gets participant id.
				 * @param p The VidyoVirtualRendererParticipant object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({p: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({p: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererParticipantGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets participant initials.
				 * @param p The VidyoVirtualRendererParticipant object.
				 */
				this.GetInitial = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({p: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({p: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererParticipantGetInitial?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets participant name.
				 * @param p The VidyoVirtualRendererParticipant object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({p: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({p: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererParticipantGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets participant unique id in the conference.
				 * @param p The VidyoVirtualRendererParticipant object.
				 */
				this.GetParticipantId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({p: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({p: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererParticipantGetParticipantId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks whether participant is remote.
				 * @param p The VidyoVirtualRendererParticipant object.
				 */
				this.IsRemote = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({p: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({p: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererParticipantIsRemote?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoVirtualRendererStream = function(){

				this.Destruct = function() {
					GetRequest("VidyoVirtualRendererStreamDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Gets stream id.
				 * @param s The VidyoVirtualRendererStream object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets stream label.
				 * @param s The VidyoVirtualRendererStream object.
				 */
				this.GetLabel = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamGetLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets streams participant unique id.
				 * @param s The VidyoVirtualRendererStream object.
				 */
				this.GetParticipantId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamGetParticipantId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets stream type.
				 * @param s The VidyoVirtualRendererStream object.
				 */
				this.GetType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamGetType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks whether stream is local.
				 * @param s The VidyoVirtualRendererStream object.
				 */
				this.IsLocal = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamIsLocal?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Checks whether stream is mirrored.
				 * @param s The VidyoVirtualRendererStream object.
				 */
				this.IsMirrored = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualRendererStreamIsMirrored?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoVirtualShareManager = function(){

				this.Destruct = function() {
					GetRequest("VidyoVirtualShareManagerDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				this.LocalMonitorEvent = function(endpoint, monitor, state) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('monitor') && arguments[0].hasOwnProperty('state')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), monitor: (arguments[0].monitor ? arguments[0].monitor.objId : 0), state: arguments[0].state});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'monitor', 'state'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), monitor: (arguments[1] ? arguments[1].objId : 0), state: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualShareManagerLocalMonitorEvent?" + params, OnComplete, OnError);
					});
				}

				this.LocalWindowShareEvent = function(endpoint, windowShare, state) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('windowShare') && arguments[0].hasOwnProperty('state')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), windowShare: (arguments[0].windowShare ? arguments[0].windowShare.objId : 0), state: arguments[0].state});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'windowShare', 'state'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), windowShare: (arguments[1] ? arguments[1].objId : 0), state: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualShareManagerLocalWindowShareEvent?" + params, OnComplete, OnError);
					});
				}

				this.MediaFailedEvent = function(endpoint) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint')){
							var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({m: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualShareManagerMediaFailedEvent?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoVirtualVideoSource = function(endpoint, type, id, name) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('type') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('name')){
						var params = vcUtilsParam({s: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), type: arguments[0].type, id: arguments[0].id, name: arguments[0].name});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint', 'type', 'id', 'name'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 4 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string")){
					var params = vcUtilsParam({s: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), type: arguments[1], id: arguments[2], name: arguments[3]});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoVirtualVideoSource = new contextObj.VidyoVirtualVideoSource(response.data.VidyoVirtualVideoSource);	// copy construct
						objects[vidyoVirtualVideoSource.objId] = vidyoVirtualVideoSource;
						resolve(vidyoVirtualVideoSource);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoVirtualVideoSourceConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoVirtualVideoSource = function(endpoint, type, id, name) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoVirtualVideoSource"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint') && arguments[0].hasOwnProperty('type') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('name')){
							var params = vcUtilsParam({s: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0), type: arguments[0].type, id: arguments[0].id, name: arguments[0].name});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['endpoint', 'type', 'id', 'name'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string")){
						var params = vcUtilsParam({s: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0), type: arguments[1], id: arguments[2], name: arguments[3]});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoVirtualVideoSourceConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoVirtualVideoSource);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoVirtualVideoSourceDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.AddToLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({s: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({s: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceAddToLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.AddToRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({s: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({s: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceAddToRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Clears existing constraints and set them to default values 3840x2160@3fps for share and 1280x720@30fps for camera.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.ClearConstraints = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceClearConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the current encode frame interval of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.GetCurrentEncodeFrameInterval = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceGetCurrentEncodeFrameInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the media format of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.GetMediaType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceGetMediaType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the name of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.GetName = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceGetName?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the preview label of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.GetPreviewLabel = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceGetPreviewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the type of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.GetType = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceGetType?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Check if source added to the local renderer.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.IsPreviewOn = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceIsPreviewOn?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Check if source added to the remote renderer.
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.IsSelected = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({s: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceIsSelected?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param mediaFormat The media format of video frame
				 */
				this.OnFrame = function(videoFrame, mediaFormat) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('videoFrame') && arguments[0].hasOwnProperty('mediaFormat')){
							var params = vcUtilsParam({s: this.objId, videoFrame: (arguments[0].videoFrame ? arguments[0].videoFrame.objId : 0), mediaFormat: arguments[0].mediaFormat});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['videoFrame', 'mediaFormat'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({s: this.objId, videoFrame: (arguments[0] ? arguments[0].objId : 0), mediaFormat: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceOnFrame?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Constructs a virtual video source.
				 * @param s The VidyoVirtualVideoSource object.
				 * @param onStart A callback invoked to notify that video source started after reconfiguration.
				 * @param onReconfigure A callback invoked if configuration changed.
				 * @param onStop A callback invoked to notify that video source stoped after reconfiguration.
				 * @param onBufferRelease Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.
				 */
				this.RegisterEventListener = function(onStart, onReconfigure, onStop, onBufferRelease) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onStart') && arguments[0].hasOwnProperty('onReconfigure') && arguments[0].hasOwnProperty('onStop') && arguments[0].hasOwnProperty('onBufferRelease')){
							this.VidyoVirtualVideoSourceStartCallback = arguments[0].onStart;
							this.VidyoVirtualVideoSourceReconfigureCallback = arguments[0].onReconfigure;
							this.VidyoVirtualVideoSourceStopCallback = arguments[0].onStop;
							this.VidyoVirtualVideoSourceExternalMediaBufferReleaseCallback = arguments[0].onBufferRelease;
							var params = vcUtilsParam({s: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onStart', 'onReconfigure', 'onStop', 'onBufferRelease'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoVirtualVideoSourceStartCallback = onStart;
						this.VidyoVirtualVideoSourceReconfigureCallback = onReconfigure;
						this.VidyoVirtualVideoSourceStopCallback = onStop;
						this.VidyoVirtualVideoSourceExternalMediaBufferReleaseCallback = onBufferRelease;
						var params = vcUtilsParam({s: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceRegisterEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.RemoveFromLocalRenderer = function(renderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('renderer')){
							var params = vcUtilsParam({s: this.objId, renderer: (arguments[0].renderer ? arguments[0].renderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['renderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({s: this.objId, renderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceRemoveFromLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoVirtualVideoSource object.
				 */
				this.RemoveFromRemoteRenderer = function(remoteRenderer) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('remoteRenderer')){
							var params = vcUtilsParam({s: this.objId, remoteRenderer: (arguments[0].remoteRenderer ? arguments[0].remoteRenderer.objId : 0)});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['remoteRenderer'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({s: this.objId, remoteRenderer: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceRemoveFromRemoteRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoVirtualVideoSource object.
				 * @param format The media format of the video frame.
				 * @param buffer A pointer to externally allocated memory that holds the pixel data.
				 * @param size The size, in bytes, of the frame data.
				 * @param width The width of the video media frame in pixels.
				 * @param height The height of the video media frame in pixels.
				 */
				this.SendFrameWithExternalData = function(format, buffer, size, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('format') && arguments[0].hasOwnProperty('buffer') && arguments[0].hasOwnProperty('size') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							var params = vcUtilsParam({s: this.objId, format: arguments[0].format, buffer: arguments[0].buffer, size: arguments[0].size, width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['format', 'buffer', 'size', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number")){
						var params = vcUtilsParam({s: this.objId, format: arguments[0], buffer: arguments[1], size: arguments[1], width: arguments[2], height: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSendFrameWithExternalData?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions.
				 * @param s The VidyoVirtualVideoSource object.
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param maxWidth Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit
				 * @param minWidth Unused
				 * @param maxHeight Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit
				 * @param minHeight Unused
				 */
				this.SetBoundsConstraints = function(maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('maxWidth') && arguments[0].hasOwnProperty('minWidth') && arguments[0].hasOwnProperty('maxHeight') && arguments[0].hasOwnProperty('minHeight')){
							var params = vcUtilsParam({s: this.objId, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, maxWidth: arguments[0].maxWidth, minWidth: arguments[0].minWidth, maxHeight: arguments[0].maxHeight, minHeight: arguments[0].minHeight});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxFrameInterval', 'minFrameInterval', 'maxWidth', 'minWidth', 'maxHeight', 'minHeight'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number") && (typeof(arguments[5]) === "number")){
						var params = vcUtilsParam({s: this.objId, maxFrameInterval: arguments[0], minFrameInterval: arguments[1], maxWidth: arguments[2], minWidth: arguments[3], maxHeight: arguments[4], minHeight: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetBoundsConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used.
				 * @param s The VidyoVirtualVideoSource object.
				 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc).
				 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
				 * @param width The width of the stream after the stream is reconfigured.
				 * @param height The height of the stream after the stream is reconfigured.
				 */
				this.SetDiscreteConstraints = function(maxFrameInterval, minFrameInterval, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('maxFrameInterval') && arguments[0].hasOwnProperty('minFrameInterval') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							var params = vcUtilsParam({s: this.objId, maxFrameInterval: arguments[0].maxFrameInterval, minFrameInterval: arguments[0].minFrameInterval, width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['maxFrameInterval', 'minFrameInterval', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number")){
						var params = vcUtilsParam({s: this.objId, maxFrameInterval: arguments[0], minFrameInterval: arguments[1], width: arguments[2], height: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetDiscreteConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets the low latency profile of the video source which treats the stream as a regular video source. This prioritizes latency over quality.
				 * @param s The VidyoVirtualVideoSource object.
				 * @param profile Low latency profile toggle. Default is LMI_FALSE.
				 */
				this.SetLowLatencyProfile = function(profile) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('profile')){
							var params = vcUtilsParam({s: this.objId, profile: arguments[0].profile});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['profile'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "boolean")){
						var params = vcUtilsParam({s: this.objId, profile: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetLowLatencyProfile?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the source is in landscape mode width and height will be applied as max constraints, if the monitor is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
				 * @param s The VidyoVirtualVideoSource object.
				 * @param width Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.
				 * @param height Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
				 */
				this.SetMaxConstraints = function(width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({s: this.objId, width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "number") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({s: this.objId, width: arguments[0], height: arguments[1], frameInterval: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetMaxConstraints?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set a minimum frame interval(maximum fps) for the encoded stream.
				 * @param s The VidyoVirtualVideoSource object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps) for share type and 33333333 (30fps) for camera. To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
				 */
				this.SetMinFrameInterval = function(frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({s: this.objId, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "number")){
						var params = vcUtilsParam({s: this.objId, frameInterval: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetMinFrameInterval?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Set the preview label of the video source.
				 * @param s The VidyoVirtualVideoSource object.
				 * @param previewLabel Display name to set on the video source.
				 */
				this.SetPreviewLabel = function(previewLabel) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('previewLabel')){
							var params = vcUtilsParam({s: this.objId, previewLabel: arguments[0].previewLabel});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['previewLabel'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({s: this.objId, previewLabel: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetPreviewLabel?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param s The VidyoVirtualVideoSource object.
				 * @param frameInterval The interval in nanoseconds between consecutive frames.
				 */
				this.SetStreamParametersInLocalRenderer = function(localRenderer, width, height, frameInterval) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('localRenderer') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height') && arguments[0].hasOwnProperty('frameInterval')){
							var params = vcUtilsParam({s: this.objId, localRenderer: (arguments[0].localRenderer ? arguments[0].localRenderer.objId : 0), width: arguments[0].width, height: arguments[0].height, frameInterval: arguments[0].frameInterval});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['localRenderer', 'width', 'height', 'frameInterval'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number")){
						var params = vcUtilsParam({s: this.objId, localRenderer: (arguments[0] ? arguments[0].objId : 0), width: arguments[1], height: arguments[2], frameInterval: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoVirtualVideoSourceSetStreamParametersInLocalRenderer?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoApplication = function(endpoint) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('endpoint')){
						var params = vcUtilsParam({application: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0)});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['endpoint'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
					var params = vcUtilsParam({application: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0)});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoApplication = new contextObj.VidyoApplication(response.data.VidyoApplication);	// copy construct
						objects[vidyoApplication.objId] = vidyoApplication;
						resolve(vidyoApplication);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoApplicationConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoApplication = function(endpoint) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoApplication"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('endpoint')){
							var params = vcUtilsParam({application: this.objId, endpoint: (arguments[0].endpoint ? arguments[0].endpoint.objId : 0)});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['endpoint'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "object")){
						var params = vcUtilsParam({application: this.objId, endpoint: (arguments[0] ? arguments[0].objId : 0)});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoApplicationConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoApplication);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoApplicationDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Registers to get notified about software updater events.
				 * @param app The VidyoApplication object.
				 */
				this.RegisterUpdaterEventListener = function(onDownloadCompleted, onDownloadFailed) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onDownloadCompleted') && arguments[0].hasOwnProperty('onDownloadFailed')){
							this.VidyoApplicationDownloadCompletedCallback = arguments[0].onDownloadCompleted;
							this.VidyoApplicationDownloadFailedCallback = arguments[0].onDownloadFailed;
							var params = vcUtilsParam({app: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onDownloadCompleted', 'onDownloadFailed'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoApplicationDownloadCompletedCallback = onDownloadCompleted;
						this.VidyoApplicationDownloadFailedCallback = onDownloadFailed;
						var params = vcUtilsParam({app: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoApplicationRegisterUpdaterEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param app The application object.
				 */
				this.SetWebProxyCredentials = function(webProxyUserName, webProxyPassword) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('webProxyUserName') && arguments[0].hasOwnProperty('webProxyPassword')){
							var params = vcUtilsParam({app: this.objId, webProxyUserName: arguments[0].webProxyUserName, webProxyPassword: arguments[0].webProxyPassword});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['webProxyUserName', 'webProxyPassword'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({app: this.objId, webProxyUserName: arguments[0], webProxyPassword: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoApplicationSetWebProxyCredentials?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Start checking for client software updates on the server.
				 * @param app The endpoint object.
				 * @param currentVersion Current version of this application.
				 * @param workingDirectory The working directory used to store the installer.
				 * @param server The server to be polled.
				 * @param webProxyUsername User name for connecting to web proxy.
				 * @param webProxyPassword Password for connecting to web proxy.
				 */
				this.StartUpdateService = function(currentVersion, workingDirectory, server, caFilePath, webProxyUsername, webProxyPassword) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('currentVersion') && arguments[0].hasOwnProperty('workingDirectory') && arguments[0].hasOwnProperty('server') && arguments[0].hasOwnProperty('caFilePath') && arguments[0].hasOwnProperty('webProxyUsername') && arguments[0].hasOwnProperty('webProxyPassword')){
							var params = vcUtilsParam({app: this.objId, currentVersion: arguments[0].currentVersion, workingDirectory: arguments[0].workingDirectory, server: arguments[0].server, caFilePath: arguments[0].caFilePath, webProxyUsername: arguments[0].webProxyUsername, webProxyPassword: arguments[0].webProxyPassword});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['currentVersion', 'workingDirectory', 'server', 'caFilePath', 'webProxyUsername', 'webProxyPassword'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "string")){
						var params = vcUtilsParam({app: this.objId, currentVersion: arguments[0], workingDirectory: arguments[1], server: arguments[2], caFilePath: arguments[3], webProxyUsername: arguments[4], webProxyPassword: arguments[5]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoApplicationStartUpdateService?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Stop checking for client software updates on the server.
				 * @param app The application object.
				 */
				this.StopUpdateService = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({app: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({app: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoApplicationStopUpdateService?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.VidyoCall = function(){

				this.Destruct = function() {
					GetRequest("VidyoCallDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Accepts an incoming VidyoCall that was notified by the VidyoUserOnCallCreatedByInvite callback.
				 * @param c Pointer to the VidyoCall object.
				 * @param onInitiated Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.
				 * @param onEnded Callback that is triggered when the room has been exited.
				 */
				this.Accept = function(onInitiated, onEnded) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onInitiated') && arguments[0].hasOwnProperty('onEnded')){
							this.VidyoCallOnInitiated = arguments[0].onInitiated;
							this.VidyoCallOnEnded = arguments[0].onEnded;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onInitiated', 'onEnded'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoCallOnInitiated = onInitiated;
						this.VidyoCallOnEnded = onEnded;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallAccept?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the unique ID of the VidyoCall
				 * @param c Pointer to the VidyoCall object.
				 */
				this.GetId = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallGetId?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Gets the current subject of the VidyoCall.
				 * @param c Pointer to the VidyoCall object.
				 */
				this.GetSubject = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallGetSubject?" + params, OnComplete, OnError);
					});
				}

				this.GetUser = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallGetUser?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Hangs up an in-progress VidyoCall.
				 * @param c Pointer to the VidyoCall object.
				 */
				this.HangUp = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallHangUp?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Initiates a VidyoCall.
				 * @param c Pointer to the VidyoCall object.
				 * @param onInitiated Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.
				 * @param onEnded Callback that is triggered when the room has been exited.
				 */
				this.Initiate = function(onInitiated, onEnded) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onInitiated') && arguments[0].hasOwnProperty('onEnded')){
							this.VidyoCallOnInitiated = arguments[0].onInitiated;
							this.VidyoCallOnEnded = arguments[0].onEnded;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onInitiated', 'onEnded'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function")){
						this.VidyoCallOnInitiated = onInitiated;
						this.VidyoCallOnEnded = onEnded;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallInitiate?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about message events.
				 * @param c The VidyoCall object.
				 * @param onMessageReceived Callback that is triggered when a new message has been received.
				 * @param onMessageAcknowledged Callback that is triggered when a sent message has been acknowledged.
				 * @param onMessageRead Callback that is triggered when a sent message has been read.
				 * @param onMessageTypingIndication Callback that is triggered when a remote participant is typing.
				 */
				this.RegisterMessageEventListener = function(onMessageReceived, onMessageAcknowledged, onMessageRead, onMessageTypingIndication) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onMessageReceived') && arguments[0].hasOwnProperty('onMessageAcknowledged') && arguments[0].hasOwnProperty('onMessageRead') && arguments[0].hasOwnProperty('onMessageTypingIndication')){
							this.VidyoCallOnMessageReceived = arguments[0].onMessageReceived;
							this.VidyoCallOnMessageAcknowledged = arguments[0].onMessageAcknowledged;
							this.VidyoCallOnMessageRead = arguments[0].onMessageRead;
							this.VidyoCallOnMessageTypingIndication = arguments[0].onMessageTypingIndication;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onMessageReceived', 'onMessageAcknowledged', 'onMessageRead', 'onMessageTypingIndication'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "function") && (typeof(arguments[1]) === "function") && (typeof(arguments[2]) === "function") && (typeof(arguments[3]) === "function")){
						this.VidyoCallOnMessageReceived = onMessageReceived;
						this.VidyoCallOnMessageAcknowledged = onMessageAcknowledged;
						this.VidyoCallOnMessageRead = onMessageRead;
						this.VidyoCallOnMessageTypingIndication = onMessageTypingIndication;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallRegisterMessageEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Registers to get notified about subject events.
				 * @param c The VidyoCall object.
				 * @param onSetSubject Callback that is triggered when the subject has been changed.
				 */
				this.RegisterSubjectEventListener = function(onSetSubject) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('onSetSubject')){
							this.VidyoCallOnSetSubject = arguments[0].onSetSubject;
							var params = vcUtilsParam({c: this.objId});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['onSetSubject'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "function")){
						this.VidyoCallOnSetSubject = onSetSubject;
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallRegisterSubjectEventListener?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Rejects an incoming VidyoCall that was notified by the VidyoUserFeedbackCallCreatedByInvite callback.
				 * @param c Pointer to the VidyoCall object.
				 */
				this.Reject = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({c: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({c: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallReject?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sends a message to the remote user in the VidyoCall.
				 * @param c Pointer to the VidyoCall object.
				 * @param message Message to be sent.
				 */
				this.SendMessage = function(message) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('message')){
							var params = vcUtilsParam({c: this.objId, message: arguments[0].message});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['message'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, message: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallSendMessage?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Sets a new subject on the VidyoCall.
				 * @param c Pointer to the VidyoCall object.
				 * @param subject New subject of the VidyoCall.
				 */
				this.SetSubject = function(subject) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('subject')){
							var params = vcUtilsParam({c: this.objId, subject: arguments[0].subject});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['subject'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({c: this.objId, subject: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoCallSetSubject?" + params, OnComplete, OnError);
					});
				}

				return this;
			}

			this.CreateVidyoEndpoint = function(viewId, viewStyle, remoteParticipants, consoleLogFilter, logFileFilter, logFileName) {
				var args = [].slice.apply(arguments);
				if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
					if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('viewStyle') && arguments[0].hasOwnProperty('remoteParticipants') && arguments[0].hasOwnProperty('consoleLogFilter') && arguments[0].hasOwnProperty('logFileFilter') && arguments[0].hasOwnProperty('logFileName')){
						arguments[0].viewId = UpdateViewOnDOM({uiEvent:"create", viewId:arguments[0].viewId, viewStyle:arguments[0].viewStyle, remoteParticipants:arguments[0].remoteParticipants, consoleLogFilter:arguments[0].consoleLogFilter, logFileFilter:arguments[0].logFileFilter, logFileName:arguments[0].logFileName});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, viewStyle: arguments[0].viewStyle, remoteParticipants: arguments[0].remoteParticipants, consoleLogFilter: arguments[0].consoleLogFilter, logFileFilter: arguments[0].logFileFilter, logFileName: arguments[0].logFileName});
					} else {
						return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'viewStyle', 'remoteParticipants', 'consoleLogFilter', 'logFileFilter', 'logFileName'], Object.keys(arguments[0])).error);
					}
				} else if (arguments.length === 6 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "string")){
					arguments[0] = UpdateViewOnDOM({uiEvent:"create", viewId:viewId, viewStyle:viewStyle, remoteParticipants:remoteParticipants, consoleLogFilter:consoleLogFilter, logFileFilter:logFileFilter, logFileName:logFileName});
					var params = vcUtilsParam({e: this.objId, viewId: arguments[0], viewStyle: arguments[1], remoteParticipants: arguments[2], consoleLogFilter: arguments[3], logFileFilter: arguments[4], logFileName: arguments[5]});
				} else {
					return Promise.reject(new Error('Invalid Parameters'));
				}

				return new Promise(function(resolve, reject){
					function OnComplete(response) {
						var vidyoEndpoint = new contextObj.VidyoEndpoint(response.data.VidyoEndpoint);	// copy construct
						objects[vidyoEndpoint.objId] = vidyoEndpoint;
						resolve(vidyoEndpoint);
					}
					function OnError(response) {
						reject(Error(response));
					}
					GetRequest("VidyoEndpointConstruct?" + params, OnComplete, OnError);
				});
			}
			this.VidyoEndpoint = function(viewId, viewStyle, remoteParticipants, consoleLogFilter, logFileFilter, logFileName) {
				if(arguments.length === 1 && arguments[0].objId && arguments[0].objType && arguments[0].objType === "VidyoEndpoint"){
					vcUtilsExtend(this, arguments[0]);	//	copy construct
				} else {
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('viewStyle') && arguments[0].hasOwnProperty('remoteParticipants') && arguments[0].hasOwnProperty('consoleLogFilter') && arguments[0].hasOwnProperty('logFileFilter') && arguments[0].hasOwnProperty('logFileName')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"constructor", viewId:arguments[0].viewId, viewStyle:arguments[0].viewStyle, remoteParticipants:arguments[0].remoteParticipants, consoleLogFilter:arguments[0].consoleLogFilter, logFileFilter:arguments[0].logFileFilter, logFileName:arguments[0].logFileName});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, viewStyle: arguments[0].viewStyle, remoteParticipants: arguments[0].remoteParticipants, consoleLogFilter: arguments[0].consoleLogFilter, logFileFilter: arguments[0].logFileFilter, logFileName: arguments[0].logFileName});
						} else {
							throw new MissingArgumentException('Missing Parameters', ['viewId', 'viewStyle', 'remoteParticipants', 'consoleLogFilter', 'logFileFilter', 'logFileName'], Object.keys(arguments[0])).error;
						}
					} else if (arguments.length === 6 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "string") && (typeof(arguments[4]) === "string") && (typeof(arguments[5]) === "string")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"constructor", viewId:viewId, viewStyle:viewStyle, remoteParticipants:remoteParticipants, consoleLogFilter:consoleLogFilter, logFileFilter:logFileFilter, logFileName:logFileName});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], viewStyle: arguments[1], remoteParticipants: arguments[2], consoleLogFilter: arguments[3], logFileFilter: arguments[4], logFileName: arguments[5]});
					} else {
						throw new Error('Invalid Parameters');
					}
					var response = GetRequest("VidyoEndpointConstruct?" + params);
					if(response == null)
						throw new Error('No Response from VidyoClient');
					vcUtilsExtend(this, response.VidyoEndpoint);
					objects[this.objId] = this;

				}

				this.Destruct = function() {
					GetRequest("VidyoEndpointDestruct?" + vcUtilsParam({ obj: this.objId }), function(){}, function(){});
					delete objects[this.objId];
				}

				/**
				 * Adds audio device to whitelist.
				 * @param e The VidyoEndpoint object.
				 * @param deviceName The name of audio device that will be whitelisted.
				 */
				this.AddAudioDeviceToWhitelist = function(deviceName) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('deviceName')){
							var params = vcUtilsParam({e: this.objId, deviceName: arguments[0].deviceName});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['deviceName'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({e: this.objId, deviceName: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAddAudioDeviceToWhitelist?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Add message class that application should receive.
				 * @param e The VidyoEndpoint object.
				 * @param messageClass Name of message class. MSGCLASS_HUNTER is added by default so application will receive only these message class.
				 */
				this.AddMessageClass = function(messageClass) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('messageClass')){
							var params = vcUtilsParam({e: this.objId, messageClass: arguments[0].messageClass});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['messageClass'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 1 && (typeof(arguments[0]) === "string")){
						var params = vcUtilsParam({e: this.objId, messageClass: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAddMessageClass?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Log an application log message into the VidyoClient logs under the log category 'Application'.
				 * @param logLevel Specify logging level using enum, allowed values defined in VidyoClientAppLogLevel
				 * @param logMsg Log message to write to logfile
				 */
				this.AppLog = function(logLevel, logMsg) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('logLevel') && arguments[0].hasOwnProperty('logMsg')){
							var params = vcUtilsParam({e: this.objId, logLevel: arguments[0].logLevel, logMsg: arguments[0].logMsg});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['logLevel', 'logMsg'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string")){
						var params = vcUtilsParam({e: this.objId, logLevel: arguments[0], logMsg: arguments[1]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAppLog?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Composites the preview and remote participants in a view. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param viewStyle Type of the composite renderer which represents the visual style and behaviour.
				 * @param remoteParticipants Number of remote participants to composite into the window. Setting the value to 0 will render preview only.
				 */
				this.AssignViewToCompositeRenderer = function(viewId, viewStyle, remoteParticipants) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('viewStyle') && arguments[0].hasOwnProperty('remoteParticipants')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToCompositeRenderer", viewId:arguments[0].viewId, viewStyle:arguments[0].viewStyle, remoteParticipants:arguments[0].remoteParticipants});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, viewStyle: arguments[0].viewStyle, remoteParticipants: arguments[0].remoteParticipants});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'viewStyle', 'remoteParticipants'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToCompositeRenderer", viewId:viewId, viewStyle:viewStyle, remoteParticipants:remoteParticipants});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], viewStyle: arguments[1], remoteParticipants: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToCompositeRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a preview of a local camera in a view. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param localCamera The VidyoLocalCamera that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToLocalCamera = function(viewId, localCamera, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('localCamera') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToLocalCamera", viewId:arguments[0].viewId, localCamera:arguments[0].localCamera, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, localCamera: (arguments[0].localCamera ? arguments[0].localCamera.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'localCamera', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToLocalCamera", viewId:viewId, localCamera:localCamera, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], localCamera: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToLocalCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a VidyoLocalMonitor in a view. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the VidyoLocalMonitor will be rendered.
				 * @param localMonitor The VidyoLocalMonitor that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToLocalMonitor = function(viewId, localMonitor, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('localMonitor') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToLocalMonitor", viewId:arguments[0].viewId, localMonitor:arguments[0].localMonitor, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, localMonitor: (arguments[0].localMonitor ? arguments[0].localMonitor.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'localMonitor', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToLocalMonitor", viewId:viewId, localMonitor:localMonitor, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], localMonitor: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(localMonitor&& response.data.localMonitor)
								vcUtilsExtend(localMonitor, response.data.localMonitor);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToLocalMonitor?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a VidyoLocalWindowShare in a view. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the VidyoLocalWindowShare will be rendered.
				 * @param localWindowShare The VidyoLocalWindowShare that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToLocalWindowShare = function(viewId, localWindowShare, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('localWindowShare') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToLocalWindowShare", viewId:arguments[0].viewId, localWindowShare:arguments[0].localWindowShare, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, localWindowShare: (arguments[0].localWindowShare ? arguments[0].localWindowShare.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'localWindowShare', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToLocalWindowShare", viewId:viewId, localWindowShare:localWindowShare, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], localWindowShare: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							if(localWindowShare&& response.data.localWindowShare)
								vcUtilsExtend(localWindowShare, response.data.localWindowShare);
							resolve(response.data);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToLocalWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a participant in a view.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param remoteCamera The VidyoRemoteCamera that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToRemoteCamera = function(viewId, remoteCamera, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('remoteCamera') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteCamera", viewId:arguments[0].viewId, remoteCamera:arguments[0].remoteCamera, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, remoteCamera: (arguments[0].remoteCamera ? arguments[0].remoteCamera.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'remoteCamera', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteCamera", viewId:viewId, remoteCamera:remoteCamera, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], remoteCamera: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToRemoteCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a participant in a view. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the participant will be rendered.
				 * @param remoteWindowShare The VidyoRemoteWindowShare that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToRemoteWindowShare = function(viewId, remoteWindowShare, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('remoteWindowShare') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteWindowShare", viewId:arguments[0].viewId, remoteWindowShare:arguments[0].remoteWindowShare, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, remoteWindowShare: (arguments[0].remoteWindowShare ? arguments[0].remoteWindowShare.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'remoteWindowShare', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToRemoteWindowShare", viewId:viewId, remoteWindowShare:remoteWindowShare, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], remoteWindowShare: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToRemoteWindowShare?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Shows a virtual video source in a view. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param viewId A platform specific view ID where the source will be rendered.
				 * @param virtualVideoSource The VidyoVirtualVideoSource that will be shown.
				 * @param displayCropped Render the image as cropped. Otherwise letterbox.
				 * @param allowZoom Allow zooming of the image with mouse or touch.
				 */
				this.AssignViewToVirtualVideoSource = function(viewId, virtualVideoSource, displayCropped, allowZoom) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('virtualVideoSource') && arguments[0].hasOwnProperty('displayCropped') && arguments[0].hasOwnProperty('allowZoom')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"AssignViewToVirtualVideoSource", viewId:arguments[0].viewId, virtualVideoSource:arguments[0].virtualVideoSource, displayCropped:arguments[0].displayCropped, allowZoom:arguments[0].allowZoom});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, virtualVideoSource: (arguments[0].virtualVideoSource ? arguments[0].virtualVideoSource.objId : 0), displayCropped: arguments[0].displayCropped, allowZoom: arguments[0].allowZoom});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'virtualVideoSource', 'displayCropped', 'allowZoom'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 4 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "object") && (typeof(arguments[2]) === "boolean") && (typeof(arguments[3]) === "boolean")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"AssignViewToVirtualVideoSource", viewId:viewId, virtualVideoSource:virtualVideoSource, displayCropped:displayCropped, allowZoom:allowZoom});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], virtualVideoSource: (arguments[1] ? arguments[1].objId : 0), displayCropped: arguments[2], allowZoom: arguments[3]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointAssignViewToVirtualVideoSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param compressedFileName Name if the compression output file.
				 * @param onComplete Callback that is triggered when the compression completes.
				 */
				this.CompressLogs = function(compressedFileName, onComplete) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('compressedFileName') && arguments[0].hasOwnProperty('onComplete')){
							this.VidyoEndpointOnLogCompressionComplete = arguments[0].onComplete;
							var params = vcUtilsParam({e: this.objId, compressedFileName: arguments[0].compressedFileName});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['compressedFileName', 'onComplete'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 2 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "function")){
						this.VidyoEndpointOnLogCompressionComplete = onComplete;
						var params = vcUtilsParam({e: this.objId, compressedFileName: arguments[0]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCompressLogs?" + params, OnComplete, OnError);
					});
				}

				this.CreateRenderer = function(monitor, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('monitor') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							var params = vcUtilsParam({e: this.objId, monitor: (arguments[0].monitor ? arguments[0].monitor.objId : 0), width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['monitor', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "object") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number")){
						var params = vcUtilsParam({e: this.objId, monitor: (arguments[0] ? arguments[0].objId : 0), width: arguments[1], height: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCreateRenderer?" + params, OnComplete, OnError);
					});
				}

				/**
				 * @param viewId A platform specific parent view ID where the rendering window will be added as a child window.
				 * @param x X coordinate of the child window within the parent view ID.
				 * @param y Y coordinate of the child window within the parent view ID.
				 * @param width Width of the child window within the parent view ID.
				 * @param height Height of the child window within the parent view ID.
				 */
				this.CreateRendererFromViewId = function(viewId, x, y, width, height) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('viewId') && arguments[0].hasOwnProperty('x') && arguments[0].hasOwnProperty('y') && arguments[0].hasOwnProperty('width') && arguments[0].hasOwnProperty('height')){
							arguments[0].viewId = UpdateViewOnDOM({uiEvent:"CreateRendererFromViewId", viewId:arguments[0].viewId, x:arguments[0].x, y:arguments[0].y, width:arguments[0].width, height:arguments[0].height});
							var params = vcUtilsParam({e: this.objId, viewId: arguments[0].viewId, x: arguments[0].x, y: arguments[0].y, width: arguments[0].width, height: arguments[0].height});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['viewId', 'x', 'y', 'width', 'height'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 5 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "number") && (typeof(arguments[2]) === "number") && (typeof(arguments[3]) === "number") && (typeof(arguments[4]) === "number")){
						arguments[0] = UpdateViewOnDOM({uiEvent:"CreateRendererFromViewId", viewId:viewId, x:x, y:y, width:width, height:height});
						var params = vcUtilsParam({e: this.objId, viewId: arguments[0], x: arguments[1], y: arguments[2], width: arguments[3], height: arguments[4]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCreateRendererFromViewId?" + params, OnComplete, OnError);
					});
				}

				this.CreateRendererMultiScreen = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({e: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({e: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCreateRendererMultiScreen?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Create virtual audio source. This is an asynchronous interface. The VidyoEndpointOnVirtualAudioSourceAdded will trigger.
				 * @param e The VidyoEndpoint object.
				 * @param name The name for the virtual audio source.
				 * @param id The id for the virtual audio source.
				 * @param configuration The string in JSON format that contain audio configuration that will be used for virtual audio source. <p>format - Specifies the media format. Possible values are: fl32 or in16. The default is fl32.</p> <p>Example: {'format' : 'in16'}.</p> <p>sampleRate - Specifies the audio sample rate. Possible values are: 48000, 32000 and 16000. The default is 32000.</p> <p>Example: {'sampleRate' : 48000}.</p> <p>numberOfChannels - Specifies the number of channels. Possible values are: 1 or 2. The default is 1.</p> <p>Example: {'numberOfChannels' : 2}.</p> <p>frameInterval - Specifies the frame interval in ms. Possible values are: 20 or 40. The default is 20.</p> <p>Example: {'frameInterval' : 40}.</p>
				 */
				this.CreateVirtualAudioSource = function(name, id, configuration) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('name') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('configuration')){
							var params = vcUtilsParam({e: this.objId, name: arguments[0].name, id: arguments[0].id, configuration: arguments[0].configuration});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['name', 'id', 'configuration'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({e: this.objId, name: arguments[0], id: arguments[1], configuration: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCreateVirtualAudioSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Create a virtual video source. The user can create a maximum of 10 virtual video sources. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 * @param type Type of the virtual video source.
				 * @param id Unique ID.
				 * @param name Name of the virtual video source.
				 */
				this.CreateVirtualVideoSource = function(type, id, name) {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						if(arguments[0].hasOwnProperty('type') && arguments[0].hasOwnProperty('id') && arguments[0].hasOwnProperty('name')){
							var params = vcUtilsParam({e: this.objId, type: arguments[0].type, id: arguments[0].id, name: arguments[0].name});
						} else {
							return Promise.reject(new MissingArgumentException('Missing Parameters', ['type', 'id', 'name'], Object.keys(arguments[0])).error);
						}
					} else if (arguments.length === 3 && (typeof(arguments[0]) === "string") && (typeof(arguments[1]) === "string") && (typeof(arguments[2]) === "string")){
						var params = vcUtilsParam({e: this.objId, type: arguments[0], id: arguments[1], name: arguments[2]});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCreateVirtualVideoSource?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Cycles camera selection to the next available camera. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 */
				this.CycleCamera = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({e: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({e: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(response));
						}
						GetRequest("VidyoEndpointCycleCamera?" + params, OnComplete, OnError);
					});
				}

				/**
				 * Cycles microphone selection to the next available microphone. On, iOS, this API must be called from main(UI) thread.
				 * @param e The VidyoEndpoint object.
				 */
				this.CycleMicrophone = function() {
					var args = [].slice.apply(arguments);
					if(arguments.length === 1 && (typeof(arguments[0]) === "object") && !arguments[0].objId ){
						var params = vcUtilsParam({e: this.objId});
					} else if (arguments.length === 0){
						var params = vcUtilsParam({e: this.objId});
					} else {
						return Promise.reject(new Error('Invalid Parameters'));
					}
					return new Promise(function(resolve, reject){
						function OnComplete(response) {
							resolve(response.data.retValue);
						}
						function OnError(response) {
							reject(Error(respon