/**
{file:
    {name: VidyoNGRWrapper.h}
    {description: Wrapper of NGR plugin interface.}
    {copyright:
        (c) 20023-2023 Vidyo, Inc.,
        433 Hackensack Avenue,
        Hackensack, NJ  07601.

        All rights reserved.

        The information contained herein is proprietary to Vidyo, Inc.
        and shall not be reproduced, copied (in whole or in part), adapted,
        modified, disseminated, transmitted, transcribed, stored in a retrieval
        system, or translated into any language in any form by any means
        without the express written consent of Vidyo, Inc.
                          ***** CONFIDENTIAL *****
    }
}
*/

#ifndef VidyoNGRWrapper_h
#define VidyoNGRWrapper_h

#include <Lmi/Os/LmiSharedPtr.h>
#include <Lmi/Ui/LmiWindow.h>
#include <Lmi/Utils/LmiUnordered.h>
#ifdef LMI_USE_NGR
#include <NgrPlugin.h>
#endif

typedef enum {
    VIDYO_NGRWRAPPERLAYOUTTYPE_Grid,
    VIDYO_NGRWRAPPERLAYOUTTYPE_Speaker,
    VIDYO_NGRWRAPPERLAYOUTTYPE_Preview,
    VIDYO_NGRWRAPPERLAYOUTTYPE_None
} VidyoNGRWrapperLayoutType;

#ifdef LMI_USE_NGR

struct VidyoNGRWrapperImpl_;
typedef struct VidyoNGRWrapperImpl_ VidyoNGRWrapperImpl;
Declare_LmiSharedPtr(VidyoNGRWrapperImpl)
Declare_LmiSharedPtrWrapper(VidyoNGRWrapper, VidyoNGRWrapperImpl)
Declare_LmiWeakPtrWrapper(VidyoNGRWrapperHandle, VidyoNGRWrapper, VidyoNGRWrapperImpl)

Declare_LmiUnorderedMap(LmiViewId, VidyoNGRWrapper)
Declare_LmiUnorderedMap(LmiUint64, VidyoNGRWrapper)

typedef enum
{
    VIDYO_NGRWRAPPERACTIONTYPE_SetLayout,
    VIDYO_NGRWRAPPERACTIONTYPE_SetViewSize,
    VIDYO_NGRWRAPPERACTIONTYPE_SetDebugInfoVisible,
    VIDYO_NGRWRAPPERACTIONTYPE_SetLabelVisible,
    VIDYO_NGRWRAPPERACTIONTYPE_SetAudioMeterVisible,
    VIDYO_NGRWRAPPERACTIONTYPE_SetBackgroundColor,
    VIDYO_NGRWRAPPERACTIONTYPE_SetDensity,
    VIDYO_NGRWRAPPERACTIONTYPE_SetMaxRemoteParticipants,
    VIDYO_NGRWRAPPERACTIONTYPE_PinParticipant,
    VIDYO_NGRWRAPPERACTIONTYPE_ShowAudioTiles,
    VIDYO_NGRWRAPPERACTIONTYPE_Invalid
} VidyoNGRWrapperActionType;

typedef enum {
    VIDYO_NGRWRAPPERPREVIEWPOSITION_TopRight,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_CenterRight,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_BottomRight,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_TopLeft,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_CenterLeft,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_BottomLeft,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_TopCenter,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_CenterCenter,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_BottomCenter,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_Default,
    VIDYO_NGRWRAPPERPREVIEWPOSITION_Invalid
} VidyoNGRWrapperPreviewPosition;

typedef enum {
    VIDYO_NGRWRAPPERINPUTMETHOD_Mouse,
    VIDYO_NGRWRAPPERINPUTMETHOD_Touch,
    VIDYO_NGRWRAPPERINPUTMETHOD_Invalid
} VidyoNGRWrapperInputMethod;

typedef enum {
    VIDYO_NGRWRAPPERBORDERSTYLE_Same,
    VIDYO_NGRWRAPPERBORDERSTYLE_Highlight,
    VIDYO_NGRWRAPPERBORDERSTYLE_Flash,
    VIDYO_NGRWRAPPERBORDERSTYLE_None
} VidyoNGRWrapperBorderStyle;

typedef enum
{
    VIDYO_NGRWRAPPERMODE_Default,
    VIDYO_NGRWRAPPERMODE_Foreground,
    VIDYO_NGRWRAPPERMODE_Background
} VidyoNGRWrapperMode;

typedef void (*VidyoNGRWrapperPlugInRequestCompleted)(VidyoNGRWrapper* ngr, LmiUint64 viewId, VidyoNGRWrapperActionType type, LmiBool success, const char *error, LmiVoidPtr userData);
typedef void (*VidyoNGRWrapperPlugInSurfaceReleased)(VidyoNGRWrapper* ngr, LmiUint64 viewId, const char *error, LmiVoidPtr userData);

typedef struct VidyoNGRWrapperPlugIn_
{
    VidyoNGRWrapperPlugInRequestCompleted requestCompleted;
    VidyoNGRWrapperPlugInSurfaceReleased surfaceReleased;
} VidyoNGRWrapperPlugIn;

VidyoNGRWrapper* VidyoNGRWrapperConstruct(VidyoNGRWrapper* ngr, LmiViewId* viewId, LmiUint64 index, VidyoNGRWrapperLayoutType layout, VidyoNGRWrapperPlugIn* plugin, LmiAllocator* alloc, LmiVoidPtr userData);
void VidyoNGRWrapperSetLayout(VidyoNGRWrapper* ngr, VidyoNGRWrapperLayoutType layout);
void VidyoNGRWrapperSetViewSize(VidyoNGRWrapper* ngr, const LmiRectangle* rect);
void VidyoNGRWrapperSetDebugInfoVisible(VidyoNGRWrapper* ngr, LmiBool visible);
void VidyoNGRWrapperSetLabelVisible(VidyoNGRWrapper* ngr, LmiBool visible);
void VidyoNGRWrapperSetAudioMeterVisible(VidyoNGRWrapper* ngr, LmiBool visible);
void VidyoNGRWrapperSetBackgroundColor(VidyoNGRWrapper* ngr, LmiUint8 red, LmiUint8 green, LmiUint8 blue);

void VidyoNGRWrapperSetDensity(VidyoNGRWrapper* ngr, LmiFloat32 density);
LmiFloat32 VidyoNGRWrapperGetDensity(VidyoNGRWrapper* ngr);

void VidyoNGRWrapperSetMaxRemoteParticipants(VidyoNGRWrapper* ngr, LmiUint remoteParticipants);
void VidyoNGRWrapperPinParticipant(VidyoNGRWrapper* ngr, const char* participantID);

LmiBool VidyoNGRWrapperDestroyRenderer(VidyoNGRWrapper* ngr);
LmiBool VidyoNGRWrapperCreateRenderer(VidyoNGRWrapper *ngr, NgrPluginHandle plugin);

LmiUint64 VidyoNGRWrapperGetUID(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperSetPreviewPosition(VidyoNGRWrapper* ngr, VidyoNGRWrapperPreviewPosition position);
VidyoNGRWrapperPreviewPosition VidyoNGRWrapperGetPreviewPosition(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperEnablePreviewMirroring(VidyoNGRWrapper* ngr, LmiBool enable);
LmiBool VidyoNGRWrapperIsPreviewMirroringEnabled(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperEnableShowAudioTiles(VidyoNGRWrapper* ngr, LmiBool enable);
LmiBool VidyoNGRWrapperIsShowAudioTilesEnabled(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperEnableExpandedCameraControl(VidyoNGRWrapper* ngr, LmiBool enable);
LmiBool VidyoNGRWrapperIsExpandedCameraControlEnabled(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperEnableTouchAsInputMethod(VidyoNGRWrapper* ngr, LmiBool enable);
LmiBool VidyoNGRWrapperIsTouchAsInputMethodEnabled(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperSetBorderStyle(VidyoNGRWrapper* ngr, VidyoNGRWrapperBorderStyle style);
VidyoNGRWrapperBorderStyle VidyoNGRWrapperGetBorderStyle(VidyoNGRWrapper* ngr);
const char* VidyoNGRWrapperBorderStyleToCStr(VidyoNGRWrapperBorderStyle style);

LmiBool VidyoNGRWrapperEnableFECCIconCustomLayout(VidyoNGRWrapper* ngr, LmiBool enable);
LmiBool VidyoNGRWrapperIsFECCIconCustomLayoutEnabled(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperEnableVerticalVideoCentering(VidyoNGRWrapper* ngr, LmiBool enable);
LmiBool VidyoNGRWrapperIsVerticalVideoCenteringEnabled(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperSetMode(VidyoNGRWrapper* ngr, VidyoNGRWrapperMode mode);

void VidyoNGRWrapperSetViewingDistance(VidyoNGRWrapper* ngr, LmiFloat32 viewingDistance);
LmiFloat32 VidyoNGRWrapperGetViewingDistance(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperSetPipSize(VidyoNGRWrapper* ngr, int size);
int VidyoNGRWrapperGetPipSize(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperSetPipLock(VidyoNGRWrapper* ngr, LmiBool lock);
LmiBool VidyoNGRWrapperGetPipLock(VidyoNGRWrapper* ngr);

LmiBool VidyoNGRWrapperSetPipToTileAfterNTiles(VidyoNGRWrapper* ngr, LmiUint numTiles);
LmiUint VidyoNGRWrapperGetPipToTileAfterNTiles(VidyoNGRWrapper* ngr);

#if LMI_INLINE_NEED_HEADER_FILE_DEFINITIONS
Define_LmiSharedPtrWrapper_NoCompare(VidyoNGRWrapper, VidyoNGRWrapperImpl)
Define_LmiWeakPtrWrapper(VidyoNGRWrapperHandle, VidyoNGRWrapper, VidyoNGRWrapperImpl)
#endif

#endif

#endif /* VidyoNGRWrapper_h */
