// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// <p>Represents an instance of a calendar service. </p> <p/> <p>General concepts: </p> <p>- Each instance is identifiable through the combination of the service type and the id </p> <p/> <p>Lifecycle of an calendar service instance: </p> <p>- Create/construct an instance of the service through the VidyoCalendarManager based on a VidyoCalendarManagerDefaultServices </p> <p>- Constructor will take a vector of connection parameters, the content of which will also be dictated by the VidyoCalendarManagerDefaultServices </p> <p>- Recieve the constructed instance back through the VidyoCalendarManager callback method VidyoCalendarManagerFeedbackCreateServiceResult. </p> <p>- Connect the service to it's resource using the VidyoCalendarConnect method </p> <p>- Receive the connect result through the calendar service callback for that service through VidyoCalendarFeedbackConnectResult </p> <p>- Upon successful connection result, the user will be able to create, update, read and delete meetings from the service </p> <p>as well as receive reminder events </p>
	/// </summary>
	public class Calendar: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoCalendar reference.
		private GCHandle objHandle; // weak VidyoCalendar reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCalendarConnectNative(IntPtr c, IntPtr connProperties);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarConnectSetconnPropertiesArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarVectorVidyoCalendarConnPropsAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCalendarVectorVidyoCalendarConnPropsDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCalendarCreateMeetingWithIdNative(IntPtr c, IntPtr id, IntPtr feedback, IntPtr createToken);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCalendarDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCalendarDisconnectNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCalendarGetCapabilitiesNative(IntPtr c, IntPtr requestedCapabilities);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarGetCapabilitiesSetrequestedCapabilitiesArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarVectorVidyoCalendarCapabilityKeyAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoCalendarVectorVidyoCalendarCapabilityKeyDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarGetIdNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern CalendarState VidyoCalendarGetServiceStateNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoCalendarGetServiceTypeNative(IntPtr c);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern MeetingSearchResult VidyoCalendarSearchMeetingsNative(IntPtr c, IntPtr searchText, IntPtr beginDateTime, IntPtr endDateTime, uint index, uint pageSize);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCalendarSearchMeetingsByDayNative(IntPtr c, uint year, uint month, uint day, IntPtr createToken);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoCalendarSetSingleSignOnNative(IntPtr c, Boolean setSingleSignOn);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoCalendarGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoCalendarSetUserDataNative(IntPtr obj, IntPtr userData);

		public Calendar(IntPtr other){
			objPtr = VidyoCalendarConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoCalendarSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~Calendar(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoCalendarSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoCalendarDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// <p>Initiates a connection of the calendar service to its resource for data. This can include both a local resource or a server based one. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackConnectResult </p>
		/// </summary>
		/// <param name="c"></param>
		/// <param name="connProperties">Property values</param>
		public Boolean Connect(List<CalendarConnProps> connProperties) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nListConnProperties = VidyoCalendarVectorVidyoCalendarConnPropsAllocateNative();

			IntPtr nConnProperties = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * connProperties.Count);
			int nConnPropertiesSize = 0;
			foreach (CalendarConnProps iter in connProperties) {
				Marshal.WriteIntPtr(nConnProperties + (nConnPropertiesSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nConnPropertiesSize++;
			}
			VidyoCalendarConnectSetconnPropertiesArrayNative(nListConnProperties, nConnProperties, nConnPropertiesSize);
			Marshal.FreeHGlobal(nConnProperties);
			Boolean ret = VidyoCalendarConnectNative(objPtr, nListConnProperties);
			VidyoCalendarVectorVidyoCalendarConnPropsDeallocateNative(nListConnProperties);

			return ret;
		}
		/// <summary>
		/// Create a meeting using an id value returned in a VidyoMeetingInfo object. VidyoMeeting object is returned in the VidyoCalendarFeedbackMeetingCreated callback
		/// </summary>
		/// <param name="c">Pointer to the VidyoCalendar object.</param>
		/// <param name="id">The id value given in the VidyoMeetingInfo structure that uniquely identifies the meeting</param>
		/// <param name="feedback"></param>
		/// <param name="createToken"></param>
		public Boolean CreateMeetingWithId(String id, MeetingFeedback feedback, String createToken) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoCalendarCreateMeetingWithIdNative(objPtr, nId, (feedback != null) ? feedback.GetObjectPtr():IntPtr.Zero, nCreateToken);
			Marshal.FreeHGlobal(nCreateToken);
			Marshal.FreeHGlobal(nId);

			return ret;
		}
		/// <summary>
		/// <p>Initiates a connection of the calendar service to its resource for data. This can include both a local resource or a server based one. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackDisconnected </p>
		/// </summary>
		/// <param name="c"></param>
		public Boolean Disconnect() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoCalendarDisconnectNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets capabilities from the CalendarPlugin. If requestedCapabilities is empty, this causes the feedback to just return a list of the plugin's capabilities with no values list. If requestedCapabilities is a list of capabilities, the plugin will respond with values it has for those capabilities.
		/// </summary>
		/// <param name="c">The CalendarPlugin's calendar.</param>
		/// <param name="requestedCapabilities">Empty to get just the capability keys. Set with capability keys to get associated values.</param>
		public Boolean GetCapabilities(List<CalendarCapabilityKey> requestedCapabilities) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nListRequestedCapabilities = VidyoCalendarVectorVidyoCalendarCapabilityKeyAllocateNative();

			IntPtr nRequestedCapabilities = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * requestedCapabilities.Count);
			int nRequestedCapabilitiesSize = 0;
			foreach (CalendarCapabilityKey iter in requestedCapabilities) {
				Marshal.WriteInt32(nRequestedCapabilities + (nRequestedCapabilitiesSize * Marshal.SizeOf<Int32>()), (int)iter);
				nRequestedCapabilitiesSize++;
			}
			VidyoCalendarGetCapabilitiesSetrequestedCapabilitiesArrayNative(nListRequestedCapabilities, nRequestedCapabilities, nRequestedCapabilitiesSize);
			Marshal.FreeHGlobal(nRequestedCapabilities);
			Boolean ret = VidyoCalendarGetCapabilitiesNative(objPtr, nListRequestedCapabilities);
			VidyoCalendarVectorVidyoCalendarCapabilityKeyDeallocateNative(nListRequestedCapabilities);

			return ret;
		}
		/// <summary>
		/// Retrieve unique calendar id value
		/// </summary>
		/// <param name="c">VidyoCalendar object</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoCalendarGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Retreives the service state for the calendar.
		/// </summary>
		/// <param name="c">Pointer to the VidyoCalendar object.</param>
		public CalendarState GetServiceState() {
			if (objPtr == IntPtr.Zero) { return default; }

			CalendarState ret = VidyoCalendarGetServiceStateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Retreives the service type for the calendar.
		/// </summary>
		/// <param name="c">Pointer to the VidyoCalendar object.</param>
		public String GetServiceType() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoCalendarGetServiceTypeNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// <p>Search a calendar for meetings based on a search string and a begin - end date.</p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackGetMeetingsResult </p>
		/// </summary>
		/// <param name="c"></param>
		/// <param name="searchText">If a string is supplied here, the resulting records will be filtered by this string if it is contained within any of the following meeting fields: - Subject - Location - Body - Meeting Owner email and name - Required attendees name and email - Optional attendees name and email</param>
		/// <param name="beginDateTime">Date and time to start search from</param>
		/// <param name="endDateTime">End date and time for search</param>
		/// <param name="index">Zero based index of the starting record in the search results, to use when returning the callback results.</param>
		/// <param name="pageSize">Number of records to return in the callback results, based off of the starting record index argument. NOTE... A value of zero will return all records starting from the index</param>
		public MeetingSearchResult SearchMeetings(String searchText, String beginDateTime, String endDateTime, uint index, uint pageSize) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			IntPtr nBeginDateTime = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(beginDateTime ?? string.Empty);
			IntPtr nEndDateTime = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(endDateTime ?? string.Empty);
			MeetingSearchResult ret = VidyoCalendarSearchMeetingsNative(objPtr, nSearchText, nBeginDateTime, nEndDateTime, index, pageSize);
			Marshal.FreeHGlobal(nEndDateTime);
			Marshal.FreeHGlobal(nBeginDateTime);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// <p>Get a list of meetings by day. </p> <p/> <p>Triggers callback(s): VidyoCalendarFeedbackGetMeetingsResult </p>
		/// </summary>
		/// <param name="c">Vidyo calendar service object.</param>
		/// <param name="year">4 digit year to search for the meetings within - (yyyy).</param>
		/// <param name="month">1-2 digit month to search for the meetings within - ((mm) - no zero padding required).</param>
		/// <param name="day">1-2 digit day to search for meetings within - ((dd) - no zero padding required).</param>
		/// <param name="createToken">A unique string token to match this method call with the resulting asynchronous callback</param>
		public Boolean SearchMeetingsByDay(uint year, uint month, uint day, String createToken) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoCalendarSearchMeetingsByDayNative(objPtr, year, month, day, nCreateToken);
			Marshal.FreeHGlobal(nCreateToken);

			return ret;
		}
		/// <summary>
		/// Enables SSO in the CalendarPlugin.
		/// </summary>
		/// <param name="c">VidyoCalendar to enbale SSO on.</param>
		/// <param name="setSingleSignOn">Whether or not to sign on using SSO.</param>
		public Boolean SetSingleSignOn(Boolean setSingleSignOn) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoCalendarSetSingleSignOnNative(objPtr, setSingleSignOn);

			return ret;
		}
	};
}
