// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// An optional module that handles all request related to REST and SOAP protocol.
	/// </summary>
	public class NetworkService: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoNetworkService reference.
		private GCHandle objHandle; // weak VidyoNetworkService reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkServiceConstructNative(IntPtr caInfo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkServiceConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoNetworkServiceDestructNative(IntPtr networkService);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern NetworkServiceErrorCode VidyoNetworkServiceHttpRequestASyncNative(IntPtr networkService, IntPtr requestHeader, ResponseCB responseCB, ulong userData);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoNetworkServiceGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoNetworkServiceSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void ResponseCB(IntPtr networkService, IntPtr httpResponseHeader, ulong userData);
		private ResponseCB _mResponseCB = ResponseCBDelegate;
		/// <summary>
		/// NetworkService error codes.
		/// </summary>
		public enum NetworkServiceErrorCode {
			/// <summary>Successful request.</summary>
			NetworkserviceERRORCODE_Ok,
			/// <summary>Unsuccessful request.</summary>
			NetworkserviceERRORCODE_Error,
			/// <summary>Mandatory parameters are missing from request.</summary>
			NetworkserviceERRORCODE_MandatoryParamsMissing,
			/// <summary>Invalid parameters.</summary>
			NetworkserviceERRORCODE_BadRequest,
			/// <summary>Maximum number of simultaneous requests reached. By default 10 simultaneous requests.</summary>
			NetworkserviceERRORCODE_MaxSimultaneousRequestsReached,
			/// <summary>Http request time out received.</summary>
			NetworkserviceERRORCODE_HttpRequestTimeOut
		}
		public interface IHttpRequestASync{

			void ResponseCB(NetworkServiceResponseHeader httpResponseHeader, ulong userData);
		}
		public class NetworkServiceRequestHeaderFactory
		{
			public static NetworkServiceRequestHeader Create()
			{
				return new NetworkServiceRequestHeader(IntPtr.Zero);
			}
			public static void Destroy(NetworkServiceRequestHeader obj)
			{
			}
		}
		/// <summary>
		/// Represents the header structure of the http request.
		/// </summary>
		public class NetworkServiceRequestHeader {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoNetworkServiceRequestHeader reference.
			public IntPtr GetObjectPtr() {
				IntPtr nRequestContentType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestContentType ?? string.Empty);
				IntPtr nRequestMethod = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestMethod ?? string.Empty);
				IntPtr nRequestNumber = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestNumber ?? string.Empty);
				IntPtr nRequestPayload = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestPayload ?? string.Empty);
				IntPtr nRequestUrl = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestUrl ?? string.Empty);
				IntPtr nUserAuthToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userAuthToken ?? string.Empty);
				IntPtr nUserAuthUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userAuthUserName ?? string.Empty);
				IntPtr nUserAuthUserPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userAuthUserPassword ?? string.Empty);
				IntPtr nWebProxyUserName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(webProxyUserName ?? string.Empty);
				IntPtr nWebProxyUserPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(webProxyUserPassword ?? string.Empty);

				VidyoNetworkServiceRequestHeaderSetrequestContentTypeNative(objPtr, nRequestContentType);
				VidyoNetworkServiceRequestHeaderSetrequestMethodNative(objPtr, nRequestMethod);
				VidyoNetworkServiceRequestHeaderSetrequestNumberNative(objPtr, nRequestNumber);
				VidyoNetworkServiceRequestHeaderSetrequestPayloadNative(objPtr, nRequestPayload);
				VidyoNetworkServiceRequestHeaderSetrequestUrlNative(objPtr, nRequestUrl);
				VidyoNetworkServiceRequestHeaderSetuserAuthTokenNative(objPtr, nUserAuthToken);
				VidyoNetworkServiceRequestHeaderSetuserAuthUserNameNative(objPtr, nUserAuthUserName);
				VidyoNetworkServiceRequestHeaderSetuserAuthUserPasswordNative(objPtr, nUserAuthUserPassword);
				VidyoNetworkServiceRequestHeaderSetwebProxyUserNameNative(objPtr, nWebProxyUserName);
				VidyoNetworkServiceRequestHeaderSetwebProxyUserPasswordNative(objPtr, nWebProxyUserPassword);

				Marshal.FreeHGlobal(nWebProxyUserPassword);
				Marshal.FreeHGlobal(nWebProxyUserName);
				Marshal.FreeHGlobal(nUserAuthUserPassword);
				Marshal.FreeHGlobal(nUserAuthUserName);
				Marshal.FreeHGlobal(nUserAuthToken);
				Marshal.FreeHGlobal(nRequestUrl);
				Marshal.FreeHGlobal(nRequestPayload);
				Marshal.FreeHGlobal(nRequestNumber);
				Marshal.FreeHGlobal(nRequestMethod);
				Marshal.FreeHGlobal(nRequestContentType);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetrequestContentTypeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetrequestContentTypeNative(IntPtr obj, IntPtr requestContentType);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetrequestMethodNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetrequestMethodNative(IntPtr obj, IntPtr requestMethod);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetrequestNumberNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetrequestNumberNative(IntPtr obj, IntPtr requestNumber);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetrequestPayloadNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetrequestPayloadNative(IntPtr obj, IntPtr requestPayload);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetrequestUrlNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetrequestUrlNative(IntPtr obj, IntPtr requestUrl);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetuserAuthTokenNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetuserAuthTokenNative(IntPtr obj, IntPtr userAuthToken);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetuserAuthUserNameNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetuserAuthUserNameNative(IntPtr obj, IntPtr userAuthUserName);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetuserAuthUserPasswordNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetuserAuthUserPasswordNative(IntPtr obj, IntPtr userAuthUserPassword);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetwebProxyUserNameNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetwebProxyUserNameNative(IntPtr obj, IntPtr webProxyUserName);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceRequestHeaderGetwebProxyUserPasswordNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceRequestHeaderSetwebProxyUserPasswordNative(IntPtr obj, IntPtr webProxyUserPassword);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoNetworkServiceRequestHeaderConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoNetworkServiceRequestHeaderConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoNetworkServiceRequestHeaderDestructNative(IntPtr obj);

			/// <summary>
			/// Represents the content/encoding type of the request. Default value: empty. Requirement: Optional.
			/// </summary>
			public String requestContentType;
			/// <summary>
			/// Represents the type of the request. Default value: post. Requirement: Optional.
			/// </summary>
			public String requestMethod;
			/// <summary>
			/// Represents the request number of the request. Default value: empty. Requirement: Optional.
			/// </summary>
			public String requestNumber;
			/// <summary>
			/// Represents the payload of the request. Default value: empty. Requirement: Optional.
			/// </summary>
			public String requestPayload;
			/// <summary>
			/// Represents the url of the request. Requirement: Mandatory.
			/// </summary>
			public String requestUrl;
			/// <summary>
			/// Represents the authorization token of the request. Default value: empty. Requirement: Optional.
			/// </summary>
			public String userAuthToken;
			/// <summary>
			/// Represents the authorization user name of the request. Default value: empty. Requirement: Optional.
			/// </summary>
			public String userAuthUserName;
			/// <summary>
			/// Represents the authorization user password of the request. Default value: empty. Requirement: Optional.
			/// </summary>
			public String userAuthUserPassword;
			/// <summary>
			/// Represents the user name of the webproxy. Default value: empty. Requirement: Optional.
			/// </summary>
			public String webProxyUserName;
			/// <summary>
			/// Represents the user password of the webproxy. Default value: empty. Requirement: Optional.
			/// </summary>
			public String webProxyUserPassword;
			public NetworkServiceRequestHeader(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoNetworkServiceRequestHeaderConstructDefaultNative();
				}
				else {
					objPtr = VidyoNetworkServiceRequestHeaderConstructCopyNative(obj);
				}

				requestContentType = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetrequestContentTypeNative(objPtr));
				requestMethod = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetrequestMethodNative(objPtr));
				requestNumber = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetrequestNumberNative(objPtr));
				requestPayload = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetrequestPayloadNative(objPtr));
				requestUrl = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetrequestUrlNative(objPtr));
				userAuthToken = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetuserAuthTokenNative(objPtr));
				userAuthUserName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetuserAuthUserNameNative(objPtr));
				userAuthUserPassword = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetuserAuthUserPasswordNative(objPtr));
				webProxyUserName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetwebProxyUserNameNative(objPtr));
				webProxyUserPassword = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceRequestHeaderGetwebProxyUserPasswordNative(objPtr));
			}
			~NetworkServiceRequestHeader() {
				VidyoNetworkServiceRequestHeaderDestructNative(objPtr);
			 }
		};
		public class NetworkServiceResponseHeaderFactory
		{
			public static NetworkServiceResponseHeader Create()
			{
				return new NetworkServiceResponseHeader(IntPtr.Zero);
			}
			public static void Destroy(NetworkServiceResponseHeader obj)
			{
			}
		}
		/// <summary>
		/// Represents a http response header structure.
		/// </summary>
		public class NetworkServiceResponseHeader {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoNetworkServiceResponseHeader reference.
			public IntPtr GetObjectPtr() {
				IntPtr nHttpResponseContent = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(httpResponseContent ?? string.Empty);
				IntPtr nHttpResponseContentType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(httpResponseContentType ?? string.Empty);
				IntPtr nRequestNumber = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestNumber ?? string.Empty);
				IntPtr nWebProxyIPAddress = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(webProxyIPAddress ?? string.Empty);

				VidyoNetworkServiceResponseHeaderSeterrorCodeNative(objPtr, errorCode);
				VidyoNetworkServiceResponseHeaderSethttpResponseContentNative(objPtr, nHttpResponseContent);
				VidyoNetworkServiceResponseHeaderSethttpResponseContentSizeNative(objPtr, httpResponseContentSize);
				VidyoNetworkServiceResponseHeaderSethttpResponseContentTypeNative(objPtr, nHttpResponseContentType);
				VidyoNetworkServiceResponseHeaderSethttpStatusCodeNative(objPtr, httpStatusCode);
				VidyoNetworkServiceResponseHeaderSetrequestNumberNative(objPtr, nRequestNumber);
				VidyoNetworkServiceResponseHeaderSetwebProxyIPAddressNative(objPtr, nWebProxyIPAddress);
				VidyoNetworkServiceResponseHeaderSetwebProxyIPPortNative(objPtr, webProxyIPPort);

				Marshal.FreeHGlobal(nWebProxyIPAddress);
				Marshal.FreeHGlobal(nRequestNumber);
				Marshal.FreeHGlobal(nHttpResponseContentType);
				Marshal.FreeHGlobal(nHttpResponseContent);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern NetworkService.NetworkServiceErrorCode VidyoNetworkServiceResponseHeaderGeterrorCodeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSeterrorCodeNative(IntPtr obj, NetworkService.NetworkServiceErrorCode errorCode);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceResponseHeaderGethttpResponseContentNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSethttpResponseContentNative(IntPtr obj, IntPtr httpResponseContent);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoNetworkServiceResponseHeaderGethttpResponseContentSizeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSethttpResponseContentSizeNative(IntPtr obj, uint httpResponseContentSize);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceResponseHeaderGethttpResponseContentTypeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSethttpResponseContentTypeNative(IntPtr obj, IntPtr httpResponseContentType);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoNetworkServiceResponseHeaderGethttpStatusCodeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSethttpStatusCodeNative(IntPtr obj, uint httpStatusCode);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceResponseHeaderGetrequestNumberNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSetrequestNumberNative(IntPtr obj, IntPtr requestNumber);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoNetworkServiceResponseHeaderGetwebProxyIPAddressNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSetwebProxyIPAddressNative(IntPtr obj, IntPtr webProxyIPAddress);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoNetworkServiceResponseHeaderGetwebProxyIPPortNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoNetworkServiceResponseHeaderSetwebProxyIPPortNative(IntPtr obj, uint webProxyIPPort);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoNetworkServiceResponseHeaderConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoNetworkServiceResponseHeaderConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoNetworkServiceResponseHeaderDestructNative(IntPtr obj);

			/// <summary>
			/// Represents the error code, see VidyoNetworkServiceErrorCode.
			/// </summary>
			public NetworkService.NetworkServiceErrorCode errorCode;
			/// <summary>
			/// Represents the content of the response.
			/// </summary>
			public String httpResponseContent;
			/// <summary>
			/// Represents the content size of the respons.
			/// </summary>
			public uint httpResponseContentSize;
			/// <summary>
			/// Represents the content type of response.
			/// </summary>
			public String httpResponseContentType;
			/// <summary>
			/// Represents the http status code of the response.
			/// </summary>
			public uint httpStatusCode;
			/// <summary>
			/// Represents the unique request number for each Http request, provided/used in VidyoNetworkServiceHttpRequestASync.
			/// </summary>
			public String requestNumber;
			/// <summary>
			/// Represents the discovered webproxy IP address.
			/// </summary>
			public String webProxyIPAddress;
			/// <summary>
			/// Represents the discovered webproxy IP address port.
			/// </summary>
			public uint webProxyIPPort;
			public NetworkServiceResponseHeader(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoNetworkServiceResponseHeaderConstructDefaultNative();
				}
				else {
					objPtr = VidyoNetworkServiceResponseHeaderConstructCopyNative(obj);
				}

				errorCode = VidyoNetworkServiceResponseHeaderGeterrorCodeNative(objPtr);
				httpResponseContent = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceResponseHeaderGethttpResponseContentNative(objPtr));
				httpResponseContentSize = VidyoNetworkServiceResponseHeaderGethttpResponseContentSizeNative(objPtr);
				httpResponseContentType = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceResponseHeaderGethttpResponseContentTypeNative(objPtr));
				httpStatusCode = VidyoNetworkServiceResponseHeaderGethttpStatusCodeNative(objPtr);
				requestNumber = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceResponseHeaderGetrequestNumberNative(objPtr));
				webProxyIPAddress = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceResponseHeaderGetwebProxyIPAddressNative(objPtr));
				webProxyIPPort = VidyoNetworkServiceResponseHeaderGetwebProxyIPPortNative(objPtr);
			}
			~NetworkServiceResponseHeader() {
				VidyoNetworkServiceResponseHeaderDestructNative(objPtr);
			 }
		};
		private IHttpRequestASync _mIHttpRequestASync;
		/// <summary>
		/// Constructs an NetworkService object.
		/// </summary>
		/// <param name="networkService">The VidyoNetworkService Object to construct.</param>
		/// <param name="caInfo">The VidyoNetworkServiceCAInfo object.</param>
		public NetworkService(NetworkServiceCAInfo caInfo) {

			objPtr = VidyoNetworkServiceConstructNative((caInfo != null) ? caInfo.GetObjectPtr():IntPtr.Zero);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoNetworkServiceSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		public NetworkService(IntPtr other){
			objPtr = VidyoNetworkServiceConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoNetworkServiceSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~NetworkService(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoNetworkServiceSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoNetworkServiceDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// Http request function, this will be call by the application in order to placed any http request. This will be asynchronous call, Application call will not be blocked.
		/// </summary>
		/// <param name="networkService">The VidyoNetworkService object.</param>
		/// <param name="requestHeader">Http request data, user has to provide data for http request.</param>
		/// <param name="responseCB">Callback function through which application will get http response.</param>
		/// <param name="userData">Application specific data, same thing will be provided back to application through http response CallBack.</param>
		public NetworkServiceErrorCode HttpRequestASync(NetworkServiceRequestHeader requestHeader, IHttpRequestASync _iIHttpRequestASync, ulong userData) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIHttpRequestASync = _iIHttpRequestASync;

			NetworkServiceErrorCode ret = VidyoNetworkServiceHttpRequestASyncNative(objPtr, (requestHeader != null) ? requestHeader.GetObjectPtr():IntPtr.Zero, _mResponseCB, userData);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(ResponseCB))]
#endif
		private static void ResponseCBDelegate(IntPtr networkService, IntPtr httpResponseHeader, ulong userData){
			var csNetworkServicePtr = networkService != IntPtr.Zero ? VidyoNetworkServiceGetUserDataNative(networkService) : IntPtr.Zero;
			if(csNetworkServicePtr == IntPtr.Zero) return;
			var csNetworkService = (NetworkService)GCHandle.FromIntPtr(csNetworkServicePtr).Target;

			NetworkServiceResponseHeader csHttpResponseHeader = new NetworkServiceResponseHeader(httpResponseHeader);
			csNetworkService?._mIHttpRequestASync?.ResponseCB(csHttpResponseHeader, userData);
		}
	};
}
