// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class NetworkServiceCAInfoFactory
	{
		public static NetworkServiceCAInfo Create()
		{
			return new NetworkServiceCAInfo(IntPtr.Zero);
		}
		public static void Destroy(NetworkServiceCAInfo obj)
		{
		}
	}
	/// <summary>
	/// Represents a certificate authority structure. if not specify, by default OS certificates will be used.
	/// </summary>
	public class NetworkServiceCAInfo {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoNetworkServiceCAInfo reference.
		public IntPtr GetObjectPtr() {
			IntPtr nCaFileContent = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(caFileContent ?? string.Empty);
			IntPtr nCaFilePath = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(caFilePath ?? string.Empty);

			VidyoNetworkServiceCAInfoSetcaFileContentNative(objPtr, nCaFileContent);
			VidyoNetworkServiceCAInfoSetcaFilePathNative(objPtr, nCaFilePath);

			Marshal.FreeHGlobal(nCaFilePath);
			Marshal.FreeHGlobal(nCaFileContent);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkServiceCAInfoGetcaFileContentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoNetworkServiceCAInfoSetcaFileContentNative(IntPtr obj, IntPtr caFileContent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoNetworkServiceCAInfoGetcaFilePathNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoNetworkServiceCAInfoSetcaFilePathNative(IntPtr obj, IntPtr caFilePath);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoNetworkServiceCAInfoConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoNetworkServiceCAInfoConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoNetworkServiceCAInfoDestructNative(IntPtr obj);

		/// <summary>
		/// The content of the CA file that will be use by the library when connecting to the specified server. Default value: empty. Requirement: Optional. Each certificate authority content should be ended with 'n' or 'rn'. Note: If the string 'default' is passed here, VidyoNetworkService will use a built-in Certificate Authority bundle.
		/// </summary>
		public String caFileContent;
		/// <summary>
		/// The path to the CA certificate file that the library will use when connecting to the specified server. Default value: empty. Requirement: Optional.
		/// </summary>
		public String caFilePath;
		public NetworkServiceCAInfo(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoNetworkServiceCAInfoConstructDefaultNative();
			}
			else {
				objPtr = VidyoNetworkServiceCAInfoConstructCopyNative(obj);
			}

			caFileContent = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceCAInfoGetcaFileContentNative(objPtr));
			caFilePath = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoNetworkServiceCAInfoGetcaFilePathNative(objPtr));
		}
		~NetworkServiceCAInfo() {
			VidyoNetworkServiceCAInfoDestructNative(objPtr);
		 }
	};
}
