// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// 
	/// </summary>
	public class User: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoUser reference.
		private GCHandle objHandle; // weak VidyoUser reference.
		private List<WeakReference> objects = new List<WeakReference>();

		private void DisposeWeakReferenceObjects() {
			foreach(var item in objects) {
				if (item == null || !item.IsAlive || item.Target == null) { continue; }
				switch (item.Target.GetType().Name) {
					case "Call": ((Call)item.Target).Dispose(false); break;
					case "Endpoint": ((Endpoint)item.Target).Dispose(false); break;
					case "Room": ((Room)item.Target).Dispose(false); break;
				}
			}
			objects.Clear();
		}
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserAddRosterContactNative(IntPtr u, IntPtr userId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserAdvancedSearchRoomsNative(IntPtr u, IntPtr fieldSet, IntPtr fieldRelations, IntPtr fieldValues, IntPtr searchToken, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserAdvancedSearchRoomsSetfieldSetArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserVectorVidyoRoomSearchFieldAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserVectorVidyoRoomSearchFieldDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserAdvancedSearchRoomsSetfieldRelationsArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserVectorVidyoRoomSearchFieldRelationAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserVectorVidyoRoomSearchFieldRelationDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserAdvancedSearchRoomsSetfieldValuesArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserVectorLmiStringAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserVectorLmiStringDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserAdvancedSearchUsersNative(IntPtr u, IntPtr fieldSet, IntPtr fieldValues, IntPtr searchToken, uint index, uint pageSize, OnUserSearchResults onUserSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserAdvancedSearchUsersSetfieldSetArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserVectorVidyoUserSearchFieldAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserVectorVidyoUserSearchFieldDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserAdvancedSearchUsersSetfieldValuesArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserAllowSubscriberNative(IntPtr u, IntPtr userId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserBlockSubscriberNative(IntPtr u, IntPtr userId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserConstructNative(IntPtr endpoint);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateCallNative(IntPtr u, IntPtr userId, IntPtr createToken, OnCallCreated onCallCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateRoomFromIdNative(IntPtr u, IntPtr id, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateRoomFromKeyNative(IntPtr u, IntPtr roomKey, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateRoomWithIdNative(IntPtr u, IntPtr id, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateScheduledRoomNative(IntPtr u, IntPtr schedule, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateTestCallRoomNative(IntPtr u, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserCreateTopicRoomNative(IntPtr u, IntPtr name, IntPtr description, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetAuthTypesNative(IntPtr u, IntPtr host, uint port, IntPtr serviceType, OnAuthTypes onAuthTypes, OnAuthTypesWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetContactNative(IntPtr u, IntPtr userId, OnGetContactResult onGetContactResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetConversationRoomNative(IntPtr u, IntPtr userIds, IntPtr createToken, OnRoomCreated onRoomCreated);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserGetConversationRoomSetuserIdsArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetCurrentRosterNative(IntPtr u, OnGetCurrentRosterComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserGetEndpointNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetFavoriteRoomsNative(IntPtr u, uint index, uint pageSize, OnFavoriteRoomResults onFavoriteRoomResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserGetIdNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetPasswordResetUrlNative(IntPtr u, OnPasswordResetUrl onPasswordResetUrl);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetRecentRoomsNative(IntPtr u, uint index, uint pageSize, OnRecentRoomResults onRecentRoomResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserGetRecordingServiceProfilesNative(IntPtr u, OnGetRecordingServiceProfiles onGetRecordingServiceProfiles);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserGetWebProxyAddressNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserInvalidateTokenOnLogoutNative(IntPtr user, Boolean invalidate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginNative(IntPtr u, IntPtr username, IntPtr password, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginAsGuestNative(IntPtr u, IntPtr displayName, IntPtr roomKey, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginWithAccessTokenNative(IntPtr u, IntPtr accessToken, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginWithCACNative(IntPtr u, IntPtr certificate, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginWithExtDataNative(IntPtr u, IntPtr extData, IntPtr ebMode, IntPtr host, uint port, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginWithRefreshTokenNative(IntPtr u, IntPtr refreshToken, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginWithSAMLNative(IntPtr u, IntPtr key, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLoginWithTenantTokenNative(IntPtr u, IntPtr provisionToken, IntPtr host, uint port, IntPtr serviceType, OnLoginComplete onLoginComplete, OnLoggedOut onLoggedOut, OnConnectionStatusChanged onConnectionStatusChanged, OnTokenReceived onTokenReceived, OnWebProxyCredentialsRequest onWebProxyCredentialsRequest);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserLogoutNative(IntPtr user);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserPauseUpdateNotificationNative(IntPtr u, Boolean pauseUpdateNotification);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserRefreshAccessTokenNative(IntPtr u, OnRefreshAccessToken onRefreshAccessToken);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserRegisterCallEventListenerNative(IntPtr u, OnCallCreatedByInvite onCallCreatedByInvite);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserRegisterContactEventListenerNative(IntPtr u, OnUpdateSelf onUpdateSelf, OnUpdateRosterContact onUpdateRosterContact, OnRemoveRosterContact onRemoveRosterContact);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserRegisterLicenseEventListenerNative(IntPtr u, OnLicenseReceived onLicenseReceived, OnGetLicenseKey onGetLicenseKey);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserRegisterRoomEventListenerNative(IntPtr u, OnRoomCreatedByInvite onRoomCreatedByInvite, OnRoomInviteCancelled onRoomInviteCancelled);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserRemoveRosterContactNative(IntPtr u, IntPtr userId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchConversationRoomsNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchRoomsNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchRoomsWithNameNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchRoomsWithOwnerNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchRoomsWithSubjectNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchTopicRoomsNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnRoomSearchResults onRoomSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSearchUsersNative(IntPtr u, IntPtr searchText, uint index, uint pageSize, OnUserSearchResults onUserSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserSetCANative(IntPtr u, IntPtr ca, IntPtr caFilePath, IntPtr caDir);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserSetDisplayNameNative(IntPtr u, IntPtr displayName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserSetTCPTransportNative(IntPtr u, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserSetUDPTransportNative(IntPtr u, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserSetWebProxyAddressCredentialsNative(IntPtr u, IntPtr proxyAddress, IntPtr username, IntPtr password);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserSetWebProxyTransportNative(IntPtr u, Boolean enable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoUserSetWebProxyTransportAddressNative(IntPtr u, IntPtr name, uint port);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserUnregisterCallEventListenerNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserUnregisterContactEventListenerNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserUnregisterLicenseEventListenerNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserUnregisterRoomEventListenerNative(IntPtr u);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoUserUpdatePresenceNative(IntPtr u, [MarshalAs(UnmanagedType.I4)]Contact.ContactPresenceState state, IntPtr status);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoUserGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoUserSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnAuthTypes(IntPtr u, UserGetAuthTypesResult result, IntPtr authTypes);
		private OnAuthTypes _mOnAuthTypes = OnAuthTypesDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnAuthTypesGetauthTypesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnAuthTypesFreeauthTypesArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnAuthTypesWebProxyCredentialsRequest(IntPtr u, IntPtr webProxyAddress);
		private OnAuthTypesWebProxyCredentialsRequest _mOnAuthTypesWebProxyCredentialsRequest = OnAuthTypesWebProxyCredentialsRequestDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnAuthTypesWebProxyCredentialsRequestGetwebProxyAddressCStr(IntPtr webProxyAddress);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnCallCreated(IntPtr u, IntPtr call, UserCallCreateResult result, IntPtr createToken);
		private OnCallCreated _mOnCallCreated = OnCallCreatedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnCallCreatedGetcreateTokenCStr(IntPtr createToken);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnCallCreatedByInvite(IntPtr u, IntPtr call, IntPtr inviter);
		private OnCallCreatedByInvite _mOnCallCreatedByInvite = OnCallCreatedByInviteDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConnectionStatusChanged(IntPtr u, UserConnectionStatusChangedReason reason);
		private OnConnectionStatusChanged _mOnConnectionStatusChanged = OnConnectionStatusChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnFavoriteRoomResults(IntPtr u, UserSearchResult searchResult, IntPtr roomInfo);
		private OnFavoriteRoomResults _mOnFavoriteRoomResults = OnFavoriteRoomResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnFavoriteRoomResultsGetroomInfoArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnFavoriteRoomResultsFreeroomInfoArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetContactResult(IntPtr u, IntPtr contact, UserGetContactResult result);
		private OnGetContactResult _mOnGetContactResult = OnGetContactResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetCurrentRosterComplete(IntPtr u, IntPtr roster);
		private OnGetCurrentRosterComplete _mOnGetCurrentRosterComplete = OnGetCurrentRosterCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetCurrentRosterCompleteGetrosterArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetCurrentRosterCompleteFreerosterArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetLicenseKey(IntPtr u, IntPtr licenseKey);
		private OnGetLicenseKey _mOnGetLicenseKey = OnGetLicenseKeyDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetLicenseKeyGetlicenseKeyCStr(IntPtr licenseKey);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetRecordingServiceProfiles(IntPtr u, IntPtr profiles, IntPtr prefixes, UserRecordingServiceResult result);
		private OnGetRecordingServiceProfiles _mOnGetRecordingServiceProfiles = OnGetRecordingServiceProfilesDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetRecordingServiceProfilesGetprofilesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetRecordingServiceProfilesFreeprofilesArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetRecordingServiceProfilesGetprefixesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnGetRecordingServiceProfilesFreeprefixesArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLicenseReceived(IntPtr u, IntPtr licenseKey);
		private OnLicenseReceived _mOnLicenseReceived = OnLicenseReceivedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnLicenseReceivedGetlicenseKeyCStr(IntPtr licenseKey);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLoggedOut(IntPtr u, UserLogoutReason reason);
		private OnLoggedOut _mOnLoggedOut = OnLoggedOutDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLoginComplete(IntPtr u, UserLoginResult result, Boolean secure, IntPtr capabilities);
		private OnLoginComplete _mOnLoginComplete = OnLoginCompleteDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPasswordResetUrl(IntPtr u, IntPtr passwordResetUrl);
		private OnPasswordResetUrl _mOnPasswordResetUrl = OnPasswordResetUrlDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnPasswordResetUrlGetpasswordResetUrlCStr(IntPtr passwordResetUrl);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecentRoomResults(IntPtr u, UserSearchResult searchResult, IntPtr roomInfo);
		private OnRecentRoomResults _mOnRecentRoomResults = OnRecentRoomResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnRecentRoomResultsGetroomInfoArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnRecentRoomResultsFreeroomInfoArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRefreshAccessToken(IntPtr u, UserOperationResult result);
		private OnRefreshAccessToken _mOnRefreshAccessToken = OnRefreshAccessTokenDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoveRosterContact(IntPtr u, IntPtr uri);
		private OnRemoveRosterContact _mOnRemoveRosterContact = OnRemoveRosterContactDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnRemoveRosterContactGeturiCStr(IntPtr uri);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRoomCreated(IntPtr u, IntPtr room, UserRoomCreateResult result, IntPtr createToken);
		private OnRoomCreated _mOnRoomCreated = OnRoomCreatedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnRoomCreatedGetcreateTokenCStr(IntPtr createToken);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRoomCreatedByInvite(IntPtr u, IntPtr room, IntPtr inviter, IntPtr message);
		private OnRoomCreatedByInvite _mOnRoomCreatedByInvite = OnRoomCreatedByInviteDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRoomInviteCancelled(IntPtr u, IntPtr roomInfo, IntPtr message);
		private OnRoomInviteCancelled _mOnRoomInviteCancelled = OnRoomInviteCancelledDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRoomSearchResults(IntPtr u, IntPtr searchText, UserSearchResult searchResult, IntPtr roomInfo, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT numRecords);
		private OnRoomSearchResults _mOnRoomSearchResults = OnRoomSearchResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnRoomSearchResultsGetroomInfoArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnRoomSearchResultsFreeroomInfoArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnTokenReceived(IntPtr u, IntPtr tokens);
		private OnTokenReceived _mOnTokenReceived = OnTokenReceivedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnTokenReceivedGettokensArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnTokenReceivedFreetokensArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUpdateRosterContact(IntPtr u, IntPtr contact);
		private OnUpdateRosterContact _mOnUpdateRosterContact = OnUpdateRosterContactDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUpdateSelf(IntPtr u, IntPtr contact);
		private OnUpdateSelf _mOnUpdateSelf = OnUpdateSelfDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUserSearchResults(IntPtr u, IntPtr searchText, UserSearchResult searchResult, IntPtr contacts, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT numRecords);
		private OnUserSearchResults _mOnUserSearchResults = OnUserSearchResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnUserSearchResultsGetcontactsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnUserSearchResultsFreecontactsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnWebProxyCredentialsRequest(IntPtr u, IntPtr webProxyAddress);
		private OnWebProxyCredentialsRequest _mOnWebProxyCredentialsRequest = OnWebProxyCredentialsRequestDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoUserOnWebProxyCredentialsRequestGetwebProxyAddressCStr(IntPtr webProxyAddress);

		/// <summary>
		/// This type specify the room property to search.
		/// </summary>
		public enum RoomSearchField {
			/// <summary>owner of the rom.</summary>
			RoomsearchfieldOwner,
			/// <summary>administrator of the room.</summary>
			RoomsearchfieldAdmin,
			/// <summary>moderator of the room.</summary>
			RoomsearchfieldModerator,
			/// <summary>member of the room.</summary>
			RoomsearchfieldMember,
			/// <summary>user of the room.</summary>
			RoomsearchfieldUser,
			/// <summary>name of the room.</summary>
			RoomsearchfieldName,
			/// <summary>subject of the room.</summary>
			RoomsearchfieldSubject,
			/// <summary>type of the room.</summary>
			RoomsearchfieldType,
			/// <summary>visibility of the room; value of "true" indicates public room.</summary>
			RoomsearchfieldPublic,
			/// <summary>number of members in the room includes owners, admins, moderators and members.</summary>
			RoomsearchfieldNonMembers
		}
		/// <summary>
		/// This type specify the relation between room property fields that apply in the search, AND operator gets evaluated before OR.
		/// </summary>
		public enum RoomSearchFieldRelation {
			/// <summary>apply logical AND between the fields.</summary>
			RoomsearchfieldrelationAND,
			/// <summary>apply logical OR between the fields.</summary>
			RoomsearchfieldrelationOR
		}
		/// <summary>
		/// This type indicates the authentication type that needs to be used by the user to login.
		/// </summary>
		public enum UserAuthType {
			/// <summary>Guest authnetication can be used to login.</summary>
			UserauthtypeGuest,
			/// <summary>Password can be used to login.</summary>
			UserauthtypePassword,
			/// <summary>AccessToken can be used to login.</summary>
			UserauthtypeAccessToken,
			/// <summary>RefreshToken can be used to login.</summary>
			UserauthtypeRefreshToken,
			/// <summary>ProvisionToken can be used to login.</summary>
			UserauthtypeProvisionToken,
			/// <summary>Facebook authnetication can be used to login.</summary>
			UserauthtypeFacebook,
			/// <summary>The associated key is a room key.</summary>
			UserauthtypeGuestWithRoomKey,
			/// <summary>SAML authnetication can be used to login.</summary>
			UserauthtypeSaml,
			/// <summary>CAC authnetication can be used to login.</summary>
			UserauthtypeCac
		}
		/// <summary>
		/// This type indicates the result of an attempt to create call.
		/// </summary>
		public enum UserCallCreateResult {
			/// <summary>The call created successfully.</summary>
			UsercallcreateresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to create the call.</summary>
			UsercallcreateresultNoResponse,
			/// <summary>The user is not allowed to create call.</summary>
			UsercallcreateresultNotAllowed,
			/// <summary>The server is rejecting the request to create the call due to some miscellaneous problem with the request.</summary>
			UsercallcreateresultMiscLocalError,
			/// <summary>The server is rejecting the request to create the call due to some miscellaneous problem of its own.</summary>
			UsercallcreateresultMiscRemoteError
		}
		/// <summary>
		/// This type indicates the reason for a change in connection status .
		/// </summary>
		public enum UserConnectionStatusChangedReason {
			/// <summary>Connected to the server</summary>
			UserconnectionstatuschangedreasonOK,
			/// <summary>Lost contact with the server</summary>
			UserconnectionstatuschangedreasonLostContactWithServer,
			/// <summary>No communication with the server</summary>
			UserconnectionstatuschangedreasonNoCommunicationWithServer,
			/// <summary>The user has no valid network interfaces available.</summary>
			UserconnectionstatuschangedreasonNoValidNetworkInterfaces,
			/// <summary>The user's network interfaces have changed.</summary>
			UserconnectionstatuschangedreasonNetworkInterfaceChanged,
			/// <summary>Misc network error</summary>
			UserconnectionstatuschangedreasonMiscNetworkError,
			/// <summary>Error on connecting to backend.</summary>
			UserconnectionstatuschangedreasonConnectionError
		}
		/// <summary>
		/// This type indicates the result of a search for user or room.
		/// </summary>
		public enum UserGetAuthTypesResult {
			/// <summary>The search operation was successful.</summary>
			UsergetauthtypesresultOK,
			/// <summary>NThe Get Authentication Types result failed as connection failed.</summary>
			UsergetauthtypesresultConnectionFailed,
			/// <summary>The Get Authentication Types result failed as connection was lost.</summary>
			UsergetauthtypesresultConnectionLost,
			/// <summary>The Get Authentication Types result failed due to request timeout.</summary>
			UsergetauthtypesresultConnectionTimeout,
			/// <summary>The Get Authentication Types result failed as there was no response from the server.</summary>
			UsergetauthtypesresultNoResponse,
			/// <summary>The Get Authentication Types result failed as the web proxy address required authentication.</summary>
			UsergetauthtypesresultWebProxyAuthenticationFailed,
			/// <summary>The Get Authentication Types result failed as the tls handshake failed.</summary>
			UsergetauthtypesresultTlsFailed,
			/// <summary>The Get Authentication Types result failed as the service was unavailable.</summary>
			UsergetauthtypesresultServiceUnavailable,
			/// <summary>The Get Authentication Types result failed due to some miscellaneous local problem.</summary>
			UsergetauthtypesresultMiscLocalError,
			/// <summary>The Get Authentication Types failed due to some miscellaneous remote problem.</summary>
			UsergetauthtypesresultMiscRemoteError,
			/// <summary>The Get Authentication Types failed as the version of tenant/backend not supported.</summary>
			UsergetauthtypesresultUnSupportedTenantVersion,
			/// <summary>The Get Authentication Types failed as there is no valid network interface available.</summary>
			UsergetauthtypesresultNoValidNetworkInterface
		}
		/// <summary>
		/// This type indicates the result of getting a contact vCard.
		/// </summary>
		public enum UserGetContactResult {
			/// <summary>The request was successful.</summary>
			UsergetcontactresultOK,
			/// <summary>The server did not respond in a reasonable amount of time.</summary>
			UsergetcontactresultNoResponse,
			/// <summary>The user is not allowed to get contacts.</summary>
			UsergetcontactresultUnauthorized,
			/// <summary>The server is rejecting the request due to some miscellaneous problem with the request.</summary>
			UsergetcontactresultMiscLocalError,
			/// <summary>The server is rejecting the request due to some miscellaneous problem of its own.</summary>
			UsergetcontactresultMiscRemoteError
		}
		/// <summary>
		/// This type indicates the result of an attempt to log in to some service.
		/// </summary>
		public enum UserLoginResult {
			/// <summary>The user logged in successfully.</summary>
			UserloginresultOK,
			/// <summary>The destination could not be reached.</summary>
			UserloginresultConnectionFailed,
			/// <summary>The transport connection was lost prior to completing the login procedure.</summary>
			UserloginresultConnectionLost,
			/// <summary>The signaling connection timed out prior to completing the login procedure.</summary>
			UserloginresultConnectionTimeout,
			/// <summary>The service was successfully contacted, but the service ignored the user's request to log in, or did not answer in a reasonable amount of time.</summary>
			UserloginresultNoResponse,
			/// <summary>The service was successfully contacted, but the service closed the connection or refused to continue processing the login request.</summary>
			UserloginresultTerminated,
			/// <summary>The user ID that was provided is unknown to the service or unauthorized to log in.</summary>
			UserloginresultInvalidUser,
			/// <summary>The password that was provided is incorrect.</summary>
			UserloginresultInvalidPassword,
			/// <summary>The login failed for some other authentication error.</summary>
			UserloginresultMiscAuthError,
			/// <summary>The user cancelled the login request before it completed.</summary>
			UserloginresultCancelled,
			/// <summary>The login failed for some other miscellaneous error.</summary>
			UserloginresultMiscError,
			/// <summary>The login failed as the web proxy address required authentication.</summary>
			UserloginresultWebProxyAuthenticationRequired,
			/// <summary>The login failed as the service is not available.</summary>
			UserloginresultServiceUnavailable,
			/// <summary>The login with room key failed as the room is full.</summary>
			UserloginresultRoomIsFull,
			/// <summary>The login with room key failed as the room is disabled.</summary>
			UserloginresultRoomIsDisabled,
			/// <summary>The login failed as TLS negotiation failed.</summary>
			UserloginresultTlsFailed,
			/// <summary>The login failed as the client certificate verification has failed.</summary>
			UserloginresultCertificateVerificationFailed,
			/// <summary>The login failed as the tenant/backend is of an unsupported version.</summary>
			UserloginresultUnsupportedTenantVersion,
			/// <summary>The login failed as there is no valid network interface available.</summary>
			UserloginresultNoValidNetworkInterface
		}
		/// <summary>
		/// This type indicates the reason that a user that was once logged in is no longer logged in.
		/// </summary>
		public enum UserLogoutReason {
			/// <summary>The user logged out gracefully.</summary>
			UserlogoutreasonLoggedOut,
			/// <summary>The transport connection was lost.</summary>
			UserlogoutreasonConnectionLost,
			/// <summary>The signaling connection timed out.</summary>
			UserlogoutreasonConnectionTimeout,
			/// <summary>The service did not respond in a reasonable amount of time to a request by the user.</summary>
			UserlogoutreasonNoResponse,
			/// <summary>The service closed the connection or otherwise terminated the login session.</summary>
			UserlogoutreasonTerminated,
			/// <summary>The login session was closed for some other miscellaneous reason.</summary>
			UserlogoutreasonMiscError,
			/// <summary>The same user has logged in from somewhere else.</summary>
			UserlogoutreasonLoggedInElsewhere,
			/// <summary>The network interface changed.</summary>
			UserlogoutreasonNetworkInterfaceChanged,
			/// <summary>The Portal is out of licenses.</summary>
			UserlogoutreasonOutOfLicenses,
			/// <summary>Logged out due to bad connection with VidyoManager.</summary>
			UserlogoutreasonEpClientBadConnection,
			/// <summary>Logged out as VidyoManager rejected the connection as EMCP version is bad.</summary>
			UserlogoutreasonEpClientBadVersion,
			/// <summary>Logged out as the Endpoint's session ID did not match that of the VidyoManager.</summary>
			UserlogoutreasonEpClientBadSessionId,
			/// <summary>Logged out due to Bad communication with VidyoManager.EpClient can no longer insure proper operation.</summary>
			UserlogoutreasonEpClientBadComms,
			/// <summary>Logged out as the VidyoManager has requested that the Endpoint reset.</summary>
			UserlogoutreasonEpClientRebootRequested,
			/// <summary>Logged out as the VidyoManager has requested that the Endpoint reset.</summary>
			UserlogoutreasonEpClientShutdownRequested,
			/// <summary>Logged out as the VidyoManager has requested that the Endpoint reset.</summary>
			UserlogoutreasonEpClientRestartRequested,
			/// <summary>Logged out because an internal error occurred at the epclient.</summary>
			UserlogoutreasonEpClientInternalError,
			/// <summary>Logged out as the endpoint is not bound to the backend and will not be able join calls.</summary>
			UserlogoutreasonEndpointNotBound,
			/// <summary>Logged out as the authentication is no longer valid.</summary>
			UserlogoutreasonInvalidAuth,
			/// <summary>Logged out as we failed to start EpClient</summary>
			UserlogoutreasonEpClientStartFailure
		}
		/// <summary>
		/// This category signifies the outcome of the user's action.
		/// </summary>
		public enum UserOperationResult {
			/// <summary>The operation was carried out successfully.</summary>
			UseroperationresultOK,
			/// <summary>The operation was unsuccessful because of a connection failure.</summary>
			UseroperationresultCONNECTIONFAILED,
			/// <summary>The operation was unsuccessful because of a connection lost.</summary>
			UseroperationresultCONNECTIONLOST,
			/// <summary>The operation was unsuccessful because of a connection timeout.</summary>
			UseroperationresultCONNECTIONTIMEDOUT,
			/// <summary>The operation was unsuccessful because of a miscellaneous error occured inside the client library.</summary>
			UseroperationresultMISCLOCALERROR,
			/// <summary>The operation was unsuccessful because of a miscellaneous error occured with the conferencing service.</summary>
			UseroperationresultMISCREMOTEERROR,
			/// <summary>The operation was unsuccessful because of a miscellaneous error from server side.</summary>
			UseroperationresultMISCRROR
		}
		/// <summary>
		/// Results of Recording service requests.
		/// </summary>
		public enum UserRecordingServiceResult {
			/// <summary>The request has succeeded.</summary>
			UserrecordingserviceresultSuccess,
			/// <summary>One or more input arguments are invalid.</summary>
			UserrecordingserviceresultInvalidArgument,
			/// <summary>Media support was disabled or there is an unknown fault on the portal.</summary>
			UserrecordingserviceresultGeneralFailure,
			/// <summary>The seat license has expired.</summary>
			UserrecordingserviceresultSeatLicenseExpired,
			/// <summary>The endpoint is not licensed.</summary>
			UserrecordingserviceresultNotLicensed,
			/// <summary>There are no available resources of the portal or recording servers.</summary>
			UserrecordingserviceresultResourceNotAvailable,
			/// <summary>Miscellaneous portal error occurred.</summary>
			UserrecordingserviceresultControlMeetingFailure
		}
		/// <summary>
		/// This type indicates the result of an attempt to create room.
		/// </summary>
		public enum UserRoomCreateResult {
			/// <summary>The room entered successfully.</summary>
			UserroomcreateresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to enter the room.</summary>
			UserroomcreateresultNoResponse,
			/// <summary>The server did not find the room.</summary>
			UserroomcreateresultNotFound,
			/// <summary>The user is not allowed to create rooms.</summary>
			UserroomcreateresultUnauthorized,
			/// <summary>The server is rejecting the request to enter due to some miscellaneous problem with the request.</summary>
			UserroomcreateresultMiscLocalError,
			/// <summary>The server is rejecting the request to enter due to some miscellaneous problem of its own.</summary>
			UserroomcreateresultMiscRemoteError,
			/// <summary>The room with this name already exists.</summary>
			UserroomcreateresultDuplicateName,
			/// <summary>THe user has already created max number of rooms allowd by the server.</summary>
			UserroomcreateresultLimitReached,
			/// <summary>The server does not support room creation.</summary>
			UserroomcreateresultNotSupported
		}
		/// <summary>
		/// This type specify the user details to search.
		/// </summary>
		public enum UserSearchField {
			/// <summary>id of the user.</summary>
			UsersearchfieldUID,
			/// <summary>mail of the user.</summary>
			UsersearchfieldEMAIL,
			/// <summary>display name of the user.</summary>
			UsersearchfieldNAME,
			/// <summary>telephone number of user.</summary>
			UsersearchfieldTELNO
		}
		/// <summary>
		/// This type indicates the result of a search for user or room.
		/// </summary>
		public enum UserSearchResult {
			/// <summary>The search operation was successful.</summary>
			UsersearchresultOK,
			/// <summary>No records found for the search.</summary>
			UsersearchresultNoRecords,
			/// <summary>The search result failed due to request timeout.</summary>
			UsersearchresultNoResponse,
			/// <summary>The search result failed due to some miscellaneous local problem.</summary>
			UsersearchresultMiscLocalError,
			/// <summary>The search result failed due to some miscellaneous remote problem.</summary>
			UsersearchresultMiscRemoteError
		}
		/// <summary>
		/// 
		/// </summary>
		public enum UserState {
			/// <summary></summary>
			UserstateIdle,
			/// <summary></summary>
			UserstateLoggingIn,
			/// <summary></summary>
			UserstateLoggedIn,
			/// <summary></summary>
			UserstateReconnecting,
			/// <summary></summary>
			UserstateRequestingAuthenticationTypes
		}
		/// <summary>
		/// An enumeration of authentication key types.
		/// </summary>
		public enum UserTokenType {
			/// <summary>The associated key is a refresh token.</summary>
			UsertokentypeRefreshToken,
			/// <summary>The associated key is an access token.</summary>
			UsertokentypeAccessToken,
			/// <summary>The associated key is a jwt token.</summary>
			UsertokentypeJwtToken,
			/// <summary>The associated key is a none.</summary>
			UsertokentypeNone
		}
		public interface IAdvancedSearchRooms{

			void OnRoomSearchResults(String searchText, UserSearchResult searchResult, List<RoomInfo> roomInfo, SizeT numRecords);
		}
		public interface IAdvancedSearchUsers{

			void OnUserSearchResults(String searchText, UserSearchResult searchResult, List<ContactInfo> contacts, SizeT numRecords);
		}
		public interface ICreateCall{

			void OnCallCreated(Call call, UserCallCreateResult result, String createToken);
		}
		public interface ICreateRoomFromId{

			void OnRoomCreated(Room room, UserRoomCreateResult result, String createToken);
		}
		public interface IGetAuthTypes{

			void OnAuthTypes(UserGetAuthTypesResult result, List<UserAuthenticationInfo> authTypes);
			void OnAuthTypesWebProxyCredentialsRequest(String webProxyAddress);
		}
		public interface IGetContact{

			void OnGetContactResult(Contact contact, UserGetContactResult result);
		}
		public interface IGetCurrentRoster{

			void OnGetCurrentRosterComplete(List<Contact> roster);
		}
		public interface IGetFavoriteRooms{

			void OnFavoriteRoomResults(UserSearchResult searchResult, List<RoomInfo> roomInfo);
		}
		public interface IGetPasswordResetUrl{

			void OnPasswordResetUrl(String passwordResetUrl);
		}
		public interface IGetRecentRooms{

			void OnRecentRoomResults(UserSearchResult searchResult, List<RoomInfo> roomInfo);
		}
		public interface IGetRecordingServiceProfiles{

			void OnGetRecordingServiceProfiles(List<String> profiles, List<String> prefixes, UserRecordingServiceResult result);
		}
		public interface ILogin{

			void OnLoginComplete(UserLoginResult result, Boolean secure, TenantCapabilities capabilities);
			void OnLoggedOut(UserLogoutReason reason);
			void OnConnectionStatusChanged(UserConnectionStatusChangedReason reason);
			void OnTokenReceived(List<UserTokenInfo> tokens);
			void OnWebProxyCredentialsRequest(String webProxyAddress);
		}
		public interface IRefreshAccessToken{

			void OnRefreshAccessToken(UserOperationResult result);
		}
		public interface IRegisterCallEventListener{

			void OnCallCreatedByInvite(Call call, Contact inviter);
		}
		public interface IRegisterContactEventListener{

			void OnUpdateSelf(Contact contact);
			void OnUpdateRosterContact(Contact contact);
			void OnRemoveRosterContact(String uri);
		}
		public interface IRegisterLicenseEventListener{

			void OnLicenseReceived(String licenseKey);
			void OnGetLicenseKey(String licenseKey);
		}
		public interface IRegisterRoomEventListener{

			void OnRoomCreatedByInvite(Room room, Contact inviter, String message);
			void OnRoomInviteCancelled(RoomInfo roomInfo, String message);
		}
		public class TenantCapabilitiesFactory
		{
			public static TenantCapabilities Create()
			{
				return new TenantCapabilities(IntPtr.Zero);
			}
			public static void Destroy(TenantCapabilities obj)
			{
			}
		}
		/// <summary>
		/// Represents the connection tenant capabilities for the user, which are based on information from the portal.
		/// </summary>
		public class TenantCapabilities {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoTenantCapabilities reference.
			public IntPtr GetObjectPtr() {
				IntPtr nLoginAttemptInfo = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * LoginAttemptInfo.Count);
				int nLoginAttemptInfoSize = 0;
				IntPtr nWSGMicroserviceAddress = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(WSGMicroserviceAddress ?? string.Empty);
				IntPtr nChangePasswordUrl = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(changePasswordUrl ?? string.Empty);
				IntPtr nEndpointBehavior = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * endpointBehavior.Count);
				int nEndpointBehaviorSize = 0;
				IntPtr nLoginBannerData = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(loginBannerData ?? string.Empty);
				IntPtr nWelcomeBannerData = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(welcomeBannerData ?? string.Empty);

				foreach (UserLoginInfo iter in LoginAttemptInfo) {
					Marshal.WriteIntPtr(nLoginAttemptInfo + (nLoginAttemptInfoSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
					nLoginAttemptInfoSize++;
				}
				foreach (Property iter in endpointBehavior) {
					Marshal.WriteIntPtr(nEndpointBehavior + (nEndpointBehaviorSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
					nEndpointBehaviorSize++;
				}

				VidyoTenantCapabilitiesSetLoginAttemptInfoNative(objPtr, nLoginAttemptInfo, nLoginAttemptInfoSize);
				VidyoTenantCapabilitiesSetWSGMicroserviceAddressNative(objPtr, nWSGMicroserviceAddress);
				VidyoTenantCapabilitiesSetbrEnabledNative(objPtr, brEnabled);
				VidyoTenantCapabilitiesSetchangePasswordUrlNative(objPtr, nChangePasswordUrl);
				VidyoTenantCapabilitiesSetendpointBehaviorNative(objPtr, nEndpointBehavior, nEndpointBehaviorSize);
				VidyoTenantCapabilitiesSetisCcEnabledNative(objPtr, isCcEnabled);
				VidyoTenantCapabilitiesSetisClientSideRoomModerationEnabledNative(objPtr, isClientSideRoomModerationEnabled);
				VidyoTenantCapabilitiesSetisCreatePublicRoomEnabledNative(objPtr, isCreatePublicRoomEnabled);
				VidyoTenantCapabilitiesSetisGuestEnabledNative(objPtr, isGuestEnabled);
				VidyoTenantCapabilitiesSetisLoginBannerEnabledNative(objPtr, isLoginBannerEnabled);
				VidyoTenantCapabilitiesSetisOpusAudioEnabledNative(objPtr, isOpusAudioEnabled);
				VidyoTenantCapabilitiesSetisPersonalRoomEnabledNative(objPtr, isPersonalRoomEnabled);
				VidyoTenantCapabilitiesSetisPrivateChatEnabledNative(objPtr, isPrivateChatEnabled);
				VidyoTenantCapabilitiesSetisPublicChatEnabledNative(objPtr, isPublicChatEnabled);
				VidyoTenantCapabilitiesSetisRoomModerationEnabledNative(objPtr, isRoomModerationEnabled);
				VidyoTenantCapabilitiesSetisScheduledRoomEnabledNative(objPtr, isScheduledRoomEnabled);
				VidyoTenantCapabilitiesSetisSdk220EnabledNative(objPtr, isSdk220Enabled);
				VidyoTenantCapabilitiesSetisTestCallEnabledNative(objPtr, isTestCallEnabled);
				VidyoTenantCapabilitiesSetisTytoCareEnabledNative(objPtr, isTytoCareEnabled);
				VidyoTenantCapabilitiesSetisVP9EnabledNative(objPtr, isVP9Enabled);
				VidyoTenantCapabilitiesSetisWSGMicroserviceEnabledNative(objPtr, isWSGMicroserviceEnabled);
				VidyoTenantCapabilitiesSetisWelcomeBannerEnabledNative(objPtr, isWelcomeBannerEnabled);
				VidyoTenantCapabilitiesSetloginBannerDataNative(objPtr, nLoginBannerData);
				VidyoTenantCapabilitiesSetmaxReceiveBandWidthNative(objPtr, maxReceiveBandWidth);
				VidyoTenantCapabilitiesSetmaxSendBandWidthNative(objPtr, maxSendBandWidth);
				VidyoTenantCapabilitiesSetmaximumRoomPinLengthNative(objPtr, maximumRoomPinLength);
				VidyoTenantCapabilitiesSetminimumRoomPinLengthNative(objPtr, minimumRoomPinLength);
				VidyoTenantCapabilitiesSetwelcomeBannerDataNative(objPtr, nWelcomeBannerData);

				Marshal.FreeHGlobal(nWelcomeBannerData);
				Marshal.FreeHGlobal(nLoginBannerData);
				Marshal.FreeHGlobal(nEndpointBehavior);
				Marshal.FreeHGlobal(nChangePasswordUrl);
				Marshal.FreeHGlobal(nWSGMicroserviceAddress);
				Marshal.FreeHGlobal(nLoginAttemptInfo);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetLoginAttemptInfoNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetLoginAttemptInfoNative(IntPtr obj, IntPtr LoginAttemptInfo, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetLoginAttemptInfoArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesFreeLoginAttemptInfoArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetWSGMicroserviceAddressNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetWSGMicroserviceAddressNative(IntPtr obj, IntPtr WSGMicroserviceAddress);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetbrEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetbrEnabledNative(IntPtr obj, Boolean brEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetchangePasswordUrlNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetchangePasswordUrlNative(IntPtr obj, IntPtr changePasswordUrl);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetendpointBehaviorNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetendpointBehaviorNative(IntPtr obj, IntPtr endpointBehavior, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetendpointBehaviorArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesFreeendpointBehaviorArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisCcEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisCcEnabledNative(IntPtr obj, Boolean isCcEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisClientSideRoomModerationEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisClientSideRoomModerationEnabledNative(IntPtr obj, Boolean isClientSideRoomModerationEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisCreatePublicRoomEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisCreatePublicRoomEnabledNative(IntPtr obj, Boolean isCreatePublicRoomEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisGuestEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisGuestEnabledNative(IntPtr obj, Boolean isGuestEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisLoginBannerEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisLoginBannerEnabledNative(IntPtr obj, Boolean isLoginBannerEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisOpusAudioEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisOpusAudioEnabledNative(IntPtr obj, Boolean isOpusAudioEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisPersonalRoomEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisPersonalRoomEnabledNative(IntPtr obj, Boolean isPersonalRoomEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisPrivateChatEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisPrivateChatEnabledNative(IntPtr obj, Boolean isPrivateChatEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisPublicChatEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisPublicChatEnabledNative(IntPtr obj, Boolean isPublicChatEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisRoomModerationEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisRoomModerationEnabledNative(IntPtr obj, Boolean isRoomModerationEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisScheduledRoomEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisScheduledRoomEnabledNative(IntPtr obj, Boolean isScheduledRoomEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisSdk220EnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisSdk220EnabledNative(IntPtr obj, Boolean isSdk220Enabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisTestCallEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisTestCallEnabledNative(IntPtr obj, Boolean isTestCallEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisTytoCareEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisTytoCareEnabledNative(IntPtr obj, Boolean isTytoCareEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisVP9EnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisVP9EnabledNative(IntPtr obj, Boolean isVP9Enabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisWSGMicroserviceEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisWSGMicroserviceEnabledNative(IntPtr obj, Boolean isWSGMicroserviceEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoTenantCapabilitiesGetisWelcomeBannerEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetisWelcomeBannerEnabledNative(IntPtr obj, Boolean isWelcomeBannerEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetloginBannerDataNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetloginBannerDataNative(IntPtr obj, IntPtr loginBannerData);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoTenantCapabilitiesGetmaxReceiveBandWidthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetmaxReceiveBandWidthNative(IntPtr obj, uint maxReceiveBandWidth);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoTenantCapabilitiesGetmaxSendBandWidthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetmaxSendBandWidthNative(IntPtr obj, uint maxSendBandWidth);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern int VidyoTenantCapabilitiesGetmaximumRoomPinLengthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetmaximumRoomPinLengthNative(IntPtr obj, int maximumRoomPinLength);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern int VidyoTenantCapabilitiesGetminimumRoomPinLengthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetminimumRoomPinLengthNative(IntPtr obj, int minimumRoomPinLength);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoTenantCapabilitiesGetwelcomeBannerDataNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoTenantCapabilitiesSetwelcomeBannerDataNative(IntPtr obj, IntPtr welcomeBannerData);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoTenantCapabilitiesConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoTenantCapabilitiesConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoTenantCapabilitiesDestructNative(IntPtr obj);

			/// <summary>
			/// Vector of VidyoUserLoginInfo.
			/// </summary>
			public List<UserLoginInfo> LoginAttemptInfo;
			/// <summary>
			/// Address of Web Socket Gateway microservice. This information is valid only when WSGMicroservice is enabled
			/// </summary>
			public String WSGMicroserviceAddress;
			/// <summary>
			/// Indicates whether Breakout Room is enabled on the backend.
			/// </summary>
			public Boolean brEnabled;
			/// <summary>
			/// URL to change the password at the backend.
			/// </summary>
			public String changePasswordUrl;
			/// <summary>
			/// endpoint behavior
			/// </summary>
			public List<Property> endpointBehavior;
			/// <summary>
			/// Indicates whether Closed Captioning is enabled on the backend.
			/// </summary>
			public Boolean isCcEnabled;
			/// <summary>
			/// indicates if the room moderation from client side is supported on the backend.
			/// </summary>
			public Boolean isClientSideRoomModerationEnabled;
			/// <summary>
			/// indicates if creation of public rooms is enabled on the backend.
			/// </summary>
			public Boolean isCreatePublicRoomEnabled;
			/// <summary>
			/// indicates if the guest login is supported on the backend.
			/// </summary>
			public Boolean isGuestEnabled;
			/// <summary>
			/// indicates if the login banner is enabled on the backend.
			/// </summary>
			public Boolean isLoginBannerEnabled;
			/// <summary>
			/// indicates if the Opus Audio codec is enabled on the backend.
			/// </summary>
			public Boolean isOpusAudioEnabled;
			/// <summary>
			/// indicates if personal room is enabled on the backend.
			/// </summary>
			public Boolean isPersonalRoomEnabled;
			/// <summary>
			/// indicates if private chat is enabled on the backend.
			/// </summary>
			public Boolean isPrivateChatEnabled;
			/// <summary>
			/// indicates if public chat is enabled on the backend.
			/// </summary>
			public Boolean isPublicChatEnabled;
			/// <summary>
			/// indicates if the room moderation is supported on the backend.
			/// </summary>
			public Boolean isRoomModerationEnabled;
			/// <summary>
			/// indicates if the creation of a scheduled meeting room is supported on the backend.
			/// </summary>
			public Boolean isScheduledRoomEnabled;
			/// <summary>
			/// indicates if the SDK 220 is enabled on the router.
			/// </summary>
			public Boolean isSdk220Enabled;
			/// <summary>
			/// indicates if test call is enabled on the backend.
			/// </summary>
			public Boolean isTestCallEnabled;
			/// <summary>
			/// indicates if TytoCare is enabled.
			/// </summary>
			public Boolean isTytoCareEnabled;
			/// <summary>
			/// Indicates whether VP9 is enabled on the backend.
			/// </summary>
			public Boolean isVP9Enabled;
			/// <summary>
			/// Indicates if Web Socket Gateway is enabled.
			/// </summary>
			public Boolean isWSGMicroserviceEnabled;
			/// <summary>
			/// indicates if the welcome banner is enabled on the backend.
			/// </summary>
			public Boolean isWelcomeBannerEnabled;
			/// <summary>
			/// Login banner text configured at the backend.
			/// </summary>
			public String loginBannerData;
			/// <summary>
			/// Represents the maximum receive bandwidth.
			/// </summary>
			public uint maxReceiveBandWidth;
			/// <summary>
			/// Represents the maximum send bandwidth.
			/// </summary>
			public uint maxSendBandWidth;
			/// <summary>
			/// represents the maximum room pin length required by the backend.
			/// </summary>
			public int maximumRoomPinLength;
			/// <summary>
			/// represents the minimum room pin length required by the backend.
			/// </summary>
			public int minimumRoomPinLength;
			/// <summary>
			/// Welcome banner text configured at the backend.
			/// </summary>
			public String welcomeBannerData;
			public TenantCapabilities(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoTenantCapabilitiesConstructDefaultNative();
				}
				else {
					objPtr = VidyoTenantCapabilitiesConstructCopyNative(obj);
				}

				List<UserLoginInfo> csLoginAttemptInfo = new List<UserLoginInfo>();
				var nLoginAttemptInfoSize = 0;
				var nLoginAttemptInfo = VidyoTenantCapabilitiesGetLoginAttemptInfoArrayNative(VidyoTenantCapabilitiesGetLoginAttemptInfoNative(objPtr), ref nLoginAttemptInfoSize);
				var nLoginAttemptInfoIndex = 0;
				while (nLoginAttemptInfoIndex < nLoginAttemptInfoSize) {
					UserLoginInfo csTLoginAttemptInfo = new UserLoginInfo(Marshal.ReadIntPtr(nLoginAttemptInfo + (nLoginAttemptInfoIndex * Marshal.SizeOf(nLoginAttemptInfo))));
					csLoginAttemptInfo.Add(csTLoginAttemptInfo);
					nLoginAttemptInfoIndex++;
				}

				List<Property> csEndpointBehavior = new List<Property>();
				var nEndpointBehaviorSize = 0;
				var nEndpointBehavior = VidyoTenantCapabilitiesGetendpointBehaviorArrayNative(VidyoTenantCapabilitiesGetendpointBehaviorNative(objPtr), ref nEndpointBehaviorSize);
				var nEndpointBehaviorIndex = 0;
				while (nEndpointBehaviorIndex < nEndpointBehaviorSize) {
					Property csTendpointBehavior = new Property(Marshal.ReadIntPtr(nEndpointBehavior + (nEndpointBehaviorIndex * Marshal.SizeOf(nEndpointBehavior))));
					csEndpointBehavior.Add(csTendpointBehavior);
					nEndpointBehaviorIndex++;
				}

				LoginAttemptInfo = csLoginAttemptInfo;
				WSGMicroserviceAddress = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoTenantCapabilitiesGetWSGMicroserviceAddressNative(objPtr));
				brEnabled = VidyoTenantCapabilitiesGetbrEnabledNative(objPtr);
				changePasswordUrl = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoTenantCapabilitiesGetchangePasswordUrlNative(objPtr));
				endpointBehavior = csEndpointBehavior;
				isCcEnabled = VidyoTenantCapabilitiesGetisCcEnabledNative(objPtr);
				isClientSideRoomModerationEnabled = VidyoTenantCapabilitiesGetisClientSideRoomModerationEnabledNative(objPtr);
				isCreatePublicRoomEnabled = VidyoTenantCapabilitiesGetisCreatePublicRoomEnabledNative(objPtr);
				isGuestEnabled = VidyoTenantCapabilitiesGetisGuestEnabledNative(objPtr);
				isLoginBannerEnabled = VidyoTenantCapabilitiesGetisLoginBannerEnabledNative(objPtr);
				isOpusAudioEnabled = VidyoTenantCapabilitiesGetisOpusAudioEnabledNative(objPtr);
				isPersonalRoomEnabled = VidyoTenantCapabilitiesGetisPersonalRoomEnabledNative(objPtr);
				isPrivateChatEnabled = VidyoTenantCapabilitiesGetisPrivateChatEnabledNative(objPtr);
				isPublicChatEnabled = VidyoTenantCapabilitiesGetisPublicChatEnabledNative(objPtr);
				isRoomModerationEnabled = VidyoTenantCapabilitiesGetisRoomModerationEnabledNative(objPtr);
				isScheduledRoomEnabled = VidyoTenantCapabilitiesGetisScheduledRoomEnabledNative(objPtr);
				isSdk220Enabled = VidyoTenantCapabilitiesGetisSdk220EnabledNative(objPtr);
				isTestCallEnabled = VidyoTenantCapabilitiesGetisTestCallEnabledNative(objPtr);
				isTytoCareEnabled = VidyoTenantCapabilitiesGetisTytoCareEnabledNative(objPtr);
				isVP9Enabled = VidyoTenantCapabilitiesGetisVP9EnabledNative(objPtr);
				isWSGMicroserviceEnabled = VidyoTenantCapabilitiesGetisWSGMicroserviceEnabledNative(objPtr);
				isWelcomeBannerEnabled = VidyoTenantCapabilitiesGetisWelcomeBannerEnabledNative(objPtr);
				loginBannerData = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoTenantCapabilitiesGetloginBannerDataNative(objPtr));
				maxReceiveBandWidth = VidyoTenantCapabilitiesGetmaxReceiveBandWidthNative(objPtr);
				maxSendBandWidth = VidyoTenantCapabilitiesGetmaxSendBandWidthNative(objPtr);
				maximumRoomPinLength = VidyoTenantCapabilitiesGetmaximumRoomPinLengthNative(objPtr);
				minimumRoomPinLength = VidyoTenantCapabilitiesGetminimumRoomPinLengthNative(objPtr);
				welcomeBannerData = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoTenantCapabilitiesGetwelcomeBannerDataNative(objPtr));
				VidyoTenantCapabilitiesFreeendpointBehaviorArrayNative(nEndpointBehavior, nEndpointBehaviorSize);
				VidyoTenantCapabilitiesFreeLoginAttemptInfoArrayNative(nLoginAttemptInfo, nLoginAttemptInfoSize);
			}
			~TenantCapabilities() {
				VidyoTenantCapabilitiesDestructNative(objPtr);
			 }
		};
		public class UserAuthenticationInfoFactory
		{
			public static UserAuthenticationInfo Create()
			{
				return new UserAuthenticationInfo(IntPtr.Zero);
			}
			public static void Destroy(UserAuthenticationInfo obj)
			{
			}
		}
		/// <summary>
		/// Represents the authentication information the server supported.
		/// </summary>
		public class UserAuthenticationInfo {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoUserAuthenticationInfo reference.
			public IntPtr GetObjectPtr() {

				VidyoUserAuthenticationInfoSetauthTypeNative(objPtr, authType);
				VidyoUserAuthenticationInfoSetpropertyNative(objPtr, property.GetObjectPtr());

				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern User.UserAuthType VidyoUserAuthenticationInfoGetauthTypeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserAuthenticationInfoSetauthTypeNative(IntPtr obj, User.UserAuthType authType);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoUserAuthenticationInfoGetpropertyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserAuthenticationInfoSetpropertyNative(IntPtr obj, IntPtr property);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoUserAuthenticationInfoConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoUserAuthenticationInfoConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoUserAuthenticationInfoDestructNative(IntPtr obj);

			/// <summary>
			/// 
			/// </summary>
			public User.UserAuthType authType;
			/// <summary>
			/// 
			/// </summary>
			public Property property;
			public UserAuthenticationInfo(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoUserAuthenticationInfoConstructDefaultNative();
				}
				else {
					objPtr = VidyoUserAuthenticationInfoConstructCopyNative(obj);
				}

				Property csProperty = new Property(VidyoUserAuthenticationInfoGetpropertyNative(objPtr));
				authType = VidyoUserAuthenticationInfoGetauthTypeNative(objPtr);
				property = csProperty;
			}
			~UserAuthenticationInfo() {
				VidyoUserAuthenticationInfoDestructNative(objPtr);
			 }
		};
		public class UserLoginInfoFactory
		{
			public static UserLoginInfo Create()
			{
				return new UserLoginInfo(IntPtr.Zero);
			}
			public static void Destroy(UserLoginInfo obj)
			{
			}
		}
		/// <summary>
		/// Represents the login attempt information fro the user.
		/// </summary>
		public class UserLoginInfo {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoUserLoginInfo reference.
			public IntPtr GetObjectPtr() {
				IntPtr nResult = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(result ?? string.Empty);
				IntPtr nSourceIp = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(sourceIp ?? string.Empty);
				IntPtr nTimestamp = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(timestamp ?? string.Empty);

				VidyoUserLoginInfoSetresultNative(objPtr, nResult);
				VidyoUserLoginInfoSetsourceIpNative(objPtr, nSourceIp);
				VidyoUserLoginInfoSettimestampNative(objPtr, nTimestamp);

				Marshal.FreeHGlobal(nTimestamp);
				Marshal.FreeHGlobal(nSourceIp);
				Marshal.FreeHGlobal(nResult);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoUserLoginInfoGetresultNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserLoginInfoSetresultNative(IntPtr obj, IntPtr result);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoUserLoginInfoGetsourceIpNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserLoginInfoSetsourceIpNative(IntPtr obj, IntPtr sourceIp);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoUserLoginInfoGettimestampNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserLoginInfoSettimestampNative(IntPtr obj, IntPtr timestamp);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoUserLoginInfoConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoUserLoginInfoConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoUserLoginInfoDestructNative(IntPtr obj);

			/// <summary>
			/// indicates wether the login attempt was sucessful or a failure.
			/// </summary>
			public String result;
			/// <summary>
			/// The ip address from which the login was initiated
			/// </summary>
			public String sourceIp;
			/// <summary>
			/// The time at which the login was initiated
			/// </summary>
			public String timestamp;
			public UserLoginInfo(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoUserLoginInfoConstructDefaultNative();
				}
				else {
					objPtr = VidyoUserLoginInfoConstructCopyNative(obj);
				}

				result = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoUserLoginInfoGetresultNative(objPtr));
				sourceIp = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoUserLoginInfoGetsourceIpNative(objPtr));
				timestamp = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoUserLoginInfoGettimestampNative(objPtr));
			}
			~UserLoginInfo() {
				VidyoUserLoginInfoDestructNative(objPtr);
			 }
		};
		public class UserTokenInfoFactory
		{
			public static UserTokenInfo Create()
			{
				return new UserTokenInfo(IntPtr.Zero);
			}
			public static void Destroy(UserTokenInfo obj)
			{
			}
		}
		/// <summary>
		/// Represents VidyoUser token info.
		/// </summary>
		public class UserTokenInfo {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoUserTokenInfo reference.
			public IntPtr GetObjectPtr() {
				IntPtr nToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(token ?? string.Empty);

				VidyoUserTokenInfoSettokenNative(objPtr, nToken);
				VidyoUserTokenInfoSettokenTypeNative(objPtr, tokenType);

				Marshal.FreeHGlobal(nToken);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoUserTokenInfoGettokenNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserTokenInfoSettokenNative(IntPtr obj, IntPtr token);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern User.UserTokenType VidyoUserTokenInfoGettokenTypeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoUserTokenInfoSettokenTypeNative(IntPtr obj, User.UserTokenType tokenType);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoUserTokenInfoConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoUserTokenInfoConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoUserTokenInfoDestructNative(IntPtr obj);

			/// <summary>
			/// Token value.
			/// </summary>
			public String token;
			/// <summary>
			/// Token Type.
			/// </summary>
			public User.UserTokenType tokenType;
			public UserTokenInfo(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoUserTokenInfoConstructDefaultNative();
				}
				else {
					objPtr = VidyoUserTokenInfoConstructCopyNative(obj);
				}

				token = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoUserTokenInfoGettokenNative(objPtr));
				tokenType = VidyoUserTokenInfoGettokenTypeNative(objPtr);
			}
			~UserTokenInfo() {
				VidyoUserTokenInfoDestructNative(objPtr);
			 }
		};
		private IAdvancedSearchRooms _mIAdvancedSearchRooms;
		private IAdvancedSearchUsers _mIAdvancedSearchUsers;
		private ICreateCall _mICreateCall;
		private ICreateRoomFromId _mICreateRoomFromId;
		private IGetAuthTypes _mIGetAuthTypes;
		private IGetContact _mIGetContact;
		private IGetCurrentRoster _mIGetCurrentRoster;
		private IGetFavoriteRooms _mIGetFavoriteRooms;
		private IGetPasswordResetUrl _mIGetPasswordResetUrl;
		private IGetRecentRooms _mIGetRecentRooms;
		private IGetRecordingServiceProfiles _mIGetRecordingServiceProfiles;
		private ILogin _mILogin;
		private IRefreshAccessToken _mIRefreshAccessToken;
		private IRegisterCallEventListener _mIRegisterCallEventListener;
		private IRegisterContactEventListener _mIRegisterContactEventListener;
		private IRegisterLicenseEventListener _mIRegisterLicenseEventListener;
		private IRegisterRoomEventListener _mIRegisterRoomEventListener;
		/// <summary>
		/// 
		/// </summary>
		/// <param name="user"></param>
		/// <param name="endpoint"></param>
		/// <param name="alloc"></param>
		public User(Endpoint endpoint) {

			objPtr = VidyoUserConstructNative((endpoint != null) ? endpoint.GetObjectPtr():IntPtr.Zero);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoUserSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		public User(IntPtr other){
			objPtr = VidyoUserConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoUserSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~User(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			DisposeWeakReferenceObjects();
			if(objPtr != IntPtr.Zero) {
				VidyoUserSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoUserDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userId"></param>
		public Boolean AddRosterContact(String userId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			Boolean ret = VidyoUserAddRosterContactNative(objPtr, nUserId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="fieldSet"></param>
		/// <param name="fieldRelations"></param>
		/// <param name="fieldValues"></param>
		/// <param name="searchToken"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean AdvancedSearchRooms(List<RoomSearchField> fieldSet, List<RoomSearchFieldRelation> fieldRelations, List<String> fieldValues, String searchToken, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nListFieldSet = VidyoUserVectorVidyoRoomSearchFieldAllocateNative();

			IntPtr nListFieldRelations = VidyoUserVectorVidyoRoomSearchFieldRelationAllocateNative();

			IntPtr nListFieldValues = VidyoUserVectorLmiStringAllocateNative();

			IntPtr nSearchToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchToken ?? string.Empty);
			IntPtr nFieldSet = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * fieldSet.Count);
			int nFieldSetSize = 0;
			foreach (RoomSearchField iter in fieldSet) {
				Marshal.WriteInt32(nFieldSet + (nFieldSetSize * Marshal.SizeOf<Int32>()), (int)iter);
				nFieldSetSize++;
			}
			VidyoUserAdvancedSearchRoomsSetfieldSetArrayNative(nListFieldSet, nFieldSet, nFieldSetSize);
			Marshal.FreeHGlobal(nFieldSet);
			IntPtr nFieldRelations = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * fieldRelations.Count);
			int nFieldRelationsSize = 0;
			foreach (RoomSearchFieldRelation iter in fieldRelations) {
				Marshal.WriteInt32(nFieldRelations + (nFieldRelationsSize * Marshal.SizeOf<Int32>()), (int)iter);
				nFieldRelationsSize++;
			}
			VidyoUserAdvancedSearchRoomsSetfieldRelationsArrayNative(nListFieldRelations, nFieldRelations, nFieldRelationsSize);
			Marshal.FreeHGlobal(nFieldRelations);
			IntPtr nFieldValues = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * fieldValues.Count);
			int nFieldValuesSize = 0;
			foreach (String iter in fieldValues) {
				Marshal.WriteIntPtr(nFieldValues + (nFieldValuesSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nFieldValuesSize++;
			}
			VidyoUserAdvancedSearchRoomsSetfieldValuesArrayNative(nListFieldValues, nFieldValues, nFieldValuesSize);
			Marshal.FreeHGlobal(nFieldValues);
			Boolean ret = VidyoUserAdvancedSearchRoomsNative(objPtr, nListFieldSet, nListFieldRelations, nListFieldValues, nSearchToken, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchToken);
			VidyoUserVectorLmiStringDeallocateNative(nListFieldValues);
			VidyoUserVectorVidyoRoomSearchFieldRelationDeallocateNative(nListFieldRelations);
			VidyoUserVectorVidyoRoomSearchFieldDeallocateNative(nListFieldSet);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="fieldSet"></param>
		/// <param name="fieldValues"></param>
		/// <param name="searchToken"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onUserSearchResults">Callback that is triggered when the user search results are ready.</param>
		public Boolean AdvancedSearchUsers(List<UserSearchField> fieldSet, List<String> fieldValues, String searchToken, uint index, uint pageSize, IAdvancedSearchUsers _iIAdvancedSearchUsers) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchUsers = _iIAdvancedSearchUsers;

			IntPtr nListFieldSet = VidyoUserVectorVidyoUserSearchFieldAllocateNative();

			IntPtr nListFieldValues = VidyoUserVectorLmiStringAllocateNative();

			IntPtr nSearchToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchToken ?? string.Empty);
			IntPtr nFieldSet = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * fieldSet.Count);
			int nFieldSetSize = 0;
			foreach (UserSearchField iter in fieldSet) {
				Marshal.WriteInt32(nFieldSet + (nFieldSetSize * Marshal.SizeOf<Int32>()), (int)iter);
				nFieldSetSize++;
			}
			VidyoUserAdvancedSearchUsersSetfieldSetArrayNative(nListFieldSet, nFieldSet, nFieldSetSize);
			Marshal.FreeHGlobal(nFieldSet);
			IntPtr nFieldValues = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * fieldValues.Count);
			int nFieldValuesSize = 0;
			foreach (String iter in fieldValues) {
				Marshal.WriteIntPtr(nFieldValues + (nFieldValuesSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nFieldValuesSize++;
			}
			VidyoUserAdvancedSearchUsersSetfieldValuesArrayNative(nListFieldValues, nFieldValues, nFieldValuesSize);
			Marshal.FreeHGlobal(nFieldValues);
			Boolean ret = VidyoUserAdvancedSearchUsersNative(objPtr, nListFieldSet, nListFieldValues, nSearchToken, index, pageSize, _mOnUserSearchResults);
			Marshal.FreeHGlobal(nSearchToken);
			VidyoUserVectorLmiStringDeallocateNative(nListFieldValues);
			VidyoUserVectorVidyoUserSearchFieldDeallocateNative(nListFieldSet);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userId"></param>
		public Boolean AllowSubscriber(String userId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			Boolean ret = VidyoUserAllowSubscriberNative(objPtr, nUserId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userId"></param>
		public Boolean BlockSubscriber(String userId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			Boolean ret = VidyoUserBlockSubscriberNative(objPtr, nUserId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userId"></param>
		/// <param name="createToken"></param>
		/// <param name="onCallCreated">Callback that is triggered when the call creation results are ready.</param>
		public Boolean CreateCall(String userId, String createToken, ICreateCall _iICreateCall) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateCall = _iICreateCall;

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateCallNative(objPtr, nUserId, nCreateToken, _mOnCallCreated);
			Marshal.FreeHGlobal(nCreateToken);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// Finds and existing room with the id specified and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="id"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean CreateRoomFromId(String id, String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateRoomFromIdNative(objPtr, nId, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);
			Marshal.FreeHGlobal(nId);

			return ret;
		}
		/// <summary>
		/// Finds a room based on the room key and privdes a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="roomKey"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean CreateRoomFromKey(String roomKey, String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nRoomKey = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomKey ?? string.Empty);
			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateRoomFromKeyNative(objPtr, nRoomKey, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);
			Marshal.FreeHGlobal(nRoomKey);

			return ret;
		}
		/// <summary>
		/// Gets a room with the id specified and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="id"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean CreateRoomWithId(String id, String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateRoomWithIdNative(objPtr, nId, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);
			Marshal.FreeHGlobal(nId);

			return ret;
		}
		/// <summary>
		/// Creates a new scheduled room and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="schedule"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean CreateScheduledRoom(EventSchedule schedule, String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateScheduledRoomNative(objPtr, (schedule != null) ? schedule.GetObjectPtr():IntPtr.Zero, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);

			return ret;
		}
		/// <summary>
		/// Creates a test call room and provides a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean CreateTestCallRoom(String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateTestCallRoomNative(objPtr, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);

			return ret;
		}
		/// <summary>
		/// Creates a new topic room and privdes a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="name"></param>
		/// <param name="description"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean CreateTopicRoom(String name, String description, String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nDescription = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(description ?? string.Empty);
			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			Boolean ret = VidyoUserCreateTopicRoomNative(objPtr, nName, nDescription, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);
			Marshal.FreeHGlobal(nDescription);
			Marshal.FreeHGlobal(nName);

			return ret;
		}
		/// <summary>
		/// Get the supported authentication types for the user.
		/// </summary>
		/// <param name="u">The user object to authentication types.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222".</param>
		/// <param name="serviceType">Optional type of the service. Default is "xmpp".</param>
		/// <param name="onAuthTypes">callback.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean GetAuthTypes(String host, uint port, String serviceType, IGetAuthTypes _iIGetAuthTypes) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetAuthTypes = _iIGetAuthTypes;

			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserGetAuthTypesNative(objPtr, nHost, port, nServiceType, _mOnAuthTypes, _mOnAuthTypesWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userId"></param>
		/// <param name="onGetContactResult">Callback that is triggered when the contact search results are ready.</param>
		public Boolean GetContact(String userId, IGetContact _iIGetContact) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetContact = _iIGetContact;

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			Boolean ret = VidyoUserGetContactNative(objPtr, nUserId, _mOnGetContactResult);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// Finds a Conversation room and privdes a new VidyoRoom object in the VidyoUserFeedbackRoomCreated callback.
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userIds"></param>
		/// <param name="createToken"></param>
		/// <param name="onRoomCreated">Callback that is triggered when the room creation results are ready.</param>
		public Boolean GetConversationRoom(List<String> userIds, String createToken, ICreateRoomFromId _iICreateRoomFromId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mICreateRoomFromId = _iICreateRoomFromId;

			IntPtr nListUserIds = VidyoUserVectorLmiStringAllocateNative();

			IntPtr nCreateToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(createToken ?? string.Empty);
			IntPtr nUserIds = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * userIds.Count);
			int nUserIdsSize = 0;
			foreach (String iter in userIds) {
				Marshal.WriteIntPtr(nUserIds + (nUserIdsSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nUserIdsSize++;
			}
			VidyoUserGetConversationRoomSetuserIdsArrayNative(nListUserIds, nUserIds, nUserIdsSize);
			Marshal.FreeHGlobal(nUserIds);
			Boolean ret = VidyoUserGetConversationRoomNative(objPtr, nListUserIds, nCreateToken, _mOnRoomCreated);
			Marshal.FreeHGlobal(nCreateToken);
			VidyoUserVectorLmiStringDeallocateNative(nListUserIds);

			return ret;
		}
		/// <summary>
		/// Gets favorite contacts.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onComplete">The callback that is triggered when getting favorite contacts completes.</param>
		public Boolean GetCurrentRoster(IGetCurrentRoster _iIGetCurrentRoster) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetCurrentRoster = _iIGetCurrentRoster;

			Boolean ret = VidyoUserGetCurrentRosterNative(objPtr, _mOnGetCurrentRosterComplete);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		public Endpoint GetEndpoint() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoUserGetEndpointNative(objPtr);
			Endpoint csRet = null;
			if(ret != IntPtr.Zero) {
				var csRetPtr = Endpoint.VidyoEndpointGetUserDataNative(ret);
				csRet = csRetPtr == IntPtr.Zero ? new Endpoint(ret) : (Endpoint)GCHandle.FromIntPtr(csRetPtr).Target;
			}


			return csRet;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="index">The start index from which the recent rooms are required. A value of '0' represents rooms starting from the beginning. A value of 'n' represents rooms starting from 'n'th record. This is used for paging the response.</param>
		/// <param name="pageSize">The maximum number of room records that can be sent in the response. This is used for paging the response.</param>
		/// <param name="onFavoriteRoomResults">Callback that is triggered when the favorite room search results are ready.</param>
		public Boolean GetFavoriteRooms(uint index, uint pageSize, IGetFavoriteRooms _iIGetFavoriteRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetFavoriteRooms = _iIGetFavoriteRooms;

			Boolean ret = VidyoUserGetFavoriteRoomsNative(objPtr, index, pageSize, _mOnFavoriteRoomResults);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoUserGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Get an URL where user can reset his password.
		/// </summary>
		/// <param name="u">The user object.</param>
		/// <param name="onPasswordResetUrl">Callback returns password reset URL.</param>
		public Boolean GetPasswordResetUrl(IGetPasswordResetUrl _iIGetPasswordResetUrl) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetPasswordResetUrl = _iIGetPasswordResetUrl;

			Boolean ret = VidyoUserGetPasswordResetUrlNative(objPtr, _mOnPasswordResetUrl);

			return ret;
		}
		/// <summary>
		/// Get the recent rooms of the user.
		/// </summary>
		/// <param name="u">Vidyo user object.</param>
		/// <param name="index">The start index from which the recent rooms are required. A value of '0' represents rooms starting from the beginning. A value of 'n' represents rooms starting from 'n'th record. This is used for paging the response.</param>
		/// <param name="pageSize">The maximum number of room records that can be sent in the response. This is used for paging the response.</param>
		/// <param name="onRecentRoomResults">Callback that is triggered when the recent room search results are ready.</param>
		public Boolean GetRecentRooms(uint index, uint pageSize, IGetRecentRooms _iIGetRecentRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetRecentRooms = _iIGetRecentRooms;

			Boolean ret = VidyoUserGetRecentRoomsNative(objPtr, index, pageSize, _mOnRecentRoomResults);

			return ret;
		}
		/// <summary>
		/// Asynchronously retrieves two vectors that describe available recording profiles defined by Recording server configuration. Each element of the first vector (profiles) is a LmiString that contains a description of a recording profile. For example, STANDARD-QUALITY, HIGH-QUALITY, VOICE-ONLY. The second vector (prefixes) contains appropriate profile prefixes. For example, 03, 01, 0. Calls a callback upon completion.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onGetRecordingServiceProfiles">Callback called upon completion. Can be NULL.</param>
		public Boolean GetRecordingServiceProfiles(IGetRecordingServiceProfiles _iIGetRecordingServiceProfiles) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetRecordingServiceProfiles = _iIGetRecordingServiceProfiles;

			Boolean ret = VidyoUserGetRecordingServiceProfilesNative(objPtr, _mOnGetRecordingServiceProfiles);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		public String GetWebProxyAddress() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoUserGetWebProxyAddressNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Set a flag to invalidates token received via VidyoUserOnTokenReceived callback during logout.
		/// </summary>
		/// <param name="user"></param>
		/// <param name="invalidate"></param>
		public Boolean InvalidateTokenOnLogout(Boolean invalidate) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserInvalidateTokenOnLogoutNative(objPtr, invalidate);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="username">Username of the user logging in.</param>
		/// <param name="password">Password of the user logging in.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222" for xmpp, "443" for wss.</param>
		/// <param name="serviceType">Optional type of the service. Default is "wss".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean Login(String username, String password, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nUsername = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(username ?? string.Empty);
			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginNative(objPtr, nUsername, nPassword, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nPassword);
			Marshal.FreeHGlobal(nUsername);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="displayName">Display name of the guest user.</param>
		/// <param name="roomKey">key to the room the guest user is attempting to join.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222" for xmpp, "443" for wss.</param>
		/// <param name="serviceType">Optional type of the service. Default is "wss".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginAsGuest(String displayName, String roomKey, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nDisplayName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(displayName ?? string.Empty);
			IntPtr nRoomKey = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomKey ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginAsGuestNative(objPtr, nDisplayName, nRoomKey, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nRoomKey);
			Marshal.FreeHGlobal(nDisplayName);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="accessToken">The short-term token used to re-login.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222" for xmpp, "443" for wss.</param>
		/// <param name="serviceType">Optional type of the service. Default is "wss".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginWithAccessToken(String accessToken, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nAccessToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(accessToken ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginWithAccessTokenNative(objPtr, nAccessToken, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nAccessToken);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="certificate">The certificate used to login.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222".</param>
		/// <param name="serviceType">Optional type of the service. Default is "xmpp".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginWithCAC(String certificate, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nCertificate = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(certificate ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginWithCACNative(objPtr, nCertificate, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nCertificate);

			return ret;
		}
		/// <summary>
		/// This API is used to login to portal with provision extended data.
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="extData">The provision extended data used as authorization token for login.</param>
		/// <param name="ebMode">Specifiy the endpoint behavior mode.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server.</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginWithExtData(String extData, String ebMode, String host, uint port, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nExtData = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(extData ?? string.Empty);
			IntPtr nEbMode = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(ebMode ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			Boolean ret = VidyoUserLoginWithExtDataNative(objPtr, nExtData, nEbMode, nHost, port, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nEbMode);
			Marshal.FreeHGlobal(nExtData);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="refreshToken">The short-term token used to re-login.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222" for xmpp, "443" for wss.</param>
		/// <param name="serviceType">Optional type of the service. Default is "wss".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginWithRefreshToken(String refreshToken, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nRefreshToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(refreshToken ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginWithRefreshTokenNative(objPtr, nRefreshToken, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nRefreshToken);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="key">The SAML key or assertion recieved from the Portal/IDP.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222".</param>
		/// <param name="serviceType">Optional type of the service. Default is "xmpp".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginWithSAML(String key, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nKey = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(key ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginWithSAMLNative(objPtr, nKey, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nKey);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u">Pointer to the VidyoUser object.</param>
		/// <param name="provisionToken">The provision token used to login.</param>
		/// <param name="host">Hostname or the IP address of the server.</param>
		/// <param name="port">Optional port of the server. Default is "5222" for xmpp, "443" for wss.</param>
		/// <param name="serviceType">Optional type of the service. Default is "wss".</param>
		/// <param name="onLoginComplete">Callback that is triggered when the user login operation is complete. This could be a successful login or a failure to login due to credentials, hostname, etc.</param>
		/// <param name="onLoggedOut">Callback that is triggered when the user is logged out.</param>
		/// <param name="onConnectionStatusChanged">Callback that is triggered when the user's connection status temporarily changes due to network lag and might be re-established without logging out.</param>
		/// <param name="onTokenReceived">Callback that is triggered when the user receives a token that can be used for subsequent logins. This token can be stored in stead of a password.</param>
		/// <param name="onWebProxyCredentialsRequest">Callback that is triggered when the user is behind a web proxy which requires credentials to establish a connection.</param>
		public Boolean LoginWithTenantToken(String provisionToken, String host, uint port, String serviceType, ILogin _iILogin) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILogin = _iILogin;

			IntPtr nProvisionToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(provisionToken ?? string.Empty);
			IntPtr nHost = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(host ?? string.Empty);
			IntPtr nServiceType = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(serviceType ?? string.Empty);
			Boolean ret = VidyoUserLoginWithTenantTokenNative(objPtr, nProvisionToken, nHost, port, nServiceType, _mOnLoginComplete, _mOnLoggedOut, _mOnConnectionStatusChanged, _mOnTokenReceived, _mOnWebProxyCredentialsRequest);
			Marshal.FreeHGlobal(nServiceType);
			Marshal.FreeHGlobal(nHost);
			Marshal.FreeHGlobal(nProvisionToken);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="user"></param>
		public Boolean Logout() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserLogoutNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Pause or resume update notifications.
		/// </summary>
		/// <param name="u">The user object.</param>
		/// <param name="pauseUpdateNotification">Set to true to resume update notificaiton, set to false to stop udpate notificaiton</param>
		public Boolean PauseUpdateNotification(Boolean pauseUpdateNotification) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserPauseUpdateNotificationNative(objPtr, pauseUpdateNotification);

			return ret;
		}
		/// <summary>
		/// Asynchronously sends a request to refresh the access token. The application will receive the token through the onTokenReceived callback.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onRefreshAccessToken">A callback that is triggered upon the completion of the request with actual result.</param>
		public Boolean RefreshAccessToken(IRefreshAccessToken _iIRefreshAccessToken) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRefreshAccessToken = _iIRefreshAccessToken;

			Boolean ret = VidyoUserRefreshAccessTokenNative(objPtr, _mOnRefreshAccessToken);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about invite to call events.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onCallCreatedByInvite">Callback that is triggered when the user is being invited to a call.</param>
		public Boolean RegisterCallEventListener(IRegisterCallEventListener _iIRegisterCallEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterCallEventListener = _iIRegisterCallEventListener;

			Boolean ret = VidyoUserRegisterCallEventListenerNative(objPtr, _mOnCallCreatedByInvite);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about contact events.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onUpdateSelf">Callback that is triggered when the users' own contact information changes.</param>
		/// <param name="onUpdateRosterContact">Callback that is triggered when a roster contact is updated.</param>
		/// <param name="onRemoveRosterContact">Callback that is triggered when a contact is removed from the roster .</param>
		public Boolean RegisterContactEventListener(IRegisterContactEventListener _iIRegisterContactEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterContactEventListener = _iIRegisterContactEventListener;

			Boolean ret = VidyoUserRegisterContactEventListenerNative(objPtr, _mOnUpdateSelf, _mOnUpdateRosterContact, _mOnRemoveRosterContact);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about license events.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onLicenseReceived">Callback that is triggered when the new license is received from the server.</param>
		/// <param name="onGetLicenseKey">Callback that is triggered when the user needs a previousely received license key.</param>
		public Boolean RegisterLicenseEventListener(IRegisterLicenseEventListener _iIRegisterLicenseEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLicenseEventListener = _iIRegisterLicenseEventListener;

			Boolean ret = VidyoUserRegisterLicenseEventListenerNative(objPtr, _mOnLicenseReceived, _mOnGetLicenseKey);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about invite to room events.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="onRoomCreatedByInvite">Callback that is triggered when the user is being invited to a room.</param>
		/// <param name="onRoomInviteCancelled">.</param>
		public Boolean RegisterRoomEventListener(IRegisterRoomEventListener _iIRegisterRoomEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRoomEventListener = _iIRegisterRoomEventListener;

			Boolean ret = VidyoUserRegisterRoomEventListenerNative(objPtr, _mOnRoomCreatedByInvite, _mOnRoomInviteCancelled);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="userId"></param>
		public Boolean RemoveRosterContact(String userId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			Boolean ret = VidyoUserRemoveRosterContactNative(objPtr, nUserId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean SearchConversationRooms(String searchText, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchConversationRoomsNative(objPtr, nSearchText, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean SearchRooms(String searchText, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchRoomsNative(objPtr, nSearchText, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean SearchRoomsWithName(String searchText, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchRoomsWithNameNative(objPtr, nSearchText, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean SearchRoomsWithOwner(String searchText, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchRoomsWithOwnerNative(objPtr, nSearchText, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean SearchRoomsWithSubject(String searchText, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchRoomsWithSubjectNative(objPtr, nSearchText, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onRoomSearchResults">Callback that is triggered when the room search results are ready.</param>
		public Boolean SearchTopicRooms(String searchText, uint index, uint pageSize, IAdvancedSearchRooms _iIAdvancedSearchRooms) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchRooms = _iIAdvancedSearchRooms;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchTopicRoomsNative(objPtr, nSearchText, index, pageSize, _mOnRoomSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="searchText"></param>
		/// <param name="index"></param>
		/// <param name="pageSize"></param>
		/// <param name="onUserSearchResults">Callback that is triggered when the user search results are ready.</param>
		public Boolean SearchUsers(String searchText, uint index, uint pageSize, IAdvancedSearchUsers _iIAdvancedSearchUsers) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAdvancedSearchUsers = _iIAdvancedSearchUsers;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoUserSearchUsersNative(objPtr, nSearchText, index, pageSize, _mOnUserSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="ca">The contents of the Certificate Authority file. Note: If the string 'default' is passed here, VidyoUser will use a built-in Certificate Authroity bundle.</param>
		/// <param name="caFilePath">The full path Certificate Authority file.</param>
		/// <param name="caDir">The full path to the directory containing Certificate Authority files.</param>
		public void SetCA(String ca, String caFilePath, String caDir) {
			if (objPtr == IntPtr.Zero) { return; }

			IntPtr nCa = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(ca ?? string.Empty);
			IntPtr nCaFilePath = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(caFilePath ?? string.Empty);
			IntPtr nCaDir = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(caDir ?? string.Empty);
			VidyoUserSetCANative(objPtr, nCa, nCaFilePath, nCaDir);
			Marshal.FreeHGlobal(nCaDir);
			Marshal.FreeHGlobal(nCaFilePath);
			Marshal.FreeHGlobal(nCa);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="displayName">The maximum length of the display name is 256 characters.</param>
		public Boolean SetDisplayName(String displayName) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nDisplayName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(displayName ?? string.Empty);
			Boolean ret = VidyoUserSetDisplayNameNative(objPtr, nDisplayName);
			Marshal.FreeHGlobal(nDisplayName);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="enable">Enable the tranport.</param>
		public void SetTCPTransport(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoUserSetTCPTransportNative(objPtr, enable);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="enable">Enable the tranport.</param>
		public void SetUDPTransport(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoUserSetUDPTransportNative(objPtr, enable);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="proxyAddress"></param>
		/// <param name="username"></param>
		/// <param name="password"></param>
		public void SetWebProxyAddressCredentials(String proxyAddress, String username, String password) {
			if (objPtr == IntPtr.Zero) { return; }

			IntPtr nProxyAddress = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(proxyAddress ?? string.Empty);
			IntPtr nUsername = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(username ?? string.Empty);
			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			VidyoUserSetWebProxyAddressCredentialsNative(objPtr, nProxyAddress, nUsername, nPassword);
			Marshal.FreeHGlobal(nPassword);
			Marshal.FreeHGlobal(nUsername);
			Marshal.FreeHGlobal(nProxyAddress);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="enable">Enable the tranport.</param>
		public void SetWebProxyTransport(Boolean enable) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoUserSetWebProxyTransportNative(objPtr, enable);
		}
		/// <summary>
		/// Enable the use of WebProxy Transport with provided web proxy server address.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		/// <param name="name">The name of web proxy server, it may also may be prefixed by a scheme ('http://proxy.company.com')</param>
		/// <param name="port">The port that web proxy server is running on</param>
		public void SetWebProxyTransportAddress(String name, uint port) {
			if (objPtr == IntPtr.Zero) { return; }

			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			VidyoUserSetWebProxyTransportAddressNative(objPtr, nName, port);
			Marshal.FreeHGlobal(nName);
		}
		/// <summary>
		/// Unregisters call event notifications.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		public Boolean UnregisterCallEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserUnregisterCallEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters contact event notifications.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		public Boolean UnregisterContactEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserUnregisterContactEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters license event notifications.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		public Boolean UnregisterLicenseEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserUnregisterLicenseEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters room event notifications.
		/// </summary>
		/// <param name="u">The VidyoUser object.</param>
		public Boolean UnregisterRoomEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoUserUnregisterRoomEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="u"></param>
		/// <param name="state"></param>
		/// <param name="status"></param>
		public Boolean UpdatePresence(Contact.ContactPresenceState state, String status) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nStatus = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(status ?? string.Empty);
			Boolean ret = VidyoUserUpdatePresenceNative(objPtr, state, nStatus);
			Marshal.FreeHGlobal(nStatus);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnAuthTypes))]
#endif
		private static void OnAuthTypesDelegate(IntPtr u, UserGetAuthTypesResult result, IntPtr authTypes){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<UserAuthenticationInfo> csAuthTypes = new List<UserAuthenticationInfo>();
			var nAuthTypesSize = 0;
			var nAuthTypes = VidyoUserOnAuthTypesGetauthTypesArrayNative(authTypes, ref nAuthTypesSize);
			var nAuthTypesIndex = 0;
			while (nAuthTypesIndex < nAuthTypesSize) {
				UserAuthenticationInfo csTauthTypes = new UserAuthenticationInfo(Marshal.ReadIntPtr(nAuthTypes + (nAuthTypesIndex * Marshal.SizeOf(nAuthTypes))));
				csAuthTypes.Add(csTauthTypes);
				nAuthTypesIndex++;
			}

			csU?._mIGetAuthTypes?.OnAuthTypes(result, csAuthTypes);
			VidyoUserOnAuthTypesFreeauthTypesArrayNative(nAuthTypes, nAuthTypesSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnAuthTypesWebProxyCredentialsRequest))]
#endif
		private static void OnAuthTypesWebProxyCredentialsRequestDelegate(IntPtr u, IntPtr webProxyAddress){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			var n_webProxyAddress = VidyoUserOnAuthTypesWebProxyCredentialsRequestGetwebProxyAddressCStr(webProxyAddress);

			csU?._mIGetAuthTypes?.OnAuthTypesWebProxyCredentialsRequest((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_webProxyAddress));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnCallCreated))]
#endif
		private static void OnCallCreatedDelegate(IntPtr u, IntPtr call, UserCallCreateResult result, IntPtr createToken){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Call csCall = null;
			if(call != IntPtr.Zero) {
				var csCallPtr = Call.VidyoCallGetUserDataNative(call);
				if (csCallPtr == IntPtr.Zero) {
					csCall = new Call(call);
					if (csCall != null) {
						csU?.objects?.Add(new WeakReference(csCall));
					}
				} else {
					csCall = (Call)GCHandle.FromIntPtr(csCallPtr).Target;
				}
			}

			var n_createToken = VidyoUserOnCallCreatedGetcreateTokenCStr(createToken);

			csU?._mICreateCall?.OnCallCreated(csCall, result, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_createToken));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnCallCreatedByInvite))]
#endif
		private static void OnCallCreatedByInviteDelegate(IntPtr u, IntPtr call, IntPtr inviter){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Call csCall = null;
			if(call != IntPtr.Zero) {
				var csCallPtr = Call.VidyoCallGetUserDataNative(call);
				if (csCallPtr == IntPtr.Zero) {
					csCall = new Call(call);
					if (csCall != null) {
						csU?.objects?.Add(new WeakReference(csCall));
					}
				} else {
					csCall = (Call)GCHandle.FromIntPtr(csCallPtr).Target;
				}
			}

			Contact csInviter = new Contact(inviter);
			csU?._mIRegisterCallEventListener?.OnCallCreatedByInvite(csCall, csInviter);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConnectionStatusChanged))]
#endif
		private static void OnConnectionStatusChangedDelegate(IntPtr u, UserConnectionStatusChangedReason reason){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			csU?._mILogin?.OnConnectionStatusChanged(reason);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnFavoriteRoomResults))]
#endif
		private static void OnFavoriteRoomResultsDelegate(IntPtr u, UserSearchResult searchResult, IntPtr roomInfo){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<RoomInfo> csRoomInfo = new List<RoomInfo>();
			var nRoomInfoSize = 0;
			var nRoomInfo = VidyoUserOnFavoriteRoomResultsGetroomInfoArrayNative(roomInfo, ref nRoomInfoSize);
			var nRoomInfoIndex = 0;
			while (nRoomInfoIndex < nRoomInfoSize) {
				RoomInfo csTroomInfo = new RoomInfo(Marshal.ReadIntPtr(nRoomInfo + (nRoomInfoIndex * Marshal.SizeOf(nRoomInfo))));
				csRoomInfo.Add(csTroomInfo);
				nRoomInfoIndex++;
			}

			csU?._mIGetFavoriteRooms?.OnFavoriteRoomResults(searchResult, csRoomInfo);
			VidyoUserOnFavoriteRoomResultsFreeroomInfoArrayNative(nRoomInfo, nRoomInfoSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetContactResult))]
#endif
		private static void OnGetContactResultDelegate(IntPtr u, IntPtr contact, UserGetContactResult result){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Contact csContact = new Contact(contact);
			csU?._mIGetContact?.OnGetContactResult(csContact, result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetCurrentRosterComplete))]
#endif
		private static void OnGetCurrentRosterCompleteDelegate(IntPtr u, IntPtr roster){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<Contact> csRoster = new List<Contact>();
			var nRosterSize = 0;
			var nRoster = VidyoUserOnGetCurrentRosterCompleteGetrosterArrayNative(roster, ref nRosterSize);
			var nRosterIndex = 0;
			while (nRosterIndex < nRosterSize) {
				Contact csTroster = new Contact(Marshal.ReadIntPtr(nRoster + (nRosterIndex * Marshal.SizeOf(nRoster))));
				csRoster.Add(csTroster);
				nRosterIndex++;
			}

			csU?._mIGetCurrentRoster?.OnGetCurrentRosterComplete(csRoster);
			VidyoUserOnGetCurrentRosterCompleteFreerosterArrayNative(nRoster, nRosterSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetLicenseKey))]
#endif
		private static void OnGetLicenseKeyDelegate(IntPtr u, IntPtr licenseKey){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			var n_licenseKey = VidyoUserOnGetLicenseKeyGetlicenseKeyCStr(licenseKey);

			csU?._mIRegisterLicenseEventListener?.OnGetLicenseKey((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_licenseKey));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetRecordingServiceProfiles))]
#endif
		private static void OnGetRecordingServiceProfilesDelegate(IntPtr u, IntPtr profiles, IntPtr prefixes, UserRecordingServiceResult result){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<String> csProfiles = new List<String>();
			var nProfilesSize = 0;
			var nProfiles = VidyoUserOnGetRecordingServiceProfilesGetprofilesArrayNative(profiles, ref nProfilesSize);
			var nProfilesIndex = 0;
			while (nProfilesIndex < nProfilesSize) {
				csProfiles.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nProfiles + (nProfilesIndex * Marshal.SizeOf(nProfiles)))));
				nProfilesIndex++;
			}

			List<String> csPrefixes = new List<String>();
			var nPrefixesSize = 0;
			var nPrefixes = VidyoUserOnGetRecordingServiceProfilesGetprefixesArrayNative(prefixes, ref nPrefixesSize);
			var nPrefixesIndex = 0;
			while (nPrefixesIndex < nPrefixesSize) {
				csPrefixes.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nPrefixes + (nPrefixesIndex * Marshal.SizeOf(nPrefixes)))));
				nPrefixesIndex++;
			}

			csU?._mIGetRecordingServiceProfiles?.OnGetRecordingServiceProfiles(csProfiles, csPrefixes, result);
			VidyoUserOnGetRecordingServiceProfilesFreeprefixesArrayNative(nPrefixes, nPrefixesSize);
			VidyoUserOnGetRecordingServiceProfilesFreeprofilesArrayNative(nProfiles, nProfilesSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLicenseReceived))]
#endif
		private static void OnLicenseReceivedDelegate(IntPtr u, IntPtr licenseKey){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			var n_licenseKey = VidyoUserOnLicenseReceivedGetlicenseKeyCStr(licenseKey);

			csU?._mIRegisterLicenseEventListener?.OnLicenseReceived((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_licenseKey));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLoggedOut))]
#endif
		private static void OnLoggedOutDelegate(IntPtr u, UserLogoutReason reason){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			csU?._mILogin?.OnLoggedOut(reason);
			csU?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLoginComplete))]
#endif
		private static void OnLoginCompleteDelegate(IntPtr u, UserLoginResult result, Boolean secure, IntPtr capabilities){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			TenantCapabilities csCapabilities = new TenantCapabilities(capabilities);
			csU?._mILogin?.OnLoginComplete(result, secure, csCapabilities);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPasswordResetUrl))]
#endif
		private static void OnPasswordResetUrlDelegate(IntPtr u, IntPtr passwordResetUrl){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			var n_passwordResetUrl = VidyoUserOnPasswordResetUrlGetpasswordResetUrlCStr(passwordResetUrl);

			csU?._mIGetPasswordResetUrl?.OnPasswordResetUrl((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_passwordResetUrl));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecentRoomResults))]
#endif
		private static void OnRecentRoomResultsDelegate(IntPtr u, UserSearchResult searchResult, IntPtr roomInfo){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<RoomInfo> csRoomInfo = new List<RoomInfo>();
			var nRoomInfoSize = 0;
			var nRoomInfo = VidyoUserOnRecentRoomResultsGetroomInfoArrayNative(roomInfo, ref nRoomInfoSize);
			var nRoomInfoIndex = 0;
			while (nRoomInfoIndex < nRoomInfoSize) {
				RoomInfo csTroomInfo = new RoomInfo(Marshal.ReadIntPtr(nRoomInfo + (nRoomInfoIndex * Marshal.SizeOf(nRoomInfo))));
				csRoomInfo.Add(csTroomInfo);
				nRoomInfoIndex++;
			}

			csU?._mIGetRecentRooms?.OnRecentRoomResults(searchResult, csRoomInfo);
			VidyoUserOnRecentRoomResultsFreeroomInfoArrayNative(nRoomInfo, nRoomInfoSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRefreshAccessToken))]
#endif
		private static void OnRefreshAccessTokenDelegate(IntPtr u, UserOperationResult result){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			csU?._mIRefreshAccessToken?.OnRefreshAccessToken(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoveRosterContact))]
#endif
		private static void OnRemoveRosterContactDelegate(IntPtr u, IntPtr uri){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			var n_uri = VidyoUserOnRemoveRosterContactGeturiCStr(uri);

			csU?._mIRegisterContactEventListener?.OnRemoveRosterContact((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_uri));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRoomCreated))]
#endif
		private static void OnRoomCreatedDelegate(IntPtr u, IntPtr room, UserRoomCreateResult result, IntPtr createToken){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Room csRoom = null;
			if(room != IntPtr.Zero) {
				var csRoomPtr = Room.VidyoRoomGetUserDataNative(room);
				if (csRoomPtr == IntPtr.Zero) {
					csRoom = new Room(room);
					if (csRoom != null) {
						csU?.objects?.Add(new WeakReference(csRoom));
					}
				} else {
					csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;
				}
			}

			var n_createToken = VidyoUserOnRoomCreatedGetcreateTokenCStr(createToken);

			csU?._mICreateRoomFromId?.OnRoomCreated(csRoom, result, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_createToken));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRoomCreatedByInvite))]
#endif
		private static void OnRoomCreatedByInviteDelegate(IntPtr u, IntPtr room, IntPtr inviter, IntPtr message){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Room csRoom = null;
			if(room != IntPtr.Zero) {
				var csRoomPtr = Room.VidyoRoomGetUserDataNative(room);
				if (csRoomPtr == IntPtr.Zero) {
					csRoom = new Room(room);
					if (csRoom != null) {
						csU?.objects?.Add(new WeakReference(csRoom));
					}
				} else {
					csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;
				}
			}

			Contact csInviter = new Contact(inviter);
			csU?._mIRegisterRoomEventListener?.OnRoomCreatedByInvite(csRoom, csInviter, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(message));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRoomInviteCancelled))]
#endif
		private static void OnRoomInviteCancelledDelegate(IntPtr u, IntPtr roomInfo, IntPtr message){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			RoomInfo csRoomInfo = new RoomInfo(roomInfo);
			csU?._mIRegisterRoomEventListener?.OnRoomInviteCancelled(csRoomInfo, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(message));
			csU?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRoomSearchResults))]
#endif
		private static void OnRoomSearchResultsDelegate(IntPtr u, IntPtr searchText, UserSearchResult searchResult, IntPtr roomInfo, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT numRecords){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<RoomInfo> csRoomInfo = new List<RoomInfo>();
			var nRoomInfoSize = 0;
			var nRoomInfo = VidyoUserOnRoomSearchResultsGetroomInfoArrayNative(roomInfo, ref nRoomInfoSize);
			var nRoomInfoIndex = 0;
			while (nRoomInfoIndex < nRoomInfoSize) {
				RoomInfo csTroomInfo = new RoomInfo(Marshal.ReadIntPtr(nRoomInfo + (nRoomInfoIndex * Marshal.SizeOf(nRoomInfo))));
				csRoomInfo.Add(csTroomInfo);
				nRoomInfoIndex++;
			}

			csU?._mIAdvancedSearchRooms?.OnRoomSearchResults((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(searchText), searchResult, csRoomInfo, numRecords);
			VidyoUserOnRoomSearchResultsFreeroomInfoArrayNative(nRoomInfo, nRoomInfoSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnTokenReceived))]
#endif
		private static void OnTokenReceivedDelegate(IntPtr u, IntPtr tokens){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<UserTokenInfo> csTokens = new List<UserTokenInfo>();
			var nTokensSize = 0;
			var nTokens = VidyoUserOnTokenReceivedGettokensArrayNative(tokens, ref nTokensSize);
			var nTokensIndex = 0;
			while (nTokensIndex < nTokensSize) {
				UserTokenInfo csTtokens = new UserTokenInfo(Marshal.ReadIntPtr(nTokens + (nTokensIndex * Marshal.SizeOf(nTokens))));
				csTokens.Add(csTtokens);
				nTokensIndex++;
			}

			csU?._mILogin?.OnTokenReceived(csTokens);
			VidyoUserOnTokenReceivedFreetokensArrayNative(nTokens, nTokensSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUpdateRosterContact))]
#endif
		private static void OnUpdateRosterContactDelegate(IntPtr u, IntPtr contact){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Contact csContact = new Contact(contact);
			csU?._mIRegisterContactEventListener?.OnUpdateRosterContact(csContact);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUpdateSelf))]
#endif
		private static void OnUpdateSelfDelegate(IntPtr u, IntPtr contact){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			Contact csContact = new Contact(contact);
			csU?._mIRegisterContactEventListener?.OnUpdateSelf(csContact);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUserSearchResults))]
#endif
		private static void OnUserSearchResultsDelegate(IntPtr u, IntPtr searchText, UserSearchResult searchResult, IntPtr contacts, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT numRecords){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			List<ContactInfo> csContacts = new List<ContactInfo>();
			var nContactsSize = 0;
			var nContacts = VidyoUserOnUserSearchResultsGetcontactsArrayNative(contacts, ref nContactsSize);
			var nContactsIndex = 0;
			while (nContactsIndex < nContactsSize) {
				ContactInfo csTcontacts = new ContactInfo(Marshal.ReadIntPtr(nContacts + (nContactsIndex * Marshal.SizeOf(nContacts))));
				csContacts.Add(csTcontacts);
				nContactsIndex++;
			}

			csU?._mIAdvancedSearchUsers?.OnUserSearchResults((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(searchText), searchResult, csContacts, numRecords);
			VidyoUserOnUserSearchResultsFreecontactsArrayNative(nContacts, nContactsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnWebProxyCredentialsRequest))]
#endif
		private static void OnWebProxyCredentialsRequestDelegate(IntPtr u, IntPtr webProxyAddress){
			var csUPtr = u != IntPtr.Zero ? VidyoUserGetUserDataNative(u) : IntPtr.Zero;
			if(csUPtr == IntPtr.Zero) return;
			var csU = (User)GCHandle.FromIntPtr(csUPtr).Target;

			var n_webProxyAddress = VidyoUserOnWebProxyCredentialsRequestGetwebProxyAddressCStr(webProxyAddress);

			csU?._mILogin?.OnWebProxyCredentialsRequest((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_webProxyAddress));
		}
	};
}
