//
//	VidyoAudioFrame_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * This object represents an audio frame.
 */
@interface VCAudioFrame : NSObject
{
	void* objPtr;
}
	/*!
	 * Bits per sample of the audio data which is based on the data format (16 bits for in16, 32 bits for fl32).
	 */
	@property unsigned int bitsPerSample;
	/*!
	 * Pointer to the frame's payload.
	 */
	@property long data;
	/*!
	 * Discontinuity has been detected.
	 */
	@property BOOL discontinuity;
	/*!
	 * Discontinuity bit has been set.
	 */
	@property BOOL discontinuityBitPresent;
	/*!
	 * Elapsed time since the beginning of frame capture that is increased by the duration of each frame.
	 */
	@property long elapsedTime;
	/*!
	 * Energy of the audio frame in dBFS (full scale).
	 */
	@property int energy;
	/*!
	 * Energy bit has been set.
	 */
	@property BOOL energyBitPresent;
	/*!
	 * Format of the audio frame.
	 */
	@property NSMutableString* format;
	/*!
	 * Number of channels.
	 */
	@property size_t numberOfChannels;
	/*!
	 * Number of samples.
	 */
	@property size_t numberOfSamples;
	/*!
	 * Number of samples per second.
	 */
	@property size_t sampleRate;
	/*!
	 * Size in bytes of the audio frame object's payload.
	 */
	@property size_t size;
	/*!
	 * Speech is detected in the frame.
	 */
	@property BOOL speech;
	/*!
	 * Speech bit has been set.
	 */
	@property BOOL speechBitPresent;
	/*!
	 * Wallclock timestamp associated with the creation of the audio frame object.
	 */
	@property long timestamp;
	-(void) dealloc;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(size_t) getBitsPerSample;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(long) getData;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(BOOL) getDiscontinuity;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(BOOL) getDiscontinuityBitPresent;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(long) getElapsedTime;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(int) getEnergy;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(BOOL) getEnergyBitPresent;
	/*!
	 * Gets the frame format.
	 * @param f The VidyoAudioFrame object.
	 */
	-(NSString*) getFormat;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(size_t) getNumberOfChannels;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(size_t) getNumberOfSamples;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(size_t) getSampleRate;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(size_t) getSize;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(BOOL) getSpeech;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(BOOL) getSpeechBitPresent;
	/*!
	 * .
	 * @param f The VidyoAudioFrame object.
	 */
	-(long) getTimestamp;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
