//
//	VidyoVirtualVideoSource_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoEndpoint_Objc.h"
#import "VidyoLocalRenderer_Objc.h"
#import "VidyoMediaFormats_Objc.h"
#import "VidyoRemoteRenderer_Objc.h"
#import "VidyoVideoFrame_Objc.h"
@protocol VCVirtualVideoSourceIRegisterEventListener
	/*!
	 * A callback invoked to notify that video source started after reconfiguration.
	 */
	-(void) startCallback:(long)frameInterval MediaFormat:(VCMediaFormat)mediaFormat UserData:(long)userData;
	/*!
	 * A callback invoked if configuration changed.
	 */
	-(void) reconfigureCallback:(long)frameInterval MediaFormat:(VCMediaFormat)mediaFormat UserData:(long)userData;
	/*!
	 * A callback invoked to notify that video source stoped after reconfiguration.
	 */
	-(void) stopCallback:(long)userData;
	/*!
	 * A callback invoked to notify application that VidyoClient is done with the buffer that holds raw video frame. This buffer is the same one that was passed to VidyoClient via function VidyoVirtualVideoSourceSendFrameWithExternalData.
	 */
	-(void) externalMediaBufferReleaseCallback:(unsigned char*)buffer Size:(size_t)size UserData:(long)userData;
@end
/*!
 * This object represents a virtual video source on the local endpoint.
 */
@interface VCVirtualVideoSource : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Constructs a virtual video source.
	 */
	id<VCVirtualVideoSourceIRegisterEventListener> virtualVideoSourceIRegisterEventListener;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name of the virtual video source.
	 */
	@property NSMutableString* name;
	/*!
	 * Type of the virtual video source.
	 */
	@property VCVirtualVideoSourceType type;
	/*!
	 * This object represents a virtual video source on the local endpoint.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param endpoint The VidyoEndpoint object.
	 * @param type Type of the virtual video source.
	 * @param id Unique ID.
	 * @param name Name of the virtual video source.
	 * @param alloc The allocator used to allocate the buffer.
	 */
	-(id) init:(VCEndpoint*)endpoint Type:(VCVirtualVideoSourceType)type Id:(NSMutableString*)id Name:(NSMutableString*)name;
	-(void) dealloc;
	/*!
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(long) addToLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(BOOL) addToRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Clears existing constraints and set them to default values 3840x2160@3fps for share and 1280x720@30fps for camera.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(BOOL) clearConstraints;
	/*!
	 * Gets the current encode frame interval of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(long) getCurrentEncodeFrameInterval;
	/*!
	 * Gets the unique ID of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the media format of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(VCMediaFormat) getMediaType;
	/*!
	 * Gets the name of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the preview label of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(NSString*) getPreviewLabel;
	/*!
	 * Gets the type of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(VCVirtualVideoSourceType) getType;
	/*!
	 * Check if source added to the local renderer.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(BOOL) isPreviewOn;
	/*!
	 * Check if source added to the remote renderer.
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(BOOL) isSelected;
	/*!
	 * @param mediaFormat The media format of video frame
	 */
	-(void) onFrame:(VCVideoFrame*)videoFrame MediaFormat:(VCMediaFormat)mediaFormat;
	/*!
	 * Constructs a virtual video source.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param onStart A callback invoked to notify that video source started after reconfiguration.
	 * @param onReconfigure A callback invoked if configuration changed.
	 * @param onStop A callback invoked to notify that video source stoped after reconfiguration.
	 * @param onBufferRelease Callback that is triggered each time when VidyoClient is done with an application allocated buffer that holds raw video frame.
	 */
	-(BOOL) registerEventListener:(id<VCVirtualVideoSourceIRegisterEventListener>)virtualVideoSourceIRegisterEventListener;
	/*!
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(BOOL) removeFromLocalRenderer:(VCLocalRenderer*)renderer;
	/*!
	 * @param s The VidyoVirtualVideoSource object.
	 */
	-(BOOL) removeFromRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * @param s The VidyoVirtualVideoSource object.
	 * @param format The media format of the video frame.
	 * @param buffer A pointer to externally allocated memory that holds the pixel data.
	 * @param size The size, in bytes, of the frame data.
	 * @param width The width of the video media frame in pixels.
	 * @param height The height of the video media frame in pixels.
	 */
	-(BOOL) sendFrameWithExternalData:(VCMediaFormat)format Buffer:(unsigned char*)buffer Size:(size_t)size Width:(size_t)width Height:(size_t)height;
	/*!
	 * Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param maxWidth Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit
	 * @param minWidth Unused
	 * @param maxHeight Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit
	 * @param minHeight Unused
	 */
	-(BOOL) setBoundsConstraints:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval MaxWidth:(unsigned int)maxWidth MinWidth:(unsigned int)minWidth MaxHeight:(unsigned int)maxHeight MinHeight:(unsigned int)minHeight;
	/*!
	 * Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc).
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param width The width of the stream after the stream is reconfigured.
	 * @param height The height of the stream after the stream is reconfigured.
	 */
	-(BOOL) setDiscreteConstraints:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval Width:(unsigned int)width Height:(unsigned int)height;
	/*!
	 * Sets the low latency profile of the video source which treats the stream as a regular video source. This prioritizes latency over quality.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param profile Low latency profile toggle. Default is LMI_FALSE.
	 */
	-(BOOL) setLowLatencyProfile:(BOOL)profile;
	/*!
	 * Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the source is in landscape mode width and height will be applied as max constraints, if the monitor is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
	 * @param s The VidyoVirtualVideoSource object.
	 * @param width Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.
	 * @param height Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
	 */
	-(BOOL) setMaxConstraints:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Set a minimum frame interval(maximum fps) for the encoded stream.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps) for share type and 33333333 (30fps) for camera. To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).
	 */
	-(BOOL) setMinFrameInterval:(long)frameInterval;
	/*!
	 * Set the preview label of the video source.
	 * @param s The VidyoVirtualVideoSource object.
	 * @param previewLabel Display name to set on the video source.
	 */
	-(BOOL) setPreviewLabel:(NSString*)previewLabel;
	/*!
	 * @param s The VidyoVirtualVideoSource object.
	 * @param frameInterval The interval in nanoseconds between consecutive frames.
	 */
	-(BOOL) setStreamParametersInLocalRenderer:(VCLocalRenderer*)localRenderer Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
