// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LatencyTestStatsFactory
	{
		public static LatencyTestStats Create()
		{
			return new LatencyTestStats(IntPtr.Zero);
		}
		public static void Destroy(LatencyTestStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a latency test.
	/// </summary>
	public class LatencyTestStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLatencyTestStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nLatencyTestDataStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * latencyTestDataStats.Count);
			int nLatencyTestDataStatsSize = 0;

			foreach (LatencyTestDataStats iter in latencyTestDataStats) {
				Marshal.WriteIntPtr(nLatencyTestDataStats + (nLatencyTestDataStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLatencyTestDataStatsSize++;
			}

			VidyoLatencyTestStatsSetlatencyTestDataStatsNative(objPtr, nLatencyTestDataStats, nLatencyTestDataStatsSize);

			Marshal.FreeHGlobal(nLatencyTestDataStats);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLatencyTestStatsGetlatencyTestDataStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestStatsSetlatencyTestDataStatsNative(IntPtr obj, IntPtr latencyTestDataStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLatencyTestStatsGetlatencyTestDataStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLatencyTestStatsFreelatencyTestDataStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLatencyTestStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLatencyTestStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLatencyTestStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Vector of stats data of latency test.
		/// </summary>
		public List<LatencyTestDataStats> latencyTestDataStats;
		public LatencyTestStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLatencyTestStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLatencyTestStatsConstructCopyNative(obj);
			}

			List<LatencyTestDataStats> csLatencyTestDataStats = new List<LatencyTestDataStats>();
			var nLatencyTestDataStatsSize = 0;
			var nLatencyTestDataStats = VidyoLatencyTestStatsGetlatencyTestDataStatsArrayNative(VidyoLatencyTestStatsGetlatencyTestDataStatsNative(objPtr), ref nLatencyTestDataStatsSize);
			var nLatencyTestDataStatsIndex = 0;
			while (nLatencyTestDataStatsIndex < nLatencyTestDataStatsSize) {
				LatencyTestDataStats csTlatencyTestDataStats = new LatencyTestDataStats(Marshal.ReadIntPtr(nLatencyTestDataStats + (nLatencyTestDataStatsIndex * Marshal.SizeOf(nLatencyTestDataStats))));
				csLatencyTestDataStats.Add(csTlatencyTestDataStats);
				nLatencyTestDataStatsIndex++;
			}

			latencyTestDataStats = csLatencyTestDataStats;
			VidyoLatencyTestStatsFreelatencyTestDataStatsArrayNative(nLatencyTestDataStats, nLatencyTestDataStatsSize);
		}
		~LatencyTestStats() {
			VidyoLatencyTestStatsDestructNative(objPtr);
		 }
	};
}
