// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LocalRendererStatsFactory
	{
		public static LocalRendererStats Create()
		{
			return new LocalRendererStats(IntPtr.Zero);
		}
		public static void Destroy(LocalRendererStats obj)
		{
		}
	}
	/// <summary>
	/// Statistics for a local renderer.
	/// </summary>
	public class LocalRendererStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalRendererStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoLocalRendererStatsSetformatNative(objPtr, format);
			VidyoLocalRendererStatsSetframeIntervalMeasuredNative(objPtr, frameIntervalMeasured);
			VidyoLocalRendererStatsSetframeIntervalSetNative(objPtr, frameIntervalSet);
			VidyoLocalRendererStatsSetheightNative(objPtr, height);
			VidyoLocalRendererStatsSetidNative(objPtr, nId);
			VidyoLocalRendererStatsSetnameNative(objPtr, nName);
			VidyoLocalRendererStatsSettotalFramesNative(objPtr, totalFrames);
			VidyoLocalRendererStatsSettotalPixelsNative(objPtr, totalPixels);
			VidyoLocalRendererStatsSetwidthNative(objPtr, width);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern MediaFormat VidyoLocalRendererStatsGetformatNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetformatNative(IntPtr obj, MediaFormat format);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalRendererStatsGetframeIntervalMeasuredNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetframeIntervalMeasuredNative(IntPtr obj, ulong frameIntervalMeasured);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalRendererStatsGetframeIntervalSetNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetframeIntervalSetNative(IntPtr obj, ulong frameIntervalSet);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLocalRendererStatsGetheightNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetheightNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalRendererStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalRendererStatsGettotalFramesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSettotalFramesNative(IntPtr obj, uint totalFrames);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalRendererStatsGettotalPixelsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSettotalPixelsNative(IntPtr obj, uint totalPixels);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLocalRendererStatsGetwidthNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalRendererStatsSetwidthNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT width);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalRendererStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalRendererStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalRendererStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Format.
		/// </summary>
		public MediaFormat format;
		/// <summary>
		/// Frame interval measured by the renderer.
		/// </summary>
		public ulong frameIntervalMeasured;
		/// <summary>
		/// Frame interval setting.
		/// </summary>
		public ulong frameIntervalSet;
		/// <summary>
		/// Height.
		/// </summary>
		public SizeT height;
		/// <summary>
		/// Id.
		/// </summary>
		public String id;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Total frames rendered.
		/// </summary>
		public uint totalFrames;
		/// <summary>
		/// Total pixels rendered.
		/// </summary>
		public uint totalPixels;
		/// <summary>
		/// Width.
		/// </summary>
		public SizeT width;
		public LocalRendererStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLocalRendererStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLocalRendererStatsConstructCopyNative(obj);
			}

			format = VidyoLocalRendererStatsGetformatNative(objPtr);
			frameIntervalMeasured = VidyoLocalRendererStatsGetframeIntervalMeasuredNative(objPtr);
			frameIntervalSet = VidyoLocalRendererStatsGetframeIntervalSetNative(objPtr);
			height = VidyoLocalRendererStatsGetheightNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalRendererStatsGetidNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalRendererStatsGetnameNative(objPtr));
			totalFrames = VidyoLocalRendererStatsGettotalFramesNative(objPtr);
			totalPixels = VidyoLocalRendererStatsGettotalPixelsNative(objPtr);
			width = VidyoLocalRendererStatsGetwidthNative(objPtr);
		}
		~LocalRendererStats() {
			VidyoLocalRendererStatsDestructNative(objPtr);
		 }
	};
}
