// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class MeetingAttendeeFactory
	{
		public static MeetingAttendee Create()
		{
			return new MeetingAttendee(IntPtr.Zero);
		}
		public static void Destroy(MeetingAttendee obj)
		{
		}
	}
	/// <summary>
	/// Stores information for a meeting attendee.
	/// </summary>
	public class MeetingAttendee {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoMeetingAttendee reference.
		public IntPtr GetObjectPtr() {
			IntPtr nEmail = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(email ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoMeetingAttendeeSetemailNative(objPtr, nEmail);
			VidyoMeetingAttendeeSetnameNative(objPtr, nName);
			VidyoMeetingAttendeeSetroleNative(objPtr, role);
			VidyoMeetingAttendeeSetstatusNative(objPtr, status);

			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nEmail);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingAttendeeGetemailNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingAttendeeSetemailNative(IntPtr obj, IntPtr email);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoMeetingAttendeeGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingAttendeeSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern AttendeeParticipationRole VidyoMeetingAttendeeGetroleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingAttendeeSetroleNative(IntPtr obj, AttendeeParticipationRole role);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern AttendeeParticipationStatus VidyoMeetingAttendeeGetstatusNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoMeetingAttendeeSetstatusNative(IntPtr obj, AttendeeParticipationStatus status);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMeetingAttendeeConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoMeetingAttendeeConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoMeetingAttendeeDestructNative(IntPtr obj);

		/// <summary>
		/// <p>This indicates the role of the local user in a meeting. </p> <p>Maps directly to participation roles defined in IETF RFC 5545. </p>
		/// </summary>
		public enum AttendeeParticipationRole {
			/// <summary></summary>
			AttendeeparticipationroleChair,
			/// <summary></summary>
			AttendeeparticipationroleRequired,
			/// <summary></summary>
			AttendeeparticipationroleOptional,
			/// <summary>Maps to NON-PARTICIPANT role in RFC type</summary>
			AttendeeparticipationroleInformational
		}
		/// <summary>
		/// <p>This indicates the role of the local user in a meeting. </p> <p>Maps directly to participation statuses defined in IETF RFC 5545. </p>
		/// </summary>
		public enum AttendeeParticipationStatus {
			/// <summary></summary>
			AttendeeparticipationstatusNeedsAction,
			/// <summary></summary>
			AttendeeparticipationstatusOrganized,
			/// <summary></summary>
			AttendeeparticipationstatusAccepted,
			/// <summary></summary>
			AttendeeparticipationstatusDeclined,
			/// <summary></summary>
			AttendeeparticipationstatusTentative,
			/// <summary></summary>
			AttendeeparticipationstatusDelegated,
			/// <summary>Response not required</summary>
			AttendeeparticipationstatusNone,
			/// <summary></summary>
			AttendeeparticipationstatusCompleted,
			/// <summary></summary>
			AttendeeparticipationstatusInProcess
		}
		/// <summary>
		/// Email for attendee.
		/// </summary>
		public String email;
		/// <summary>
		/// Attendee name as held by the underlying calendar service
		/// </summary>
		public String name;
		/// <summary>
		/// Role for the attendee as defined by the roleparam specified in RFC 5545
		/// </summary>
		public AttendeeParticipationRole role;
		/// <summary>
		/// Participation status of the attendee for the meeting as specified by the STATUS property name specified in RFC 5545
		/// </summary>
		public AttendeeParticipationStatus status;
		public MeetingAttendee(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoMeetingAttendeeConstructDefaultNative();
			}
			else {
				objPtr = VidyoMeetingAttendeeConstructCopyNative(obj);
			}

			email = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingAttendeeGetemailNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoMeetingAttendeeGetnameNative(objPtr));
			role = VidyoMeetingAttendeeGetroleNative(objPtr);
			status = VidyoMeetingAttendeeGetstatusNative(objPtr);
		}
		~MeetingAttendee() {
			VidyoMeetingAttendeeDestructNative(objPtr);
		 }
	};
}
