// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class RoomInfoFactory
	{
		public static RoomInfo Create()
		{
			return new RoomInfo(IntPtr.Zero);
		}
		public static void Destroy(RoomInfo obj)
		{
		}
	}
	/// <summary>
	/// descriptive details of a room.
	/// </summary>
	public class RoomInfo {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRoomInfo reference.
		public IntPtr GetObjectPtr() {
			IntPtr nDescription = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(description ?? string.Empty);
			IntPtr nExtension = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(extension ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nLanguage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(language ?? string.Empty);
			IntPtr nMessageList = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * messageList.Count);
			int nMessageListSize = 0;
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nOwnerList = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * ownerList.Count);
			int nOwnerListSize = 0;
			IntPtr nUserList = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * userList.Count);
			int nUserListSize = 0;

			foreach (ChatMessage iter in messageList) {
				Marshal.WriteIntPtr(nMessageList + (nMessageListSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nMessageListSize++;
			}
			foreach (String iter in ownerList) {
				Marshal.WriteIntPtr(nOwnerList + (nOwnerListSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nOwnerListSize++;
			}
			foreach (String iter in userList) {
				Marshal.WriteIntPtr(nUserList + (nUserListSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nUserListSize++;
			}

			VidyoRoomInfoSetcreationTimeNative(objPtr, creationTime);
			VidyoRoomInfoSetdescriptionNative(objPtr, nDescription);
			VidyoRoomInfoSetextensionNative(objPtr, nExtension);
			VidyoRoomInfoSetidNative(objPtr, nId);
			VidyoRoomInfoSetisFavoriteNative(objPtr, isFavorite);
			VidyoRoomInfoSetisMembersOnlyNative(objPtr, isMembersOnly);
			VidyoRoomInfoSetisPasswordProtectedNative(objPtr, isPasswordProtected);
			VidyoRoomInfoSetisPublicNative(objPtr, isPublic);
			VidyoRoomInfoSetisRoleChangeAllowedNative(objPtr, isRoleChangeAllowed);
			VidyoRoomInfoSetlanguageNative(objPtr, nLanguage);
			VidyoRoomInfoSetmaxParticipantsNative(objPtr, maxParticipants);
			VidyoRoomInfoSetmessageListNative(objPtr, nMessageList, nMessageListSize);
			VidyoRoomInfoSetnameNative(objPtr, nName);
			VidyoRoomInfoSetnumUsersNative(objPtr, numUsers);
			VidyoRoomInfoSetownerListNative(objPtr, nOwnerList, nOwnerListSize);
			VidyoRoomInfoSettypeNative(objPtr, type);
			VidyoRoomInfoSetuserListNative(objPtr, nUserList, nUserListSize);

			for (int i = 0; i < nOwnerListSize; i++) {
				Marshal.FreeHGlobal(Marshal.ReadIntPtr(nOwnerList + (i * Marshal.SizeOf<IntPtr>())));
			}
			for (int i = 0; i < nUserListSize; i++) {
				Marshal.FreeHGlobal(Marshal.ReadIntPtr(nUserList + (i * Marshal.SizeOf<IntPtr>())));
			}

			Marshal.FreeHGlobal(nUserList);
			Marshal.FreeHGlobal(nOwnerList);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nMessageList);
			Marshal.FreeHGlobal(nLanguage);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nExtension);
			Marshal.FreeHGlobal(nDescription);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoRoomInfoGetcreationTimeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetcreationTimeNative(IntPtr obj, ulong creationTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetdescriptionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetdescriptionNative(IntPtr obj, IntPtr description);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetextensionNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetextensionNative(IntPtr obj, IntPtr extension);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInfoGetisFavoriteNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetisFavoriteNative(IntPtr obj, Boolean isFavorite);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInfoGetisMembersOnlyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetisMembersOnlyNative(IntPtr obj, Boolean isMembersOnly);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInfoGetisPasswordProtectedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetisPasswordProtectedNative(IntPtr obj, Boolean isPasswordProtected);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInfoGetisPublicNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetisPublicNative(IntPtr obj, Boolean isPublic);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInfoGetisRoleChangeAllowedNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetisRoleChangeAllowedNative(IntPtr obj, Boolean isRoleChangeAllowed);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetlanguageNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetlanguageNative(IntPtr obj, IntPtr language);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomInfoGetmaxParticipantsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetmaxParticipantsNative(IntPtr obj, uint maxParticipants);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetmessageListNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetmessageListNative(IntPtr obj, IntPtr messageList, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetmessageListArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoFreemessageListArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoRoomInfoGetnumUsersNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetnumUsersNative(IntPtr obj, int numUsers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetownerListNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetownerListNative(IntPtr obj, IntPtr ownerList, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetownerListArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoFreeownerListArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Room.RoomType VidyoRoomInfoGettypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSettypeNative(IntPtr obj, Room.RoomType type);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetuserListNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoSetuserListNative(IntPtr obj, IntPtr userList, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInfoGetuserListArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomInfoFreeuserListArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRoomInfoConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRoomInfoConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRoomInfoDestructNative(IntPtr obj);

		/// <summary>
		/// Creation time of the room.
		/// </summary>
		public ulong creationTime;
		/// <summary>
		/// 
		/// </summary>
		public String description;
		/// <summary>
		/// 
		/// </summary>
		public String extension;
		/// <summary>
		/// 
		/// </summary>
		public String id;
		/// <summary>
		/// 
		/// </summary>
		public Boolean isFavorite;
		/// <summary>
		/// 
		/// </summary>
		public Boolean isMembersOnly;
		/// <summary>
		/// 
		/// </summary>
		public Boolean isPasswordProtected;
		/// <summary>
		/// 
		/// </summary>
		public Boolean isPublic;
		/// <summary>
		/// 
		/// </summary>
		public Boolean isRoleChangeAllowed;
		/// <summary>
		/// 
		/// </summary>
		public String language;
		/// <summary>
		/// 
		/// </summary>
		public uint maxParticipants;
		/// <summary>
		/// few messages send in the room.
		/// </summary>
		public List<ChatMessage> messageList;
		/// <summary>
		/// 
		/// </summary>
		public String name;
		/// <summary>
		/// Total number of users of the room.
		/// </summary>
		public int numUsers;
		/// <summary>
		/// List of owners of the room.
		/// </summary>
		public List<String> ownerList;
		/// <summary>
		/// 
		/// </summary>
		public Room.RoomType type;
		/// <summary>
		/// few people ever joined the room.
		/// </summary>
		public List<String> userList;
		public RoomInfo(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoRoomInfoConstructDefaultNative();
			}
			else {
				objPtr = VidyoRoomInfoConstructCopyNative(obj);
			}

			List<ChatMessage> csMessageList = new List<ChatMessage>();
			var nMessageListSize = 0;
			var nMessageList = VidyoRoomInfoGetmessageListArrayNative(VidyoRoomInfoGetmessageListNative(objPtr), ref nMessageListSize);
			var nMessageListIndex = 0;
			while (nMessageListIndex < nMessageListSize) {
				ChatMessage csTmessageList = new ChatMessage(Marshal.ReadIntPtr(nMessageList + (nMessageListIndex * Marshal.SizeOf(nMessageList))));
				csMessageList.Add(csTmessageList);
				nMessageListIndex++;
			}

			List<String> csOwnerList = new List<String>();
			var nOwnerListSize = 0;
			var nOwnerList = VidyoRoomInfoGetownerListArrayNative(VidyoRoomInfoGetownerListNative(objPtr), ref nOwnerListSize);
			var nOwnerListIndex = 0;
			while (nOwnerListIndex < nOwnerListSize) {
				csOwnerList.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nOwnerList + (nOwnerListIndex * Marshal.SizeOf(nOwnerList)))));
				nOwnerListIndex++;
			}

			List<String> csUserList = new List<String>();
			var nUserListSize = 0;
			var nUserList = VidyoRoomInfoGetuserListArrayNative(VidyoRoomInfoGetuserListNative(objPtr), ref nUserListSize);
			var nUserListIndex = 0;
			while (nUserListIndex < nUserListSize) {
				csUserList.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nUserList + (nUserListIndex * Marshal.SizeOf(nUserList)))));
				nUserListIndex++;
			}

			creationTime = VidyoRoomInfoGetcreationTimeNative(objPtr);
			description = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomInfoGetdescriptionNative(objPtr));
			extension = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomInfoGetextensionNative(objPtr));
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomInfoGetidNative(objPtr));
			isFavorite = VidyoRoomInfoGetisFavoriteNative(objPtr);
			isMembersOnly = VidyoRoomInfoGetisMembersOnlyNative(objPtr);
			isPasswordProtected = VidyoRoomInfoGetisPasswordProtectedNative(objPtr);
			isPublic = VidyoRoomInfoGetisPublicNative(objPtr);
			isRoleChangeAllowed = VidyoRoomInfoGetisRoleChangeAllowedNative(objPtr);
			language = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomInfoGetlanguageNative(objPtr));
			maxParticipants = VidyoRoomInfoGetmaxParticipantsNative(objPtr);
			messageList = csMessageList;
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomInfoGetnameNative(objPtr));
			numUsers = VidyoRoomInfoGetnumUsersNative(objPtr);
			ownerList = csOwnerList;
			type = VidyoRoomInfoGettypeNative(objPtr);
			userList = csUserList;
			VidyoRoomInfoFreeuserListArrayNative(nUserList, nUserListSize);
			VidyoRoomInfoFreeownerListArrayNative(nOwnerList, nOwnerListSize);
			VidyoRoomInfoFreemessageListArrayNative(nMessageList, nMessageListSize);
		}
		~RoomInfo() {
			VidyoRoomInfoDestructNative(objPtr);
		 }
	};
}
