#pragma once

#include <stdbool.h>

#include <bnb/error.h>
#include <bnb/export.h>

#ifdef __cplusplus
extern "C"
{
#endif

    /*
     * license_manager
     */
    /**
     * opaque object representing license_manager
     */
    typedef struct license_manager_holder license_manager_holder_t;
    typedef enum
    {
        valid,
        revoked,
        time_bombed
    } license_status_holder_t;

    /** Creates *new* `LicenceManager`. This metod won't change Banuba SDK internal state. */
    BNB_EXPORT license_manager_holder_t* bnb_license_manager_create(const char* client_token, bnb_error**);
    /**
     * Returns the instance used by Banuba SDK to check licence.
     * This istance was created by `UtilityManager.initialize`.
     */
    BNB_EXPORT license_manager_holder_t* bnb_license_manager_get_instance(bnb_error**);
    /** Destroys license_manager */
    BNB_EXPORT void bnb_license_manager_destroy(license_manager_holder_t* lm, bnb_error**);

    /** Checks if Client Token is expired. */
    BNB_EXPORT license_status_holder_t bnb_license_manager_is_expired(license_manager_holder_t* lm, bnb_error**);

    /**
     * Returns decoded content of Client Token
     * Returned string must be freed using bnb_memory_free()
     */
    BNB_EXPORT void bnb_license_manager_get_json(license_manager_holder_t* lm, char** json, bnb_error**);

#ifdef __cplusplus
} // extern "C"
#endif
