#include <bnb/glsl.frag>

BNB_IN(0)
vec2 var_uv;

BNB_IN(1)
vec2 var_glare_uv;

BNB_DECLARE_SAMPLER_2D(0, 1, lipstick_result);
BNB_DECLARE_SAMPLER_2D(2, 3, lips_glare_mask);

void main()
{
    vec4 camera_lipstick = BNB_TEXTURE_2D(BNB_SAMPLER_2D(lipstick_result), var_uv);
    vec4 glare_mask = BNB_TEXTURE_2D(BNB_SAMPLER_2D(lips_glare_mask), var_glare_uv);

    float max_brightness = lips_glare_max_brightness.x;

    float V = lips_glare_max_brightness.x * lips_glare_multiplier_alpha.x / 255.f;
    V = min(1.f, V);

    vec3 result = camera_lipstick.rgb;

    result.x = result.x * (1.f - glare_mask.x) + glare_mask.x * V;
    result.y = result.y * (1.f - glare_mask.x) + glare_mask.x * V;
    result.z = result.z * (1.f - glare_mask.x) + glare_mask.x * V;

    result = result * lips_glare_multiplier_alpha.y + camera_lipstick.rgb * (1.f - lips_glare_multiplier_alpha.y);

    bnb_FragColor = vec4(result, 1.f);
}
