#ifndef BORDER_STYLE_H
#define BORDER_STYLE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

typedef enum {
	/**
	 * Put a border on each tile, but tiles associated with the highest ranked participant will have a different colored border than the others.
	 */
	BORDER_STYLE_HIGHLIGHT = 0,
	/**
	 * Tiles associated with the highest ranked participant have a different colored border than the others, When the highest ranked participant changes, the border of the new highest ranked participant flashes momentarily.
	 */
	BORDER_STYLE_FLASH = 1,
	/**
	 * Put the same colored border on each tile
	 */
	BORDER_STYLE_SAME = 2,
	/**
	 * Do not put a border on any tiles
	 */
	BORDER_STYLE_NONE = 3,
} NgrBorderStyle;

#ifdef __cplusplus
}
#endif

#endif /* BORDER_STYLE_H */
