#ifndef DIMENSION_KIND_H
#define DIMENSION_KIND_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/**
 * Specifies how to calculate pixel value of the size or offset
 */
typedef enum {
	/**
	 * Absolute value in pixels
	 */
	DIMENSION_KIND_PX = 0,
	/**
	 * Absolute value in density-aware pixels (scales with the surface's density)
	 */
	DIMENSION_KIND_DP = 1,
	/**
	 * Fraction (0.0 - 1.0) of the parent object's size
	 */
	DIMENSION_KIND_FRACTION_OF_PARENT = 2,
	/**
	 * Fraction (0.0 - 1.0) of the root surface object's size
	 */
	DIMENSION_KIND_FRACTION_OF_SURFACE = 3,
} NgrDimensionKind;

#ifdef __cplusplus
}
#endif

#endif /* DIMENSION_KIND_H */
