#ifndef EDGE_INSET_H
#define EDGE_INSET_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrDimension.h"

/**
 * Content offset from each side
 */
typedef struct {
	NgrDimension left;
	NgrDimension top;
	NgrDimension right;
	NgrDimension bottom;
} NgrEdgeInset;

void NgrEdgeInsetAcquireRef(const NgrEdgeInset* ptr);
void NgrEdgeInsetReleaseRef(const NgrEdgeInset* ptr);

#ifdef __cplusplus
}
#endif

#endif /* EDGE_INSET_H */
