#ifndef PLUGIN_H
#define PLUGIN_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrDynamicTexture.h"
#include "NgrSurface.h"

typedef struct {
	uintptr_t value;
} NgrPluginHandle;

typedef void (*NgrPluginCreateSurfaceCallback) (const void* userData, NgrSurfaceHandle* value, const char* error);
typedef void (*NgrPluginCreateDynamicTextureCallback) (const void* userData, NgrDynamicTextureHandle* value, const char* error);

void NgrPluginAcquireRef(NgrPluginHandle handle);
void NgrPluginReleaseRef(NgrPluginHandle handle);

/**
 * Get plugin info handle
 * Plugin instance is created by passing this handle to the VidyoClient/VidyoConnector registerPlugin function
 */
uintptr_t NgrPluginGetPluginInfo();

/**
 * Create new surface based on the platform window handle
 *
 * Special helper must be used for the platforms where window cannot be represented as a pointer/integer:
 * * Android - com.vidyo.renderer.utils.SurfaceHandle
 *
 * # Arguments
 * * `surface` - Surface handle
 * * `result` - Surface or error otherwise
 */
void NgrPluginCreateSurface(
	NgrPluginHandle handle,
	uintptr_t surface,
	const NgrUserData callback_userData,
	NgrPluginCreateSurfaceCallback callback
);

/**
 * Create new dynamic texture
 *
 * Texture size and format will dynamically change based on the uploaded data
 *
 * # Arguments
 * * `id` - ID of the plugin
 * * `result` - DynamicTexture or error otherwise
 */
void NgrPluginCreateDynamicTexture(
	NgrPluginHandle handle,
	const NgrUserData callback_userData,
	NgrPluginCreateDynamicTextureCallback callback
);


#ifdef __cplusplus
}
#endif

#endif /* PLUGIN_H */
