#ifndef PREVIEW_POSITION_H
#define PREVIEW_POSITION_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

typedef enum {
	/**
	 * top right position on the screen
	 */
	PREVIEW_POSITION_TOP_RIGHT = 0,
	/**
	 * bottom right position on the screen
	 */
	PREVIEW_POSITION_BOTTOM_RIGHT = 1,
	/**
	 * top left position on the screen
	 */
	PREVIEW_POSITION_TOP_LEFT = 2,
	/**
	 * bottom left position on the screen
	 */
	PREVIEW_POSITION_BOTTOM_LEFT = 3,
	/**
	 * center right position on the screen
	 */
	PREVIEW_POSITION_CENTER_RIGHT = 4,
	/**
	 * center left position on the screen
	 */
	PREVIEW_POSITION_CENTER_LEFT = 5,
	/**
	 * top center position on the screen
	 */
	PREVIEW_POSITION_TOP_CENTER = 6,
	/**
	 * center center position on the screen
	 */
	PREVIEW_POSITION_CENTER_CENTER = 7,
	/**
	 * bottom center position on the screen
	 */
	PREVIEW_POSITION_BOTTOM_CENTER = 8,
} NgrPreviewPosition;

#ifdef __cplusplus
}
#endif

#endif /* PREVIEW_POSITION_H */
