#ifndef TEXTURE_PLANE_H
#define TEXTURE_PLANE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"

/**
 * Texture plane info
 */
typedef struct {
	NgrBufferView buffer;
	uint32_t stride;
} NgrTexturePlane;

void NgrTexturePlaneAcquireRef(const NgrTexturePlane* ptr);
void NgrTexturePlaneReleaseRef(const NgrTexturePlane* ptr);

#ifdef __cplusplus
}
#endif

#endif /* TEXTURE_PLANE_H */
