#ifndef ALIGNMENT_H
#define ALIGNMENT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/**
 * Alignment for horizontal or vertical axis
 */
typedef enum {
	/**
	 * Align to the nearest side (for ex. left or top)
	 */
	ALIGNMENT_START = 0,
	/**
	 * Align in the middle
	 */
	ALIGNMENT_CENTER = 1,
	/**
	 * Align to the farthest side (for ex. right or bottom)
	 */
	ALIGNMENT_END = 2,
} NgrAlignment;

#ifdef __cplusplus
}
#endif

#endif /* ALIGNMENT_H */
