#ifndef BLEND_MODE_H
#define BLEND_MODE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/**
 * Alpha compositing modes.
 *
 * Detailed information can be found here:
 * https://developer.android.com/reference/android/graphics/PorterDuff.Mode
 */
typedef enum {
	/**
	 * Destination pixels covered by the source are cleared to 0.
	 */
	BLEND_MODE_CLEAR = 0,
	/**
	 * The source pixels replace the destination pixels.
	 */
	BLEND_MODE_SRC = 1,
	/**
	 * The source pixels are discarded, leaving the destination intact.
	 */
	BLEND_MODE_DST = 2,
	/**
	 * The source pixels are drawn over the destination pixels.
	 */
	BLEND_MODE_SRC_OVER = 3,
	/**
	 * The source pixels are drawn behind the destination pixels.
	 */
	BLEND_MODE_DST_OVER = 4,
	/**
	 * Keeps the source pixels that cover the destination pixels, discards the remaining source and destination pixels.
	 */
	BLEND_MODE_SRC_IN = 5,
	/**
	 * Keeps the destination pixels that cover source pixels, discards the remaining source and destination pixels.
	 */
	BLEND_MODE_DST_IN = 6,
	/**
	 * Keeps the source pixels that do not cover destination pixels.
	 */
	BLEND_MODE_SRC_OUT = 7,
	/**
	 * Keeps the destination pixels that are not covered by source pixels.
	 */
	BLEND_MODE_DST_OUT = 8,
	/**
	 * Discards the source pixels that do not cover destination pixels.
	 */
	BLEND_MODE_SRC_ATOP = 9,
	/**
	 * Discards the destination pixels that are not covered by source pixels.
	 */
	BLEND_MODE_DST_ATOP = 10,
	/**
	 * Discards the source and destination pixels where source pixels cover destination pixels.
	 */
	BLEND_MODE_XOR = 11,
	/**
	 * Adds the source pixels to the destination pixels and saturates the result.
	 */
	BLEND_MODE_ADD = 12,
	/**
	 * Multiplies the source and destination pixels.
	 */
	BLEND_MODE_MULTIPLY = 13,
	/**
	 * Adds the source and destination pixels, then subtracts the source pixels multiplied by the destination.
	 */
	BLEND_MODE_SCREEN = 14,
	/**
	 * Multiplies or screens the source and destination depending on the destination color.
	 */
	BLEND_MODE_OVERLAY = 15,
	/**
	 * Retains the smallest component of the source and destination pixels.
	 */
	BLEND_MODE_DARKEN = 16,
	/**
	 * Retains the largest component of the source and destination pixel.
	 */
	BLEND_MODE_LIGHTEN = 17,
} NgrBlendMode;

#ifdef __cplusplus
}
#endif

#endif /* BLEND_MODE_H */
