#ifndef DIMENSION_H
#define DIMENSION_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrDimensionKind.h"

/**
 * Size or offset specified absolutely or relatively
 */
typedef struct {
	float value;
	NgrDimensionKind kind;
} NgrDimension;

void NgrDimensionAcquireRef(const NgrDimension* ptr);
void NgrDimensionReleaseRef(const NgrDimension* ptr);

#ifdef __cplusplus
}
#endif

#endif /* DIMENSION_H */
