#ifndef DYNAMIC_TEXTURE_H
#define DYNAMIC_TEXTURE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrTextureInfo.h"

typedef struct {
	uintptr_t value;
} NgrDynamicTextureHandle;

typedef void (*NgrDynamicTextureReleaseCallback) (const void* userData, const char* error);
typedef void (*NgrDynamicTextureUploadCallback) (const void* userData, const char* error);

void NgrDynamicTextureAcquireRef(NgrDynamicTextureHandle handle);
void NgrDynamicTextureReleaseRef(NgrDynamicTextureHandle handle);

/**
 * Release texture
 *
 * # Arguments
 * * `callback` - error if occurred
 */
void NgrDynamicTextureRelease(
	NgrDynamicTextureHandle handle,
	const NgrUserData callback_userData,
	NgrDynamicTextureReleaseCallback callback
);

/**
 * Upload texture image info
 *
 * Note: Buffer must be valid until callback is triggered
 *
 * # Arguments
 * * `info` - Image info that will be used
 * * `callback` - error if occurred
 */
void NgrDynamicTextureUpload(
	NgrDynamicTextureHandle handle,
	NgrTextureInfo info,
	const NgrUserData callback_userData,
	NgrDynamicTextureUploadCallback callback
);


#ifdef __cplusplus
}
#endif

#endif /* DYNAMIC_TEXTURE_H */
