#ifndef GESTURE_EVENT_H
#define GESTURE_EVENT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrGestureEventKind.h"

/**
 * Gesture (touch, mouse, etc.) input event
 */
typedef struct {
	NgrGestureEventKind kind;
	uintptr_t pointerId;
	float positionX;
	float positionY;
	float magnification;
} NgrGestureEvent;

void NgrGestureEventAcquireRef(const NgrGestureEvent* ptr);
void NgrGestureEventReleaseRef(const NgrGestureEvent* ptr);

#ifdef __cplusplus
}
#endif

#endif /* GESTURE_EVENT_H */
