#ifndef GESTURE_EVENT_KIND_H
#define GESTURE_EVENT_KIND_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/**
 * Kind of the gesture event
 */
typedef enum {
	/**
	 * Pointer gesture has started
	 */
	GESTURE_EVENT_KIND_DOWN = 0,
	/**
	 * Pointer has moved to a different
	 */
	GESTURE_EVENT_KIND_MOVE = 1,
	/**
	 * Pointer gesture has ended
	 */
	GESTURE_EVENT_KIND_UP = 2,
	/**
	 * Pointer gesture has ended and ignored
	 */
	GESTURE_EVENT_KIND_CANCEL = 3,
	/**
	 * Magnification has start
	 */
	GESTURE_EVENT_KIND_MAGNIFY = 4,
} NgrGestureEventKind;

#ifdef __cplusplus
}
#endif

#endif /* GESTURE_EVENT_KIND_H */
