#ifndef POSITION_H
#define POSITION_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrDimension.h"

/**
 * Position of the object on the plane
 */
typedef struct {
	NgrDimension x;
	NgrDimension y;
	NgrDimension w;
	NgrDimension h;
} NgrPosition;

void NgrPositionAcquireRef(const NgrPosition* ptr);
void NgrPositionReleaseRef(const NgrPosition* ptr);

#ifdef __cplusplus
}
#endif

#endif /* POSITION_H */
