#ifndef SCALE_KIND_H
#define SCALE_KIND_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>

/**
 * How a box should be inscribed into another box
 */
typedef enum {
	/**
	 * Fill the target box by distorting the source's aspect ratio
	 */
	SCALE_KIND_FILL = 0,
	/**
	 * Align the source within the target box (by default, centering) and discard any portions of the source that lie outside the box
	 */
	SCALE_KIND_ONE_TO_ONE = 1,
	/**
	 * As small as possible while still covering the entire target box
	 */
	SCALE_KIND_COVER = 2,
	/**
	 * As large as possible while still containing the source entirely within the target box
	 */
	SCALE_KIND_CONTAIN = 3,
	/**
	 * Align the source within the target box (by default, centering) and, if necessary, scale the source down to ensure that the source fits within the box
	 */
	SCALE_KIND_SCALE_DOWN = 4,
} NgrScaleKind;

#ifdef __cplusplus
}
#endif

#endif /* SCALE_KIND_H */
