#ifndef SELF_PREVIEW_LAYOUT_H
#define SELF_PREVIEW_LAYOUT_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrTileStyle.h"

typedef struct {
	uintptr_t value;
} NgrSelfPreviewLayoutHandle;

typedef void (*NgrSelfPreviewLayoutReleaseCallback) (const void* userData, const char* error);
typedef void (*NgrSelfPreviewLayoutActivateCallback) (const void* userData, const char* error);
typedef void (*NgrSelfPreviewLayoutGetTileStyleCallback) (const void* userData, NgrTileStyleHandle* value, const char* error);

void NgrSelfPreviewLayoutAcquireRef(NgrSelfPreviewLayoutHandle handle);
void NgrSelfPreviewLayoutReleaseRef(NgrSelfPreviewLayoutHandle handle);

/**
 * Release layout
 *
 * # Arguments
 * * `callback` - error if occurred
 */
void NgrSelfPreviewLayoutRelease(
	NgrSelfPreviewLayoutHandle handle,
	const NgrUserData callback_userData,
	NgrSelfPreviewLayoutReleaseCallback callback
);

/**
 * Activate layout
 *
 * Only one layout can be active at once
 *
 * # Arguments
 * * `callback` - error if occurred
 */
void NgrSelfPreviewLayoutActivate(
	NgrSelfPreviewLayoutHandle handle,
	const NgrUserData callback_userData,
	NgrSelfPreviewLayoutActivateCallback callback
);

/**
 * Get style for the tile
 *
 * # Arguments
 * * `callback` - error if occurred
 */
void NgrSelfPreviewLayoutGetTileStyle(
	NgrSelfPreviewLayoutHandle handle,
	const NgrUserData callback_userData,
	NgrSelfPreviewLayoutGetTileStyleCallback callback
);


#ifdef __cplusplus
}
#endif

#endif /* SELF_PREVIEW_LAYOUT_H */
