#ifndef TEXTURE_INFO_H
#define TEXTURE_INFO_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrTextureFormat.h"
#include "NgrTexturePlane.h"

/**
 * Texture info
 */
typedef struct {
	uint32_t width;
	uint32_t height;
	NgrTextureFormat format;
	NgrTexturePlane planes[3];
} NgrTextureInfo;

void NgrTextureInfoAcquireRef(const NgrTextureInfo* ptr);
void NgrTextureInfoReleaseRef(const NgrTextureInfo* ptr);

#ifdef __cplusplus
}
#endif

#endif /* TEXTURE_INFO_H */
