#ifndef TILE_STYLE_H
#define TILE_STYLE_H

#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>

#include "NgrGeneralUtils.h"
#include "NgrBorderStyle.h"
#include "NgrDimension.h"
#include "NgrEdgeInset.h"
#include "NgrFECCPlacement.h"
#include "NgrFECCType.h"

typedef struct {
	uintptr_t value;
} NgrTileStyleHandle;


void NgrTileStyleAcquireRef(NgrTileStyleHandle handle);
void NgrTileStyleReleaseRef(NgrTileStyleHandle handle);

/**
 * Put tile style label visible
 *
 * # Arguments
 * * `value` - Label visible value
 */
void NgrTileStyleSetLabelVisible(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put tile margin
 *
 * # Arguments
 * * `value` - Margin value
 */
void NgrTileStyleSetMargin(
	NgrTileStyleHandle handle,
	NgrEdgeInset value
);

/**
 * Put tile avatar foreground color
 *
 * # Arguments
 * * `value` - RGBA avatar foreground color value
 */
void NgrTileStyleSetAvatarForegroundColor(
	NgrTileStyleHandle handle,
	uint32_t value
);

/**
 * Put avatar background color
 *
 * # Arguments
 * * `value` - RGBA avatar background color value
 */
void NgrTileStyleSetAvatarBackgroundColor(
	NgrTileStyleHandle handle,
	uint32_t value
);

/**
 * Put audio level visible
 *
 * # Arguments
 * * `value` - Audio level visible value
 */
void NgrTileStyleSetAudioLevelVisible(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put audio level noise color
 *
 * # Arguments
 * * `value` - Audio level noise color value
 */
void NgrTileStyleSetAudioLevelNoiseColor(
	NgrTileStyleHandle handle,
	uint32_t value
);

/**
 * Put audio level speech color
 *
 * # Arguments
 * * `value` - Audio level speech color value
 */
void NgrTileStyleSetAudioLevelSpeechColor(
	NgrTileStyleHandle handle,
	uint32_t value
);

/**
 * Put loudest border visible
 *
 * # Arguments
 * * `value` - Loudest border visible value
 */
void NgrTileStyleSetLoudestBorderVisible(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put loudest border color
 *
 * # Arguments
 * * `value` - Loudest border color value
 */
void NgrTileStyleSetLoudestBorderColor(
	NgrTileStyleHandle handle,
	uint32_t value
);

/**
 * Put loudest border sixe
 *
 * # Arguments
 * * `value` - Loudest border size value
 */
void NgrTileStyleSetLoudestBorderSize(
	NgrTileStyleHandle handle,
	NgrDimension value
);

/**
 * Put fecc icon visible
 *
 * # Arguments
 * * `value` - Fecc icon visible value
 */
void NgrTileStyleSetFeccIconVisible(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put fecc icon placement
 *
 * # Arguments
 * * `value` - FECC icon placement value
 */
void NgrTileStyleSetFeccIconPlacement(
	NgrTileStyleHandle handle,
	NgrFECCPlacement value
);

/**
 * Put fecc control visible
 *
 * # Arguments
 * * `value` - FECC control visible value
 */
void NgrTileStyleSetFeccControlVisible(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put fecc control extended enable
 *
 * # Arguments
 * * `value` - FECC control extended enable value
 */
void NgrTileStyleSetFeccControlExtendedEnable(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put custome fecc svg
 *
 * # Arguments
 * * `value` - Custom FECC svg value
 */
void NgrTileStyleSetCustomFeccSvg(
	NgrTileStyleHandle handle,
	NgrFECCType feccType,
	const char* value
);

/**
 * Put preview mirroring enable
 *
 * # Arguments
 * * `value` - FECC preview mirroring enable value
 */
void NgrTileStyleSetPreviewMirroring(
	NgrTileStyleHandle handle,
	bool value
);

/**
 * Put border style
 *
 * # Arguments
 * * `style` - border style
 */
void NgrTileStyleSetBorderStyle(
	NgrTileStyleHandle handle,
	NgrBorderStyle style
);

/**
 * Put vertical video centering enable
 *
 * # Arguments
 * * `value` - vertical video centering enable value
 */
void NgrTileStyleSetVerticalVideoCentering(
	NgrTileStyleHandle handle,
	bool value
);


#ifdef __cplusplus
}
#endif

#endif /* TILE_STYLE_H */
