//
//	VidyoChatMessage_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * @enum Type of the VidyoChatMessage sender.
 * @constant VCChatMessageSenderTypeUser VidyoChatMessage is from a VidyoUser represented by VidyoParticipant in VidyoRoom/VidyoCall.
 * @constant VCChatMessageSenderTypeRoom VidyoChatMessage is from a VidyoRoom.
 * @constant VCChatMessageSenderTypeSystem VidyoChatMessage is from the system.
 * @constant VCChatMessageSenderTypeNone Sender type is not set.
 */
typedef NS_ENUM(NSInteger, VCChatMessageSenderType) {
	VCChatMessageSenderTypeUser,
	VCChatMessageSenderTypeRoom,
	VCChatMessageSenderTypeSystem,
	VCChatMessageSenderTypeNone
};
/*!
 * @enum Type of a message. This type will depend on the content of the message or where it originated.
 * @constant VCChatMessageTypeChat Text chat message from another VidyoParticipant.
 * @constant VCChatMessageTypeMediaStart Media was enabled in the room. This indicates that someone enabled their camera/microphone/etc and would like to escalate the VidyoRoom to audio/video.
 * @constant VCChatMessageTypeMediaStop Media was disabled in the room. This indicates that there are no more audio/video in the VidyoRoom.
 * @constant VCChatMessageTypePrivateChat Private text chat message from another VidyoParticipant.
 */
typedef NS_ENUM(NSInteger, VCChatMessageType) {
	VCChatMessageTypeChat,
	VCChatMessageTypeMediaStart,
	VCChatMessageTypeMediaStop,
	VCChatMessageTypePrivateChat
};
/*!
 * @enum Typing indicator of VidyoParticipant state in the VidyoRoom.
 * @constant VCChatMessageTypingIndicationActive Active and responsive.
 * @constant VCChatMessageTypingIndicationComposing Composing a text message.
 * @constant VCChatMessageTypingIndicationGone Closed the chat window.
 * @constant VCChatMessageTypingIndicationInactive Inactive for reasons such as the chat is out of focus.
 * @constant VCChatMessageTypingIndicationPaused Paused composing a message.
 * @constant VCChatMessageTypingIndicationNone Not set.
 */
typedef NS_ENUM(NSInteger, VCChatMessageTypingIndication) {
	VCChatMessageTypingIndicationActive,
	VCChatMessageTypingIndicationComposing,
	VCChatMessageTypingIndicationGone,
	VCChatMessageTypingIndicationInactive,
	VCChatMessageTypingIndicationPaused,
	VCChatMessageTypingIndicationNone
};
/*!
 * Contains the text message and additional information about who sent it and when.
 */
@interface VCChatMessage : NSObject
{
}
	/*!
	 * The body of the VidyoChatMessage.
	 */
	@property NSMutableString* body;
	/*!
	 * Unique ID of the VidyoChatMessage.
	 */
	@property long long id;
	/*!
	 * The type of the sender.
	 */
	@property VCChatMessageSenderType senderType;
	/*!
	 * The time when the message was created.
	 */
	@property long timestamp;
	/*!
	 * The type of VidyoChatMessage.
	 */
	@property VCChatMessageType type;
	/*!
	 * Unique ID of a VidyoParticipant who sent the message or NULL depending on the VidyoChatMessageSenderType.
	 */
	@property NSMutableString* userId;
	/*!
	 * Name of a VidyoParticipant who sent the message.
	 */
	@property NSMutableString* userName;
@end
