/**
{file:
	{name: LmiCrc32.h}
	{description: Calculation of the V.42 CRC-32.}
	{copyright:
		(c) 2016 Vidyo, Inc.,
		433 Hackensack Avenue,
		Hackensack, NJ  07601.

		All rights reserved.

		The information contained herein is proprietary to Vidyo, Inc.
		and shall not be reproduced, copied (in whole or in part), adapted,
		modified, disseminated, transmitted, transcribed, stored in a retrieval
		system, or translated into any language in any form by any means
		without the express written consent of Vidyo, Inc.
		                  ***** CONFIDENTIAL *****
	}
}
*/
#ifndef LMI_CRC32_H
#define LMI_CRC32_H

#include <Lmi/Utils/LmiTypes.h>

LMI_BEGIN_EXTERN_C



/**
{package visibility="private":
	{name: Crc32}
	{parent: Utils}
	{include: Lmi/Utils/LmiCrc32.h}
	{description: Utilities for the calculation of the V.42 CRC-32 (Cyclic redundancy
		check).}
}
*/


/**
	{function visibility="private":
		{name: LmiCrc32Compute}
		{parent: Crc32}
		{description: Compute a CRC-32 over a buffer of data.}
		{prototype: LmiUint32 LmiCrc32Compute(const LmiUint8* data, LmiSizeT len)}
		{parameter:
			{name: data}
			{description: The data over which to compute the CRC-32.}}
		{parameter:
			{name: len}
			{description: The length of the data.}}
		{return: The CRC-32 of the data.}
	}
*/
LMI_INLINE_DECLARATION LmiUint32 LmiCrc32Compute(const LmiUint8* data, LmiSizeT len);


/**
	{function visibility="private":
		{name: LmiCrc32Update}
		{parent: Crc32}
		{description: Update an existing CRC-32 with an additional buffer of data.}
		{prototype: LmiUint32 LmiCrc32Update(LmiUint32 crc32, const LmiUint8* data, LmiSizeT len)}
		{parameter:
			{name: crc32}
			{description: An existing CRC-32 value, as produced by a previous call to LmiCrc32Compute or LmiCrc32Update.}}
		{parameter:
			{name: data}
			{description: The data over which to compute the additional CRC-32.}}
		{parameter:
			{name: len}
			{description: The length of the data}}
		{return: The updated CRC-32.}
	}
*/
LmiUint32 LmiCrc32Update(LmiUint32 crc32, const LmiUint8* data, LmiSizeT len);


extern const LmiUint32 lmiCrc32Table_[256];

LMI_END_EXTERN_C

#if LMI_INLINE_NEED_HEADER_FILE_DEFINITIONS
#include <Lmi/Utils/LmiCrc32Inline.h>
#endif

#endif
