//
//	VidyoDevice_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoCameraControlCapabilities_Objc.h"
/*!
 * @enum Sets the type of the auido signal which determines how it is processed such as noise suppression, echo cancellation etc.
 * @constant VCDeviceAudioSignalTypeVoice Default type which will do echo cancellation, noise suppresstion etc.
 * @constant VCDeviceAudioSignalTypeUnprocessed Does not alter audio singal by having all the audio processing disabled.
 */
typedef NS_ENUM(NSInteger, VCDeviceAudioSignalType) {
	VCDeviceAudioSignalTypeVoice,
	VCDeviceAudioSignalTypeUnprocessed
};
/*!
 * @enum Orientations of the device.
 * @constant VCDeviceOrientationUP Up
 * @constant VCDeviceOrientationDOWN Down
 * @constant VCDeviceOrientationLEFT Left
 * @constant VCDeviceOrientationRIGHT Right
 */
typedef NS_ENUM(NSInteger, VCDeviceOrientation) {
	VCDeviceOrientationUP,
	VCDeviceOrientationDOWN,
	VCDeviceOrientationLEFT,
	VCDeviceOrientationRIGHT
};
/*!
 * @enum Operational state of a device.
 * @constant VCDeviceStateAdded The device was added to the system.
 * @constant VCDeviceStateRemoved The device was removed from the system.
 * @constant VCDeviceStateStarted The device started successfully.
 * @constant VCDeviceStateStopped The device stopped.
 * @constant VCDeviceStateSuspended The device was suspended and the frames can no longer be captured.
 * @constant VCDeviceStateUnsuspended The device was unsuspended.
 * @constant VCDeviceStateInUse The device is in use by another application.
 * @constant VCDeviceStateAvailable The device that was previousely in use is now available.
 * @constant VCDeviceStatePaused The device was paused (muted) and no media will be sent.
 * @constant VCDeviceStateResumed The device was resumed (unmuted) and media will be sent.
 * @constant VCDeviceStateControlledByRemoteEntity The device is under Remote control (i.e if paused, can only be resumed by remote controller.
 * @constant VCDeviceStateNotControlledByRemoteEntity The device is not under Remote control anymore.
 * @constant VCDeviceStateControllable The device PTZ is controllable.
 * @constant VCDeviceStateNotControllable The device PTZ is not controllable.
 * @constant VCDeviceStateDefaultChanged The device default device has changed.
 * @constant VCDeviceStateConfigureSuccess The device configured successfully.
 * @constant VCDeviceStateConfigureError The device configuring failed.
 * @constant VCDeviceStateConfigurationChanged The device configuring changed.
 * @constant VCDeviceStateError The device failed.
 * @constant VCDeviceStateUnableGetDeviceData The device started successfully but cannot produce the data.
 * @constant VCDeviceStateUnexpectedEvent The device started successfully but sends unexpected events.
 */
typedef NS_ENUM(NSInteger, VCDeviceState) {
	VCDeviceStateAdded,
	VCDeviceStateRemoved,
	VCDeviceStateStarted,
	VCDeviceStateStopped,
	VCDeviceStateSuspended,
	VCDeviceStateUnsuspended,
	VCDeviceStateInUse,
	VCDeviceStateAvailable,
	VCDeviceStatePaused,
	VCDeviceStateResumed,
	VCDeviceStateControlledByRemoteEntity,
	VCDeviceStateNotControlledByRemoteEntity,
	VCDeviceStateControllable,
	VCDeviceStateNotControllable,
	VCDeviceStateDefaultChanged,
	VCDeviceStateConfigureSuccess,
	VCDeviceStateConfigureError,
	VCDeviceStateConfigurationChanged,
	VCDeviceStateError,
	VCDeviceStateUnableGetDeviceData,
	VCDeviceStateUnexpectedEvent
};
/*!
 * @enum Device type.
 * @constant VCDeviceTypeLocalCamera local camera device.
 * @constant VCDeviceTypeLocalMicrophone local microphone device.
 * @constant VCDeviceTypeLocalMonitor local screen device.
 * @constant VCDeviceTypeLocalWindowShare local application window device.
 * @constant VCDeviceTypeLocalSpeaker local speaker device.
 * @constant VCDeviceTypeLocalRenderer local renderer device.
 * @constant VCDeviceTypeRemoteCamera remote camera device.
 * @constant VCDeviceTypeRemoteMicrophone remote microphone device.
 * @constant VCDeviceTypeRemoteWindowShare remote application window device.
 * @constant VCDeviceTypeRemoteSpeaker remote speaker device.
 * @constant VCDeviceTypeRemoteRenderer remote renderer device.
 * @constant VCDeviceTypeVirtualVideoSource virtual video source.
 * @constant VCDeviceTypeVirtualAudioSource virtual audio source.
 */
typedef NS_ENUM(NSInteger, VCDeviceType) {
	VCDeviceTypeLocalCamera,
	VCDeviceTypeLocalMicrophone,
	VCDeviceTypeLocalMonitor,
	VCDeviceTypeLocalWindowShare,
	VCDeviceTypeLocalSpeaker,
	VCDeviceTypeLocalRenderer,
	VCDeviceTypeRemoteCamera,
	VCDeviceTypeRemoteMicrophone,
	VCDeviceTypeRemoteWindowShare,
	VCDeviceTypeRemoteSpeaker,
	VCDeviceTypeRemoteRenderer,
	VCDeviceTypeVirtualVideoSource,
	VCDeviceTypeVirtualAudioSource
};
/*!
 * Represents the camera control structure.
 */
@interface VCCameraControlCommand : NSObject
{
}
	/*!
	 * Represents the camera control action, refer VidyoCameraControlAction.
	 */
	@property VCCameraControlAction action;
	/*!
	 * Represents the direction of camera control, refer VidyoCameraControlDirection.
	 */
	@property VCCameraControlDirection direction;
	/*!
	 * Represents the preset id.
	 */
	@property unsigned int presetId;
	/*!
	 * Represents the visca command.
	 */
	@property NSMutableString* viscaCmd;
@end
/*!
 * Represents camera preset structure.
 */
@interface VCCameraPreset : NSObject
{
}
	/*!
	 * Represents preset index.
	 */
	@property unsigned int index;
	/*!
	 * Represents friendly name associate with preset index.
	 */
	@property NSMutableString* name;
@end
/*!
 * A wrapper class for Local and Remote devices.
 */
@interface VCDevice : NSObject
{
	void* objPtr;
}
	/*!
	 * Unique ID of the device.
	 */
	@property NSMutableString* id;
	/*!
	 * Name of the device.
	 */
	@property NSMutableString* name;
	/*!
	 * Type of the device.
	 */
	@property VCDeviceType type;
	-(void) dealloc;
	/*!
	 * Compare the values of two derived devices for equality.
	 * @param obj The VidyoDevice object comparing against.
	 * @param other The VidyoDevice object comparing.
	 */
	-(BOOL) derivedEqual;
	/*!
	 * Gets the device id.
	 * @param d The VidyoDevice object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the device name.
	 * @param d The VidyoDevice object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the device type.
	 * @param d The VidyoDevice object.
	 */
	-(VCDeviceType) getType;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
