//
//	VidyoGateway_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

/*!
 * @enum Reasons why an established connection was disconnected.
 * @constant VCGatewayDisconnectReasonDisconnected The user disconnected gracefully.
 * @constant VCGatewayDisconnectReasonConnectionLost The transport connection was lost.
 * @constant VCGatewayDisconnectReasonConnectionTimeout The signaling connection timed-out.
 * @constant VCGatewayDisconnectReasonNoResponse The service did not respond in a reasonable amount of time to a request by the user.
 * @constant VCGatewayDisconnectReasonTerminated The service closed the connection or otherwise terminated the login session.
 * @constant VCGatewayDisconnectReasonMiscLocalError A miscellaneous problem occurred with this client library.
 * @constant VCGatewayDisconnectReasonMiscRemoteError A miscellaneous problem occurred with the conferencing service.
 * @constant VCGatewayDisconnectReasonMiscError The connection was closed for some other miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCGatewayDisconnectReason) {
	VCGatewayDisconnectReasonDisconnected,
	VCGatewayDisconnectReasonConnectionLost,
	VCGatewayDisconnectReasonConnectionTimeout,
	VCGatewayDisconnectReasonNoResponse,
	VCGatewayDisconnectReasonTerminated,
	VCGatewayDisconnectReasonMiscLocalError,
	VCGatewayDisconnectReasonMiscRemoteError,
	VCGatewayDisconnectReasonMiscError
};
/*!
 * @enum Reasons why a connection attempt failed.
 * @constant VCGatewayFailReasonConnectionFailed The destination could not be reached.
 * @constant VCGatewayFailReasonConnectionLost The transport connection was lost prior to completing the login procedure.
 * @constant VCGatewayFailReasonConnectionTimeout The signaling connection timed-out prior to completing the login procedure.
 * @constant VCGatewayFailReasonNoResponse The service was successfully contacted, but the service ignored the user's request to log in or it did not answer in a reasonable amount of time.
 * @constant VCGatewayFailReasonTerminated The service was successfully contacted, but the service closed the connection or it refused to continue processing the login request.
 * @constant VCGatewayFailReasonInvalidToken The token that was provided is unknown to the service or unauthorized to log in.
 * @constant VCGatewayFailReasonUnableToCreateResource The server was unable to create the resource.
 * @constant VCGatewayFailReasonNoResponseFromResource The server did not respond in a reasonable amount of time to the request to connect to the resource.
 * @constant VCGatewayFailReasonInvalidResourceId The resource ID was invalid.
 * @constant VCGatewayFailReasonResourceFull The resource is at full capacity, and it cannot accept additional members.
 * @constant VCGatewayFailReasonNotMember The resource allows only certain users to enter, and the current user is not one of them.
 * @constant VCGatewayFailReasonBanned The user has been banned from entering the resource.
 * @constant VCGatewayFailReasonMediaNotEnabled The client could not enable media.
 * @constant VCGatewayFailReasonMediaFailed An established media connection failed.
 * @constant VCGatewayFailReasonMiscLocalError The server rejected the user's request to enter the resource, due to a miscellaneous problem with the request.
 * @constant VCGatewayFailReasonMiscRemoteError The server rejected the user's request to enter the resource, due to a miscellaneous problem of its own.
 * @constant VCGatewayFailReasonMiscError The login failed for some other miscellaneous reason.
 */
typedef NS_ENUM(NSInteger, VCGatewayFailReason) {
	VCGatewayFailReasonConnectionFailed,
	VCGatewayFailReasonConnectionLost,
	VCGatewayFailReasonConnectionTimeout,
	VCGatewayFailReasonNoResponse,
	VCGatewayFailReasonTerminated,
	VCGatewayFailReasonInvalidToken,
	VCGatewayFailReasonUnableToCreateResource,
	VCGatewayFailReasonNoResponseFromResource,
	VCGatewayFailReasonInvalidResourceId,
	VCGatewayFailReasonResourceFull,
	VCGatewayFailReasonNotMember,
	VCGatewayFailReasonBanned,
	VCGatewayFailReasonMediaNotEnabled,
	VCGatewayFailReasonMediaFailed,
	VCGatewayFailReasonMiscLocalError,
	VCGatewayFailReasonMiscRemoteError,
	VCGatewayFailReasonMiscError
};
/*!
 * @enum States of the VidyoGateway.
 * @constant VCGatewayStateIdle Ready to connect.
 * @constant VCGatewayStateEstablishingConnection Establishing a connection to the server.
 * @constant VCGatewayStateFindingResource Finding a resource.
 * @constant VCGatewayStateConnectingToResource Connecting to a resource.
 * @constant VCGatewayStateEnablingMedia Enabling media.
 * @constant VCGatewayStateConnected Successfully connected.
 */
typedef NS_ENUM(NSInteger, VCGatewayState) {
	VCGatewayStateIdle,
	VCGatewayStateEstablishingConnection,
	VCGatewayStateFindingResource,
	VCGatewayStateConnectingToResource,
	VCGatewayStateEnablingMedia,
	VCGatewayStateConnected
};
@protocol VCGatewayIConnect
	/*!
	 * Callback that is triggered when the connection is successfully established.
	 */
	-(void) onSuccess;
	/*!
	 * Callback that is triggered when the connection establishemnt failed.
	 */
	-(void) onFailure:(VCGatewayFailReason)reason;
	/*!
	 * Callback that is triggered when an established connection is disconnected.
	 */
	-(void) onDisconnected:(VCGatewayDisconnectReason)reason;
@end
/*!
 * A wrapper for Vidyo gateways.
 */
@interface VCGateway : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Connects to a gateway to a live conference with the specified resourceId.
	 */
	id<VCGatewayIConnect> gatewayIConnect;
}
	-(void) dealloc;
	/*!
	 * Connects to a gateway to a live conference with the specified resourceId.
	 * @param gateway The VidyoGateway object.
	 * @param host Host to which the connection will be made.
	 * @param token Token generated by the backend that contains the user ID and other metadata that will be used for authentication.
	 * @param displayName A display name that will be used in the UI.
	 * @param resourceId An alphanumeric string. This resourceId does does not need to be pre-provisioned but in order to create a connection between multiple participants, the same resource ID has to be specified.
	 * @param onSuccess Callback that is triggered when the connection is successfully established.
	 * @param onFailure Callback that is triggered when the connection establishemnt failed.
	 * @param onDisconnected Callback that is triggered when an established connection is disconnected.
	 */
	-(BOOL) connect:(const char*)host Token:(const char*)token DisplayName:(const char*)displayName ResourceId:(const char*)resourceId GatewayIConnect:(id<VCGatewayIConnect>)gatewayIConnect;
	/*!
	 * Disconnects a live gateway call.
	 * @param gateway The VidyoGateway object.
	 */
	-(void) disconnect;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
