//
//	VidyoLocalCamera_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoCameraControlCapabilities_Objc.h"
#import "VidyoDevice_Objc.h"
#import "VidyoLocalRenderer_Objc.h"
#import "VidyoRemoteRenderer_Objc.h"
#import "VidyoVideoCapability_Objc.h"
/*!
 * @enum Position of the camera.
 * @constant VCLocalCameraPositionUnknown Position is unknown.
 * @constant VCLocalCameraPositionFront Facing towards the screen.
 * @constant VCLocalCameraPositionBack Facing away from the screen.
 */
typedef NS_ENUM(NSInteger, VCLocalCameraPosition) {
	VCLocalCameraPositionUnknown,
	VCLocalCameraPositionFront,
	VCLocalCameraPositionBack
};
/*!
 * @enum Represents torch modes for a mobile camera.
 * @constant LOCALCAMERA_TORCHMODE_Off Torch is On.
 * @constant LOCALCAMERA_TORCHMODE_On Torch is Off.
 * @constant LOCALCAMERA_TORCHMODE_None Error.
 */
typedef NS_ENUM(NSInteger, VCLocalCameraTorchMode) {
	LOCALCAMERA_TORCHMODE_Off,
	LOCALCAMERA_TORCHMODE_On,
	LOCALCAMERA_TORCHMODE_None
};
/*!
 * @enum Frame-rate and resolution tradeoff profile.
 * @constant VCLocalCameraTradeOffProfileHigh High frame-rate, high resolution.
 * @constant VCLocalCameraTradeOffProfileMedium Balanced frame-rate and resolution.
 * @constant VCLocalCameraTradeOffProfileLow Low frame-rate, low resolution.
 * @constant VCLocalCameraTradeOffProfileMax Try to guarantee max frame rate, max resolutioin.
 */
typedef NS_ENUM(NSInteger, VCLocalCameraTradeOffProfile) {
	VCLocalCameraTradeOffProfileHigh,
	VCLocalCameraTradeOffProfileMedium,
	VCLocalCameraTradeOffProfileLow,
	VCLocalCameraTradeOffProfileMax
};
@protocol VCLocalCameraIGetVideoCapabilitiesAsync
	/*!
	 * Callback that is triggered when getting the video capabilities completes.
	 */
	-(void) onGetVideoCapabilitiesComplete:(NSMutableArray*)capabilities;
@end
/*!
 * This object represents a camera on the local endpoint.
 */
@interface VCLocalCamera : NSObject
{
	void* objPtr;
	@public
	/*!
	 * Gets supported video capabilities.
	 */
	id<VCLocalCameraIGetVideoCapabilitiesAsync> localCameraIGetVideoCapabilitiesAsync;
}
	/*!
	 * Unique ID.
	 */
	@property NSMutableString* id;
	/*!
	 * Name.
	 */
	@property NSMutableString* name;
	-(void) dealloc;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(long) addToLocalRenderer:(VCLocalRenderer*)localRenderer;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) addToRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * Allows the PTZ conrol of the camera by remote participants.
	 * @param c The VidyoLocalCamera object.
	 * @param allow Allow or prohibit camera control.
	 */
	-(BOOL) allowRemoteCameraControl:(BOOL)allow;
	/*!
	 * Send the PTZ Nudge commands to the local camera.
	 * @param c The VidyoLocalCamera object.
	 * @param pan Number of nudges to pan the camera.
	 * @param tilt Number of nudges to tilt the camera.
	 * @param zoom Number of nudges to zoom the camera.
	 */
	-(BOOL) controlPTZ:(int)pan Tilt:(int)tilt Zoom:(int)zoom;
	/*!
	 * Send PTZ Start command to the local camera.
	 * @param c The VidyoLocalCamera object.
	 * @param cmd PTZ command.
	 * @param timeout Amount of time in nanoseconds at which camera will be moving in the specified direction.
	 */
	-(BOOL) controlPTZStart:(VCCameraControlDirection)cmd Timeout:(long)timeout;
	/*!
	 * Send PTZ Stop command to the local camera.
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) controlPTZStop;
	/*!
	 * Gets the backlight compensation state.
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) getBacklightCompensation;
	/*!
	 * Gets camera control capabilities.
	 * @param c The VidyoLocalCamera object.
	 */
	-(VCCameraControlCapabilities*) getControlCapabilities;
	/*!
	 * Gets the frame rate v.s. video quality tradeoff profile.
	 * @param c The VidyoLocalCamera object.
	 */
	-(VCLocalCameraTradeOffProfile) getFramerateTradeOffProfile;
	/*!
	 * Gets the unique ID of the camera.
	 * @param c The VidyoLocalCamera object.
	 */
	-(NSString*) getId;
	/*!
	 * Gets the name of the camera.
	 * @param c The VidyoLocalCamera object.
	 */
	-(NSString*) getName;
	/*!
	 * Gets the position of the camera.
	 * @param c The VidyoLocalCamera object.
	 */
	-(VCLocalCameraPosition) getPosition;
	/*!
	 * Gets the preview label of the camera.
	 * @param c The VidyoLocalCamera object.
	 */
	-(NSString*) getPreviewLabel;
	/*!
	 * Gets the resolution v.s. video quality tradeoff profile.
	 * @param c The VidyoLocalCamera object.
	 */
	-(VCLocalCameraTradeOffProfile) getResolutionTradeOffProfile;
	/*!
	 * Returns the current torch mode of camera. This function is only available if VidyoLocalCameraHasTorch returns true.
	 * @param c The VidyoLocalCamera object.
	 */
	-(VCLocalCameraTorchMode) getTorchMode;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) getVideoCapabilities:(NSMutableArray*)capabilities;
	/*!
	 * Gets supported video capabilities.
	 * @param c The VidyoLocalCamera object.
	 * @param onComplete The callback that is triggered when getting video capabilities completes.
	 */
	-(BOOL) getVideoCapabilitiesAsync:(id<VCLocalCameraIGetVideoCapabilitiesAsync>)localCameraIGetVideoCapabilitiesAsync;
	/*!
	 * Determines whether the camera has a torch.
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) hasTorch;
	/*!
	 * Checks if the camera control to digital only.
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) isControlDigital;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) isPaused;
	/*!
	 * Checks if the camera is suspended.
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) isSuspended;
	/*!
	 * Determines whether camera supports a particular torch mode. This function is only available if VidyoLocalCameraHasTorch returns true.
	 * @param c The VidyoLocalCamera object.
	 * @param mode Torch mode.
	 */
	-(BOOL) isTorchModeSupported:(VCLocalCameraTorchMode)mode;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) removeFromLocalRenderer:(VCLocalRenderer*)localRenderer;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) removeFromRemoteRenderer:(VCRemoteRenderer*)remoteRenderer;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(void) resume;
	/*!
	 * Sets the aspect ratio constraint on the camera which will adjust local camera frames to match.
	 * @param c The VidyoLocalCamera object.
	 * @param aspectRatioWidth Width of the aspect ratio.
	 * @param aspectRatioHeight Height of the aspect ration.
	 */
	-(BOOL) setAspectRatioConstraint:(unsigned int)aspectRatioWidth AspectRatioHeight:(unsigned int)aspectRatioHeight;
	/*!
	 * Set the backlight compensation which improves the dynamic range of the image when the subject is dark but the background is bright.
	 * @param c The VidyoLocalCamera object.
	 * @param backlightCompensation Compensate for the bright backlighting.
	 */
	-(BOOL) setBacklightCompensation:(BOOL)backlightCompensation;
	/*!
	 * @param c The VidyoLocalCamera object.
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 */
	-(BOOL) setBoundsConstraint:(unsigned int)minWidth MinHeight:(unsigned int)minHeight MaxWidth:(unsigned int)maxWidth MaxHeight:(unsigned int)maxHeight MaxFrameInterval:(long)maxFrameInterval MinFrameInterval:(long)minFrameInterval AspectRatioWidth:(unsigned int)aspectRatioWidth AspectRatioHeight:(unsigned int)aspectRatioHeight TemporalSpatialTradeOff:(unsigned int)temporalSpatialTradeOff;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) setCapabilitiesConstraint:(NSMutableArray*)capabilities TemporalSpatialTradeOff:(unsigned int)temporalSpatialTradeOff;
	/*!
	 * @param c The VidyoLocalCamera object.
	 * @param maxFrameInterval Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 * @param minFrameInterval Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)
	 */
	-(BOOL) setConstraints:(unsigned int)minWidth MinHeight:(unsigned int)minHeight MaxWidth:(unsigned int)maxWidth MaxHeight:(unsigned int)maxHeight MaxFrameInterval:(unsigned int)maxFrameInterval MinFrameInterval:(unsigned int)minFrameInterval AspectRatioWidth:(unsigned int)aspectRatioWidth AspectRatioHeight:(unsigned int)aspectRatioHeight TemporalSpatialTradeOff:(unsigned int)temporalSpatialTradeOff Capabilities:(NSMutableArray*)capabilities;
	/*!
	 * Sets camera control capabilities.
	 * @param c The VidyoLocalCamera object.
	 * @param caps The VidyoCameraControlCapabilities object.
	 */
	-(BOOL) setControlCapabilities:(VCCameraControlCapabilities*)caps;
	/*!
	 * Sets the camera control to digital only.
	 * @param c The VidyoLocalCamera object.
	 * @param digital Forces digital control.
	 */
	-(void) setControlDigital:(BOOL)digital;
	/*!
	 * Sets the frame rate v.s. video quality tradeoff profile.
	 * @param c The VidyoLocalCamera object.
	 * @param profile Frame-rate tradeoff profile.
	 */
	-(BOOL) setFramerateTradeOffProfile:(VCLocalCameraTradeOffProfile)profile;
	/*!
	 * Sets the maximum resolution and framerate constraint on the local camera. This overrides the defaults which are based on the CPU profile of the endpoint. The maximum if not an exact match for the camera resolution will be chosen by the aproximate closest resolution based on calculations that include the width, height and frameInterval.
	 * @param c The VidyoLocalCamera object.
	 * @param width Maximum width.
	 * @param height Maximum height.
	 * @param frameInterval Maximum frame interval. Setting to 0 selects the fastest frame rate.
	 */
	-(BOOL) setMaxConstraint:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Set the time delta that the camera moves left/right (pan), up/down (tilt), and/or in/out (zoom) for each nudge if the camera supports only start/stop (relative) behavior.
	 * @param c The VidyoLocalCamera object.
	 * @param panTime The time delta to pan the camera per nudge.
	 * @param tiltTime The time delta to tilt the camera per nudge.
	 * @param zoomTime The time delta to zoom the camera per nudge.
	 */
	-(BOOL) setNudgeTimes:(long)panTime TiltTime:(long)tiltTime ZoomTime:(long)zoomTime;
	/*!
	 * Sets relative orientation of a local camera.
	 * @param c The VidyoLocalCamera object.
	 * @param orientation Orientation of the camera.
	 * @param lockOrientation Lock the camera in the specified orientation.
	 */
	-(BOOL) setOrientation:(VCDeviceOrientation)orientation LockOrientation:(BOOL)lockOrientation;
	/*!
	 * @param c The VidyoLocalCamera object.
	 */
	-(BOOL) setPositionInLocalRenderer:(VCLocalRenderer*)localRenderer X:(int)x Y:(int)y Width:(unsigned int)width Height:(unsigned int)height FrameInterval:(long)frameInterval;
	/*!
	 * Set the preview label of the camera.
	 * @param c The VidyoLocalCamera object.
	 * @param previewLabel Display name to set on the camera.
	 */
	-(BOOL) setPreviewLabel:(NSString*)previewLabel;
	/*!
	 * Set the preview label of the camera stream.
	 * @param c The VidyoLocalCamera object.
	 * @param previewLabel Display name to set on the camera stream. Camera and Content labels are stored separately.
	 */
	-(BOOL) setPreviewStreamLabel:(NSString*)previewLabel;
	/*!
	 * Sets the resolution v.s. video quality trade off profile.
	 * @param c The VidyoLocalCamera object.
	 * @param profile Resolution tradeoff profile.
	 */
	-(BOOL) setResolutionTradeOffProfile:(VCLocalCameraTradeOffProfile)profile;
	/*!
	 * Sets the target send bit rate for a local camera.
	 * @param c The VidyoLocalCamera object.
	 * @param bitRate The target send bit rate in bits per second.
	 */
	-(void) setTargetBitRate:(unsigned int)bitRate;
	/*!
	 * Set the torch mode for camera. This function is only available if VidyoLocalCameraHasTorch returns true and VidyoLocalCameraGetTorchMode called with the torch mode returns true.
	 * @param c The VidyoLocalCamera object.
	 * @param mode Torch mode.
	 */
	-(BOOL) setTorchMode:(VCLocalCameraTorchMode)mode;
	/*!
	 * Shows camera control when rendering preview.
	 * @param c The VidyoLocalCamera object.
	 * @param show Show or hide camera controls.
	 */
	-(BOOL) showCameraControl:(BOOL)show;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
