//
//	VidyoRoomProperties_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoEventSchedule_Objc.h"
@class VCRoomParticipantProfile;
/*!
 * Properties of a room.
 */
@interface VCRoomProperties : NSObject
{
}
	/*!
	 * An administrator in the room.
	 */
	@property NSMutableArray* administrators;
	/*!
	 * Calendar invitation body retrieved from the portal.
	 */
	@property NSMutableString* calendarInviteBody;
	/*!
	 * Calendar invitation HTML body retrieved from the portal.
	 */
	@property NSMutableString* calendarInviteHTMLBody;
	/*!
	 * Calendar invitation subject retrieved from the portal.
	 */
	@property NSMutableString* calendarInviteSubject;
	/*!
	 * Creation time of the room.
	 */
	@property long creationTime;
	/*!
	 * Default profile for all participants.
	 */
	@property VCRoomParticipantProfile* defaultProfile;
	@property NSMutableString* description;
	/*!
	 * Server designated presenter.
	 */
	@property NSMutableString* designatedPresenter;
	/*!
	 * The room has a calendar invitation text that contains dial-in information. Retrieved from the portal.
	 */
	@property BOOL hasCalendarInviteText;
	/*!
	 * This room has a moderator pin.
	 */
	@property BOOL hasModeratorPin;
	/*!
	 * if hasPassword is LMI_TRUE, password filed should be examined. If password field is empty, it means to clear the password, otherwise, it means set the room with this new password.
	 */
	@property BOOL hasPassword;
	/*!
	 * The room is being broadcast.
	 */
	@property BOOL isBroadcastingEnabled;
	/*!
	 * The room is being logges and is on the record.
	 */
	@property BOOL isLoggingEnabled;
	/*!
	 * The recording(logging) of the room is paused.
	 */
	@property BOOL isLoggingPaused;
	/*!
	 * The room can be logged/recorded.
	 */
	@property BOOL isLoggingSupported;
	/*!
	 * The room is for members only. A user cannot join unless they have a member or better clearance.
	 */
	@property BOOL isMembersOnly;
	/*!
	 * This room is moderated.
	 */
	@property BOOL isModerated;
	/*!
	 * The room requres a password to join.
	 */
	@property BOOL isPasswordProtected;
	/*!
	 * The room is created for peer to peer call with legacy endpoint.
	 */
	@property BOOL isPeertoPeerCallWithLegacy;
	/*!
	 * The room Public. This room will show up in searches.
	 */
	@property BOOL isPublic;
	/*!
	 * It set to LMI_TRUE, a member can request to become a user with additional privillege (such as moderator) .
	 */
	@property BOOL isRoleChangeAllowed;
	/*!
	 * The room is secure (both signaling and media).
	 */
	@property BOOL isSecure;
	/*!
	 * WaitintRoom feature is enabled.
	 */
	@property BOOL isWaitingRoomEnabled;
	@property NSMutableString* language;
	/*!
	 * Where to find the recording(logging).
	 */
	@property NSMutableString* loggingLocation;
	/*!
	 * Maxumum number of concurrent participants.
	 */
	@property unsigned int maxParticipants;
	/*!
	 * A member of the room.
	 */
	@property NSMutableArray* members;
	@property NSMutableString* moderatorUrl;
	/*!
	 * A member of the room with moderator privileges. A moderator will typically have privileges such as muting users or kicking them out of the room.
	 */
	@property NSMutableArray* moderators;
	@property NSMutableString* name;
	/*!
	 * The user has been banned from the room.
	 */
	@property NSMutableArray* outcasts;
	/*!
	 * An owner of the room. This is the highest clearance. This type of user typically has unlimited privileges in the room.
	 */
	@property NSMutableArray* owners;
	/*!
	 * Profile for specific participants.
	 */
	@property NSMutableArray* participantProfiles;
	/*!
	 * The password to join this room.
	 */
	@property NSMutableString* password;
	/*!
	 * A schedule for a room in iCalendar format.
	 */
	@property VCEventSchedule* schedule;
	/*!
	 * A HTTP link to the room that can be shared.
	 */
	@property NSMutableString* webLink;
@end
