//
//	VidyoVideoFrame_Objc.h
//	VidyoClient
//
//	This file is auto generated, do not edit this file
//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.
//

#import "VidyoMediaFormats_Objc.h"
@protocol VCVideoFrameIConstructFromKnownFormatWithExternalBuffer
	/*!
	 * Describes a callback used to release externally allocated buffer memory of an VidyoVideoFrame.
	 */
	-(void) releaseCallback:(void*)buffer Size:(size_t)size;
@end
/*!
 * This object represents a video frame.
 */
@interface VCVideoFrame : NSObject
{
	void* objPtr;
	@public
	id<VCVideoFrameIConstructFromKnownFormatWithExternalBuffer> videoFrameIConstructFromKnownFormatWithExternalBuffer;
}
	/*!
	 * This object represents a video frame.
	 * @param x A video frame object to construct.
	 * @param format The media format of the video frame.
	 * @param buffer A pointer to externally allocated memory that holds the pixel data.
	 * @param size The size, in bytes, of the frame data.
	 * @param bufferAlloc External allocator for frame-buffer data.
	 * @param releaseCallback A callback to be called on when external buffer may be reclaimed.
	 * @param width The width of the video media frame in pixels.
	 * @param height The height of the video media frame in pixels.
	 * @param alloc An allocator for non-frame-buffer data.
	 */
	-(id) init:(VCMediaFormat)format Buffer:(unsigned char*)buffer Size:(unsigned int)size VideoFrameIConstructFromKnownFormatWithExternalBuffer:(id<VCVideoFrameIConstructFromKnownFormatWithExternalBuffer>)videoFrameIConstructFromKnownFormatWithExternalBuffer Width:(unsigned int)width Height:(unsigned int)height;
	-(void) dealloc;
	/*!
	 * Gets the pointer to the frame's payload.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned char*) getData;
	/*!
	 * Gets the pointer to the frame's payload of the Cb plane.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned char*) getDataCb;
	/*!
	 * Gets the pointer to the frame's payload of the Cr plane.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned char*) getDataCr;
	/*!
	 * Gets the pointer to the frame's payload of the Y plane.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned char*) getDataY;
	/*!
	 * Gets the elapsed time since the beginning of frame capture that is increased by the duration of each frame.
	 * @param f The VidyoVideoFrame object.
	 */
	-(long) getElapsedTime;
	/*!
	 * Gets the format of the frame.
	 * @param f The VidyoVideoFrame object.
	 */
	-(NSString*) getFormat;
	/*!
	 * Gets the height of the frame.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getHeight;
	/*!
	 * Gets the height in bytes of the frame's Cb pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getHeightCb;
	/*!
	 * Gets the height in bytes of the frame's Cr pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getHeightCr;
	/*!
	 * Gets the height in bytes of the frame's Y pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getHeightY;
	/*!
	 * Gets the number of bytes from the Cb plane's payload to the start of the pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getOffsetCb;
	/*!
	 * Gets the number of bytes from the Cr plane's payload to the start of the pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getOffsetCr;
	/*!
	 * Gets the number of bytes from the Y plane's payload to the start of the pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getOffsetY;
	/*!
	 * Gets the number of bytes between consecutive pixels in a row of the Cb plane.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getPitchCb;
	/*!
	 * Gets the number of bytes between consecutive pixels in a row of the Cr plane.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getPitchCr;
	/*!
	 * Gets the number of bytes between consecutive pixels in a row of the Y plane
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getPitchY;
	/*!
	 * Gets the size in bytes of the frame's payload.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getSize;
	/*!
	 * Gets the size in bytes of the plane's payload.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getSizeCb;
	/*!
	 * Gets the size in bytes of the Cr plane's payload.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getSizeCr;
	/*!
	 * Gets the size in bytes of the plane's payload.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getSizeY;
	/*!
	 * Gets the wallclock timestamp associated with the creation of the audio frame object.
	 * @param f The VidyoVideoFrame object.
	 */
	-(long) getTimestamp;
	/*!
	 * Gets the width of the frame.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getWidth;
	/*!
	 * Gets the width in bytes of the frame's Cb pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getWidthCb;
	/*!
	 * Gets the width in bytes of the frame's Cr pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getWidthCr;
	/*!
	 * Gets the width in bytes of the frame's Y pixel data.
	 * @param f The VidyoVideoFrame object.
	 */
	-(unsigned int) getWidthY;
	/*!
	 * Sets elapsedTime and timestamp of the video frame. In case elapsedTime and timestamp are equal to zero will set current monotonic and wall time.
	 * @param f The VidyoVideoFrame object.
	 * @param elapsedTime The elapsed time of the video frame. If zero will set current monotonic time.
	 * @param timestamp Video frame timestamp. If zero will set current wall time.
	 */
	-(BOOL) setTimeProperties:(long)elapsedTime Timestamp:(long)timestamp;
	-(id) initWithObject:(void*)rPtr;
	-(void*)getObjectPtr;
@end
