// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents an audio frame.
	/// </summary>
	public class AudioFrame: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoAudioFrame reference.
		private GCHandle objHandle; // weak VidyoAudioFrame reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoAudioFrameConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoAudioFrameDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoAudioFrameGetBitsPerSampleNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoAudioFrameGetDataNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoAudioFrameGetDiscontinuityNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoAudioFrameGetDiscontinuityBitPresentNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoAudioFrameGetElapsedTimeNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoAudioFrameGetEnergyNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoAudioFrameGetEnergyBitPresentNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoAudioFrameGetFormatNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoAudioFrameGetNumberOfChannelsNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoAudioFrameGetNumberOfSamplesNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoAudioFrameGetSampleRateNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoAudioFrameGetSizeNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoAudioFrameGetSpeechNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoAudioFrameGetSpeechBitPresentNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoAudioFrameGetTimestampNative(IntPtr f);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoAudioFrameGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoAudioFrameSetUserDataNative(IntPtr obj, IntPtr userData);

		public AudioFrame(IntPtr other){
			objPtr = VidyoAudioFrameConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoAudioFrameSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~AudioFrame(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoAudioFrameSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoAudioFrameDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public SizeT GetBitsPerSample() {
			if (objPtr == IntPtr.Zero) { return default; }

			SizeT ret = VidyoAudioFrameGetBitsPerSampleNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public ulong GetData() {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoAudioFrameGetDataNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public Boolean GetDiscontinuity() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoAudioFrameGetDiscontinuityNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public Boolean GetDiscontinuityBitPresent() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoAudioFrameGetDiscontinuityBitPresentNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public ulong GetElapsedTime() {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoAudioFrameGetElapsedTimeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public int GetEnergy() {
			if (objPtr == IntPtr.Zero) { return default; }

			int ret = VidyoAudioFrameGetEnergyNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public Boolean GetEnergyBitPresent() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoAudioFrameGetEnergyBitPresentNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the frame format.
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public String GetFormat() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoAudioFrameGetFormatNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public SizeT GetNumberOfChannels() {
			if (objPtr == IntPtr.Zero) { return default; }

			SizeT ret = VidyoAudioFrameGetNumberOfChannelsNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public SizeT GetNumberOfSamples() {
			if (objPtr == IntPtr.Zero) { return default; }

			SizeT ret = VidyoAudioFrameGetNumberOfSamplesNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public SizeT GetSampleRate() {
			if (objPtr == IntPtr.Zero) { return default; }

			SizeT ret = VidyoAudioFrameGetSampleRateNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public SizeT GetSize() {
			if (objPtr == IntPtr.Zero) { return default; }

			SizeT ret = VidyoAudioFrameGetSizeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public Boolean GetSpeech() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoAudioFrameGetSpeechNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public Boolean GetSpeechBitPresent() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoAudioFrameGetSpeechBitPresentNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="f">The VidyoAudioFrame object.</param>
		public ulong GetTimestamp() {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoAudioFrameGetTimestampNative(objPtr);

			return ret;
		}
	};
}
