// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class ConnectorCameraEffectInfoFactory
	{
		public static ConnectorCameraEffectInfo Create()
		{
			return new ConnectorCameraEffectInfo(IntPtr.Zero);
		}
		public static void Destroy(ConnectorCameraEffectInfo obj)
		{
		}
	}
	/// <summary>
	/// Represent the configuration of camera background effect.
	/// </summary>
	public class ConnectorCameraEffectInfo {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoConnectorCameraEffectInfo reference.
		public IntPtr GetObjectPtr() {
			IntPtr nPathToEffect = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(pathToEffect ?? string.Empty);
			IntPtr nPathToResources = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(pathToResources ?? string.Empty);
			IntPtr nToken = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(token ?? string.Empty);
			IntPtr nVirtualBackgroundPicture = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(virtualBackgroundPicture ?? string.Empty);

			VidyoConnectorCameraEffectInfoSetblurIntensityNative(objPtr, blurIntensity);
			VidyoConnectorCameraEffectInfoSeteffectTypeNative(objPtr, effectType);
			VidyoConnectorCameraEffectInfoSetpathToEffectNative(objPtr, nPathToEffect);
			VidyoConnectorCameraEffectInfoSetpathToResourcesNative(objPtr, nPathToResources);
			VidyoConnectorCameraEffectInfoSettokenNative(objPtr, nToken);
			VidyoConnectorCameraEffectInfoSetvirtualBackgroundPictureNative(objPtr, nVirtualBackgroundPicture);

			Marshal.FreeHGlobal(nVirtualBackgroundPicture);
			Marshal.FreeHGlobal(nToken);
			Marshal.FreeHGlobal(nPathToResources);
			Marshal.FreeHGlobal(nPathToEffect);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoConnectorCameraEffectInfoGetblurIntensityNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorCameraEffectInfoSetblurIntensityNative(IntPtr obj, uint blurIntensity);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Connector.ConnectorCameraEffectType VidyoConnectorCameraEffectInfoGeteffectTypeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorCameraEffectInfoSeteffectTypeNative(IntPtr obj, Connector.ConnectorCameraEffectType effectType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorCameraEffectInfoGetpathToEffectNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorCameraEffectInfoSetpathToEffectNative(IntPtr obj, IntPtr pathToEffect);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorCameraEffectInfoGetpathToResourcesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorCameraEffectInfoSetpathToResourcesNative(IntPtr obj, IntPtr pathToResources);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorCameraEffectInfoGettokenNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorCameraEffectInfoSettokenNative(IntPtr obj, IntPtr token);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoConnectorCameraEffectInfoGetvirtualBackgroundPictureNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoConnectorCameraEffectInfoSetvirtualBackgroundPictureNative(IntPtr obj, IntPtr virtualBackgroundPicture);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoConnectorCameraEffectInfoConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoConnectorCameraEffectInfoConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoConnectorCameraEffectInfoDestructNative(IntPtr obj);

		/// <summary>
		/// Blur intensity. Valid valies is [3-8]. Default value is 5. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_Blur
		/// </summary>
		public uint blurIntensity;
		/// <summary>
		/// Type of the camera background effect. In case VIDYO_CONNECTORCAMERAEFFECTTYPE_None is set no need to set other fields.
		/// </summary>
		public Connector.ConnectorCameraEffectType effectType;
		/// <summary>
		/// The path to effect. A directory with supported effect is packaged with VidyoClient library.
		/// </summary>
		public String pathToEffect;
		/// <summary>
		/// The path to resources like a model and its configuration. A directory with supported resources is packaged with VidyoClient library.
		/// </summary>
		public String pathToResources;
		/// <summary>
		/// The token for enabling the camera background effect. The blank string is NOT allowed. In case the token is not valid or expired enabling of camera background effect will fail.
		/// </summary>
		public String token;
		/// <summary>
		/// The path to the picture that will be used for the virtual background. Used only if effectType VIDYO_CONNECTORCAMERAEFFECTTYPE_VirtualBackground.
		/// </summary>
		public String virtualBackgroundPicture;
		public ConnectorCameraEffectInfo(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoConnectorCameraEffectInfoConstructDefaultNative();
			}
			else {
				objPtr = VidyoConnectorCameraEffectInfoConstructCopyNative(obj);
			}

			blurIntensity = VidyoConnectorCameraEffectInfoGetblurIntensityNative(objPtr);
			effectType = VidyoConnectorCameraEffectInfoGeteffectTypeNative(objPtr);
			pathToEffect = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorCameraEffectInfoGetpathToEffectNative(objPtr));
			pathToResources = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorCameraEffectInfoGetpathToResourcesNative(objPtr));
			token = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorCameraEffectInfoGettokenNative(objPtr));
			virtualBackgroundPicture = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoConnectorCameraEffectInfoGetvirtualBackgroundPictureNative(objPtr));
		}
		~ConnectorCameraEffectInfo() {
			VidyoConnectorCameraEffectInfoDestructNative(objPtr);
		 }
	};
}
