// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class ContactFactory
	{
		public static Contact Create()
		{
			return new Contact(IntPtr.Zero);
		}
		public static void Destroy(Contact obj)
		{
		}
	}
	/// <summary>
	/// Stores contact information and presence status.
	/// </summary>
	public class Contact {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoContact reference.
		public IntPtr GetObjectPtr() {
			IntPtr nDepartment = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(department ?? string.Empty);
			IntPtr nEmails = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * emails.Count);
			int nEmailsSize = 0;
			IntPtr nGroups = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * groups.Count);
			int nGroupsSize = 0;
			IntPtr nHandle = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(handle ?? string.Empty);
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nNickname = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(nickname ?? string.Empty);
			IntPtr nPhoto = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(photo ?? string.Empty);
			IntPtr nPresenceStatus = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(presenceStatus ?? string.Empty);
			IntPtr nTelephones = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * telephones.Count);
			int nTelephonesSize = 0;
			IntPtr nTitle = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(title ?? string.Empty);

			foreach (ContactProperty iter in emails) {
				Marshal.WriteIntPtr(nEmails + (nEmailsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nEmailsSize++;
			}
			foreach (String iter in groups) {
				Marshal.WriteIntPtr(nGroups + (nGroupsSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nGroupsSize++;
			}
			foreach (ContactProperty iter in telephones) {
				Marshal.WriteIntPtr(nTelephones + (nTelephonesSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nTelephonesSize++;
			}

			VidyoContactSetdepartmentNative(objPtr, nDepartment);
			VidyoContactSetemailsNative(objPtr, nEmails, nEmailsSize);
			VidyoContactSetgroupsNative(objPtr, nGroups, nGroupsSize);
			VidyoContactSethandleNative(objPtr, nHandle);
			VidyoContactSetidNative(objPtr, nId);
			VidyoContactSetnameNative(objPtr, nName);
			VidyoContactSetnicknameNative(objPtr, nNickname);
			VidyoContactSetphotoNative(objPtr, nPhoto);
			VidyoContactSetpresenceStateNative(objPtr, presenceState);
			VidyoContactSetpresenceStatusNative(objPtr, nPresenceStatus);
			VidyoContactSetpublicationStateNative(objPtr, publicationState);
			VidyoContactSetsubscriptionStateNative(objPtr, subscriptionState);
			VidyoContactSettelephonesNative(objPtr, nTelephones, nTelephonesSize);
			VidyoContactSettimestampNative(objPtr, timestamp);
			VidyoContactSettitleNative(objPtr, nTitle);

			for (int i = 0; i < nGroupsSize; i++) {
				Marshal.FreeHGlobal(Marshal.ReadIntPtr(nGroups + (i * Marshal.SizeOf<IntPtr>())));
			}

			Marshal.FreeHGlobal(nTitle);
			Marshal.FreeHGlobal(nTelephones);
			Marshal.FreeHGlobal(nPresenceStatus);
			Marshal.FreeHGlobal(nPhoto);
			Marshal.FreeHGlobal(nNickname);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nId);
			Marshal.FreeHGlobal(nHandle);
			Marshal.FreeHGlobal(nGroups);
			Marshal.FreeHGlobal(nEmails);
			Marshal.FreeHGlobal(nDepartment);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetdepartmentNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetdepartmentNative(IntPtr obj, IntPtr department);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetemailsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetemailsNative(IntPtr obj, IntPtr emails, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetemailsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactFreeemailsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetgroupsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetgroupsNative(IntPtr obj, IntPtr groups, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetgroupsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactFreegroupsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGethandleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSethandleNative(IntPtr obj, IntPtr handle);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetnicknameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetnicknameNative(IntPtr obj, IntPtr nickname);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetphotoNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetphotoNative(IntPtr obj, IntPtr photo);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ContactPresenceState VidyoContactGetpresenceStateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetpresenceStateNative(IntPtr obj, ContactPresenceState presenceState);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGetpresenceStatusNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetpresenceStatusNative(IntPtr obj, IntPtr presenceStatus);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ContactSubscriptionState VidyoContactGetpublicationStateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetpublicationStateNative(IntPtr obj, ContactSubscriptionState publicationState);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern ContactSubscriptionState VidyoContactGetsubscriptionStateNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSetsubscriptionStateNative(IntPtr obj, ContactSubscriptionState subscriptionState);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGettelephonesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSettelephonesNative(IntPtr obj, IntPtr telephones, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGettelephonesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactFreetelephonesArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoContactGettimestampNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSettimestampNative(IntPtr obj, ulong timestamp);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoContactGettitleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoContactSettitleNative(IntPtr obj, IntPtr title);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoContactConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoContactConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoContactDestructNative(IntPtr obj);

		/// <summary>
		/// Presence status codes.
		/// </summary>
		public enum ContactPresenceState {
			/// <summary>Unavailable</summary>
			ContactpresencestateUnavailable,
			/// <summary>Do not disturb</summary>
			ContactpresencestateDoNotDisturb,
			/// <summary>Extended away</summary>
			ContactpresencestateExtendedAway,
			/// <summary>Away</summary>
			ContactpresencestateAway,
			/// <summary>Available</summary>
			ContactpresencestateAvailable,
			/// <summary>Interested in chat</summary>
			ContactpresencestateInterestedInChat
		}
		/// <summary>
		/// Describes the relationship between a contact publishing its contact information and a contact subscribing to that information.
		/// </summary>
		public enum ContactSubscriptionState {
			/// <summary>The subscriber's state is unknown.</summary>
			ContactsubscriptionstateUnavailable,
			/// <summary>The subscriber is not currently subscribed to the publisher's information. No action is pending on the subscription state.</summary>
			ContactsubscriptionstateNotSubscribed,
			/// <summary>The subscriber has not subscribed to the publisher's information, however, the publisher has already granted permission to the subscriber.</summary>
			ContactsubscriptionstatePreapproved,
			/// <summary>The subscriber has subscribed to the publisher's information and is waiting for the publisher to grant permission for the subscription.</summary>
			ContactsubscriptionstateAwaitingApproval,
			/// <summary>The subscriber is currently subscribed to the publisher's information.</summary>
			ContactsubscriptionstateSubscribed
		}
		public class ContactPropertyFactory
		{
			public static ContactProperty Create()
			{
				return new ContactProperty(IntPtr.Zero);
			}
			public static void Destroy(ContactProperty obj)
			{
			}
		}
		/// <summary>
		/// Contact Property that has value and metadata for fields.
		/// </summary>
		public class ContactProperty {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoContactProperty reference.
			public IntPtr GetObjectPtr() {
				IntPtr nTypes = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * types.Count);
				int nTypesSize = 0;
				IntPtr nValue = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(value ?? string.Empty);

				foreach (String iter in types) {
					Marshal.WriteIntPtr(nTypes + (nTypesSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
					nTypesSize++;
				}

				VidyoContactPropertySettypesNative(objPtr, nTypes, nTypesSize);
				VidyoContactPropertySetvalueNative(objPtr, nValue);

				for (int i = 0; i < nTypesSize; i++) {
					Marshal.FreeHGlobal(Marshal.ReadIntPtr(nTypes + (i * Marshal.SizeOf<IntPtr>())));
				}

				Marshal.FreeHGlobal(nValue);
				Marshal.FreeHGlobal(nTypes);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoContactPropertyGettypesNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoContactPropertySettypesNative(IntPtr obj, IntPtr types, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoContactPropertyGettypesArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoContactPropertyFreetypesArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoContactPropertyGetvalueNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoContactPropertySetvalueNative(IntPtr obj, IntPtr value);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoContactPropertyConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoContactPropertyConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoContactPropertyDestructNative(IntPtr obj);

			/// <summary>
			/// 
			/// </summary>
			public List<String> types;
			/// <summary>
			/// 
			/// </summary>
			public String value;
			public ContactProperty(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoContactPropertyConstructDefaultNative();
				}
				else {
					objPtr = VidyoContactPropertyConstructCopyNative(obj);
				}

				List<String> csTypes = new List<String>();
				var nTypesSize = 0;
				var nTypes = VidyoContactPropertyGettypesArrayNative(VidyoContactPropertyGettypesNative(objPtr), ref nTypesSize);
				var nTypesIndex = 0;
				while (nTypesIndex < nTypesSize) {
					csTypes.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nTypes + (nTypesIndex * Marshal.SizeOf(nTypes)))));
					nTypesIndex++;
				}

				types = csTypes;
				value = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactPropertyGetvalueNative(objPtr));
				VidyoContactPropertyFreetypesArrayNative(nTypes, nTypesSize);
			}
			~ContactProperty() {
				VidyoContactPropertyDestructNative(objPtr);
			 }
		};
		/// <summary>
		/// 
		/// </summary>
		public String department;
		/// <summary>
		/// 
		/// </summary>
		public List<ContactProperty> emails;
		/// <summary>
		/// 
		/// </summary>
		public List<String> groups;
		/// <summary>
		/// 
		/// </summary>
		public String handle;
		/// <summary>
		/// 
		/// </summary>
		public String id;
		/// <summary>
		/// 
		/// </summary>
		public String name;
		/// <summary>
		/// 
		/// </summary>
		public String nickname;
		/// <summary>
		/// 
		/// </summary>
		public String photo;
		/// <summary>
		/// 
		/// </summary>
		public ContactPresenceState presenceState;
		/// <summary>
		/// 
		/// </summary>
		public String presenceStatus;
		/// <summary>
		/// 
		/// </summary>
		public ContactSubscriptionState publicationState;
		/// <summary>
		/// 
		/// </summary>
		public ContactSubscriptionState subscriptionState;
		/// <summary>
		/// 
		/// </summary>
		public List<ContactProperty> telephones;
		/// <summary>
		/// 
		/// </summary>
		public ulong timestamp;
		/// <summary>
		/// 
		/// </summary>
		public String title;
		public Contact(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoContactConstructDefaultNative();
			}
			else {
				objPtr = VidyoContactConstructCopyNative(obj);
			}

			List<ContactProperty> csEmails = new List<ContactProperty>();
			var nEmailsSize = 0;
			var nEmails = VidyoContactGetemailsArrayNative(VidyoContactGetemailsNative(objPtr), ref nEmailsSize);
			var nEmailsIndex = 0;
			while (nEmailsIndex < nEmailsSize) {
				ContactProperty csTemails = new ContactProperty(Marshal.ReadIntPtr(nEmails + (nEmailsIndex * Marshal.SizeOf(nEmails))));
				csEmails.Add(csTemails);
				nEmailsIndex++;
			}

			List<String> csGroups = new List<String>();
			var nGroupsSize = 0;
			var nGroups = VidyoContactGetgroupsArrayNative(VidyoContactGetgroupsNative(objPtr), ref nGroupsSize);
			var nGroupsIndex = 0;
			while (nGroupsIndex < nGroupsSize) {
				csGroups.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nGroups + (nGroupsIndex * Marshal.SizeOf(nGroups)))));
				nGroupsIndex++;
			}

			List<ContactProperty> csTelephones = new List<ContactProperty>();
			var nTelephonesSize = 0;
			var nTelephones = VidyoContactGettelephonesArrayNative(VidyoContactGettelephonesNative(objPtr), ref nTelephonesSize);
			var nTelephonesIndex = 0;
			while (nTelephonesIndex < nTelephonesSize) {
				ContactProperty csTtelephones = new ContactProperty(Marshal.ReadIntPtr(nTelephones + (nTelephonesIndex * Marshal.SizeOf(nTelephones))));
				csTelephones.Add(csTtelephones);
				nTelephonesIndex++;
			}

			department = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGetdepartmentNative(objPtr));
			emails = csEmails;
			groups = csGroups;
			handle = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGethandleNative(objPtr));
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGetidNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGetnameNative(objPtr));
			nickname = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGetnicknameNative(objPtr));
			photo = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGetphotoNative(objPtr));
			presenceState = VidyoContactGetpresenceStateNative(objPtr);
			presenceStatus = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGetpresenceStatusNative(objPtr));
			publicationState = VidyoContactGetpublicationStateNative(objPtr);
			subscriptionState = VidyoContactGetsubscriptionStateNative(objPtr);
			telephones = csTelephones;
			timestamp = VidyoContactGettimestampNative(objPtr);
			title = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoContactGettitleNative(objPtr));
			VidyoContactFreetelephonesArrayNative(nTelephones, nTelephonesSize);
			VidyoContactFreegroupsArrayNative(nGroups, nGroupsSize);
			VidyoContactFreeemailsArrayNative(nEmails, nEmailsSize);
		}
		~Contact() {
			VidyoContactDestructNative(objPtr);
		 }
	};
}
