// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents a microphone on the local endpoint.
	/// </summary>
	public class LocalMicrophone: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalMicrophone reference.
		private GCHandle objHandle; // weak VidyoLocalMicrophone reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneAddToLocalSpeakerNative(IntPtr m, IntPtr speaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneAddToRemoteSpeakerNative(IntPtr m, IntPtr remoteSpeaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneDisableDebugRecordingNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneEnableDebugRecordingNative(IntPtr m, IntPtr dir);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneGetAutoGainNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern double VidyoLocalMicrophoneGetBoostNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneGetEchoCancellationNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneGetIdNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneGetNameNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern Device.DeviceAudioSignalType VidyoLocalMicrophoneGetSignalTypeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneGetTypeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneGetVoiceProcessingNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneGetVolumeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneHideDebugDialogNative(IntPtr microphone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneIsDebugRecordingEnabledNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneIsPausedNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophonePauseNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophonePlayToneNative(IntPtr m, char dtmfTone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneRemoveFromLocalSpeakerNative(IntPtr m, IntPtr speaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneRemoveFromRemoteSpeakerNative(IntPtr m, IntPtr remoteSpeaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneRestartNative(IntPtr microphone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneResumeNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneSetAutoGainNative(IntPtr m, Boolean autoGain);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneSetBoostNative(IntPtr m, double value);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneSetEchoCancellationNative(IntPtr m, IntPtr speaker, Boolean isEnable);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneSetSignalTypeNative(IntPtr m, [MarshalAs(UnmanagedType.I4)]Device.DeviceAudioSignalType signalType);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMicrophoneSetVoiceProcessingNative(IntPtr m, Boolean voiceProcessing, [MarshalAs(UnmanagedType.I4)]VoiceProcessingMode mode);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneSetVolumeNative(IntPtr m, uint volumePercent);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneShowDebugDialogNative(IntPtr microphone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalMicrophoneGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalMicrophoneSetUserDataNative(IntPtr obj, IntPtr userData);

		/// <summary>
		/// State of the voice processing selection mode inside the capturer.
		/// </summary>
		public enum VoiceProcessingMode {
			/// <summary>Audio capturer will rely on default voice processing algorithms.</summary>
			VoiceprocessingmodeDefault,
			/// <summary>Audio capturer will rely on Vidyo's voice processing algorithms.</summary>
			VoiceprocessingmodeVidyo,
			/// <summary>Audio capturer will rely on the voice processing algorithms supported by the OS (if applicable).</summary>
			VoiceprocessingmodePlatform
		}
		public LocalMicrophone(IntPtr other){
			objPtr = VidyoLocalMicrophoneConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoLocalMicrophoneSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~LocalMicrophone(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoLocalMicrophoneSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoLocalMicrophoneDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="speaker"></param>
		public Boolean AddToLocalSpeaker(LocalSpeaker speaker) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneAddToLocalSpeakerNative(objPtr, (speaker != null) ? speaker.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="remoteSpeaker"></param>
		public Boolean AddToRemoteSpeaker(RemoteSpeaker remoteSpeaker) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneAddToRemoteSpeakerNative(objPtr, (remoteSpeaker != null) ? remoteSpeaker.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Boolean DisableDebugRecording() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneDisableDebugRecordingNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="dir"></param>
		public Boolean EnableDebugRecording(String dir) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nDir = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(dir ?? string.Empty);
			Boolean ret = VidyoLocalMicrophoneEnableDebugRecordingNative(objPtr, nDir);
			Marshal.FreeHGlobal(nDir);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Boolean GetAutoGain() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneGetAutoGainNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get the microphone boost for the local microphone.
		/// </summary>
		/// <param name="m">The local microphone object.</param>
		public double GetBoost() {
			if (objPtr == IntPtr.Zero) { return default; }

			double ret = VidyoLocalMicrophoneGetBoostNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get echo cancellation status for particular microphone.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Boolean GetEchoCancellation() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneGetEchoCancellationNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the unique ID of the microphone.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalMicrophoneGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the name of the microphone.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalMicrophoneGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets signal type of the microphone, which affects how the audio is processed.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Device.DeviceAudioSignalType GetSignalType() {
			if (objPtr == IntPtr.Zero) { return default; }

			Device.DeviceAudioSignalType ret = VidyoLocalMicrophoneGetSignalTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Gets the type of the microphone.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public String GetType() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalMicrophoneGetTypeNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Boolean GetVoiceProcessing() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneGetVoiceProcessingNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public uint GetVolume() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoLocalMicrophoneGetVolumeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Hides an audio debug dialog for the local microphone.
		/// </summary>
		/// <param name="microphone">The local microphone object to extract stats.</param>
		public void HideDebugDialog() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMicrophoneHideDebugDialogNative(objPtr);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Boolean IsDebugRecordingEnabled() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneIsDebugRecordingEnabledNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public Boolean IsPaused() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneIsPausedNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public void Pause() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMicrophonePauseNative(objPtr);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="dtmfTone"></param>
		public void PlayTone(char dtmfTone) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMicrophonePlayToneNative(objPtr, dtmfTone);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="speaker"></param>
		public Boolean RemoveFromLocalSpeaker(LocalSpeaker speaker) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneRemoveFromLocalSpeakerNative(objPtr, (speaker != null) ? speaker.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="remoteSpeaker"></param>
		public Boolean RemoveFromRemoteSpeaker(RemoteSpeaker remoteSpeaker) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneRemoveFromRemoteSpeakerNative(objPtr, (remoteSpeaker != null) ? remoteSpeaker.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Restart the local microphone.
		/// </summary>
		/// <param name="microphone">The local microphone object to restart.</param>
		public Boolean Restart() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneRestartNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		public void Resume() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMicrophoneResumeNative(objPtr);
		}
		/// <summary>
		/// Enable or disable AGC for a microphone. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="autoGain">LMI_TRUE to enable AGC, LMI_FALSE to disable AGC.</param>
		public Boolean SetAutoGain(Boolean autoGain) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneSetAutoGainNative(objPtr, autoGain);

			return ret;
		}
		/// <summary>
		/// Set the microphone boost for the local microphone.
		/// </summary>
		/// <param name="m">The local microphone object.</param>
		/// <param name="value">The microphone boost in dB.</param>
		public Boolean SetBoost(double value) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneSetBoostNative(objPtr, value);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="speaker"></param>
		/// <param name="isEnable"></param>
		public Boolean SetEchoCancellation(LocalSpeaker speaker, Boolean isEnable) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneSetEchoCancellationNative(objPtr, (speaker != null) ? speaker.GetObjectPtr():IntPtr.Zero, isEnable);

			return ret;
		}
		/// <summary>
		/// Sets the signal type of the microhone which changes how the auido is processed. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="signalType">The signal type of the microphone.</param>
		public Boolean SetSignalType(Device.DeviceAudioSignalType signalType) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneSetSignalTypeNative(objPtr, signalType);

			return ret;
		}
		/// <summary>
		/// Enable or disable voice processing and set voice processing mode. If this API will be called for selected microphone this will cause a force reconfiguration of the device and will restart the audio capturer.
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="voiceProcessing">LMI_TRUE to enable the voice processing, LMI_FALSE to disable the voice processing.</param>
		/// <param name="mode">The voice processing mode.</param>
		public Boolean SetVoiceProcessing(Boolean voiceProcessing, VoiceProcessingMode mode) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMicrophoneSetVoiceProcessingNative(objPtr, voiceProcessing, mode);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMicrophone object.</param>
		/// <param name="volumePercent"></param>
		public void SetVolume(uint volumePercent) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMicrophoneSetVolumeNative(objPtr, volumePercent);
		}
		/// <summary>
		/// Shows an audio debug dialog for the local microphone.
		/// </summary>
		/// <param name="microphone">The local microphone object to extract stats.</param>
		public void ShowDebugDialog() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMicrophoneShowDebugDialogNative(objPtr);
		}
	};
}
