// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LocalMicrophoneStatsFactory
	{
		public static LocalMicrophoneStats Create()
		{
			return new LocalMicrophoneStats(IntPtr.Zero);
		}
		public static void Destroy(LocalMicrophoneStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a local microphone.
	/// </summary>
	public class LocalMicrophoneStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalMicrophoneStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
			IntPtr nLocalSpeakerStreams = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * localSpeakerStreams.Count);
			int nLocalSpeakerStreamsSize = 0;
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nRemoteSpeakerStreams = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * remoteSpeakerStreams.Count);
			int nRemoteSpeakerStreamsSize = 0;

			foreach (LocalSpeakerStreamStats iter in localSpeakerStreams) {
				Marshal.WriteIntPtr(nLocalSpeakerStreams + (nLocalSpeakerStreamsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLocalSpeakerStreamsSize++;
			}
			foreach (RemoteSpeakerStreamStats iter in remoteSpeakerStreams) {
				Marshal.WriteIntPtr(nRemoteSpeakerStreams + (nRemoteSpeakerStreamsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nRemoteSpeakerStreamsSize++;
			}

			VidyoLocalMicrophoneStatsSetaecEchoCouplingNative(objPtr, aecEchoCoupling);
			VidyoLocalMicrophoneStatsSetagcAverageGainNative(objPtr, agcAverageGain);
			VidyoLocalMicrophoneStatsSetbitsPerSampleNative(objPtr, bitsPerSample);
			VidyoLocalMicrophoneStatsSetformatNative(objPtr, format);
			VidyoLocalMicrophoneStatsSetidNative(objPtr, nId);
			VidyoLocalMicrophoneStatsSetlocalSpeakerStreamsNative(objPtr, nLocalSpeakerStreams, nLocalSpeakerStreamsSize);
			VidyoLocalMicrophoneStatsSetnameNative(objPtr, nName);
			VidyoLocalMicrophoneStatsSetnoiseSuppressionSnrNative(objPtr, noiseSuppressionSnr);
			VidyoLocalMicrophoneStatsSetnumberOfChannelsNative(objPtr, numberOfChannels);
			VidyoLocalMicrophoneStatsSetremoteSpeakerStreamsNative(objPtr, nRemoteSpeakerStreams, nRemoteSpeakerStreamsSize);
			VidyoLocalMicrophoneStatsSetsampleRateMeasuredNative(objPtr, sampleRateMeasured);
			VidyoLocalMicrophoneStatsSetsampleRateSetNative(objPtr, sampleRateSet);

			Marshal.FreeHGlobal(nRemoteSpeakerStreams);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nLocalSpeakerStreams);
			Marshal.FreeHGlobal(nId);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetaecEchoCouplingNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetaecEchoCouplingNative(IntPtr obj, uint aecEchoCoupling);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetagcAverageGainNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetagcAverageGainNative(IntPtr obj, uint agcAverageGain);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetbitsPerSampleNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetbitsPerSampleNative(IntPtr obj, uint bitsPerSample);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern MediaFormat VidyoLocalMicrophoneStatsGetformatNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetformatNative(IntPtr obj, MediaFormat format);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneStatsGetidNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetidNative(IntPtr obj, IntPtr id);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneStatsGetlocalSpeakerStreamsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetlocalSpeakerStreamsNative(IntPtr obj, IntPtr localSpeakerStreams, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneStatsGetlocalSpeakerStreamsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsFreelocalSpeakerStreamsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetnoiseSuppressionSnrNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetnoiseSuppressionSnrNative(IntPtr obj, uint noiseSuppressionSnr);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetnumberOfChannelsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetnumberOfChannelsNative(IntPtr obj, uint numberOfChannels);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneStatsGetremoteSpeakerStreamsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetremoteSpeakerStreamsNative(IntPtr obj, IntPtr remoteSpeakerStreams, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMicrophoneStatsGetremoteSpeakerStreamsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsFreeremoteSpeakerStreamsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetsampleRateMeasuredNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetsampleRateMeasuredNative(IntPtr obj, uint sampleRateMeasured);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLocalMicrophoneStatsGetsampleRateSetNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMicrophoneStatsSetsampleRateSetNative(IntPtr obj, uint sampleRateSet);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalMicrophoneStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalMicrophoneStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalMicrophoneStatsDestructNative(IntPtr obj);

		/// <summary>
		/// AEC echo coupling.
		/// </summary>
		public uint aecEchoCoupling;
		/// <summary>
		/// AGC average gain.
		/// </summary>
		public uint agcAverageGain;
		/// <summary>
		/// Bits per sample.
		/// </summary>
		public uint bitsPerSample;
		/// <summary>
		/// Format.
		/// </summary>
		public MediaFormat format;
		/// <summary>
		/// Id.
		/// </summary>
		public String id;
		/// <summary>
		/// Vector of stats of local speaker streams.
		/// </summary>
		public List<LocalSpeakerStreamStats> localSpeakerStreams;
		/// <summary>
		/// Name.
		/// </summary>
		public String name;
		/// <summary>
		/// Noise suppression SNR.
		/// </summary>
		public uint noiseSuppressionSnr;
		/// <summary>
		/// Number of channels.
		/// </summary>
		public uint numberOfChannels;
		/// <summary>
		/// Vector of stats of remote speaker streams.
		/// </summary>
		public List<RemoteSpeakerStreamStats> remoteSpeakerStreams;
		/// <summary>
		/// Measured sample rate.
		/// </summary>
		public uint sampleRateMeasured;
		/// <summary>
		/// Sample rate setting.
		/// </summary>
		public uint sampleRateSet;
		public LocalMicrophoneStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLocalMicrophoneStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLocalMicrophoneStatsConstructCopyNative(obj);
			}

			List<LocalSpeakerStreamStats> csLocalSpeakerStreams = new List<LocalSpeakerStreamStats>();
			var nLocalSpeakerStreamsSize = 0;
			var nLocalSpeakerStreams = VidyoLocalMicrophoneStatsGetlocalSpeakerStreamsArrayNative(VidyoLocalMicrophoneStatsGetlocalSpeakerStreamsNative(objPtr), ref nLocalSpeakerStreamsSize);
			var nLocalSpeakerStreamsIndex = 0;
			while (nLocalSpeakerStreamsIndex < nLocalSpeakerStreamsSize) {
				LocalSpeakerStreamStats csTlocalSpeakerStreams = new LocalSpeakerStreamStats(Marshal.ReadIntPtr(nLocalSpeakerStreams + (nLocalSpeakerStreamsIndex * Marshal.SizeOf(nLocalSpeakerStreams))));
				csLocalSpeakerStreams.Add(csTlocalSpeakerStreams);
				nLocalSpeakerStreamsIndex++;
			}

			List<RemoteSpeakerStreamStats> csRemoteSpeakerStreams = new List<RemoteSpeakerStreamStats>();
			var nRemoteSpeakerStreamsSize = 0;
			var nRemoteSpeakerStreams = VidyoLocalMicrophoneStatsGetremoteSpeakerStreamsArrayNative(VidyoLocalMicrophoneStatsGetremoteSpeakerStreamsNative(objPtr), ref nRemoteSpeakerStreamsSize);
			var nRemoteSpeakerStreamsIndex = 0;
			while (nRemoteSpeakerStreamsIndex < nRemoteSpeakerStreamsSize) {
				RemoteSpeakerStreamStats csTremoteSpeakerStreams = new RemoteSpeakerStreamStats(Marshal.ReadIntPtr(nRemoteSpeakerStreams + (nRemoteSpeakerStreamsIndex * Marshal.SizeOf(nRemoteSpeakerStreams))));
				csRemoteSpeakerStreams.Add(csTremoteSpeakerStreams);
				nRemoteSpeakerStreamsIndex++;
			}

			aecEchoCoupling = VidyoLocalMicrophoneStatsGetaecEchoCouplingNative(objPtr);
			agcAverageGain = VidyoLocalMicrophoneStatsGetagcAverageGainNative(objPtr);
			bitsPerSample = VidyoLocalMicrophoneStatsGetbitsPerSampleNative(objPtr);
			format = VidyoLocalMicrophoneStatsGetformatNative(objPtr);
			id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalMicrophoneStatsGetidNative(objPtr));
			localSpeakerStreams = csLocalSpeakerStreams;
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLocalMicrophoneStatsGetnameNative(objPtr));
			noiseSuppressionSnr = VidyoLocalMicrophoneStatsGetnoiseSuppressionSnrNative(objPtr);
			numberOfChannels = VidyoLocalMicrophoneStatsGetnumberOfChannelsNative(objPtr);
			remoteSpeakerStreams = csRemoteSpeakerStreams;
			sampleRateMeasured = VidyoLocalMicrophoneStatsGetsampleRateMeasuredNative(objPtr);
			sampleRateSet = VidyoLocalMicrophoneStatsGetsampleRateSetNative(objPtr);
			VidyoLocalMicrophoneStatsFreeremoteSpeakerStreamsArrayNative(nRemoteSpeakerStreams, nRemoteSpeakerStreamsSize);
			VidyoLocalMicrophoneStatsFreelocalSpeakerStreamsArrayNative(nLocalSpeakerStreams, nLocalSpeakerStreamsSize);
		}
		~LocalMicrophoneStats() {
			VidyoLocalMicrophoneStatsDestructNative(objPtr);
		 }
	};
}
