// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// This object represents a monitor on the local endpoint.
	/// </summary>
	public class LocalMonitor: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLocalMonitor reference.
		private GCHandle objHandle; // weak VidyoLocalMonitor reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLocalMonitorAddToLocalRendererNative(IntPtr m, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorAddToRemoteRendererNative(IntPtr m, IntPtr remoteRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorClearConstraintsNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMonitorConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMonitorDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorExcludeWindowNative(IntPtr monitor, IntPtr window, Boolean exclude);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMonitorGetIdNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMonitorGetNameNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern LocalMonitorState VidyoLocalMonitorGetPreviewFrameDataUriNative(IntPtr m, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxWidth, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxHeight, IntPtr videoFrame);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorGetPreviewFrameDataUriAsyncNative(IntPtr m, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxWidth, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT maxHeight, OnPreviewDataUriComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorIsPrimaryNative(IntPtr m);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMonitorPrecludeApplicationNative(IntPtr m, IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLocalMonitorPrecludeWindowNative(IntPtr m, IntPtr w);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorRemoveFromLocalRendererNative(IntPtr m, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorRemoveFromRemoteRendererNative(IntPtr m, IntPtr remoteRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetBoundsConstraintsNative(IntPtr m, ulong maxFrameInterval, ulong minFrameInterval, uint maxWidth, uint minWidth, uint maxHeight, uint minHeight);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetCaptureIntervalNative(IntPtr m, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetDiscreteConstraintsNative(IntPtr m, ulong maxFrameInterval, ulong minFrameInterval, uint width, uint height, double scaleFactor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetFrameIntervalNative(IntPtr m, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetLowLatencyProfileNative(IntPtr m, Boolean profile);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetMaxConstraintsNative(IntPtr m, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetMinFrameIntervalNative(IntPtr m, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitorSetPositionInLocalRendererNative(IntPtr m, IntPtr localRenderer, int x, int y, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoLocalMonitoreGetCapabilitiesNative(IntPtr monitor, OnGetCapabilities onGetCapabilities);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLocalMonitorGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLocalMonitorSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetCapabilities(IntPtr m, uint width, uint height, ulong frameInterval);
		private OnGetCapabilities _mOnGetCapabilities = OnGetCapabilitiesDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPreviewDataUriComplete(IntPtr m, IntPtr videoFrame, LocalMonitorState state);
		private OnPreviewDataUriComplete _mOnPreviewDataUriComplete = OnPreviewDataUriCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLocalMonitorOnPreviewDataUriCompleteGetvideoFrameCStr(IntPtr videoFrame);

		/// <summary>
		/// State of the monitor.
		/// </summary>
		public enum LocalMonitorState {
			/// <summary>The monitor is visible and has been fully captured.</summary>
			LocalmonitorstateOk,
			/// <summary>The monitor exists but is not "visible".</summary>
			LocalmonitorstateNotVisible,
			/// <summary>Miscellaneous error has occured trying to capture the frame.</summary>
			LocalmonitorstateMiscError
		}
		public interface IGetPreviewFrameDataUriAsync{

			void OnPreviewDataUriComplete(String videoFrame, LocalMonitorState state);
		}
		public interface IeGetCapabilities{

			void OnGetCapabilities(uint width, uint height, ulong frameInterval);
		}
		private IGetPreviewFrameDataUriAsync _mIGetPreviewFrameDataUriAsync;
		private IeGetCapabilities _mIeGetCapabilities;
		public LocalMonitor(IntPtr other){
			objPtr = VidyoLocalMonitorConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoLocalMonitorSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~LocalMonitor(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoLocalMonitorSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoLocalMonitorDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="renderer"></param>
		public ulong AddToLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			ulong ret = VidyoLocalMonitorAddToLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="remoteRenderer"></param>
		public Boolean AddToRemoteRenderer(RemoteRenderer remoteRenderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorAddToRemoteRendererNative(objPtr, (remoteRenderer != null) ? remoteRenderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Clears existing constraints and set them to default values 3840x2160@3fps.
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		public Boolean ClearConstraints() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorClearConstraintsNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Enable/disable window exclude. Only top-level window related to the current process can be excluded.
		/// </summary>
		/// <param name="monitor">The VidyoLocalMonitor object.</param>
		/// <param name="window">The VidyoLocalWindowShare object.</param>
		/// <param name="exclude">The variable indicates whether the window will be excluded or not.</param>
		public Boolean ExcludeWindow(LocalWindowShare window, Boolean exclude) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorExcludeWindowNative(objPtr, (window != null) ? window.GetObjectPtr():IntPtr.Zero, exclude);

			return ret;
		}
		/// <summary>
		/// Gets the unique ID of the monitor.
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalMonitorGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// Gets the name of the monitor.
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoLocalMonitorGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="maxWidth">Maximum width of the preview image.</param>
		/// <param name="maxHeight">Maximum height of the preview image.</param>
		/// <param name="videoFrame">Video Frame to which the image will be assigned.</param>
		public LocalMonitorState GetPreviewFrameDataUri(SizeT maxWidth, SizeT maxHeight, String videoFrame) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nVideoFrame = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(videoFrame ?? string.Empty);
			LocalMonitorState ret = VidyoLocalMonitorGetPreviewFrameDataUriNative(objPtr, maxWidth, maxHeight, nVideoFrame);
			Marshal.FreeHGlobal(nVideoFrame);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="maxWidth">Maximum width of the preview image.</param>
		/// <param name="maxHeight">Maximum height of the preview image.</param>
		/// <param name="onComplete">Callback that is triggered when a preview frame is captured.</param>
		public Boolean GetPreviewFrameDataUriAsync(SizeT maxWidth, SizeT maxHeight, IGetPreviewFrameDataUriAsync _iIGetPreviewFrameDataUriAsync) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetPreviewFrameDataUriAsync = _iIGetPreviewFrameDataUriAsync;

			Boolean ret = VidyoLocalMonitorGetPreviewFrameDataUriAsyncNative(objPtr, maxWidth, maxHeight, _mOnPreviewDataUriComplete);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		public Boolean IsPrimary() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorIsPrimaryNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m"></param>
		/// <param name="w"></param>
		public void PrecludeApplication(LocalWindowShare w) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMonitorPrecludeApplicationNative(objPtr, (w != null) ? w.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="w"></param>
		public void PrecludeWindow(LocalWindowShare w) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoLocalMonitorPrecludeWindowNative(objPtr, (w != null) ? w.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="renderer"></param>
		public Boolean RemoveFromLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorRemoveFromLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="remoteRenderer"></param>
		public Boolean RemoveFromRemoteRenderer(RemoteRenderer remoteRenderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorRemoveFromRemoteRendererNative(objPtr, (remoteRenderer != null) ? remoteRenderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// Set a maximum width and height for the encoded stream and frame interval bounds. The stream size will be scaled down to fit the maxWidth/maxHeight if the capture is larger than either of those dimensions
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="maxFrameInterval">Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="minFrameInterval">Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="maxWidth">Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit</param>
		/// <param name="minWidth">Unused</param>
		/// <param name="maxHeight">Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit</param>
		/// <param name="minHeight">Unusued</param>
		public Boolean SetBoundsConstraints(ulong maxFrameInterval, ulong minFrameInterval, uint maxWidth, uint minWidth, uint maxHeight, uint minHeight) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetBoundsConstraintsNative(objPtr, maxFrameInterval, minFrameInterval, maxWidth, minWidth, maxHeight, minHeight);

			return ret;
		}
		/// <summary>
		/// Set frame interval(fps) for capturer.
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. By default will be calculated based on encoder configuration.</param>
		public Boolean SetCaptureInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetCaptureIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// Set the stream characteristics, causing the stream to be reconfigured. This is an override which allows teh application to control the stream reconfiguration. After calling SetDiscreteConstraints the stream will not longer be reconfigured unless SetDiscreteConstraints again or SetBoundsConstraints is used
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="maxFrameInterval">Maximum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="minFrameInterval">Minimum time between frames in ns. This is a hint to the resource manager for how it decides to allocate internal resources (cpu,mem,etc)</param>
		/// <param name="width">The width of the stream after the stream is reconfigured</param>
		/// <param name="height">The height of the stream after the stream is reconfigured</param>
		/// <param name="scaleFactor">This should be 1</param>
		public Boolean SetDiscreteConstraints(ulong maxFrameInterval, ulong minFrameInterval, uint width, uint height, double scaleFactor) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetDiscreteConstraintsNative(objPtr, maxFrameInterval, minFrameInterval, width, height, scaleFactor);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. Default is 333333333 which is 3 frames per second.</param>
		public Boolean SetFrameInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetFrameIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// Sets the low latency profile of the monitor which treats the stream as a regular video source. This prioritizes latency over quality.
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="profile">Low latency profile toggle. Default is LMI_FALSE.</param>
		public Boolean SetLowLatencyProfile(Boolean profile) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetLowLatencyProfileNative(objPtr, profile);

			return ret;
		}
		/// <summary>
		/// Set a maximum width, height, and minimum frame interval(max fps) for the encoded stream. The stream size will be scaled down with a preserving aspect ratio to fit the width/height if the capture is larger than either of those dimensions. If the monitor is in landscape mode width and height will be applied as max constraints, if the monitor is in portrait mode width and height will be swapped. Any values are allowed for width and height if they fit width multiply height equal to or less than 4K pixels(3840 x 2160 = 8294400 pixels) and higher than 180p (320 x 180 = 57600 pixels).
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object</param>
		/// <param name="width">Maximum width of the encoded stream. If the captured stream width is larger than this max the stream will be scaled before sending to fit. The default value is 3840.</param>
		/// <param name="height">Maximum height of the encoded stream. If the captured stream height is larger than this max the stream will be scaled before sending to fit. The default value is 2160.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).</param>
		public Boolean SetMaxConstraints(uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetMaxConstraintsNative(objPtr, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// Set a minimum frame interval(maximum fps) for the encoded stream.
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames. The default is 333333333 (3fps). To enable a high frame rate share set value less than 142857142 (7 fps). Range of allowed values 33333333(30fps) - 5000000000(1 frame per 5 secs).</param>
		public Boolean SetMinFrameInterval(ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetMinFrameIntervalNative(objPtr, frameInterval);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="m">The VidyoLocalMonitor object.</param>
		/// <param name="localRenderer"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		/// <param name="frameInterval">The interval in nanoseconds between consecutive frames.</param>
		public Boolean SetPositionInLocalRenderer(LocalRenderer localRenderer, int x, int y, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoLocalMonitorSetPositionInLocalRendererNative(objPtr, (localRenderer != null) ? localRenderer.GetObjectPtr():IntPtr.Zero, x, y, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// Get the capabilities of the operating point that is currently used as the most optimal for the device. Note: These capabilities are used during starting the device.
		/// </summary>
		/// <param name="monitor">The VidyoLocalMonitor object.</param>
		/// <param name="onGetCapabilities">The callback to which we will pass the most optimal capabilities.</param>
		public Boolean eGetCapabilities(IeGetCapabilities _iIeGetCapabilities) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIeGetCapabilities = _iIeGetCapabilities;

			Boolean ret = VidyoLocalMonitoreGetCapabilitiesNative(objPtr, _mOnGetCapabilities);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetCapabilities))]
#endif
		private static void OnGetCapabilitiesDelegate(IntPtr m, uint width, uint height, ulong frameInterval){
			var csMPtr = m != IntPtr.Zero ? VidyoLocalMonitorGetUserDataNative(m) : IntPtr.Zero;
			if(csMPtr == IntPtr.Zero) return;
			var csM = (LocalMonitor)GCHandle.FromIntPtr(csMPtr).Target;

			csM?._mIeGetCapabilities?.OnGetCapabilities(width, height, frameInterval);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPreviewDataUriComplete))]
#endif
		private static void OnPreviewDataUriCompleteDelegate(IntPtr m, IntPtr videoFrame, LocalMonitorState state){
			var csMPtr = m != IntPtr.Zero ? VidyoLocalMonitorGetUserDataNative(m) : IntPtr.Zero;
			if(csMPtr == IntPtr.Zero) return;
			var csM = (LocalMonitor)GCHandle.FromIntPtr(csMPtr).Target;

			var n_videoFrame = VidyoLocalMonitorOnPreviewDataUriCompleteGetvideoFrameCStr(videoFrame);

			csM?._mIGetPreviewFrameDataUriAsync?.OnPreviewDataUriComplete((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_videoFrame), state);
		}
	};
}
