// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LogDataStatsFactory
	{
		public static LogDataStats Create()
		{
			return new LogDataStats(IntPtr.Zero);
		}
		public static void Destroy(LogDataStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics for a log function:line number.
	/// </summary>
	public class LogDataStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLogDataStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

			VidyoLogDataStatsSetnameNative(objPtr, nName);
			VidyoLogDataStatsSetoccurancesNative(objPtr, occurances);

			Marshal.FreeHGlobal(nName);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogDataStatsGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogDataStatsSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoLogDataStatsGetoccurancesNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogDataStatsSetoccurancesNative(IntPtr obj, uint occurances);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLogDataStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLogDataStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLogDataStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Function name and line number of the log record.
		/// </summary>
		public String name;
		/// <summary>
		/// Number of occurances of this log record.
		/// </summary>
		public uint occurances;
		public LogDataStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLogDataStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLogDataStatsConstructCopyNative(obj);
			}

			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLogDataStatsGetnameNative(objPtr));
			occurances = VidyoLogDataStatsGetoccurancesNative(objPtr);
		}
		~LogDataStats() {
			VidyoLogDataStatsDestructNative(objPtr);
		 }
	};
}
