// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LogRecordFactory
	{
		public static LogRecord Create()
		{
			return new LogRecord(IntPtr.Zero);
		}
		public static void Destroy(LogRecord obj)
		{
		}
	}
	/// <summary>
	/// A record of one logged event.
	/// </summary>
	public class LogRecord {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLogRecord reference.
		public IntPtr GetObjectPtr() {
			IntPtr nFile = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(file ?? string.Empty);
			IntPtr nFunctionName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(functionName ?? string.Empty);
			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
			IntPtr nThreadName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(threadName ?? string.Empty);

			VidyoLogRecordSetcategoryNameNative(objPtr, categoryName);
			VidyoLogRecordSeteventTimeNative(objPtr, eventTime);
			VidyoLogRecordSetfileNative(objPtr, nFile);
			VidyoLogRecordSetfunctionNameNative(objPtr, nFunctionName);
			VidyoLogRecordSetlevelNative(objPtr, level);
			VidyoLogRecordSetlineNative(objPtr, line);
			VidyoLogRecordSetmessageNative(objPtr, nMessage);
			VidyoLogRecordSetnameNative(objPtr, nName);
			VidyoLogRecordSetthreadNameNative(objPtr, nThreadName);

			Marshal.FreeHGlobal(nThreadName);
			Marshal.FreeHGlobal(nName);
			Marshal.FreeHGlobal(nMessage);
			Marshal.FreeHGlobal(nFunctionName);
			Marshal.FreeHGlobal(nFile);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]
		private static extern SizeT VidyoLogRecordGetcategoryNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetcategoryNameNative(IntPtr obj, [MarshalAs(UnmanagedType.CustomMarshaler, MarshalTypeRef = typeof(SizeTMarshaler))]SizeT categoryName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern ulong VidyoLogRecordGeteventTimeNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSeteventTimeNative(IntPtr obj, ulong eventTime);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogRecordGetfileNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetfileNative(IntPtr obj, IntPtr file);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogRecordGetfunctionNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetfunctionNameNative(IntPtr obj, IntPtr functionName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern LogLevel VidyoLogRecordGetlevelNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetlevelNative(IntPtr obj, LogLevel level);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern int VidyoLogRecordGetlineNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetlineNative(IntPtr obj, int line);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogRecordGetmessageNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetmessageNative(IntPtr obj, IntPtr message);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogRecordGetnameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetnameNative(IntPtr obj, IntPtr name);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogRecordGetthreadNameNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogRecordSetthreadNameNative(IntPtr obj, IntPtr threadName);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLogRecordConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLogRecordConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLogRecordDestructNative(IntPtr obj);

		/// <summary>
		/// An identifier for the level, or type, of a logged event. This indicates the degree of significance of the event.
		/// </summary>
		public enum LogLevel {
			/// <summary>The event being logged describes a fatal error. In all likelihood system execution will not be able to continue.</summary>
			LoglevelFATAL,
			/// <summary>The event being logged describes a continuable error. The system should be able to continue, but human intervention or diagnosis may be necessary.</summary>
			LoglevelERROR,
			/// <summary>The event being logged describes a warning. Something has occurred which may require attention or action, but which is not actually erroneous.</summary>
			LoglevelWARNING,
			/// <summary>The event being logged describes information which may be useful or informative to a user of the system. No problems are being reported.</summary>
			LoglevelINFO,
			/// <summary>The event being logged describes information which may be useful to a developer to understand the code. The information is not expected to be useful to users of the system.</summary>
			LoglevelDEBUG,
			/// <summary>The event being logged describes data that has been transmitted by the system.</summary>
			LoglevelSENT,
			/// <summary>The event being logged describes data that has been received by the system.</summary>
			LoglevelRECEIVED,
			/// <summary>The event being logged describes the system entering a function.</summary>
			LoglevelENTER,
			/// <summary>The event being logged describes the system leaving from a function.</summary>
			LoglevelLEAVE,
			/// <summary>A value that does not represent a valid log level. This value is returned by LmiLogGetLevelByName and LmiLogGetLevelByIndex on invalid input.</summary>
			LoglevelINVALID
		}
		/// <summary>
		/// 
		/// </summary>
		public SizeT categoryName;
		/// <summary>
		/// 
		/// </summary>
		public ulong eventTime;
		/// <summary>
		/// 
		/// </summary>
		public String file;
		/// <summary>
		/// 
		/// </summary>
		public String functionName;
		/// <summary>
		/// 
		/// </summary>
		public LogLevel level;
		/// <summary>
		/// 
		/// </summary>
		public int line;
		/// <summary>
		/// 
		/// </summary>
		public String message;
		/// <summary>
		/// 
		/// </summary>
		public String name;
		/// <summary>
		/// 
		/// </summary>
		public String threadName;
		public LogRecord(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLogRecordConstructDefaultNative();
			}
			else {
				objPtr = VidyoLogRecordConstructCopyNative(obj);
			}

			categoryName = VidyoLogRecordGetcategoryNameNative(objPtr);
			eventTime = VidyoLogRecordGeteventTimeNative(objPtr);
			file = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLogRecordGetfileNative(objPtr));
			functionName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLogRecordGetfunctionNameNative(objPtr));
			level = VidyoLogRecordGetlevelNative(objPtr);
			line = VidyoLogRecordGetlineNative(objPtr);
			message = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLogRecordGetmessageNative(objPtr));
			name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLogRecordGetnameNative(objPtr));
			threadName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoLogRecordGetthreadNameNative(objPtr));
		}
		~LogRecord() {
			VidyoLogRecordDestructNative(objPtr);
		 }
	};
}
