// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	public class LogStatsFactory
	{
		public static LogStats Create()
		{
			return new LogStats(IntPtr.Zero);
		}
		public static void Destroy(LogStats obj)
		{
		}
	}
	/// <summary>
	/// Staticstics of the endpoint logs.
	/// </summary>
	public class LogStats {
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoLogStats reference.
		public IntPtr GetObjectPtr() {
			IntPtr nLogErrorDataStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * logErrorDataStats.Count);
			int nLogErrorDataStatsSize = 0;
			IntPtr nLogWarningDataStats = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * logWarningDataStats.Count);
			int nLogWarningDataStatsSize = 0;

			foreach (LogDataStats iter in logErrorDataStats) {
				Marshal.WriteIntPtr(nLogErrorDataStats + (nLogErrorDataStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLogErrorDataStatsSize++;
			}
			foreach (LogDataStats iter in logWarningDataStats) {
				Marshal.WriteIntPtr(nLogWarningDataStats + (nLogWarningDataStatsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nLogWarningDataStatsSize++;
			}

			VidyoLogStatsSetlogErrorDataStatsNative(objPtr, nLogErrorDataStats, nLogErrorDataStatsSize);
			VidyoLogStatsSetlogWarningDataStatsNative(objPtr, nLogWarningDataStats, nLogWarningDataStatsSize);

			Marshal.FreeHGlobal(nLogWarningDataStats);
			Marshal.FreeHGlobal(nLogErrorDataStats);
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogStatsGetlogErrorDataStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogStatsSetlogErrorDataStatsNative(IntPtr obj, IntPtr logErrorDataStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogStatsGetlogErrorDataStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogStatsFreelogErrorDataStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogStatsGetlogWarningDataStatsNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogStatsSetlogWarningDataStatsNative(IntPtr obj, IntPtr logWarningDataStats, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoLogStatsGetlogWarningDataStatsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoLogStatsFreelogWarningDataStatsArrayNative(IntPtr obj, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLogStatsConstructCopyNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoLogStatsConstructDefaultNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoLogStatsDestructNative(IntPtr obj);

		/// <summary>
		/// Vector of error stats data of logs.
		/// </summary>
		public List<LogDataStats> logErrorDataStats;
		/// <summary>
		/// Vector of warning stats data of logs.
		/// </summary>
		public List<LogDataStats> logWarningDataStats;
		public LogStats(IntPtr obj){
			if(obj == IntPtr.Zero) {
				objPtr = VidyoLogStatsConstructDefaultNative();
			}
			else {
				objPtr = VidyoLogStatsConstructCopyNative(obj);
			}

			List<LogDataStats> csLogErrorDataStats = new List<LogDataStats>();
			var nLogErrorDataStatsSize = 0;
			var nLogErrorDataStats = VidyoLogStatsGetlogErrorDataStatsArrayNative(VidyoLogStatsGetlogErrorDataStatsNative(objPtr), ref nLogErrorDataStatsSize);
			var nLogErrorDataStatsIndex = 0;
			while (nLogErrorDataStatsIndex < nLogErrorDataStatsSize) {
				LogDataStats csTlogErrorDataStats = new LogDataStats(Marshal.ReadIntPtr(nLogErrorDataStats + (nLogErrorDataStatsIndex * Marshal.SizeOf(nLogErrorDataStats))));
				csLogErrorDataStats.Add(csTlogErrorDataStats);
				nLogErrorDataStatsIndex++;
			}

			List<LogDataStats> csLogWarningDataStats = new List<LogDataStats>();
			var nLogWarningDataStatsSize = 0;
			var nLogWarningDataStats = VidyoLogStatsGetlogWarningDataStatsArrayNative(VidyoLogStatsGetlogWarningDataStatsNative(objPtr), ref nLogWarningDataStatsSize);
			var nLogWarningDataStatsIndex = 0;
			while (nLogWarningDataStatsIndex < nLogWarningDataStatsSize) {
				LogDataStats csTlogWarningDataStats = new LogDataStats(Marshal.ReadIntPtr(nLogWarningDataStats + (nLogWarningDataStatsIndex * Marshal.SizeOf(nLogWarningDataStats))));
				csLogWarningDataStats.Add(csTlogWarningDataStats);
				nLogWarningDataStatsIndex++;
			}

			logErrorDataStats = csLogErrorDataStats;
			logWarningDataStats = csLogWarningDataStats;
			VidyoLogStatsFreelogWarningDataStatsArrayNative(nLogWarningDataStats, nLogWarningDataStatsSize);
			VidyoLogStatsFreelogErrorDataStatsArrayNative(nLogErrorDataStats, nLogErrorDataStatsSize);
		}
		~LogStats() {
			VidyoLogStatsDestructNative(objPtr);
		 }
	};
}
