// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// 
	/// </summary>
	public class RemoteRenderer: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRemoteRenderer reference.
		private GCHandle objHandle; // weak VidyoRemoteRenderer reference.
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteRendererConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRemoteRendererDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteRendererGetIdNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRemoteRendererGetNameNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRemoteRendererIsClientCanResumeNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRemoteRendererIsPausedNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRemoteRendererPauseNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRemoteRendererResumeNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRemoteRendererGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRemoteRendererSetUserDataNative(IntPtr obj, IntPtr userData);

		public RemoteRenderer(IntPtr other){
			objPtr = VidyoRemoteRendererConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoRemoteRendererSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
		}
		~RemoteRenderer(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			if(objPtr != IntPtr.Zero) {
				VidyoRemoteRendererSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoRemoteRendererDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoRemoteRendererGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public String GetName() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoRemoteRendererGetNameNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The VidyoRemoteRenderer object.</param>
		public Boolean IsClientCanResume() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRemoteRendererIsClientCanResumeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The VidyoRemoteRenderer object.</param>
		public Boolean IsPaused() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRemoteRendererIsPausedNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The VidyoRemoteRenderer object.</param>
		public Boolean Pause() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRemoteRendererPauseNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The VidyoRemoteRenderer object.</param>
		public Boolean Resume() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRemoteRendererResumeNative(objPtr);

			return ret;
		}
	};
}
