// DO NOT EDIT! This is an autogenerated file. All changes will be
// overwritten!

//	Copyright (c) 2023 Vidyo, Inc. All rights reserved.


using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;

namespace VidyoClient
{
	/// <summary>
	/// Establishes and manages a conference room. See VidyoRoomType for sescription of room types.
	/// </summary>
	public class Room: IDisposable {
		private bool disposed = false; 
#if __IOS__
		const string importLib = "__Internal";
#else
		const string importLib = "libVidyoClient";
#endif
		private IntPtr objPtr; // opaque VidyoRoom reference.
		private GCHandle objHandle; // weak VidyoRoom reference.
		private Dictionary<string, Participant> participantsMap = new Dictionary<string, Participant>();
		private List<WeakReference> objects = new List<WeakReference>();

		private void DisposeWeakReferenceObjects() {
			foreach(var item in objects) {
				if (item == null || !item.IsAlive || item.Target == null) { continue; }
				switch (item.Target.GetType().Name) {
					case "Participant": ((Participant)item.Target).Dispose(false); break;
					case "User": ((User)item.Target).Dispose(false); break;
				}
			}
			objects.Clear();
		}
		public IntPtr GetObjectPtr() {
			return objPtr;
		}
		public Dictionary<string, Participant> GetParticipantsMap() {
			return participantsMap;
		}
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomAcceptIncomingNative(IntPtr r, OnIncomingEntered onIncomingEntered, OnIncomingExited onIncomingExited);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomAcquireMediaRouteNative(IntPtr r, OnMediaRouteAcquired onMediaRouteAcquired, OnMediaRouteAcquireFailed onMediaRouteAcquireFailed);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddLocalCameraNative(IntPtr r, IntPtr localCamera, Boolean removeOthers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddLocalMicrophoneNative(IntPtr r, IntPtr localMicrophone, Boolean removeOthers, Boolean isAES);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddLocalMonitorNative(IntPtr r, IntPtr localMonitor, Boolean removeOthers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddLocalRendererNative(IntPtr r, IntPtr localRenderer, Boolean removeOthers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddLocalSpeakerNative(IntPtr r, IntPtr localSpeaker, Boolean removeOthers, Boolean isAES);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddLocalWindowShareNative(IntPtr r, IntPtr localWindowShare, Boolean removeOthers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddVirtualAudioSourceNative(IntPtr r, IntPtr virtualAudioSource, Boolean removeOthers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomAddVirtualVideoSourceNative(IntPtr r, IntPtr virtualVideoSource, Boolean removeOthers);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomApproveRaisedHandNative(IntPtr r, IntPtr participant, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomBootAllParticipantsNative(IntPtr r, IntPtr reason, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomBootParticipantNative(IntPtr r, IntPtr userId, IntPtr reason, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomCancelInviteNative(IntPtr r, IntPtr inviteeId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomConstructCopyNative(IntPtr other);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomCreateParticipantProfileNative(IntPtr r, IntPtr p, IntPtr userId, [MarshalAs(UnmanagedType.I4)]RoomProfileControlMode microphone, [MarshalAs(UnmanagedType.I4)]RoomProfileControlMode camera, [MarshalAs(UnmanagedType.I4)]RoomProfileControlMode windowShare, [MarshalAs(UnmanagedType.I4)]RoomProfileControlMode chat);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomDeleteNative(IntPtr r, OnDeleteResult onDeleteResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomDestroyParticipantProfileNative(IntPtr r, IntPtr p);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomDestructNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomDisableMediaNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomDismissAllRaisedHandsNative(IntPtr r, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomDismissRaisedHandNative(IntPtr r, IntPtr participants, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomDismissRaisedHandSetparticipantsArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomVectorVidyoParticipantAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomVectorVidyoParticipantDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomEnableMediaNative(IntPtr r, OnMediaEnabled onMediaEnabled, OnMediaFailed onMediaFailed, OnMediaDisabled onMediaDisabled);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomEnterNative(IntPtr r, IntPtr password, OnEntered onEntered, OnExited onExited);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomGetHistoryNative(IntPtr r, uint numMessages, OnGetHistoryResults onGetHistoryResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomGetHistoryByIdNative(IntPtr r, long messageId, uint numMessagesBefore, uint numMessagesAfter, OnGetHistoryResults onGetHistoryResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomGetHistoryByTimeNative(IntPtr r, ulong time, uint numMessagesBefore, uint numMessagesAfter, OnGetHistoryResults onGetHistoryResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomGetIdNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomGetRoomPropertiesNative(IntPtr r, OnGetRoomPropertiesResult onGetRoomPropertiesResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomGetSelectedLocalCamerasNative(IntPtr r, OnGetSelectedLocalCamerasComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomGetSelectedLocalMicrophonesNative(IntPtr r, OnGetSelectedLocalMicrophonesComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomGetSelectedLocalMonitorsNative(IntPtr r, OnGetSelectedLocalMonitorsComplete monitors);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomGetSelectedLocalRenderersNative(IntPtr r, OnGetSelectedLocalRenderersComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomGetSelectedLocalSpeakersNative(IntPtr r, OnGetSelectedLocalSpeakersComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomGetSelectedLocalWindowSharesNative(IntPtr r, OnGetSelectedLocalWindowSharesComplete onComplete);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern RoomShowThrottle VidyoRoomGetShowThrottleNative(IntPtr room);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomGetShowThrottleTimerIntervalNative(IntPtr room);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern uint VidyoRoomGetShowThrottleWindowSizeChangeThresholdNative(IntPtr room);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I4)]
		private static extern RoomType VidyoRoomGetTypeNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomGetUserNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomHideStatisticsDialogNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInviteNative(IntPtr r, IntPtr userId, IntPtr message, OnInviteResult onInviteResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInviteAllNative(IntPtr r, IntPtr message, OnInviteResult onInviteResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomInviteNNative(IntPtr r, IntPtr userIds, IntPtr message, OnInviteResult onInviteResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomInviteNSetuserIdsArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomVectorLmiStringAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomVectorLmiStringDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomLeaveNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomLockRoomNative(IntPtr r, OnLockRoomResult onLockRoomResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomMessageSearchNative(IntPtr r, IntPtr searchText, uint index, uint pageSize, OnMessageSearchResults onMessageSearchResults);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomPauseRecordingNative(IntPtr r, OnRecordingServicePauseResult onRecordingServicePauseResultCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRaiseHandNative(IntPtr r, OnRaiseHandResponse raiseHandResponse, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterBotEventListenerNative(IntPtr r, OnBotJoined onJoined, OnBotLeft onLeft);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterConferenceModeEventListenerNative(IntPtr r, OnConferenceModeChanged conferenceModeChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterConnectionPropertiesEventListenerNative(IntPtr r, OnConnectionPropertiesChanged onConnectionPropertiesChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterHostEventListenerNative(IntPtr r, OnConferenceHostStatusChanged hostStatus);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterInCallEventListenerNative(IntPtr r, OnInCallEvents cb);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterLectureModeEventListenerNative(IntPtr room, OnPresenterChanged presenterChanged, OnHandRaised handRaised);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterMessageEventListenerNative(IntPtr r, OnMessageReceived onMessageReceived, OnMessageAcknowledged onMessageAcknowledged, OnMessageRead onMessageRead, OnMessageTypingIndication onMessageTypingIndication);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterModerationCommandEventListenerNative(IntPtr room, OnModerationCommandReceived onModerationCommand);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterModerationResultEventListenerNative(IntPtr room, OnModerationResult onModerationResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterParticipantEventListenerNative(IntPtr r, OnParticipantJoined onParticipantJoined, OnParticipantLeft onParticipantLeft, OnDynamicParticipantChanged onDynamicParticipantChanged, OnLoudestParticipantChanged onLoudestParticipantChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterPipEventListenerNative(IntPtr r, OnPipLocationChanged onPipLocationChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterRecorderInCallEventListenerNative(IntPtr r, RecorderInCall onRecorderInCallChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterResourceManagerEventListenerNative(IntPtr r, OnAvailableResourcesChanged onAvailableResourcesChanged, OnMaxRemoteSourcesChanged onMaxRemoteSourcesChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterRoomPropertiesEventListenerNative(IntPtr r, OnRoomPropertiesChanged onRoomPropertiesChanged);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterSubjectEventListenerNative(IntPtr r, OnSetSubject onSetSubject);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRegisterUnprocessedAudioEventListenerNative(IntPtr r, OnUnprocessedAudioSupportChanged onUnprocessedAudioSupportChanged, OnUnprocessedAudioStarted onUnprocessedAudioStarted);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRejectIncomingNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveLocalCameraNative(IntPtr r, IntPtr localCamera);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveLocalMicrophoneNative(IntPtr r, IntPtr localMicrophone);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveLocalMonitorNative(IntPtr r, IntPtr localMonitor);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveLocalRendererNative(IntPtr r, IntPtr localRenderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveLocalSpeakerNative(IntPtr r, IntPtr localSpeaker);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveLocalWindowShareNative(IntPtr r, IntPtr localWindowShare);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRemovePresenterNative(IntPtr room, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRemoveRoleChangeAuthorizationNative(IntPtr room, [MarshalAs(UnmanagedType.I4)]Role role, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRemoveRoomPINNative(IntPtr r, OnRemoveRoomPINResult onRemoveRoomPINResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveVirtualAudioSourceNative(IntPtr r, IntPtr virtualAudioSource);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomRemoveVirtualVideoSourceNative(IntPtr r, IntPtr virtualVideoSource);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomReportLocalParticipantOnJoinedNative(IntPtr r, Boolean reportLocalParticipant);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRequestAudioSilenceForAllNative(IntPtr room, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRequestAudioSilenceForParticipantNative(IntPtr room, IntPtr userId, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRequestRoleChangeNative(IntPtr room, [MarshalAs(UnmanagedType.I4)]Role newRole, IntPtr auth, OnRequestRoleChangeResult onRequestRoleChangeResult, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRequestVideoSilenceForAllNative(IntPtr room, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRequestVideoSilenceForParticipantNative(IntPtr room, IntPtr userId, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomResizeStatisticsDialogNative(IntPtr r, int width, int height);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomResumeRecordingNative(IntPtr r, OnRecordingServiceResumeResult onRecordingServiceResumeResultCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRevokeAudioForAllNative(IntPtr room, Boolean revoke, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRevokeAudioForParticipantNative(IntPtr room, IntPtr userId, Boolean revoke, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRevokeVideoForAllNative(IntPtr room, Boolean revoke, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomRevokeVideoForParticipantNative(IntPtr room, IntPtr userId, Boolean revoke, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSendMessageNative(IntPtr r, IntPtr message);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSendMessageAcknowledgedNative(IntPtr r, long messageId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSendMessageTypingIndicationNative(IntPtr r, [MarshalAs(UnmanagedType.I4)]ChatMessage.ChatMessageTypingIndication typingIndication);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSendPrivateMessageNative(IntPtr r, IntPtr participant, IntPtr message);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetDefaultProfileNative(IntPtr r, IntPtr profile, OnSetRoomPropertyResult onSetRoomPropertyResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetDynamicGenerationPositionNative(IntPtr r, uint generation, int x, int y, uint width, uint height, ulong frameInterval);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetDynamicLocalRendererNative(IntPtr r, IntPtr renderer);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomSetFavoriteNative(IntPtr r, Boolean isFavorite, OnSetFavoriteResult onSetFavoriteResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetMaxAudioSourcesNative(IntPtr r, uint count);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomSetMaxReceiveBitRateNative(IntPtr r, uint bitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomSetMaxSendBitRateNative(IntPtr r, uint bitRate);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetMaxVideoSourcesNative(IntPtr r, uint count);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetParticipantProfilesNative(IntPtr r, IntPtr profiles, OnSetRoomPropertyResult onSetRoomPropertyResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomSetParticipantProfilesSetprofilesArrayNative(IntPtr obj, IntPtr objArray, int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomVectorVidyoRoomParticipantProfileAllocateNative();

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomVectorVidyoRoomParticipantProfileDeallocateNative(IntPtr param);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetPresenterNative(IntPtr room, IntPtr participant, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetRoleChangeAuthorizationNative(IntPtr room, [MarshalAs(UnmanagedType.I4)]Role role, IntPtr auth, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetRoomPINNative(IntPtr r, IntPtr roomPIN, OnSetRoomPINResult onSetRoomPINResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetRoomPropertiesNative(IntPtr r, IntPtr roomProperties, OnSetRoomPropertiesResult onSetRoomPropertiesResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomSetShowThrottleNative(IntPtr room, [MarshalAs(UnmanagedType.I4)]RoomShowThrottle t);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomSetShowThrottleTimerIntervalNative(IntPtr room, uint seconds);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomSetShowThrottleWindowSizeChangeThresholdNative(IntPtr room, uint percentage);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomSetSubjectNative(IntPtr r, IntPtr subject);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern void VidyoRoomShowStatisticsDialogNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomStartLectureModeNative(IntPtr room, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomStartRecordingNative(IntPtr r, IntPtr recordingProfilePrefix, OnRecordingServiceStartResult onRecordingServiceStartCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomStopLectureModeNative(IntPtr room, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomStopRecordingNative(IntPtr r, OnRecordingServiceStopResult onRecordingServiceStopResultCallback);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnlockRoomNative(IntPtr r, OnUnlockRoomResult onUnlockRoomResult);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnraiseHandNative(IntPtr r, IntPtr requestId);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterBotEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterConferenceModeEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterConnectionPropertiesEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterHostEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterInCallEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterLectureModeEventListenerNative(IntPtr room);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterMessageEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterModerationCommandEventListenerNative(IntPtr room);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterModerationResultEventListenerNative(IntPtr room);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterParticipantEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterPipEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterRecorderInCallEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterResourceManagerEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterRoomPropertiesEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterSubjectEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		[return: MarshalAs(UnmanagedType.I1)]
		private static extern Boolean VidyoRoomUnregisterUnprocessedAudioEventListenerNative(IntPtr r);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern IntPtr VidyoRoomGetUserDataNative(IntPtr obj);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		public static extern void VidyoRoomSetUserDataNative(IntPtr obj, IntPtr userData);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnAvailableResourcesChanged(IntPtr room, uint cpuEncode, uint cpuDecode, uint bandwidthSend, uint bandwidthReceive);
		private OnAvailableResourcesChanged _mOnAvailableResourcesChanged = OnAvailableResourcesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnBotJoined(IntPtr r, IntPtr info);
		private OnBotJoined _mOnBotJoined = OnBotJoinedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnBotLeft(IntPtr r, IntPtr info);
		private OnBotLeft _mOnBotLeft = OnBotLeftDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConferenceHostStatusChanged(IntPtr r, IntPtr host, RoomConferenceHostState hostState);
		private OnConferenceHostStatusChanged _mOnConferenceHostStatusChanged = OnConferenceHostStatusChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConferenceModeChanged(IntPtr r, RoomConferenceMode mode);
		private OnConferenceModeChanged _mOnConferenceModeChanged = OnConferenceModeChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnConnectionPropertiesChanged(IntPtr r, IntPtr connectionProperties);
		private OnConnectionPropertiesChanged _mOnConnectionPropertiesChanged = OnConnectionPropertiesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnDeleteResult(IntPtr room, RoomDeleteResult result);
		private OnDeleteResult _mOnDeleteResult = OnDeleteResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnDynamicParticipantChanged(IntPtr room, IntPtr selectedParticipants);
		private OnDynamicParticipantChanged _mOnDynamicParticipantChanged = OnDynamicParticipantChangedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnDynamicParticipantChangedGetselectedParticipantsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnDynamicParticipantChangedFreeselectedParticipantsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnEntered(IntPtr room, RoomEnterResult result);
		private OnEntered _mOnEntered = OnEnteredDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnExited(IntPtr room, RoomExitReason reason);
		private OnExited _mOnExited = OnExitedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetHistoryResults(IntPtr room, IntPtr records, long historySize, RoomSearchResult result);
		private OnGetHistoryResults _mOnGetHistoryResults = OnGetHistoryResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetHistoryResultsGetrecordsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetHistoryResultsFreerecordsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetRoomPropertiesResult(IntPtr room, RoomGetPropertiesResult result, IntPtr roomProperties);
		private OnGetRoomPropertiesResult _mOnGetRoomPropertiesResult = OnGetRoomPropertiesResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetSelectedLocalCamerasComplete(IntPtr r, IntPtr cameras);
		private OnGetSelectedLocalCamerasComplete _mOnGetSelectedLocalCamerasComplete = OnGetSelectedLocalCamerasCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalCamerasCompleteGetcamerasArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalCamerasCompleteFreecamerasArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetSelectedLocalMicrophonesComplete(IntPtr r, IntPtr microphones);
		private OnGetSelectedLocalMicrophonesComplete _mOnGetSelectedLocalMicrophonesComplete = OnGetSelectedLocalMicrophonesCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalMicrophonesCompleteGetmicrophonesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalMicrophonesCompleteFreemicrophonesArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetSelectedLocalMonitorsComplete(IntPtr r, IntPtr monitors);
		private OnGetSelectedLocalMonitorsComplete _mOnGetSelectedLocalMonitorsComplete = OnGetSelectedLocalMonitorsCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalMonitorsCompleteGetmonitorsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalMonitorsCompleteFreemonitorsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetSelectedLocalRenderersComplete(IntPtr r, IntPtr renderers);
		private OnGetSelectedLocalRenderersComplete _mOnGetSelectedLocalRenderersComplete = OnGetSelectedLocalRenderersCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalRenderersCompleteGetrenderersArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalRenderersCompleteFreerenderersArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetSelectedLocalSpeakersComplete(IntPtr r, IntPtr speakers);
		private OnGetSelectedLocalSpeakersComplete _mOnGetSelectedLocalSpeakersComplete = OnGetSelectedLocalSpeakersCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalSpeakersCompleteGetspeakersArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalSpeakersCompleteFreespeakersArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnGetSelectedLocalWindowSharesComplete(IntPtr r, IntPtr windowShares);
		private OnGetSelectedLocalWindowSharesComplete _mOnGetSelectedLocalWindowSharesComplete = OnGetSelectedLocalWindowSharesCompleteDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalWindowSharesCompleteGetwindowSharesArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnGetSelectedLocalWindowSharesCompleteFreewindowSharesArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnHandRaised(IntPtr room, IntPtr participant);
		private OnHandRaised _mOnHandRaised = OnHandRaisedDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnHandRaisedGetparticipantArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnHandRaisedFreeparticipantArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnInCallEvents(IntPtr r, IntPtr ev);
		private OnInCallEvents _mOnInCallEvents = OnInCallEventsDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnIncomingEntered(IntPtr room, RoomEnterResult result);
		private OnIncomingEntered _mOnIncomingEntered = OnIncomingEnteredDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnIncomingExited(IntPtr room, RoomExitReason reason);
		private OnIncomingExited _mOnIncomingExited = OnIncomingExitedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnInviteResult(IntPtr room, IntPtr inviteeId, RoomInviteResult result);
		private OnInviteResult _mOnInviteResult = OnInviteResultDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnInviteResultGetinviteeIdCStr(IntPtr inviteeId);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLockRoomResult(IntPtr room, RoomSetPropertiesResult result);
		private OnLockRoomResult _mOnLockRoomResult = OnLockRoomResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnLoudestParticipantChanged(IntPtr room, IntPtr participant, Boolean isAudioOnly, Boolean isStatic);
		private OnLoudestParticipantChanged _mOnLoudestParticipantChanged = OnLoudestParticipantChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMaxRemoteSourcesChanged(IntPtr room, uint maxRemoteSources);
		private OnMaxRemoteSourcesChanged _mOnMaxRemoteSourcesChanged = OnMaxRemoteSourcesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMediaDisabled(IntPtr room, RoomMediaDisableReason reason);
		private OnMediaDisabled _mOnMediaDisabled = OnMediaDisabledDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMediaEnabled(IntPtr room);
		private OnMediaEnabled _mOnMediaEnabled = OnMediaEnabledDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMediaFailed(IntPtr room, RoomMediaFailReason reason);
		private OnMediaFailed _mOnMediaFailed = OnMediaFailedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMediaRouteAcquireFailed(IntPtr room, RoomMediaFailReason reason);
		private OnMediaRouteAcquireFailed _mOnMediaRouteAcquireFailed = OnMediaRouteAcquireFailedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMediaRouteAcquired(IntPtr room);
		private OnMediaRouteAcquired _mOnMediaRouteAcquired = OnMediaRouteAcquiredDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMessageAcknowledged(IntPtr room, IntPtr chatMessage);
		private OnMessageAcknowledged _mOnMessageAcknowledged = OnMessageAcknowledgedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMessageRead(IntPtr room, IntPtr participant, long messageId);
		private OnMessageRead _mOnMessageRead = OnMessageReadDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMessageReceived(IntPtr room, IntPtr participant, IntPtr chatMessage);
		private OnMessageReceived _mOnMessageReceived = OnMessageReceivedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMessageSearchResults(IntPtr room, IntPtr searchText, IntPtr records, RoomSearchResult result);
		private OnMessageSearchResults _mOnMessageSearchResults = OnMessageSearchResultsDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnMessageSearchResultsGetrecordsArrayNative(IntPtr obj, ref int size);

		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnMessageSearchResultsFreerecordsArrayNative(IntPtr obj, int size);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnMessageTypingIndication(IntPtr room, IntPtr participant, ChatMessage.ChatMessageTypingIndication typingIndication);
		private OnMessageTypingIndication _mOnMessageTypingIndication = OnMessageTypingIndicationDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnModerationCommandReceived(IntPtr room, Device.DeviceType deviceType, RoomModerationType moderationType, Boolean state);
		private OnModerationCommandReceived _mOnModerationCommandReceived = OnModerationCommandReceivedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnModerationResult(IntPtr room, IntPtr participant, RoomModerationResult result, RoomModerationActionType actionType, IntPtr requestId);
		private OnModerationResult _mOnModerationResult = OnModerationResultDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnModerationResultGetrequestIdCStr(IntPtr requestId);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnParticipantJoined(IntPtr room, IntPtr participant);
		private OnParticipantJoined _mOnParticipantJoined = OnParticipantJoinedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnParticipantLeft(IntPtr room, IntPtr participant);
		private OnParticipantLeft _mOnParticipantLeft = OnParticipantLeftDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPipLocationChanged(IntPtr room, int x, int y, uint width, uint height, Boolean isExpanded);
		private OnPipLocationChanged _mOnPipLocationChanged = OnPipLocationChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnPresenterChanged(IntPtr room, IntPtr participant);
		private OnPresenterChanged _mOnPresenterChanged = OnPresenterChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRaiseHandResponse(IntPtr r, Participant.ParticipantHandState handState);
		private OnRaiseHandResponse _mOnRaiseHandResponse = OnRaiseHandResponseDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServicePauseResult(IntPtr r, RoomSetPropertiesResult result);
		private OnRecordingServicePauseResult _mOnRecordingServicePauseResult = OnRecordingServicePauseResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServiceResumeResult(IntPtr r, RoomSetPropertiesResult result);
		private OnRecordingServiceResumeResult _mOnRecordingServiceResumeResult = OnRecordingServiceResumeResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServiceStartResult(IntPtr r, RoomSetPropertiesResult result);
		private OnRecordingServiceStartResult _mOnRecordingServiceStartResult = OnRecordingServiceStartResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRecordingServiceStopResult(IntPtr r, RoomSetPropertiesResult result);
		private OnRecordingServiceStopResult _mOnRecordingServiceStopResult = OnRecordingServiceStopResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRemoveRoomPINResult(IntPtr room, RoomSetPropertiesResult result);
		private OnRemoveRoomPINResult _mOnRemoveRoomPINResult = OnRemoveRoomPINResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRequestRoleChangeResult(IntPtr room, RoomRequestRoleChangeResult result, IntPtr requestId);
		private OnRequestRoleChangeResult _mOnRequestRoleChangeResult = OnRequestRoleChangeResultDelegate;
		[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
		private static extern IntPtr VidyoRoomOnRequestRoleChangeResultGetrequestIdCStr(IntPtr requestId);

		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnRoomPropertiesChanged(IntPtr room, IntPtr roomProperties);
		private OnRoomPropertiesChanged _mOnRoomPropertiesChanged = OnRoomPropertiesChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSetFavoriteResult(IntPtr room, Boolean isFavorite, RoomSetFavoriteResult result);
		private OnSetFavoriteResult _mOnSetFavoriteResult = OnSetFavoriteResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSetRoomPINResult(IntPtr room, RoomSetPropertiesResult result);
		private OnSetRoomPINResult _mOnSetRoomPINResult = OnSetRoomPINResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSetRoomPropertiesResult(IntPtr room, RoomSetPropertiesResult result);
		private OnSetRoomPropertiesResult _mOnSetRoomPropertiesResult = OnSetRoomPropertiesResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSetRoomPropertyResult(IntPtr room, RoomSetPropertiesResult result);
		private OnSetRoomPropertyResult _mOnSetRoomPropertyResult = OnSetRoomPropertyResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnSetSubject(IntPtr room, IntPtr subject);
		private OnSetSubject _mOnSetSubject = OnSetSubjectDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUnlockRoomResult(IntPtr room, RoomSetPropertiesResult result);
		private OnUnlockRoomResult _mOnUnlockRoomResult = OnUnlockRoomResultDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUnprocessedAudioStarted(IntPtr room, Boolean started);
		private OnUnprocessedAudioStarted _mOnUnprocessedAudioStarted = OnUnprocessedAudioStartedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void OnUnprocessedAudioSupportChanged(IntPtr room, Boolean supported);
		private OnUnprocessedAudioSupportChanged _mOnUnprocessedAudioSupportChanged = OnUnprocessedAudioSupportChangedDelegate;
		[UnmanagedFunctionPointer(CallingConvention.Cdecl)]
		private delegate void RecorderInCall(IntPtr r, Boolean hasRecorder, Boolean isPaused);
		private RecorderInCall _mRecorderInCall = RecorderInCallDelegate;
		/// <summary>
		/// 
		/// </summary>
		public enum Role {
			/// <summary></summary>
			RoleModerator,
			/// <summary></summary>
			RoleNone
		}
		/// <summary>
		/// Tell us the joining status of the host or owner of the room hosting the conference.
		/// </summary>
		public enum RoomConferenceHostState {
			/// <summary>Tells us if the host has joined</summary>
			RoomconferencehoststateJOINED,
			/// <summary>Tells us if the host has left the conference</summary>
			RoomconferencehoststateLEFT
		}
		/// <summary>
		/// Sets the type of conference mode.
		/// </summary>
		public enum RoomConferenceMode {
			/// <summary>Tells us if the user has entered into a waiting room,i.e. presenter has not joined yet</summary>
			RoomconferencemodeLOBBY,
			/// <summary>Tells us if conference mode is lecture mode</summary>
			RoomconferencemodeLECTURE,
			/// <summary>Tells us if the user is in group mode</summary>
			RoomconferencemodeGROUP
		}
		/// <summary>
		/// This type indicates the result of delete room.
		/// </summary>
		public enum RoomDeleteResult {
			/// <summary>The delete room operation was successful.</summary>
			RoomdeleteresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to delete room.</summary>
			RoomdeleteresultNoResponse,
			/// <summary>The user did not have permission to delete room.</summary>
			RoomdeleteresultUnauthorized,
			/// <summary>The server cannot delete rooms at the current time because it is out of some resource.</summary>
			RoomdeleteresultOutOfResources,
			/// <summary>Some other error occurred.</summary>
			RoomdeleteresultMiscError
		}
		/// <summary>
		/// Result of an attempt to enter a VidyoRoom.
		/// </summary>
		public enum RoomEnterResult {
			/// <summary>Room entered successfully.</summary>
			RoomenterresultOK,
			/// <summary>Enter request was cancelled.</summary>
			RoomenterresultCancelled,
			/// <summary>Server did not respond in a reasonable amount of time to the request to enter the room.</summary>
			RoomenterresultNoResponse,
			/// <summary>User did not provide a password when one was required, or provided an invalid password.</summary>
			RoomenterresultInvalidPassword,
			/// <summary>Room specified by the user does not exist.</summary>
			RoomenterresultUnknownRoom,
			/// <summary>Room is at full capacity and cannot accept additional members.</summary>
			RoomenterresultRoomFull,
			/// <summary>Room is locked.</summary>
			RoomenterresultRoomLocked,
			/// <summary>Room allows only certain users to enter, and the user is not one of them.</summary>
			RoomenterresultNotMember,
			/// <summary>User has been banned from entering the room.</summary>
			RoomenterresultBanned,
			/// <summary>Server is rejecting the request to enter due to some miscellaneous problem with the request.</summary>
			RoomenterresultMiscLocalError,
			/// <summary>Server is rejecting the request to enter due to some miscellaneous problem of its own.</summary>
			RoomenterresultMiscRemoteError
		}
		/// <summary>
		/// Reason why a user is no longer a participant of a VidyoRoom.
		/// </summary>
		public enum RoomExitReason {
			/// <summary>Leave was invoked, and this action completed successfully.</summary>
			RoomexitreasonLeft,
			/// <summary>Connectivity was lost and signaling messages can no longer be sent or received.</summary>
			RoomexitreasonConnectionLost,
			/// <summary>Session connectivity was lost.</summary>
			RoomexitreasonSessionConnectionLost,
			/// <summary>Membership connectivity was lost.</summary>
			RoomexitreasonMembershipConnectionLost,
			/// <summary>A signaling request was sent, but no response was received within the allotted amount of time.</summary>
			RoomexitreasonNoResponse,
			/// <summary>A signaling message was received that could not be understood or otherwise violated the rules of the protocol in use.</summary>
			RoomexitreasonProtocolViolation,
			/// <summary>User was kicked out of the room. This could be the result of an administrator's action.</summary>
			RoomexitreasonBooted,
			/// <summary>Room or the entire conferencing service is going offline. All users are being removed from the room.</summary>
			RoomexitreasonShuttingDown,
			/// <summary>Some miscellaneous problem occurred with this application.</summary>
			RoomexitreasonMiscLocalError,
			/// <summary>Some miscellaneous problem occurred with the conferencing service.</summary>
			RoomexitreasonMiscRemoteError
		}
		/// <summary>
		/// This type indicates the result of get room properties.
		/// </summary>
		public enum RoomGetPropertiesResult {
			/// <summary>The get properties operation was successful.</summary>
			RoomgetpropertiesresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to get room properties.</summary>
			RoomgetpropertiesresultNoResponse,
			/// <summary>The user did not have permission to get room properties.</summary>
			RoomgetpropertiesresultUnauthorized,
			/// <summary>The server is rejecting the request to get room properties due to some miscellaneous problem with the request.</summary>
			RoomgetpropertiesresultMiscLocalError,
			/// <summary>The server is rejecting the request to get room properties due to some miscellaneous problem of its own.</summary>
			RoomgetpropertiesresultMiscRemoteError
		}
		/// <summary>
		/// It identifies the class of in call event.
		/// </summary>
		public enum RoomInCallEventClass {
			/// <summary>It indicate event belongs to media transportation.</summary>
			RoomincalleventclassMediaTransport,
			/// <summary>It indicate event belongs to InCallCodec.</summary>
			RoomincalleventclassInCallCodec,
			/// <summary>It indicate event belongs to Dtls.</summary>
			RoomincalleventclassDtls,
			/// <summary>It indicate Unknown event.</summary>
			RoomincalleventclassUnKnown
		}
		/// <summary>
		/// It represents error code in call event.
		/// </summary>
		public enum RoomInCallEventCode {
			/// <summary>RTCP send fail.</summary>
			RoomincalleventcodeRTCPSendError,
			/// <summary>RTCP receive fail.</summary>
			RoomincalleventcodeRTCPReceiveError,
			/// <summary>RTP media packet send fail.</summary>
			RoomincalleventcodeRTPSendError,
			/// <summary>RTP media packet receive fail.</summary>
			RoomincalleventcodeRTPReceiveError,
			/// <summary>Notification when encoder pauses when low bandwidth condition occur.</summary>
			RoomincalleventcodeEncoderPausedOnLowBW,
			/// <summary>Notification when encoder resumes after pause.</summary>
			RoomincalleventcodeEncoderResumed,
			/// <summary>Notification when H264 video codec is used in a conference call.</summary>
			RoomincalleventcodeInCallCodecVideoH264,
			/// <summary>Notification when H264-SVC video codec is used in a conference call.</summary>
			RoomincalleventcodeInCallCodecVideoH264SVC,
			/// <summary>Notification when SPEEX RED audio codec is used in a conference call.</summary>
			RoomincalleventcodeInCallCodecAudioSPEEXRED,
			/// <summary>Notification when Dtls encryption fails.</summary>
			RoomincalleventcodeDtlsError,
			/// <summary>Unknown event code.</summary>
			RoomincalleventcodeUnKnown
		}
		/// <summary>
		/// This type indicates the result of an attempt to invite an user to a room.
		/// </summary>
		public enum RoomInviteResult {
			/// <summary>The invite operation was successful.</summary>
			RoominviteresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to invite user to the room.</summary>
			RoominviteresultNoResponse,
			/// <summary>The user does not have sufficient privileges to invite user to the room it requested.</summary>
			RoominviteresultUnauthorized,
			/// <summary>The server cannot delete rooms at the current time because it is out of some resource.</summary>
			RoominviteresultOutOfResources,
			/// <summary>Some other error occurred.</summary>
			RoominviteresultMiscError,
			/// <summary>User we are attempting to invite to a room is offline.</summary>
			RoominviteresultUserIsOffline,
			/// <summary>Server returned an error while attemptig to invite user to the room.</summary>
			RoominviteresultServerError,
			/// <summary>Room is currently full.</summary>
			RoominviteresultRoomFull
		}
		/// <summary>
		/// This type indicates the reason why media support is now disabled on a room.
		/// </summary>
		public enum RoomMediaDisableReason {
			/// <summary>Media support was disabled gracefully (after calling VidyoRoomEnableMedia).</summary>
			RoommediadisablereasonDisabled,
			/// <summary>Signaling connectivity to the conference server was lost.</summary>
			RoommediadisablereasonSignalingConnectionLost,
			/// <summary>Media connectivity to the conference server was lost.</summary>
			RoommediadisablereasonMediaConnectionLost,
			/// <summary>The server is ousting this member from the conference. This could be the result of an administrator's action.</summary>
			RoommediadisablereasonBooted,
			/// <summary>The session that was carrying the conferencing protocol has been terminated.</summary>
			RoommediadisablereasonSessionTerminated,
			/// <summary>The conference server is shutting down. All members of all conferences are being booted.</summary>
			RoommediadisablereasonServerShuttingDown,
			/// <summary>The conference is being destroyed. All members of the conference are being booted.</summary>
			RoommediadisablereasonConferenceDestroyed,
			/// <summary>Some miscellaneous problem occurred with this application.</summary>
			RoommediadisablereasonMiscLocalError,
			/// <summary>Some miscellaneous problem occurred with the conferencing service.</summary>
			RoommediadisablereasonMiscRemoteError
		}
		/// <summary>
		/// This type indicates the reason why an attempt to enable media on a room failed.
		/// </summary>
		public enum RoomMediaFailReason {
			/// <summary>Media support was disabled (by calling VidyoRoomDisableMedia) before an attempt to enable it completed.</summary>
			RoommediafailreasonCancelled,
			/// <summary>There was an error determining which conference to join.</summary>
			RoommediafailreasonNoConference,
			/// <summary>Signaling Connection lost on current transport.</summary>
			RoommediafailreasonSignalingConnectionLost,
			/// <summary>Media Connection lost on current transport.</summary>
			RoommediafailreasonMediaConnectionLost,
			/// <summary>Signaling messages were sent to enable media, but no response was received within the allotted amount of time.</summary>
			RoommediafailreasonNoResponse,
			/// <summary>Media support was disabled because the room password has changed.</summary>
			RoommediafailreasonInvalidPassword,
			/// <summary>Media support was disabled because the room pin has changed.</summary>
			RoommediafailreasonInvalidRoomPin,
			/// <summary>Media support was disabled because the room is full.</summary>
			RoommediafailreasonRoomIsFull,
			/// <summary>Media support was disabled because the room is invalid.</summary>
			RoommediafailreasonInvalidRoomKey,
			/// <summary>Media support was disabled because the room is disabled.</summary>
			RoommediafailreasonRoomDisabled,
			/// <summary>Media support was disabled because all lines are in use.</summary>
			RoommediafailreasonAllLinesInUse,
			/// <summary>Media support was disabled because the of a connection error.</summary>
			RoommediafailreasonConnectionError,
			/// <summary></summary>
			RoommediafailreasonInvalidRoom,
			/// <summary>Media support was disabled because the room is locked.</summary>
			RoommediafailreasonConferenceLocked,
			/// <summary>Media support was disabled because the seat license has expired.</summary>
			RoommediafailreasonSeatLicenseExpired,
			/// <summary>Media support was disabled because the endpoint is not licensed.</summary>
			RoommediafailreasonNotLicensed,
			/// <summary>Attempt to enable media was rejected by the server</summary>
			RoommediafailreasonRejected,
			/// <summary>Media support was disabled as there an unknown fault from the portal.</summary>
			RoommediafailreasonUnknownError,
			/// <summary>Some miscellaneous problem occurred with this application.</summary>
			RoommediafailreasonMiscLocalError,
			/// <summary>Some miscellaneous problem occurred with the conferencing service.</summary>
			RoommediafailreasonMiscRemoteError
		}
		/// <summary>
		/// This type indicates the action of moderation request.
		/// </summary>
		public enum RoomModerationActionType {
			/// <summary>Mute video or audio action.</summary>
			RoommoderationactiontypeMute,
			/// <summary>Unmute video or audio action.</summary>
			RoommoderationactiontypeUnmute,
			/// <summary>Start lecture mode action.</summary>
			RoommoderationactiontypeStartLectureMode,
			/// <summary>Stop lecture mode action.</summary>
			RoommoderationactiontypeStopLectureMode,
			/// <summary>Set presenter action.</summary>
			RoommoderationactiontypeSetPresenter,
			/// <summary>Remove presenter action.</summary>
			RoommoderationactiontypeRemovePresenter,
			/// <summary>Raise hand action.</summary>
			RoommoderationactiontypeRaiseHand,
			/// <summary>Unraise hand action.</summary>
			RoommoderationactiontypeUnraiseHand,
			/// <summary>Dismiss raised hand action.</summary>
			RoommoderationactiontypeDismissRaisedHand,
			/// <summary>Dismiss all raised hands action.</summary>
			RoommoderationactiontypeDismissAllRaisedHands,
			/// <summary>Set moderator pin.</summary>
			RoommoderationactiontypeSetModeratorPin,
			/// <summary>Remove moderator pin.</summary>
			RoommoderationactiontypeRemoveModeratorPin,
			/// <summary>Disconnect all participants.</summary>
			RoommoderationactiontypeDisconnectAll,
			/// <summary>Disconnect one participant.</summary>
			RoommoderationactiontypeDisconnectOne,
			/// <summary>Wrong action.</summary>
			RoommoderationactiontypeInvalid
		}
		/// <summary>
		/// This type indicates the result of room moderation
		/// </summary>
		public enum RoomModerationResult {
			/// <summary>The moderation operation was successful.</summary>
			RoommoderationresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the moderation request.</summary>
			RoommoderationresultNoResponse,
			/// <summary>The user did not have permission to moderate.</summary>
			RoommoderationresultUnauthorized,
			/// <summary>The input of role change authorization is invalid.</summary>
			RoommoderationresultInvalidInput,
			/// <summary>Moderation request failed due to some miscellaneous problem with the request.</summary>
			RoommoderationresultMiscLocalError,
			/// <summary>The server is rejecting the moderation request due to some miscellaneous problem of its own.</summary>
			RoommoderationresultMiscRemoteError
		}
		/// <summary>
		/// Sets the type of moderation command received from the server.
		/// </summary>
		public enum RoomModerationType {
			/// <summary>Moderation command which tells that device was muted by the server and he is allowed to unmute.</summary>
			RoommoderationtypeSoftMute,
			/// <summary>Moderation command which tells that device was muted by the server and he is NOT allowed to unmute.</summary>
			RoommoderationtypeHardMute,
			/// <summary>Moderation command which tells that device was not muted by the server and he is allowed to unmute.</summary>
			RoommoderationtypeNone
		}
		/// <summary>
		/// Describes the profile control mode.
		/// </summary>
		public enum RoomProfileControlMode {
			/// <summary>Profile is always ON.</summary>
			RoomprofilecontrolmodeAlwaysOn,
			/// <summary>Profile is always OFF.</summary>
			RoomprofilecontrolmodeAlwaysOff,
			/// <summary>Profile will take the default behavior.</summary>
			RoomprofilecontrolmodeDefault
		}
		/// <summary>
		/// Provide the status of recording.
		/// </summary>
		public enum RoomRecordingState {
			/// <summary>Recording is in stop state.</summary>
			RoomrecordingstateNotRecording,
			/// <summary>Recording is in pause state.</summary>
			RoomrecordingstateRecordingPaused,
			/// <summary>Recording is in start/resume state.</summary>
			RoomrecordingstateRecording
		}
		/// <summary>
		/// This type indicates the result of request role change.
		/// </summary>
		public enum RoomRequestRoleChangeResult {
			/// <summary>Request role change was successful.</summary>
			RoomrequestrolechangeresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the role change request.</summary>
			RoomrequestrolechangeresultNoResponse,
			/// <summary>The user did not have permission to request role change.</summary>
			RoomrequestrolechangeresultUnauthorized,
			/// <summary>Request role change failed due to some miscellaneous problem with the request.</summary>
			RoomrequestrolechangeresultMiscLocalError,
			/// <summary>The server is rejecting the role change request due to some miscellaneous problem of its own.</summary>
			RoomrequestrolechangeresultMiscRemoteError
		}
		/// <summary>
		/// Result of get room history.
		/// </summary>
		public enum RoomSearchResult {
			/// <summary>Get room history operation was successful.</summary>
			RoomsearchresultOK,
			/// <summary>Server did not return any records.</summary>
			RoomsearchresultNoRecords,
			/// <summary>Server did not respond in a reasonable amount of time to the get room history request.</summary>
			RoomsearchresultNoResponse,
			/// <summary>User did not have the permission to get room history.</summary>
			RoomsearchresultUnauthorized,
			/// <summary>Server is rejecting the request to get room history due to some miscellaneous problem with the request.</summary>
			RoomsearchresultMiscLocalError,
			/// <summary>Server is rejecting the request to get room history due to some miscellaneous problem of its own.</summary>
			RoomsearchresultMiscRemoteError
		}
		/// <summary>
		/// This type indicates the result of set favorite room.
		/// </summary>
		public enum RoomSetFavoriteResult {
			/// <summary>The set operation was successful.</summary>
			RoomsetfavoriteresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to set.</summary>
			RoomsetfavoriteresultNoResponse,
			/// <summary>There was a conflict in set.</summary>
			RoomsetfavoriteresultConflict,
			/// <summary>The user did not have permission to set.</summary>
			RoomsetfavoriteresultUnauthorized,
			/// <summary>The properties set on the room are not acceptable.</summary>
			RoomsetfavoriteresultNotAcceptable,
			/// <summary>The operation being performed on the room using set properties is not allowed.</summary>
			RoomsetfavoriteresultNotAllowed,
			/// <summary>The server is rejecting the request to set due to some miscellaneous problem with the request.</summary>
			RoomsetfavoriteresultMiscLocalError,
			/// <summary>The server isrejecting the request to set room properties due to some miscellaneous problem of its own.</summary>
			RoomsetfavoriteresultMiscRemoteError
		}
		/// <summary>
		/// This type indicates the result of set room properties.
		/// </summary>
		public enum RoomSetPropertiesResult {
			/// <summary>The set properties operation was successful.</summary>
			RoomsetpropertiesresultOK,
			/// <summary>The server did not respond in a reasonable amount of time to the request to set room properties.</summary>
			RoomsetpropertiesresultNoResponse,
			/// <summary>There was a conflict in setting room properties.</summary>
			RoomsetpropertiesresultConflict,
			/// <summary>The user did not have permission to get room properties.</summary>
			RoomsetpropertiesresultUnauthorized,
			/// <summary>The user is not owner of the room.</summary>
			RoomsetpropertiesresultNotOwnerOfRoom,
			/// <summary>The properties set on the room are not acceptable.</summary>
			RoomsetpropertiesresultNotAcceptable,
			/// <summary>The operation being performed on the room using set properties is not allowed.</summary>
			RoomsetpropertiesresultNotAllowed,
			/// <summary>The server is rejecting the request to set room properties due to some miscellaneous problem with the request.</summary>
			RoomsetpropertiesresultMiscLocalError,
			/// <summary>The server is rejecting the request to set room properties due to some miscellaneous problem of its own.</summary>
			RoomsetpropertiesresultMiscRemoteError
		}
		/// <summary>
		/// Type of throttling to apply to show requests.
		/// </summary>
		public enum RoomShowThrottle {
			/// <summary>Disable show throttling.</summary>
			RoomshowthrottleNONE,
			/// <summary>Throttle show requests with timer.</summary>
			RoomshowthrottleTIMED,
			/// <summary>Throttle show requests by window size change threshold.</summary>
			RoomshowthrottleWINDOWSIZE
		}
		/// <summary>
		/// 
		/// </summary>
		public enum RoomState {
			/// <summary></summary>
			RoomstateCreating,
			/// <summary></summary>
			RoomstateCreated,
			/// <summary></summary>
			RoomstateEntering,
			/// <summary></summary>
			RoomstateEntered,
			/// <summary></summary>
			RoomstateMediaRouteAcquiring,
			/// <summary></summary>
			RoomstateMediaRouteAcquired,
			/// <summary></summary>
			RoomstateMediaEnabling,
			/// <summary></summary>
			RoomstateMediaEnabled,
			/// <summary></summary>
			RoomstateMediaDisabling,
			/// <summary></summary>
			RoomstateMediaDisabled,
			/// <summary></summary>
			RoomstateExiting,
			/// <summary></summary>
			RoomstateExited
		}
		/// <summary>
		/// This indicates the type of the room.
		/// </summary>
		public enum RoomType {
			/// <summary>This indicates that room type is unknown.</summary>
			RoomtypeUnknown,
			/// <summary>This room is for private chat between users speicfied in the VidyoUserGetConversationRoom method. It is auto-created and the access is permanently limited to the list of users specified so that no other participants can be invited outside of the original user list. If the list of users needs to be modified, another CONVERSATION room must be created with the new list.</summary>
			RoomtypeConversation,
			/// <summary>This room is created using the VidyoUserCreateTopicRoom method for topic discussions. The user creating the room will usually become the owner and can moderate/invite other users. The access and properties of this room can be modified by privileged users and others can join/leave this room based on those properties such as guest access or member only.</summary>
			RoomtypeTopic,
			/// <summary>This indicates that room is of type scheduled.</summary>
			RoomtypeScheduled,
			/// <summary>This indicates that room is of type personal.</summary>
			RoomtypePersonal,
			/// <summary>This indicates that room is for test call.</summary>
			RoomtypeTestCall,
			/// <summary>This indicates that room is a legacy endpoint.</summary>
			RoomtypeLegacy
		}
		/// <summary>
		/// Provide the status of webcasting/broadcasting.
		/// </summary>
		public enum RoomWebcastingState {
			/// <summary>Room is not broadcast or webcasting is not going on.</summary>
			RoomwebcastingstateNotWebcasting,
			/// <summary>Room is being broadcast or webcasting is going on.</summary>
			RoomwebcastingstateWebcasting
		}
		public interface IAcceptIncoming{

			void OnIncomingEntered(RoomEnterResult result);
			void OnIncomingExited(RoomExitReason reason);
		}
		public interface IAcquireMediaRoute{

			void OnMediaRouteAcquired();
			void OnMediaRouteAcquireFailed(RoomMediaFailReason reason);
		}
		public interface IDelete{

			void OnDeleteResult(RoomDeleteResult result);
		}
		public interface IEnableMedia{

			void OnMediaEnabled();
			void OnMediaFailed(RoomMediaFailReason reason);
			void OnMediaDisabled(RoomMediaDisableReason reason);
		}
		public interface IEnter{

			void OnEntered(RoomEnterResult result);
			void OnExited(RoomExitReason reason);
		}
		public interface IGetHistory{

			void OnGetHistoryResults(List<ChatMessage> records, long historySize, RoomSearchResult result);
		}
		public interface IGetRoomProperties{

			void OnGetRoomPropertiesResult(RoomGetPropertiesResult result, RoomProperties roomProperties);
		}
		public interface IGetSelectedLocalCameras{

			void OnGetSelectedLocalCamerasComplete(List<LocalCamera> cameras);
		}
		public interface IGetSelectedLocalMicrophones{

			void OnGetSelectedLocalMicrophonesComplete(List<LocalMicrophone> microphones);
		}
		public interface IGetSelectedLocalMonitors{

			void OnGetSelectedLocalMonitorsComplete(List<LocalMonitor> monitors);
		}
		public interface IGetSelectedLocalRenderers{

			void OnGetSelectedLocalRenderersComplete(List<LocalRenderer> renderers);
		}
		public interface IGetSelectedLocalSpeakers{

			void OnGetSelectedLocalSpeakersComplete(List<LocalSpeaker> speakers);
		}
		public interface IGetSelectedLocalWindowShares{

			void OnGetSelectedLocalWindowSharesComplete(List<LocalWindowShare> windowShares);
		}
		public interface IInvite{

			void OnInviteResult(String inviteeId, RoomInviteResult result);
		}
		public interface ILockRoom{

			void OnLockRoomResult(RoomSetPropertiesResult result);
		}
		public interface IMessageSearch{

			void OnMessageSearchResults(String searchText, List<ChatMessage> records, RoomSearchResult result);
		}
		public interface IPauseRecording{

			void OnRecordingServicePauseResult(RoomSetPropertiesResult result);
		}
		public interface IRaiseHand{

			void OnRaiseHandResponse(Participant.ParticipantHandState handState);
		}
		public interface IRegisterBotEventListener{

			void OnBotJoined(RoomBotInfo info);
			void OnBotLeft(RoomBotInfo info);
		}
		public interface IRegisterConferenceModeEventListener{

			void OnConferenceModeChanged(RoomConferenceMode mode);
		}
		public interface IRegisterConnectionPropertiesEventListener{

			void OnConnectionPropertiesChanged(RoomConnectionProperties connectionProperties);
		}
		public interface IRegisterHostEventListener{

			void OnConferenceHostStatusChanged(Participant host, RoomConferenceHostState hostState);
		}
		public interface IRegisterInCallEventListener{

			void OnInCallEvents(RoomInCallEvent ev);
		}
		public interface IRegisterLectureModeEventListener{

			void OnPresenterChanged(Participant participant);
			void OnHandRaised(List<Participant> participant);
		}
		public interface IRegisterMessageEventListener{

			void OnMessageReceived(Participant participant, ChatMessage chatMessage);
			void OnMessageAcknowledged(ChatMessage chatMessage);
			void OnMessageRead(Participant participant, long messageId);
			void OnMessageTypingIndication(Participant participant, ChatMessage.ChatMessageTypingIndication typingIndication);
		}
		public interface IRegisterModerationCommandEventListener{

			void OnModerationCommandReceived(Device.DeviceType deviceType, RoomModerationType moderationType, Boolean state);
		}
		public interface IRegisterModerationResultEventListener{

			void OnModerationResult(Participant participant, RoomModerationResult result, RoomModerationActionType actionType, String requestId);
		}
		public interface IRegisterParticipantEventListener{

			void OnParticipantJoined(Participant participant);
			void OnParticipantLeft(Participant participant);
			void OnDynamicParticipantChanged(List<Participant> selectedParticipants);
			void OnLoudestParticipantChanged(Participant participant, Boolean isAudioOnly, Boolean isStatic);
		}
		public interface IRegisterPipEventListener{

			void OnPipLocationChanged(int x, int y, uint width, uint height, Boolean isExpanded);
		}
		public interface IRegisterRecorderInCallEventListener{

			void RecorderInCall(Boolean hasRecorder, Boolean isPaused);
		}
		public interface IRegisterResourceManagerEventListener{

			void OnAvailableResourcesChanged(uint cpuEncode, uint cpuDecode, uint bandwidthSend, uint bandwidthReceive);
			void OnMaxRemoteSourcesChanged(uint maxRemoteSources);
		}
		public interface IRegisterRoomPropertiesEventListener{

			void OnRoomPropertiesChanged(RoomProperties roomProperties);
		}
		public interface IRegisterSubjectEventListener{

			void OnSetSubject(String subject);
		}
		public interface IRegisterUnprocessedAudioEventListener{

			void OnUnprocessedAudioSupportChanged(Boolean supported);
			void OnUnprocessedAudioStarted(Boolean started);
		}
		public interface IRemoveRoomPIN{

			void OnRemoveRoomPINResult(RoomSetPropertiesResult result);
		}
		public interface IRequestRoleChange{

			void OnRequestRoleChangeResult(RoomRequestRoleChangeResult result, String requestId);
		}
		public interface IResumeRecording{

			void OnRecordingServiceResumeResult(RoomSetPropertiesResult result);
		}
		public interface ISetDefaultProfile{

			void OnSetRoomPropertyResult(RoomSetPropertiesResult result);
		}
		public interface ISetFavorite{

			void OnSetFavoriteResult(Boolean isFavorite, RoomSetFavoriteResult result);
		}
		public interface ISetRoomPIN{

			void OnSetRoomPINResult(RoomSetPropertiesResult result);
		}
		public interface ISetRoomProperties{

			void OnSetRoomPropertiesResult(RoomSetPropertiesResult result);
		}
		public interface IStartRecording{

			void OnRecordingServiceStartResult(RoomSetPropertiesResult result);
		}
		public interface IStopRecording{

			void OnRecordingServiceStopResult(RoomSetPropertiesResult result);
		}
		public interface IUnlockRoom{

			void OnUnlockRoomResult(RoomSetPropertiesResult result);
		}
		public class GenerationDiffFactory
		{
			public static GenerationDiff Create()
			{
				return new GenerationDiff(IntPtr.Zero);
			}
			public static void Destroy(GenerationDiff obj)
			{
			}
		}
		/// <summary>
		/// Represents a remote participant whose selected ranking in a conference has changed. When the selected participant list changes, a set of these objects can be used to represent the differences between the old list and the new list. Each object can indicate a new participant in the list, a participant that is no longer in the list, or a participant that has changed rank within the list.
		/// </summary>
		public class GenerationDiff {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoGenerationDiff reference.
			public IntPtr GetObjectPtr() {

				VidyoGenerationDiffSetnewIndexNative(objPtr, newIndex);
				VidyoGenerationDiffSetoldIndexNative(objPtr, oldIndex);
				VidyoGenerationDiffSetparticipantNative(objPtr, participant.GetObjectPtr());

				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern int VidyoGenerationDiffGetnewIndexNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoGenerationDiffSetnewIndexNative(IntPtr obj, int newIndex);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern int VidyoGenerationDiffGetoldIndexNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoGenerationDiffSetoldIndexNative(IntPtr obj, int oldIndex);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoGenerationDiffGetparticipantNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoGenerationDiffSetparticipantNative(IntPtr obj, IntPtr participant);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoGenerationDiffConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoGenerationDiffConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoGenerationDiffDestructNative(IntPtr obj);

			/// <summary>
			/// 
			/// </summary>
			public int newIndex;
			/// <summary>
			/// 
			/// </summary>
			public int oldIndex;
			/// <summary>
			/// 
			/// </summary>
			public Participant participant;
			public GenerationDiff(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoGenerationDiffConstructDefaultNative();
				}
				else {
					objPtr = VidyoGenerationDiffConstructCopyNative(obj);
				}

				Participant csParticipant = null;
				if(VidyoGenerationDiffGetparticipantNative(objPtr) != IntPtr.Zero) {
					var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(VidyoGenerationDiffGetparticipantNative(objPtr));
					csParticipant = csParticipantPtr == IntPtr.Zero ? new Participant(VidyoGenerationDiffGetparticipantNative(objPtr)) : (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}

				newIndex = VidyoGenerationDiffGetnewIndexNative(objPtr);
				oldIndex = VidyoGenerationDiffGetoldIndexNative(objPtr);
				participant = csParticipant;
			}
			~GenerationDiff() {
				VidyoGenerationDiffDestructNative(objPtr);
			 }
		};
		public class RoleAuthorizationFactory
		{
			public static RoleAuthorization Create()
			{
				return new RoleAuthorization(IntPtr.Zero);
			}
			public static void Destroy(RoleAuthorization obj)
			{
			}
		}
		/// <summary>
		/// 
		/// </summary>
		public class RoleAuthorization {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoRoleAuthorization reference.
			public IntPtr GetObjectPtr() {
				IntPtr nPassCode = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(passCode ?? string.Empty);

				VidyoRoleAuthorizationSethasPassCodeNative(objPtr, hasPassCode);
				VidyoRoleAuthorizationSetpassCodeNative(objPtr, nPassCode);

				Marshal.FreeHGlobal(nPassCode);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoleAuthorizationGethasPassCodeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoleAuthorizationSethasPassCodeNative(IntPtr obj, Boolean hasPassCode);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoleAuthorizationGetpassCodeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoleAuthorizationSetpassCodeNative(IntPtr obj, IntPtr passCode);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoleAuthorizationConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoleAuthorizationConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoRoleAuthorizationDestructNative(IntPtr obj);

			/// <summary>
			/// hasPassCode set to LMI_TRUE means 'passCode' field contains a valid input.
			/// </summary>
			public Boolean hasPassCode;
			/// <summary>
			/// 
			/// </summary>
			public String passCode;
			public RoleAuthorization(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoRoleAuthorizationConstructDefaultNative();
				}
				else {
					objPtr = VidyoRoleAuthorizationConstructCopyNative(obj);
				}

				hasPassCode = VidyoRoleAuthorizationGethasPassCodeNative(objPtr);
				passCode = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoleAuthorizationGetpassCodeNative(objPtr));
			}
			~RoleAuthorization() {
				VidyoRoleAuthorizationDestructNative(objPtr);
			 }
		};
		public class RoomBotInfoFactory
		{
			public static RoomBotInfo Create()
			{
				return new RoomBotInfo(IntPtr.Zero);
			}
			public static void Destroy(RoomBotInfo obj)
			{
			}
		}
		/// <summary>
		/// Represents the bot info structure.
		/// </summary>
		public class RoomBotInfo {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoRoomBotInfo reference.
			public IntPtr GetObjectPtr() {
				IntPtr nData = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(data ?? string.Empty);
				IntPtr nId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(id ?? string.Empty);
				IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);

				VidyoRoomBotInfoSetdataNative(objPtr, nData);
				VidyoRoomBotInfoSetidNative(objPtr, nId);
				VidyoRoomBotInfoSetnameNative(objPtr, nName);

				Marshal.FreeHGlobal(nName);
				Marshal.FreeHGlobal(nId);
				Marshal.FreeHGlobal(nData);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomBotInfoGetdataNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomBotInfoSetdataNative(IntPtr obj, IntPtr data);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomBotInfoGetidNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomBotInfoSetidNative(IntPtr obj, IntPtr id);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomBotInfoGetnameNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomBotInfoSetnameNative(IntPtr obj, IntPtr name);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomBotInfoConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomBotInfoConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoRoomBotInfoDestructNative(IntPtr obj);

			/// <summary>
			/// Represents the meta data associated with bot in json format string.
			/// </summary>
			public String data;
			/// <summary>
			/// Represents the id associated with bot.
			/// </summary>
			public String id;
			/// <summary>
			/// Represents the name associated with bot.
			/// </summary>
			public String name;
			public RoomBotInfo(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoRoomBotInfoConstructDefaultNative();
				}
				else {
					objPtr = VidyoRoomBotInfoConstructCopyNative(obj);
				}

				data = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomBotInfoGetdataNative(objPtr));
				id = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomBotInfoGetidNative(objPtr));
				name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomBotInfoGetnameNative(objPtr));
			}
			~RoomBotInfo() {
				VidyoRoomBotInfoDestructNative(objPtr);
			 }
		};
		public class RoomConnectionPropertiesFactory
		{
			public static RoomConnectionProperties Create()
			{
				return new RoomConnectionProperties(IntPtr.Zero);
			}
			public static void Destroy(RoomConnectionProperties obj)
			{
			}
		}
		/// <summary>
		/// Represents the connection properties for the room, which are based on information from the portal.
		/// </summary>
		public class RoomConnectionProperties {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoRoomConnectionProperties reference.
			public IntPtr GetObjectPtr() {
				IntPtr nRoomName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomName ?? string.Empty);

				VidyoRoomConnectionPropertiesSethasModeratorPinNative(objPtr, hasModeratorPin);
				VidyoRoomConnectionPropertiesSethasRoomPinNative(objPtr, hasRoomPin);
				VidyoRoomConnectionPropertiesSetisRoomLockedNative(objPtr, isRoomLocked);
				VidyoRoomConnectionPropertiesSetisVp9EnabledNative(objPtr, isVp9Enabled);
				VidyoRoomConnectionPropertiesSetmaxReceiveBandWidthNative(objPtr, maxReceiveBandWidth);
				VidyoRoomConnectionPropertiesSetmaxSendBandWidthNative(objPtr, maxSendBandWidth);
				VidyoRoomConnectionPropertiesSetmaximumRoomPinLengthNative(objPtr, maximumRoomPinLength);
				VidyoRoomConnectionPropertiesSetminimumRoomPinLengthNative(objPtr, minimumRoomPinLength);
				VidyoRoomConnectionPropertiesSetrecordingStateNative(objPtr, recordingState);
				VidyoRoomConnectionPropertiesSetroomNameNative(objPtr, nRoomName);
				VidyoRoomConnectionPropertiesSetwebcastingStateNative(objPtr, webcastingState);

				Marshal.FreeHGlobal(nRoomName);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomConnectionPropertiesGethasModeratorPinNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSethasModeratorPinNative(IntPtr obj, Boolean hasModeratorPin);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomConnectionPropertiesGethasRoomPinNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSethasRoomPinNative(IntPtr obj, Boolean hasRoomPin);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomConnectionPropertiesGetisRoomLockedNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetisRoomLockedNative(IntPtr obj, Boolean isRoomLocked);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomConnectionPropertiesGetisVp9EnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetisVp9EnabledNative(IntPtr obj, Boolean isVp9Enabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoRoomConnectionPropertiesGetmaxReceiveBandWidthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetmaxReceiveBandWidthNative(IntPtr obj, uint maxReceiveBandWidth);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoRoomConnectionPropertiesGetmaxSendBandWidthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetmaxSendBandWidthNative(IntPtr obj, uint maxSendBandWidth);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern int VidyoRoomConnectionPropertiesGetmaximumRoomPinLengthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetmaximumRoomPinLengthNative(IntPtr obj, int maximumRoomPinLength);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern int VidyoRoomConnectionPropertiesGetminimumRoomPinLengthNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetminimumRoomPinLengthNative(IntPtr obj, int minimumRoomPinLength);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomRecordingState VidyoRoomConnectionPropertiesGetrecordingStateNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetrecordingStateNative(IntPtr obj, Room.RoomRecordingState recordingState);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomConnectionPropertiesGetroomNameNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetroomNameNative(IntPtr obj, IntPtr roomName);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomWebcastingState VidyoRoomConnectionPropertiesGetwebcastingStateNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomConnectionPropertiesSetwebcastingStateNative(IntPtr obj, Room.RoomWebcastingState webcastingState);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomConnectionPropertiesConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomConnectionPropertiesConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoRoomConnectionPropertiesDestructNative(IntPtr obj);

			/// <summary>
			/// Return LMI_TRUE if moderation pin is set otherwise LMI_FALSE.
			/// </summary>
			public Boolean hasModeratorPin;
			/// <summary>
			/// Return LMI_TRUE if room pin is set otherwise LMI_FALSE.
			/// </summary>
			public Boolean hasRoomPin;
			/// <summary>
			/// Return LMI_TRUE if room is lock otherwise LMI_FALSE.
			/// </summary>
			public Boolean isRoomLocked;
			/// <summary>
			/// Return LMI_TRUE if VP9 is enabled otherwise LMI_FALSE.
			/// </summary>
			public Boolean isVp9Enabled;
			/// <summary>
			/// Represents the maximum receive bandwidth.
			/// </summary>
			public uint maxReceiveBandWidth;
			/// <summary>
			/// Represents the maximum send bandwidth.
			/// </summary>
			public uint maxSendBandWidth;
			/// <summary>
			/// Return the maximum room pin length if maximumRoomPinLength is set by default.
			/// </summary>
			public int maximumRoomPinLength;
			/// <summary>
			/// Return the minimum room pin length if minimumRoomPinLength is set by default.
			/// </summary>
			public int minimumRoomPinLength;
			/// <summary>
			/// State of Recording. See enum VidyoRoomRecordingState.
			/// </summary>
			public Room.RoomRecordingState recordingState;
			/// <summary>
			/// Name of the room.
			/// </summary>
			public String roomName;
			/// <summary>
			/// State of Webcasting. See enum VidyoRoomWebcastingState.
			/// </summary>
			public Room.RoomWebcastingState webcastingState;
			public RoomConnectionProperties(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoRoomConnectionPropertiesConstructDefaultNative();
				}
				else {
					objPtr = VidyoRoomConnectionPropertiesConstructCopyNative(obj);
				}

				hasModeratorPin = VidyoRoomConnectionPropertiesGethasModeratorPinNative(objPtr);
				hasRoomPin = VidyoRoomConnectionPropertiesGethasRoomPinNative(objPtr);
				isRoomLocked = VidyoRoomConnectionPropertiesGetisRoomLockedNative(objPtr);
				isVp9Enabled = VidyoRoomConnectionPropertiesGetisVp9EnabledNative(objPtr);
				maxReceiveBandWidth = VidyoRoomConnectionPropertiesGetmaxReceiveBandWidthNative(objPtr);
				maxSendBandWidth = VidyoRoomConnectionPropertiesGetmaxSendBandWidthNative(objPtr);
				maximumRoomPinLength = VidyoRoomConnectionPropertiesGetmaximumRoomPinLengthNative(objPtr);
				minimumRoomPinLength = VidyoRoomConnectionPropertiesGetminimumRoomPinLengthNative(objPtr);
				recordingState = VidyoRoomConnectionPropertiesGetrecordingStateNative(objPtr);
				roomName = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomConnectionPropertiesGetroomNameNative(objPtr));
				webcastingState = VidyoRoomConnectionPropertiesGetwebcastingStateNative(objPtr);
			}
			~RoomConnectionProperties() {
				VidyoRoomConnectionPropertiesDestructNative(objPtr);
			 }
		};
		public class RoomInCallEventFactory
		{
			public static RoomInCallEvent Create()
			{
				return new RoomInCallEvent(IntPtr.Zero);
			}
			public static void Destroy(RoomInCallEvent obj)
			{
			}
		}
		/// <summary>
		/// It is the event which will be sent to application which register for incall events.
		/// </summary>
		public class RoomInCallEvent {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoRoomInCallEvent reference.
			public IntPtr GetObjectPtr() {
				IntPtr nDetails = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(details ?? string.Empty);

				VidyoRoomInCallEventSetcodeNative(objPtr, code);
				VidyoRoomInCallEventSetdetailsNative(objPtr, nDetails);
				VidyoRoomInCallEventSettypeNative(objPtr, type);

				Marshal.FreeHGlobal(nDetails);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomInCallEventCode VidyoRoomInCallEventGetcodeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomInCallEventSetcodeNative(IntPtr obj, Room.RoomInCallEventCode code);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomInCallEventGetdetailsNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomInCallEventSetdetailsNative(IntPtr obj, IntPtr details);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomInCallEventClass VidyoRoomInCallEventGettypeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomInCallEventSettypeNative(IntPtr obj, Room.RoomInCallEventClass type);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomInCallEventConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomInCallEventConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoRoomInCallEventDestructNative(IntPtr obj);

			/// <summary>
			/// It is error code for the event.
			/// </summary>
			public Room.RoomInCallEventCode code;
			/// <summary>
			/// It extra information for the event. It is optional and it may depend on type of event.
			/// </summary>
			public String details;
			/// <summary>
			/// This indicate the module to which event belongs to.
			/// </summary>
			public Room.RoomInCallEventClass type;
			public RoomInCallEvent(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoRoomInCallEventConstructDefaultNative();
				}
				else {
					objPtr = VidyoRoomInCallEventConstructCopyNative(obj);
				}

				code = VidyoRoomInCallEventGetcodeNative(objPtr);
				details = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomInCallEventGetdetailsNative(objPtr));
				type = VidyoRoomInCallEventGettypeNative(objPtr);
			}
			~RoomInCallEvent() {
				VidyoRoomInCallEventDestructNative(objPtr);
			 }
		};
		public class RoomParticipantProfileFactory
		{
			public static RoomParticipantProfile Create()
			{
				return new RoomParticipantProfile(IntPtr.Zero);
			}
			public static void Destroy(RoomParticipantProfile obj)
			{
			}
		}
		/// <summary>
		/// Participant's profile describing the source restrictions and the chat restriction.
		/// </summary>
		public class RoomParticipantProfile {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoRoomParticipantProfile reference.
			public IntPtr GetObjectPtr() {
				IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);

				VidyoRoomParticipantProfileSetcameraNative(objPtr, camera);
				VidyoRoomParticipantProfileSetchatNative(objPtr, chat);
				VidyoRoomParticipantProfileSetmicrophoneNative(objPtr, microphone);
				VidyoRoomParticipantProfileSetuserIdNative(objPtr, nUserId);
				VidyoRoomParticipantProfileSetwindowShareNative(objPtr, windowShare);

				Marshal.FreeHGlobal(nUserId);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomProfileControlMode VidyoRoomParticipantProfileGetcameraNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomParticipantProfileSetcameraNative(IntPtr obj, Room.RoomProfileControlMode camera);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomProfileControlMode VidyoRoomParticipantProfileGetchatNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomParticipantProfileSetchatNative(IntPtr obj, Room.RoomProfileControlMode chat);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomProfileControlMode VidyoRoomParticipantProfileGetmicrophoneNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomParticipantProfileSetmicrophoneNative(IntPtr obj, Room.RoomProfileControlMode microphone);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomParticipantProfileGetuserIdNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomParticipantProfileSetuserIdNative(IntPtr obj, IntPtr userId);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I4)]
			private static extern Room.RoomProfileControlMode VidyoRoomParticipantProfileGetwindowShareNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomParticipantProfileSetwindowShareNative(IntPtr obj, Room.RoomProfileControlMode windowShare);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomParticipantProfileConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomParticipantProfileConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoRoomParticipantProfileDestructNative(IntPtr obj);

			/// <summary>
			/// 
			/// </summary>
			public Room.RoomProfileControlMode camera;
			/// <summary>
			/// 
			/// </summary>
			public Room.RoomProfileControlMode chat;
			/// <summary>
			/// 
			/// </summary>
			public Room.RoomProfileControlMode microphone;
			/// <summary>
			/// 
			/// </summary>
			public String userId;
			/// <summary>
			/// 
			/// </summary>
			public Room.RoomProfileControlMode windowShare;
			public RoomParticipantProfile(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoRoomParticipantProfileConstructDefaultNative();
				}
				else {
					objPtr = VidyoRoomParticipantProfileConstructCopyNative(obj);
				}

				camera = VidyoRoomParticipantProfileGetcameraNative(objPtr);
				chat = VidyoRoomParticipantProfileGetchatNative(objPtr);
				microphone = VidyoRoomParticipantProfileGetmicrophoneNative(objPtr);
				userId = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomParticipantProfileGetuserIdNative(objPtr));
				windowShare = VidyoRoomParticipantProfileGetwindowShareNative(objPtr);
			}
			~RoomParticipantProfile() {
				VidyoRoomParticipantProfileDestructNative(objPtr);
			 }
		};
		public class RoomPropertiesFactory
		{
			public static RoomProperties Create()
			{
				return new RoomProperties(IntPtr.Zero);
			}
			public static void Destroy(RoomProperties obj)
			{
			}
		}
		/// <summary>
		/// Properties of a room.
		/// </summary>
		public class RoomProperties {
#if __IOS__
			const string importLib = "__Internal";
#else
			const string importLib = "libVidyoClient";
#endif
			private IntPtr objPtr; // opaque VidyoRoomProperties reference.
			public IntPtr GetObjectPtr() {
				IntPtr nAdministrators = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * administrators.Count);
				int nAdministratorsSize = 0;
				IntPtr nCalendarInviteBody = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(calendarInviteBody ?? string.Empty);
				IntPtr nCalendarInviteHTMLBody = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(calendarInviteHTMLBody ?? string.Empty);
				IntPtr nCalendarInviteSubject = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(calendarInviteSubject ?? string.Empty);
				IntPtr nDescription = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(description ?? string.Empty);
				IntPtr nDesignatedPresenter = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(designatedPresenter ?? string.Empty);
				IntPtr nLanguage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(language ?? string.Empty);
				IntPtr nLoggingLocation = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(loggingLocation ?? string.Empty);
				IntPtr nMembers = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * members.Count);
				int nMembersSize = 0;
				IntPtr nModeratorUrl = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(moderatorUrl ?? string.Empty);
				IntPtr nModerators = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * moderators.Count);
				int nModeratorsSize = 0;
				IntPtr nName = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(name ?? string.Empty);
				IntPtr nOutcasts = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * outcasts.Count);
				int nOutcastsSize = 0;
				IntPtr nOwners = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * owners.Count);
				int nOwnersSize = 0;
				IntPtr nParticipantProfiles = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * participantProfiles.Count);
				int nParticipantProfilesSize = 0;
				IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
				IntPtr nWebLink = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(webLink ?? string.Empty);

				foreach (String iter in administrators) {
					Marshal.WriteIntPtr(nAdministrators + (nAdministratorsSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
					nAdministratorsSize++;
				}
				foreach (String iter in members) {
					Marshal.WriteIntPtr(nMembers + (nMembersSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
					nMembersSize++;
				}
				foreach (String iter in moderators) {
					Marshal.WriteIntPtr(nModerators + (nModeratorsSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
					nModeratorsSize++;
				}
				foreach (String iter in outcasts) {
					Marshal.WriteIntPtr(nOutcasts + (nOutcastsSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
					nOutcastsSize++;
				}
				foreach (String iter in owners) {
					Marshal.WriteIntPtr(nOwners + (nOwnersSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
					nOwnersSize++;
				}
				foreach (RoomParticipantProfile iter in participantProfiles) {
					Marshal.WriteIntPtr(nParticipantProfiles + (nParticipantProfilesSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
					nParticipantProfilesSize++;
				}

				VidyoRoomPropertiesSetadministratorsNative(objPtr, nAdministrators, nAdministratorsSize);
				VidyoRoomPropertiesSetcalendarInviteBodyNative(objPtr, nCalendarInviteBody);
				VidyoRoomPropertiesSetcalendarInviteHTMLBodyNative(objPtr, nCalendarInviteHTMLBody);
				VidyoRoomPropertiesSetcalendarInviteSubjectNative(objPtr, nCalendarInviteSubject);
				VidyoRoomPropertiesSetcreationTimeNative(objPtr, creationTime);
				VidyoRoomPropertiesSetdefaultProfileNative(objPtr, defaultProfile.GetObjectPtr());
				VidyoRoomPropertiesSetdescriptionNative(objPtr, nDescription);
				VidyoRoomPropertiesSetdesignatedPresenterNative(objPtr, nDesignatedPresenter);
				VidyoRoomPropertiesSethasCalendarInviteTextNative(objPtr, hasCalendarInviteText);
				VidyoRoomPropertiesSethasModeratorPinNative(objPtr, hasModeratorPin);
				VidyoRoomPropertiesSethasPasswordNative(objPtr, hasPassword);
				VidyoRoomPropertiesSetisBroadcastingEnabledNative(objPtr, isBroadcastingEnabled);
				VidyoRoomPropertiesSetisLoggingEnabledNative(objPtr, isLoggingEnabled);
				VidyoRoomPropertiesSetisLoggingPausedNative(objPtr, isLoggingPaused);
				VidyoRoomPropertiesSetisLoggingSupportedNative(objPtr, isLoggingSupported);
				VidyoRoomPropertiesSetisMembersOnlyNative(objPtr, isMembersOnly);
				VidyoRoomPropertiesSetisModeratedNative(objPtr, isModerated);
				VidyoRoomPropertiesSetisPasswordProtectedNative(objPtr, isPasswordProtected);
				VidyoRoomPropertiesSetisPeertoPeerCallWithLegacyNative(objPtr, isPeertoPeerCallWithLegacy);
				VidyoRoomPropertiesSetisPublicNative(objPtr, isPublic);
				VidyoRoomPropertiesSetisRoleChangeAllowedNative(objPtr, isRoleChangeAllowed);
				VidyoRoomPropertiesSetisSecureNative(objPtr, isSecure);
				VidyoRoomPropertiesSetisWaitingRoomEnabledNative(objPtr, isWaitingRoomEnabled);
				VidyoRoomPropertiesSetlanguageNative(objPtr, nLanguage);
				VidyoRoomPropertiesSetloggingLocationNative(objPtr, nLoggingLocation);
				VidyoRoomPropertiesSetmaxParticipantsNative(objPtr, maxParticipants);
				VidyoRoomPropertiesSetmembersNative(objPtr, nMembers, nMembersSize);
				VidyoRoomPropertiesSetmoderatorUrlNative(objPtr, nModeratorUrl);
				VidyoRoomPropertiesSetmoderatorsNative(objPtr, nModerators, nModeratorsSize);
				VidyoRoomPropertiesSetnameNative(objPtr, nName);
				VidyoRoomPropertiesSetoutcastsNative(objPtr, nOutcasts, nOutcastsSize);
				VidyoRoomPropertiesSetownersNative(objPtr, nOwners, nOwnersSize);
				VidyoRoomPropertiesSetparticipantProfilesNative(objPtr, nParticipantProfiles, nParticipantProfilesSize);
				VidyoRoomPropertiesSetpasswordNative(objPtr, nPassword);
				VidyoRoomPropertiesSetscheduleNative(objPtr, schedule.GetObjectPtr());
				VidyoRoomPropertiesSetwebLinkNative(objPtr, nWebLink);

				for (int i = 0; i < nAdministratorsSize; i++) {
					Marshal.FreeHGlobal(Marshal.ReadIntPtr(nAdministrators + (i * Marshal.SizeOf<IntPtr>())));
				}
				for (int i = 0; i < nMembersSize; i++) {
					Marshal.FreeHGlobal(Marshal.ReadIntPtr(nMembers + (i * Marshal.SizeOf<IntPtr>())));
				}
				for (int i = 0; i < nModeratorsSize; i++) {
					Marshal.FreeHGlobal(Marshal.ReadIntPtr(nModerators + (i * Marshal.SizeOf<IntPtr>())));
				}
				for (int i = 0; i < nOutcastsSize; i++) {
					Marshal.FreeHGlobal(Marshal.ReadIntPtr(nOutcasts + (i * Marshal.SizeOf<IntPtr>())));
				}
				for (int i = 0; i < nOwnersSize; i++) {
					Marshal.FreeHGlobal(Marshal.ReadIntPtr(nOwners + (i * Marshal.SizeOf<IntPtr>())));
				}

				Marshal.FreeHGlobal(nWebLink);
				Marshal.FreeHGlobal(nPassword);
				Marshal.FreeHGlobal(nParticipantProfiles);
				Marshal.FreeHGlobal(nOwners);
				Marshal.FreeHGlobal(nOutcasts);
				Marshal.FreeHGlobal(nName);
				Marshal.FreeHGlobal(nModerators);
				Marshal.FreeHGlobal(nModeratorUrl);
				Marshal.FreeHGlobal(nMembers);
				Marshal.FreeHGlobal(nLoggingLocation);
				Marshal.FreeHGlobal(nLanguage);
				Marshal.FreeHGlobal(nDesignatedPresenter);
				Marshal.FreeHGlobal(nDescription);
				Marshal.FreeHGlobal(nCalendarInviteSubject);
				Marshal.FreeHGlobal(nCalendarInviteHTMLBody);
				Marshal.FreeHGlobal(nCalendarInviteBody);
				Marshal.FreeHGlobal(nAdministrators);
				return objPtr;
			}
			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetadministratorsNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetadministratorsNative(IntPtr obj, IntPtr administrators, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetadministratorsArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesFreeadministratorsArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetcalendarInviteBodyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetcalendarInviteBodyNative(IntPtr obj, IntPtr calendarInviteBody);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetcalendarInviteHTMLBodyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetcalendarInviteHTMLBodyNative(IntPtr obj, IntPtr calendarInviteHTMLBody);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetcalendarInviteSubjectNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetcalendarInviteSubjectNative(IntPtr obj, IntPtr calendarInviteSubject);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern ulong VidyoRoomPropertiesGetcreationTimeNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetcreationTimeNative(IntPtr obj, ulong creationTime);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetdefaultProfileNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetdefaultProfileNative(IntPtr obj, IntPtr defaultProfile);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetdescriptionNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetdescriptionNative(IntPtr obj, IntPtr description);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetdesignatedPresenterNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetdesignatedPresenterNative(IntPtr obj, IntPtr designatedPresenter);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGethasCalendarInviteTextNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSethasCalendarInviteTextNative(IntPtr obj, Boolean hasCalendarInviteText);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGethasModeratorPinNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSethasModeratorPinNative(IntPtr obj, Boolean hasModeratorPin);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGethasPasswordNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSethasPasswordNative(IntPtr obj, Boolean hasPassword);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisBroadcastingEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisBroadcastingEnabledNative(IntPtr obj, Boolean isBroadcastingEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisLoggingEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisLoggingEnabledNative(IntPtr obj, Boolean isLoggingEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisLoggingPausedNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisLoggingPausedNative(IntPtr obj, Boolean isLoggingPaused);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisLoggingSupportedNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisLoggingSupportedNative(IntPtr obj, Boolean isLoggingSupported);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisMembersOnlyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisMembersOnlyNative(IntPtr obj, Boolean isMembersOnly);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisModeratedNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisModeratedNative(IntPtr obj, Boolean isModerated);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisPasswordProtectedNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisPasswordProtectedNative(IntPtr obj, Boolean isPasswordProtected);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisPeertoPeerCallWithLegacyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisPeertoPeerCallWithLegacyNative(IntPtr obj, Boolean isPeertoPeerCallWithLegacy);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisPublicNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisPublicNative(IntPtr obj, Boolean isPublic);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisRoleChangeAllowedNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisRoleChangeAllowedNative(IntPtr obj, Boolean isRoleChangeAllowed);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisSecureNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisSecureNative(IntPtr obj, Boolean isSecure);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			[return: MarshalAs(UnmanagedType.I1)]
			private static extern Boolean VidyoRoomPropertiesGetisWaitingRoomEnabledNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetisWaitingRoomEnabledNative(IntPtr obj, Boolean isWaitingRoomEnabled);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetlanguageNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetlanguageNative(IntPtr obj, IntPtr language);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetloggingLocationNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetloggingLocationNative(IntPtr obj, IntPtr loggingLocation);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern uint VidyoRoomPropertiesGetmaxParticipantsNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetmaxParticipantsNative(IntPtr obj, uint maxParticipants);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetmembersNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetmembersNative(IntPtr obj, IntPtr members, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetmembersArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesFreemembersArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetmoderatorUrlNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetmoderatorUrlNative(IntPtr obj, IntPtr moderatorUrl);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetmoderatorsNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetmoderatorsNative(IntPtr obj, IntPtr moderators, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetmoderatorsArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesFreemoderatorsArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetnameNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetnameNative(IntPtr obj, IntPtr name);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetoutcastsNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetoutcastsNative(IntPtr obj, IntPtr outcasts, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetoutcastsArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesFreeoutcastsArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetownersNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetownersNative(IntPtr obj, IntPtr owners, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetownersArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesFreeownersArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetparticipantProfilesNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetparticipantProfilesNative(IntPtr obj, IntPtr participantProfiles, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetparticipantProfilesArrayNative(IntPtr obj, ref int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesFreeparticipantProfilesArrayNative(IntPtr obj, int size);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetpasswordNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetpasswordNative(IntPtr obj, IntPtr password);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetscheduleNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetscheduleNative(IntPtr obj, IntPtr schedule);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern IntPtr VidyoRoomPropertiesGetwebLinkNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			private static extern void VidyoRoomPropertiesSetwebLinkNative(IntPtr obj, IntPtr webLink);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomPropertiesConstructCopyNative(IntPtr obj);

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern IntPtr VidyoRoomPropertiesConstructDefaultNative();

			[DllImport(importLib, CallingConvention = CallingConvention.Cdecl)]
			public static extern void VidyoRoomPropertiesDestructNative(IntPtr obj);

			/// <summary>
			/// An administrator in the room.
			/// </summary>
			public List<String> administrators;
			/// <summary>
			/// Calendar invitation body retrieved from the portal.
			/// </summary>
			public String calendarInviteBody;
			/// <summary>
			/// Calendar invitation HTML body retrieved from the portal.
			/// </summary>
			public String calendarInviteHTMLBody;
			/// <summary>
			/// Calendar invitation subject retrieved from the portal.
			/// </summary>
			public String calendarInviteSubject;
			/// <summary>
			/// Creation time of the room.
			/// </summary>
			public ulong creationTime;
			/// <summary>
			/// Default profile for all participants.
			/// </summary>
			public RoomParticipantProfile defaultProfile;
			/// <summary>
			/// 
			/// </summary>
			public String description;
			/// <summary>
			/// Server designated presenter.
			/// </summary>
			public String designatedPresenter;
			/// <summary>
			/// The room has a calendar invitation text that contains dial-in information. Retrieved from the portal.
			/// </summary>
			public Boolean hasCalendarInviteText;
			/// <summary>
			/// This room has a moderator pin.
			/// </summary>
			public Boolean hasModeratorPin;
			/// <summary>
			/// if hasPassword is LMI_TRUE, password filed should be examined. If password field is empty, it means to clear the password, otherwise, it means set the room with this new password.
			/// </summary>
			public Boolean hasPassword;
			/// <summary>
			/// The room is being broadcast.
			/// </summary>
			public Boolean isBroadcastingEnabled;
			/// <summary>
			/// The room is being logges and is on the record.
			/// </summary>
			public Boolean isLoggingEnabled;
			/// <summary>
			/// The recording(logging) of the room is paused.
			/// </summary>
			public Boolean isLoggingPaused;
			/// <summary>
			/// The room can be logged/recorded.
			/// </summary>
			public Boolean isLoggingSupported;
			/// <summary>
			/// The room is for members only. A user cannot join unless they have a member or better clearance.
			/// </summary>
			public Boolean isMembersOnly;
			/// <summary>
			/// This room is moderated.
			/// </summary>
			public Boolean isModerated;
			/// <summary>
			/// The room requres a password to join.
			/// </summary>
			public Boolean isPasswordProtected;
			/// <summary>
			/// The room is created for peer to peer call with legacy endpoint.
			/// </summary>
			public Boolean isPeertoPeerCallWithLegacy;
			/// <summary>
			/// The room Public. This room will show up in searches.
			/// </summary>
			public Boolean isPublic;
			/// <summary>
			/// It set to LMI_TRUE, a member can request to become a user with additional privillege (such as moderator) .
			/// </summary>
			public Boolean isRoleChangeAllowed;
			/// <summary>
			/// The room is secure (both signaling and media).
			/// </summary>
			public Boolean isSecure;
			/// <summary>
			/// WaitintRoom feature is enabled.
			/// </summary>
			public Boolean isWaitingRoomEnabled;
			/// <summary>
			/// 
			/// </summary>
			public String language;
			/// <summary>
			/// Where to find the recording(logging).
			/// </summary>
			public String loggingLocation;
			/// <summary>
			/// Maxumum number of concurrent participants.
			/// </summary>
			public uint maxParticipants;
			/// <summary>
			/// A member of the room.
			/// </summary>
			public List<String> members;
			/// <summary>
			/// 
			/// </summary>
			public String moderatorUrl;
			/// <summary>
			/// A member of the room with moderator privileges. A moderator will typically have privileges such as muting users or kicking them out of the room.
			/// </summary>
			public List<String> moderators;
			/// <summary>
			/// 
			/// </summary>
			public String name;
			/// <summary>
			/// The user has been banned from the room.
			/// </summary>
			public List<String> outcasts;
			/// <summary>
			/// An owner of the room. This is the highest clearance. This type of user typically has unlimited privileges in the room.
			/// </summary>
			public List<String> owners;
			/// <summary>
			/// Profile for specific participants.
			/// </summary>
			public List<RoomParticipantProfile> participantProfiles;
			/// <summary>
			/// The password to join this room.
			/// </summary>
			public String password;
			/// <summary>
			/// A schedule for a room in iCalendar format.
			/// </summary>
			public EventSchedule schedule;
			/// <summary>
			/// A HTTP link to the room that can be shared.
			/// </summary>
			public String webLink;
			public RoomProperties(IntPtr obj){
				if(obj == IntPtr.Zero) {
					objPtr = VidyoRoomPropertiesConstructDefaultNative();
				}
				else {
					objPtr = VidyoRoomPropertiesConstructCopyNative(obj);
				}

				List<String> csAdministrators = new List<String>();
				var nAdministratorsSize = 0;
				var nAdministrators = VidyoRoomPropertiesGetadministratorsArrayNative(VidyoRoomPropertiesGetadministratorsNative(objPtr), ref nAdministratorsSize);
				var nAdministratorsIndex = 0;
				while (nAdministratorsIndex < nAdministratorsSize) {
					csAdministrators.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nAdministrators + (nAdministratorsIndex * Marshal.SizeOf(nAdministrators)))));
					nAdministratorsIndex++;
				}

				RoomParticipantProfile csDefaultProfile = new RoomParticipantProfile(VidyoRoomPropertiesGetdefaultProfileNative(objPtr));
				List<String> csMembers = new List<String>();
				var nMembersSize = 0;
				var nMembers = VidyoRoomPropertiesGetmembersArrayNative(VidyoRoomPropertiesGetmembersNative(objPtr), ref nMembersSize);
				var nMembersIndex = 0;
				while (nMembersIndex < nMembersSize) {
					csMembers.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nMembers + (nMembersIndex * Marshal.SizeOf(nMembers)))));
					nMembersIndex++;
				}

				List<String> csModerators = new List<String>();
				var nModeratorsSize = 0;
				var nModerators = VidyoRoomPropertiesGetmoderatorsArrayNative(VidyoRoomPropertiesGetmoderatorsNative(objPtr), ref nModeratorsSize);
				var nModeratorsIndex = 0;
				while (nModeratorsIndex < nModeratorsSize) {
					csModerators.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nModerators + (nModeratorsIndex * Marshal.SizeOf(nModerators)))));
					nModeratorsIndex++;
				}

				List<String> csOutcasts = new List<String>();
				var nOutcastsSize = 0;
				var nOutcasts = VidyoRoomPropertiesGetoutcastsArrayNative(VidyoRoomPropertiesGetoutcastsNative(objPtr), ref nOutcastsSize);
				var nOutcastsIndex = 0;
				while (nOutcastsIndex < nOutcastsSize) {
					csOutcasts.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nOutcasts + (nOutcastsIndex * Marshal.SizeOf(nOutcasts)))));
					nOutcastsIndex++;
				}

				List<String> csOwners = new List<String>();
				var nOwnersSize = 0;
				var nOwners = VidyoRoomPropertiesGetownersArrayNative(VidyoRoomPropertiesGetownersNative(objPtr), ref nOwnersSize);
				var nOwnersIndex = 0;
				while (nOwnersIndex < nOwnersSize) {
					csOwners.Add((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(Marshal.ReadIntPtr(nOwners + (nOwnersIndex * Marshal.SizeOf(nOwners)))));
					nOwnersIndex++;
				}

				List<RoomParticipantProfile> csParticipantProfiles = new List<RoomParticipantProfile>();
				var nParticipantProfilesSize = 0;
				var nParticipantProfiles = VidyoRoomPropertiesGetparticipantProfilesArrayNative(VidyoRoomPropertiesGetparticipantProfilesNative(objPtr), ref nParticipantProfilesSize);
				var nParticipantProfilesIndex = 0;
				while (nParticipantProfilesIndex < nParticipantProfilesSize) {
					RoomParticipantProfile csTparticipantProfiles = new RoomParticipantProfile(Marshal.ReadIntPtr(nParticipantProfiles + (nParticipantProfilesIndex * Marshal.SizeOf(nParticipantProfiles))));
					csParticipantProfiles.Add(csTparticipantProfiles);
					nParticipantProfilesIndex++;
				}

				EventSchedule csSchedule = new EventSchedule(VidyoRoomPropertiesGetscheduleNative(objPtr));
				administrators = csAdministrators;
				calendarInviteBody = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetcalendarInviteBodyNative(objPtr));
				calendarInviteHTMLBody = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetcalendarInviteHTMLBodyNative(objPtr));
				calendarInviteSubject = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetcalendarInviteSubjectNative(objPtr));
				creationTime = VidyoRoomPropertiesGetcreationTimeNative(objPtr);
				defaultProfile = csDefaultProfile;
				description = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetdescriptionNative(objPtr));
				designatedPresenter = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetdesignatedPresenterNative(objPtr));
				hasCalendarInviteText = VidyoRoomPropertiesGethasCalendarInviteTextNative(objPtr);
				hasModeratorPin = VidyoRoomPropertiesGethasModeratorPinNative(objPtr);
				hasPassword = VidyoRoomPropertiesGethasPasswordNative(objPtr);
				isBroadcastingEnabled = VidyoRoomPropertiesGetisBroadcastingEnabledNative(objPtr);
				isLoggingEnabled = VidyoRoomPropertiesGetisLoggingEnabledNative(objPtr);
				isLoggingPaused = VidyoRoomPropertiesGetisLoggingPausedNative(objPtr);
				isLoggingSupported = VidyoRoomPropertiesGetisLoggingSupportedNative(objPtr);
				isMembersOnly = VidyoRoomPropertiesGetisMembersOnlyNative(objPtr);
				isModerated = VidyoRoomPropertiesGetisModeratedNative(objPtr);
				isPasswordProtected = VidyoRoomPropertiesGetisPasswordProtectedNative(objPtr);
				isPeertoPeerCallWithLegacy = VidyoRoomPropertiesGetisPeertoPeerCallWithLegacyNative(objPtr);
				isPublic = VidyoRoomPropertiesGetisPublicNative(objPtr);
				isRoleChangeAllowed = VidyoRoomPropertiesGetisRoleChangeAllowedNative(objPtr);
				isSecure = VidyoRoomPropertiesGetisSecureNative(objPtr);
				isWaitingRoomEnabled = VidyoRoomPropertiesGetisWaitingRoomEnabledNative(objPtr);
				language = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetlanguageNative(objPtr));
				loggingLocation = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetloggingLocationNative(objPtr));
				maxParticipants = VidyoRoomPropertiesGetmaxParticipantsNative(objPtr);
				members = csMembers;
				moderatorUrl = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetmoderatorUrlNative(objPtr));
				moderators = csModerators;
				name = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetnameNative(objPtr));
				outcasts = csOutcasts;
				owners = csOwners;
				participantProfiles = csParticipantProfiles;
				password = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetpasswordNative(objPtr));
				schedule = csSchedule;
				webLink = (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(VidyoRoomPropertiesGetwebLinkNative(objPtr));
				VidyoRoomPropertiesFreeparticipantProfilesArrayNative(nParticipantProfiles, nParticipantProfilesSize);
				VidyoRoomPropertiesFreeownersArrayNative(nOwners, nOwnersSize);
				VidyoRoomPropertiesFreeoutcastsArrayNative(nOutcasts, nOutcastsSize);
				VidyoRoomPropertiesFreemoderatorsArrayNative(nModerators, nModeratorsSize);
				VidyoRoomPropertiesFreemembersArrayNative(nMembers, nMembersSize);
				VidyoRoomPropertiesFreeadministratorsArrayNative(nAdministrators, nAdministratorsSize);
			}
			~RoomProperties() {
				VidyoRoomPropertiesDestructNative(objPtr);
			 }
		};
		private IAcceptIncoming _mIAcceptIncoming;
		private IAcquireMediaRoute _mIAcquireMediaRoute;
		private IDelete _mIDelete;
		private IEnableMedia _mIEnableMedia;
		private IEnter _mIEnter;
		private IGetHistory _mIGetHistory;
		private IGetRoomProperties _mIGetRoomProperties;
		private IGetSelectedLocalCameras _mIGetSelectedLocalCameras;
		private IGetSelectedLocalMicrophones _mIGetSelectedLocalMicrophones;
		private IGetSelectedLocalMonitors _mIGetSelectedLocalMonitors;
		private IGetSelectedLocalRenderers _mIGetSelectedLocalRenderers;
		private IGetSelectedLocalSpeakers _mIGetSelectedLocalSpeakers;
		private IGetSelectedLocalWindowShares _mIGetSelectedLocalWindowShares;
		private IInvite _mIInvite;
		private ILockRoom _mILockRoom;
		private IMessageSearch _mIMessageSearch;
		private IPauseRecording _mIPauseRecording;
		private IRaiseHand _mIRaiseHand;
		private IRegisterBotEventListener _mIRegisterBotEventListener;
		private IRegisterConferenceModeEventListener _mIRegisterConferenceModeEventListener;
		private IRegisterConnectionPropertiesEventListener _mIRegisterConnectionPropertiesEventListener;
		private IRegisterHostEventListener _mIRegisterHostEventListener;
		private IRegisterInCallEventListener _mIRegisterInCallEventListener;
		private IRegisterLectureModeEventListener _mIRegisterLectureModeEventListener;
		private IRegisterMessageEventListener _mIRegisterMessageEventListener;
		private IRegisterModerationCommandEventListener _mIRegisterModerationCommandEventListener;
		private IRegisterModerationResultEventListener _mIRegisterModerationResultEventListener;
		private IRegisterParticipantEventListener _mIRegisterParticipantEventListener;
		private IRegisterPipEventListener _mIRegisterPipEventListener;
		private IRegisterRecorderInCallEventListener _mIRegisterRecorderInCallEventListener;
		private IRegisterResourceManagerEventListener _mIRegisterResourceManagerEventListener;
		private IRegisterRoomPropertiesEventListener _mIRegisterRoomPropertiesEventListener;
		private IRegisterSubjectEventListener _mIRegisterSubjectEventListener;
		private IRegisterUnprocessedAudioEventListener _mIRegisterUnprocessedAudioEventListener;
		private IRemoveRoomPIN _mIRemoveRoomPIN;
		private IRequestRoleChange _mIRequestRoleChange;
		private IResumeRecording _mIResumeRecording;
		private ISetDefaultProfile _mISetDefaultProfile;
		private ISetFavorite _mISetFavorite;
		private ISetRoomPIN _mISetRoomPIN;
		private ISetRoomProperties _mISetRoomProperties;
		private IStartRecording _mIStartRecording;
		private IStopRecording _mIStopRecording;
		private IUnlockRoom _mIUnlockRoom;
		public Room(IntPtr other){
			objPtr = VidyoRoomConstructCopyNative(other);
			objHandle = GCHandle.Alloc(this, GCHandleType.Weak);
			VidyoRoomSetUserDataNative(objPtr, GCHandle.ToIntPtr(objHandle));
			VidyoRoomRegisterParticipantEventListenerNative(objPtr, _mOnParticipantJoined, _mOnParticipantLeft, _mOnDynamicParticipantChanged, _mOnLoudestParticipantChanged);
		}
		~Room(){
			Dispose(false);
		}
		public void Dispose(){
			Dispose(true);
			GC.SuppressFinalize(this);
		}

		public void Dispose(bool disposing){
			if(disposed) return;

			disposed = true;
			DisposeWeakReferenceObjects();
			if(objPtr != IntPtr.Zero) {
				VidyoRoomSetUserDataNative(objPtr, IntPtr.Zero);
				VidyoRoomDestructNative(objPtr);
				objPtr = IntPtr.Zero;
			}

			if(objHandle.IsAllocated) objHandle.Free();
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="onIncomingEntered">Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.</param>
		/// <param name="onIncomingExited">Callback that is triggered when the room has been exited.</param>
		public Boolean AcceptIncoming(IAcceptIncoming _iIAcceptIncoming) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAcceptIncoming = _iIAcceptIncoming;

			Boolean ret = VidyoRoomAcceptIncomingNative(objPtr, _mOnIncomingEntered, _mOnIncomingExited);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="onMediaRouteAcquired">Callback that is triggered when the acquire media route operation is complete.</param>
		/// <param name="onMediaRouteAcquireFailed">Callback that is triggered when the could not be enabled.</param>
		public Boolean AcquireMediaRoute(IAcquireMediaRoute _iIAcquireMediaRoute) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIAcquireMediaRoute = _iIAcquireMediaRoute;

			Boolean ret = VidyoRoomAcquireMediaRouteNative(objPtr, _mOnMediaRouteAcquired, _mOnMediaRouteAcquireFailed);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localCamera"></param>
		/// <param name="removeOthers"></param>
		public void AddLocalCamera(LocalCamera localCamera, Boolean removeOthers) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddLocalCameraNative(objPtr, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero, removeOthers);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localMicrophone"></param>
		/// <param name="removeOthers"></param>
		/// <param name="isAES"></param>
		public void AddLocalMicrophone(LocalMicrophone localMicrophone, Boolean removeOthers, Boolean isAES) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddLocalMicrophoneNative(objPtr, (localMicrophone != null) ? localMicrophone.GetObjectPtr():IntPtr.Zero, removeOthers, isAES);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localMonitor"></param>
		/// <param name="removeOthers"></param>
		public void AddLocalMonitor(LocalMonitor localMonitor, Boolean removeOthers) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddLocalMonitorNative(objPtr, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero, removeOthers);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localRenderer"></param>
		/// <param name="removeOthers"></param>
		public void AddLocalRenderer(LocalRenderer localRenderer, Boolean removeOthers) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddLocalRendererNative(objPtr, (localRenderer != null) ? localRenderer.GetObjectPtr():IntPtr.Zero, removeOthers);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localSpeaker"></param>
		/// <param name="removeOthers"></param>
		/// <param name="isAES"></param>
		public void AddLocalSpeaker(LocalSpeaker localSpeaker, Boolean removeOthers, Boolean isAES) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddLocalSpeakerNative(objPtr, (localSpeaker != null) ? localSpeaker.GetObjectPtr():IntPtr.Zero, removeOthers, isAES);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localWindowShare"></param>
		/// <param name="removeOthers"></param>
		public void AddLocalWindowShare(LocalWindowShare localWindowShare, Boolean removeOthers) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddLocalWindowShareNative(objPtr, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero, removeOthers);
		}
		/// <summary>
		/// Add the virtual audio source to the room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="virtualAudioSource">The VidyoVirtualAudioSource object.</param>
		/// <param name="removeOthers">Indicates that previously added virtual audio sources will be removed.</param>
		public void AddVirtualAudioSource(VirtualAudioSource virtualAudioSource, Boolean removeOthers) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddVirtualAudioSourceNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero, removeOthers);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="virtualVideoSource"></param>
		/// <param name="removeOthers"></param>
		public void AddVirtualVideoSource(VirtualVideoSource virtualVideoSource, Boolean removeOthers) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomAddVirtualVideoSourceNative(objPtr, (virtualVideoSource != null) ? virtualVideoSource.GetObjectPtr():IntPtr.Zero, removeOthers);
		}
		/// <summary>
		/// The Moderator can send a moderation request to approve a raised hand, in which case the participant whose hand was raised will be notified.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="participant">Selected participant whose raised hand request is approved.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean ApproveRaisedHand(Participant participant, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomApproveRaisedHandNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Kick all participants out of a room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="reason">A message explaining the reason for the booting. This can be NULL if no message is desired.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean BootAllParticipants(String reason, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nReason = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(reason ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomBootAllParticipantsNative(objPtr, nReason, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nReason);

			return ret;
		}
		/// <summary>
		/// Kick one participant out of a room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="userId">ID of users to be kicked out of a room.</param>
		/// <param name="reason">A message explaining the reason for the booting. This can be NULL if no message is desired.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean BootParticipant(String userId, String reason, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nReason = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(reason ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomBootParticipantNative(objPtr, nUserId, nReason, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nReason);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// Cancel invitation to a VidyoRoom.
		/// </summary>
		/// <param name="r">The room object to extract stats.</param>
		/// <param name="inviteeId">Id of the invited user.</param>
		public Boolean CancelInvite(String inviteeId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nInviteeId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(inviteeId ?? string.Empty);
			Boolean ret = VidyoRoomCancelInviteNative(objPtr, nInviteeId);
			Marshal.FreeHGlobal(nInviteeId);

			return ret;
		}
		/// <summary>
		/// Creates a VidyoRoomParticipantProfile object.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="p">The VidyoRoomParticipantProfile object to construct.</param>
		/// <param name="userId">User ID if this is not a default profile.</param>
		/// <param name="microphone">The Microphone Profile.</param>
		/// <param name="camera">The Camera Profile.</param>
		/// <param name="windowShare">The WindowShare Profile.</param>
		/// <param name="chat">The Chat Profile.</param>
		public RoomParticipantProfile CreateParticipantProfile(RoomParticipantProfile p, String userId, RoomProfileControlMode microphone, RoomProfileControlMode camera, RoomProfileControlMode windowShare, RoomProfileControlMode chat) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr ret = VidyoRoomCreateParticipantProfileNative(objPtr, (p != null) ? p.GetObjectPtr():IntPtr.Zero, nUserId, microphone, camera, windowShare, chat);
			Marshal.FreeHGlobal(nUserId);
			RoomParticipantProfile csRet = new RoomParticipantProfile(ret);

			return csRet;
		}
		/// <summary>
		/// Delete a room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="onDeleteResult">Callback that is triggered when delete operation completes.</param>
		public void Delete(IDelete _iIDelete) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIDelete = _iIDelete;

			VidyoRoomDeleteNative(objPtr, _mOnDeleteResult);
		}
		/// <summary>
		/// Destroys a VidyoRoomParticipantProfile object.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="p">The VidyoRoomParticipantProfile object to construct.</param>
		public void DestroyParticipantProfile(RoomParticipantProfile p) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomDestroyParticipantProfileNative(objPtr, (p != null) ? p.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The room object.</param>
		public Boolean DisableMedia() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomDisableMediaNative(objPtr);

			return ret;
		}
		/// <summary>
		/// The Moderator can send a moderation request to reject all raised hand, in which case all participants whose hand was raised will be notified.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DismissAllRaisedHands(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomDismissAllRaisedHandsNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// The Moderator can send a moderation request to decline a raised hands, in which case the participant whose hand was raised will be notified.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="participants">List of selected participants whose raised hand request is going to dismiss.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean DismissRaisedHand(List<Participant> participants, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nListParticipants = VidyoRoomVectorVidyoParticipantAllocateNative();

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			IntPtr nParticipants = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * participants.Count);
			int nParticipantsSize = 0;
			foreach (Participant iter in participants) {
				Marshal.WriteIntPtr(nParticipants + (nParticipantsSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nParticipantsSize++;
			}
			VidyoRoomDismissRaisedHandSetparticipantsArrayNative(nListParticipants, nParticipants, nParticipantsSize);
			Marshal.FreeHGlobal(nParticipants);
			Boolean ret = VidyoRoomDismissRaisedHandNative(objPtr, nListParticipants, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			VidyoRoomVectorVidyoParticipantDeallocateNative(nListParticipants);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="onMediaEnabled">Callback that is triggered when the media has been successfully enabled.</param>
		/// <param name="onMediaFailed">Callback that is triggered when the could not be enabled.</param>
		/// <param name="onMediaDisabled">Callback that is triggered when the media has been disabled after being previously enabled successfully.</param>
		public Boolean EnableMedia(IEnableMedia _iIEnableMedia) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIEnableMedia = _iIEnableMedia;

			Boolean ret = VidyoRoomEnableMediaNative(objPtr, _mOnMediaEnabled, _mOnMediaFailed, _mOnMediaDisabled);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="password"></param>
		/// <param name="onEntered">Callback that is triggered when the enter operation completes. This could be a successful enter or a failure due to permissions, etc.</param>
		/// <param name="onExited">Callback that is triggered when the room has been exited.</param>
		public Boolean Enter(String password, IEnter _iIEnter) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIEnter = _iIEnter;

			IntPtr nPassword = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(password ?? string.Empty);
			Boolean ret = VidyoRoomEnterNative(objPtr, nPassword, _mOnEntered, _mOnExited);
			Marshal.FreeHGlobal(nPassword);

			return ret;
		}
		/// <summary>
		/// Gets the latest history of the room.
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="numMessages">The number of latest messages to request.</param>
		/// <param name="onGetHistoryResults">Callback that is triggered when history results are ready.</param>
		public Boolean GetHistory(uint numMessages, IGetHistory _iIGetHistory) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetHistory = _iIGetHistory;

			Boolean ret = VidyoRoomGetHistoryNative(objPtr, numMessages, _mOnGetHistoryResults);

			return ret;
		}
		/// <summary>
		/// Gets the history of the room before and after the messageId.
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="messageId">The ID of the message to use as an apex.</param>
		/// <param name="numMessagesBefore">The number of messages before the apex.</param>
		/// <param name="numMessagesAfter">The number of messages after the apex.</param>
		/// <param name="onGetHistoryResults">Callback that is triggered when history results are ready.</param>
		public Boolean GetHistoryById(long messageId, uint numMessagesBefore, uint numMessagesAfter, IGetHistory _iIGetHistory) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetHistory = _iIGetHistory;

			Boolean ret = VidyoRoomGetHistoryByIdNative(objPtr, messageId, numMessagesBefore, numMessagesAfter, _mOnGetHistoryResults);

			return ret;
		}
		/// <summary>
		/// Gets the history of the room before and after the messageId.
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="time">The time to use as an apex.</param>
		/// <param name="numMessagesBefore">The number of messages before the apex.</param>
		/// <param name="numMessagesAfter">The number of messages after the apex.</param>
		/// <param name="onGetHistoryResults">Callback that is triggered when history results are ready.</param>
		public Boolean GetHistoryByTime(ulong time, uint numMessagesBefore, uint numMessagesAfter, IGetHistory _iIGetHistory) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetHistory = _iIGetHistory;

			Boolean ret = VidyoRoomGetHistoryByTimeNative(objPtr, time, numMessagesBefore, numMessagesAfter, _mOnGetHistoryResults);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public String GetId() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoRoomGetIdNative(objPtr);

			return (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(ret);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="onGetRoomPropertiesResult">Callback that is triggered when get properties operation completes.</param>
		public Boolean GetRoomProperties(IGetRoomProperties _iIGetRoomProperties) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIGetRoomProperties = _iIGetRoomProperties;

			Boolean ret = VidyoRoomGetRoomPropertiesNative(objPtr, _mOnGetRoomPropertiesResult);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="onComplete"></param>
		public void GetSelectedLocalCameras(IGetSelectedLocalCameras _iIGetSelectedLocalCameras) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIGetSelectedLocalCameras = _iIGetSelectedLocalCameras;

			VidyoRoomGetSelectedLocalCamerasNative(objPtr, _mOnGetSelectedLocalCamerasComplete);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="onComplete"></param>
		public void GetSelectedLocalMicrophones(IGetSelectedLocalMicrophones _iIGetSelectedLocalMicrophones) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIGetSelectedLocalMicrophones = _iIGetSelectedLocalMicrophones;

			VidyoRoomGetSelectedLocalMicrophonesNative(objPtr, _mOnGetSelectedLocalMicrophonesComplete);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="monitors"></param>
		public void GetSelectedLocalMonitors(IGetSelectedLocalMonitors _iIGetSelectedLocalMonitors) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIGetSelectedLocalMonitors = _iIGetSelectedLocalMonitors;

			VidyoRoomGetSelectedLocalMonitorsNative(objPtr, _mOnGetSelectedLocalMonitorsComplete);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="onComplete"></param>
		public void GetSelectedLocalRenderers(IGetSelectedLocalRenderers _iIGetSelectedLocalRenderers) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIGetSelectedLocalRenderers = _iIGetSelectedLocalRenderers;

			VidyoRoomGetSelectedLocalRenderersNative(objPtr, _mOnGetSelectedLocalRenderersComplete);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="onComplete"></param>
		public void GetSelectedLocalSpeakers(IGetSelectedLocalSpeakers _iIGetSelectedLocalSpeakers) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIGetSelectedLocalSpeakers = _iIGetSelectedLocalSpeakers;

			VidyoRoomGetSelectedLocalSpeakersNative(objPtr, _mOnGetSelectedLocalSpeakersComplete);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="onComplete"></param>
		public void GetSelectedLocalWindowShares(IGetSelectedLocalWindowShares _iIGetSelectedLocalWindowShares) {
			if (objPtr == IntPtr.Zero) { return; }
			_mIGetSelectedLocalWindowShares = _iIGetSelectedLocalWindowShares;

			VidyoRoomGetSelectedLocalWindowSharesNative(objPtr, _mOnGetSelectedLocalWindowSharesComplete);
		}
		/// <summary>
		/// Get show throttle type.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		public RoomShowThrottle GetShowThrottle() {
			if (objPtr == IntPtr.Zero) { return default; }

			RoomShowThrottle ret = VidyoRoomGetShowThrottleNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get show throttle timer interval.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		public uint GetShowThrottleTimerInterval() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoRoomGetShowThrottleTimerIntervalNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Get show throttle threshold for window size change.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		public uint GetShowThrottleWindowSizeChangeThreshold() {
			if (objPtr == IntPtr.Zero) { return default; }

			uint ret = VidyoRoomGetShowThrottleWindowSizeChangeThresholdNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public RoomType GetType() {
			if (objPtr == IntPtr.Zero) { return default; }

			RoomType ret = VidyoRoomGetTypeNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public User GetUser() {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr ret = VidyoRoomGetUserNative(objPtr);
			User csRet = null;
			if(ret != IntPtr.Zero) {
				var csRetPtr = User.VidyoUserGetUserDataNative(ret);
				csRet = csRetPtr == IntPtr.Zero ? new User(ret) : (User)GCHandle.FromIntPtr(csRetPtr).Target;
			}


			return csRet;
		}
		/// <summary>
		/// Hides statistics for a room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		public void HideStatisticsDialog() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomHideStatisticsDialogNative(objPtr);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="userId"></param>
		/// <param name="message"></param>
		/// <param name="onInviteResult">Callback that is triggered when another participant joins a conference.</param>
		public Boolean Invite(String userId, String message, IInvite _iIInvite) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIInvite = _iIInvite;

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoRoomInviteNative(objPtr, nUserId, nMessage, _mOnInviteResult);
			Marshal.FreeHGlobal(nMessage);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="message"></param>
		/// <param name="onInviteResult">Callback that is triggered when another participant joins a conference.</param>
		public Boolean InviteAll(String message, IInvite _iIInvite) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIInvite = _iIInvite;

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoRoomInviteAllNative(objPtr, nMessage, _mOnInviteResult);
			Marshal.FreeHGlobal(nMessage);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="userIds"></param>
		/// <param name="message"></param>
		/// <param name="onInviteResult">Callback that is triggered when another participant joins a conference.</param>
		public Boolean InviteN(List<String> userIds, String message, IInvite _iIInvite) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIInvite = _iIInvite;

			IntPtr nListUserIds = VidyoRoomVectorLmiStringAllocateNative();

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			IntPtr nUserIds = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * userIds.Count);
			int nUserIdsSize = 0;
			foreach (String iter in userIds) {
				Marshal.WriteIntPtr(nUserIds + (nUserIdsSize * Marshal.SizeOf<IntPtr>()), MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(iter ?? string.Empty));
				nUserIdsSize++;
			}
			VidyoRoomInviteNSetuserIdsArrayNative(nListUserIds, nUserIds, nUserIdsSize);
			Marshal.FreeHGlobal(nUserIds);
			Boolean ret = VidyoRoomInviteNNative(objPtr, nListUserIds, nMessage, _mOnInviteResult);
			Marshal.FreeHGlobal(nMessage);
			VidyoRoomVectorLmiStringDeallocateNative(nListUserIds);

			return ret;
		}
		/// <summary>
		/// Leaves the room. This triggers VidyoRoomOnExited.
		/// </summary>
		/// <param name="r"></param>
		public Boolean Leave() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomLeaveNative(objPtr);

			return ret;
		}
		/// <summary>
		/// This api provides the ability lock the current room.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="onLockRoomResult">Callback to be triggered for lock room result.</param>
		public Boolean LockRoom(ILockRoom _iILockRoom) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mILockRoom = _iILockRoom;

			Boolean ret = VidyoRoomLockRoomNative(objPtr, _mOnLockRoomResult);

			return ret;
		}
		/// <summary>
		/// Searches the room for text messages.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="searchText">The text to search the messages in the room.</param>
		/// <param name="index">The start index from which the recent rooms are required. A value of '0' represents rooms starting from the beginning. A value of 'n' represents rooms starting from 'n'th record. This is used for paging the response.</param>
		/// <param name="pageSize">The maximum number of room records that can be sent in the response. This is used for paging the response.</param>
		/// <param name="onMessageSearchResults">Callback that is triggered when message search results are ready.</param>
		public Boolean MessageSearch(String searchText, uint index, uint pageSize, IMessageSearch _iIMessageSearch) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIMessageSearch = _iIMessageSearch;

			IntPtr nSearchText = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(searchText ?? string.Empty);
			Boolean ret = VidyoRoomMessageSearchNative(objPtr, nSearchText, index, pageSize, _mOnMessageSearchResults);
			Marshal.FreeHGlobal(nSearchText);

			return ret;
		}
		/// <summary>
		/// Asynchronously pauses recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or already paused. Calls a callback upon completion.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="onRecordingServicePauseResultCallback">Callback called upon completion.</param>
		public Boolean PauseRecording(IPauseRecording _iIPauseRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIPauseRecording = _iIPauseRecording;

			Boolean ret = VidyoRoomPauseRecordingNative(objPtr, _mOnRecordingServicePauseResult);

			return ret;
		}
		/// <summary>
		/// Each participant can send a moderation request to raise their hand to request to be unmuted. The Moderator and Presenter will be notified.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="raiseHandResponse">Callback that is triggered each time when response of hand raise request.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RaiseHand(IRaiseHand _iIRaiseHand, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRaiseHand = _iIRaiseHand;

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRaiseHandNative(objPtr, _mOnRaiseHandResponse, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Application can register a callback to get notified about bot participants.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onJoined">Callback that is triggered when bot participant joins a conference.</param>
		/// <param name="onLeft">Callback that is triggered when an existing bot participant leaves a conference.</param>
		public Boolean RegisterBotEventListener(IRegisterBotEventListener _iIRegisterBotEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterBotEventListener = _iIRegisterBotEventListener;

			Boolean ret = VidyoRoomRegisterBotEventListenerNative(objPtr, _mOnBotJoined, _mOnBotLeft);

			return ret;
		}
		/// <summary>
		/// Registers callbacks to get notified about conference mode events,i.e. lobby mode/lecture mode/waiting room.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="conferenceModeChanged">The conference mode i.e. Lecture mode/lobby room/group mode</param>
		public Boolean RegisterConferenceModeEventListener(IRegisterConferenceModeEventListener _iIRegisterConferenceModeEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterConferenceModeEventListener = _iIRegisterConferenceModeEventListener;

			Boolean ret = VidyoRoomRegisterConferenceModeEventListenerNative(objPtr, _mOnConferenceModeChanged);

			return ret;
		}
		/// <summary>
		/// Registers to get notified when a connection properties is changed.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onConnectionPropertiesChanged">Callback that is triggered when a connection properties is changed.</param>
		public Boolean RegisterConnectionPropertiesEventListener(IRegisterConnectionPropertiesEventListener _iIRegisterConnectionPropertiesEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterConnectionPropertiesEventListener = _iIRegisterConnectionPropertiesEventListener;

			Boolean ret = VidyoRoomRegisterConnectionPropertiesEventListenerNative(objPtr, _mOnConnectionPropertiesChanged);

			return ret;
		}
		/// <summary>
		/// Registers callbacks to get notified about room host joinin or leaving events
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="hostStatus">The host status whether joining or leaving</param>
		public Boolean RegisterHostEventListener(IRegisterHostEventListener _iIRegisterHostEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterHostEventListener = _iIRegisterHostEventListener;

			Boolean ret = VidyoRoomRegisterHostEventListenerNative(objPtr, _mOnConferenceHostStatusChanged);

			return ret;
		}
		/// <summary>
		/// Registers a callback to be will be triggered during a conference, these events may not stop the conferece but may degrade quality of call.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="cb">Callback which will be triggered when error occur in conference.</param>
		public Boolean RegisterInCallEventListener(IRegisterInCallEventListener _iIRegisterInCallEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterInCallEventListener = _iIRegisterInCallEventListener;

			Boolean ret = VidyoRoomRegisterInCallEventListenerNative(objPtr, _mOnInCallEvents);

			return ret;
		}
		/// <summary>
		/// Register a callback if application needs to know result of moderation request.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="presenterChanged">Callback that is triggered when presenter changed.</param>
		/// <param name="handRaised">Callback that is triggered for Moderator when some hand raised.</param>
		public Boolean RegisterLectureModeEventListener(IRegisterLectureModeEventListener _iIRegisterLectureModeEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterLectureModeEventListener = _iIRegisterLectureModeEventListener;

			Boolean ret = VidyoRoomRegisterLectureModeEventListenerNative(objPtr, _mOnPresenterChanged, _mOnHandRaised);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about message events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onMessageReceived">Callback that is triggered when a new message has been received.</param>
		/// <param name="onMessageAcknowledged">Callback that is triggered when a sent message has been acknowledged.</param>
		/// <param name="onMessageRead">Callback that is triggered when a sent message has been read.</param>
		/// <param name="onMessageTypingIndication">Callback that is triggered when a remote participant is typing.</param>
		public Boolean RegisterMessageEventListener(IRegisterMessageEventListener _iIRegisterMessageEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterMessageEventListener = _iIRegisterMessageEventListener;

			Boolean ret = VidyoRoomRegisterMessageEventListenerNative(objPtr, _mOnMessageReceived, _mOnMessageAcknowledged, _mOnMessageRead, _mOnMessageTypingIndication);

			return ret;
		}
		/// <summary>
		/// Register a callback to receive moderation commands sent from the server.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="onModerationCommand">Callback to be triggered upon receive moderation command from the server.</param>
		public Boolean RegisterModerationCommandEventListener(IRegisterModerationCommandEventListener _iIRegisterModerationCommandEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterModerationCommandEventListener = _iIRegisterModerationCommandEventListener;

			Boolean ret = VidyoRoomRegisterModerationCommandEventListenerNative(objPtr, _mOnModerationCommandReceived);

			return ret;
		}
		/// <summary>
		/// Register a callback if application needs to know result of moderation request.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="onModerationResult">Callback to be triggered upon receive moderation request result.</param>
		public Boolean RegisterModerationResultEventListener(IRegisterModerationResultEventListener _iIRegisterModerationResultEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterModerationResultEventListener = _iIRegisterModerationResultEventListener;

			Boolean ret = VidyoRoomRegisterModerationResultEventListenerNative(objPtr, _mOnModerationResult);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about participant events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onParticipantJoined">Callback that is triggered when another participant joins a conference.</param>
		/// <param name="onParticipantLeft">Callback that is triggered when an existing participant leaves a conference.</param>
		/// <param name="onDynamicParticipantChanged">Callback that is triggered when the order of participants has changed, based on their importance according to active speech detection.</param>
		/// <param name="onLoudestParticipantChanged">Callback that is triggered when a new participant becomes the loudest, based on active speech detection.</param>
		public Boolean RegisterParticipantEventListener(IRegisterParticipantEventListener _iIRegisterParticipantEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterParticipantEventListener = _iIRegisterParticipantEventListener;

			Boolean ret = VidyoRoomRegisterParticipantEventListenerNative(objPtr, _mOnParticipantJoined, _mOnParticipantLeft, _mOnDynamicParticipantChanged, _mOnLoudestParticipantChanged);

			return ret;
		}
		/// <summary>
		/// Registers to get notified when a a call is being recorded.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onPipLocationChanged">.</param>
		public Boolean RegisterPipEventListener(IRegisterPipEventListener _iIRegisterPipEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterPipEventListener = _iIRegisterPipEventListener;

			Boolean ret = VidyoRoomRegisterPipEventListenerNative(objPtr, _mOnPipLocationChanged);

			return ret;
		}
		/// <summary>
		/// Registers to get notified when a a call is being recorded.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onRecorderInCallChanged">Callback that is triggered when a recorder joins or leaves the call.</param>
		public Boolean RegisterRecorderInCallEventListener(IRegisterRecorderInCallEventListener _iIRegisterRecorderInCallEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRecorderInCallEventListener = _iIRegisterRecorderInCallEventListener;

			Boolean ret = VidyoRoomRegisterRecorderInCallEventListenerNative(objPtr, _mRecorderInCall);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about resource-management events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onAvailableResourcesChanged">Callback that is triggered when local resource availability changes.</param>
		/// <param name="onMaxRemoteSourcesChanged">Callback that is triggered when the maximum number of decoded sources changes.</param>
		public Boolean RegisterResourceManagerEventListener(IRegisterResourceManagerEventListener _iIRegisterResourceManagerEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterResourceManagerEventListener = _iIRegisterResourceManagerEventListener;

			Boolean ret = VidyoRoomRegisterResourceManagerEventListenerNative(objPtr, _mOnAvailableResourcesChanged, _mOnMaxRemoteSourcesChanged);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about participant events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onRoomPropertiesChanged">Callback that is triggered when room properties have changed.</param>
		public Boolean RegisterRoomPropertiesEventListener(IRegisterRoomPropertiesEventListener _iIRegisterRoomPropertiesEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterRoomPropertiesEventListener = _iIRegisterRoomPropertiesEventListener;

			Boolean ret = VidyoRoomRegisterRoomPropertiesEventListenerNative(objPtr, _mOnRoomPropertiesChanged);

			return ret;
		}
		/// <summary>
		/// Registers to get notified about subject events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onSetSubject">Callback that is triggered when the subject has been changed.</param>
		public Boolean RegisterSubjectEventListener(IRegisterSubjectEventListener _iIRegisterSubjectEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterSubjectEventListener = _iIRegisterSubjectEventListener;

			Boolean ret = VidyoRoomRegisterSubjectEventListenerNative(objPtr, _mOnSetSubject);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="onUnprocessedAudioSupportChanged">.</param>
		/// <param name="onUnprocessedAudioStarted">.</param>
		public Boolean RegisterUnprocessedAudioEventListener(IRegisterUnprocessedAudioEventListener _iIRegisterUnprocessedAudioEventListener) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRegisterUnprocessedAudioEventListener = _iIRegisterUnprocessedAudioEventListener;

			Boolean ret = VidyoRoomRegisterUnprocessedAudioEventListenerNative(objPtr, _mOnUnprocessedAudioSupportChanged, _mOnUnprocessedAudioStarted);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		public Boolean RejectIncoming() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomRejectIncomingNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localCamera"></param>
		public void RemoveLocalCamera(LocalCamera localCamera) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveLocalCameraNative(objPtr, (localCamera != null) ? localCamera.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localMicrophone"></param>
		public void RemoveLocalMicrophone(LocalMicrophone localMicrophone) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveLocalMicrophoneNative(objPtr, (localMicrophone != null) ? localMicrophone.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localMonitor"></param>
		public void RemoveLocalMonitor(LocalMonitor localMonitor) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveLocalMonitorNative(objPtr, (localMonitor != null) ? localMonitor.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localRenderer"></param>
		public void RemoveLocalRenderer(LocalRenderer localRenderer) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveLocalRendererNative(objPtr, (localRenderer != null) ? localRenderer.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localSpeaker"></param>
		public void RemoveLocalSpeaker(LocalSpeaker localSpeaker) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveLocalSpeakerNative(objPtr, (localSpeaker != null) ? localSpeaker.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="localWindowShare"></param>
		public void RemoveLocalWindowShare(LocalWindowShare localWindowShare) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveLocalWindowShareNative(objPtr, (localWindowShare != null) ? localWindowShare.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// Remove presenter rights from a specific participant.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RemovePresenter(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRemovePresenterNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This API provides the ability to allow a room owner to remove authentication scheme for moderator functionality
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="role">VidyoRole that provided auth is assoicted with.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RemoveRoleChangeAuthorization(Role role, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRemoveRoleChangeAuthorizationNative(objPtr, role, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This api provides the ability to remove the room pin. Once room pin is remove, all other users are not required to enter room pin to join the conference room.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="onRemoveRoomPINResult">Callback to be triggered for remove room pin result.</param>
		public Boolean RemoveRoomPIN(IRemoveRoomPIN _iIRemoveRoomPIN) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRemoveRoomPIN = _iIRemoveRoomPIN;

			Boolean ret = VidyoRoomRemoveRoomPINNative(objPtr, _mOnRemoveRoomPINResult);

			return ret;
		}
		/// <summary>
		/// Remove the virtual audio source from the room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="virtualAudioSource">The VidyoVirtualAudioSource object.</param>
		public void RemoveVirtualAudioSource(VirtualAudioSource virtualAudioSource) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveVirtualAudioSourceNative(objPtr, (virtualAudioSource != null) ? virtualAudioSource.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="virtualVideoSource"></param>
		public void RemoveVirtualVideoSource(VirtualVideoSource virtualVideoSource) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomRemoveVirtualVideoSourceNative(objPtr, (virtualVideoSource != null) ? virtualVideoSource.GetObjectPtr():IntPtr.Zero);
		}
		/// <summary>
		/// By default, local participant joining/leaving conference are not reported to applicaiotn. Use this function to report those events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="reportLocalParticipant">Set to LMI_TRUE if application is interested in local participant to be included in participant event callbacks. Otherwise set to LMI_FALSE. Default is LMI_FALSE</param>
		public Boolean ReportLocalParticipantOnJoined(Boolean reportLocalParticipant) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomReportLocalParticipantOnJoinedNative(objPtr, reportLocalParticipant);

			return ret;
		}
		/// <summary>
		/// Reqeust all participants in the room to stop sending audio. And any participant is allowed to restart audio after it is stopped first.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RequestAudioSilenceForAll(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRequestAudioSilenceForAllNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Reqeust a single participant in the room to stop sending audio. This participant is allowed to restart audio after it is stopped first.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="userId">The ID of participant whose audio is requested to stop.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RequestAudioSilenceForParticipant(String userId, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRequestAudioSilenceForParticipantNative(objPtr, nUserId, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// This API provides the ability to request moderator functionality, providing the user who is not a room owner, the ability to control remote source transmitting, for other users in the conference. Remote sources currently include camera's and microphones.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="newRole">.</param>
		/// <param name="auth">.</param>
		/// <param name="onRequestRoleChangeResult">.</param>
		/// <param name="requestId">.</param>
		public Boolean RequestRoleChange(Role newRole, RoleAuthorization auth, IRequestRoleChange _iIRequestRoleChange, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIRequestRoleChange = _iIRequestRoleChange;

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRequestRoleChangeNative(objPtr, newRole, (auth != null) ? auth.GetObjectPtr():IntPtr.Zero, _mOnRequestRoleChangeResult, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Reqeust all participants in the room to stop sending video. And any participant is allowed to restart video after it is stopped first.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RequestVideoSilenceForAll(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRequestVideoSilenceForAllNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Reqeust a single participant in the room to stop sending video. This participant is allowed to restart video after it is stopped first.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="userId">The ID of participant whose video is requested to stop.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RequestVideoSilenceForParticipant(String userId, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRequestVideoSilenceForParticipantNative(objPtr, nUserId, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// Resizes statistics dialog for a room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="width">Width of the dialog.</param>
		/// <param name="height">height of the dialog.</param>
		public void ResizeStatisticsDialog(int width, int height) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomResizeStatisticsDialogNative(objPtr, width, height);
		}
		/// <summary>
		/// Asynchronously resumes recording a conference. Must be called on behalf of a moderator. Fails in case recording is not in progress or not paused. Calls a callback upon completion.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="onRecordingServiceResumeResultCallback">Callback called upon completion.</param>
		public Boolean ResumeRecording(IResumeRecording _iIResumeRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIResumeRecording = _iIResumeRecording;

			Boolean ret = VidyoRoomResumeRecordingNative(objPtr, _mOnRecordingServiceResumeResult);

			return ret;
		}
		/// <summary>
		/// Set audio revoke state for all participants in the room.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="revoke">Set to LMI_TRUE to stop all participants' audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RevokeAudioForAll(Boolean revoke, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRevokeAudioForAllNative(objPtr, revoke, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Set audio revoke state for a single participant in the room.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="userId">The ID of participant whose audio is revoked/resumed.</param>
		/// <param name="revoke">Set to LMI_TRUE to stop the participant's audio. Audio cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RevokeAudioForParticipant(String userId, Boolean revoke, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRevokeAudioForParticipantNative(objPtr, nUserId, revoke, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// Set video revoke state for all participants in the room.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="revoke">Set to LMI_TRUE to stop all participants' video. Video cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RevokeVideoForAll(Boolean revoke, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRevokeVideoForAllNative(objPtr, revoke, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Set video revoke state for a single participant in the room.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="userId">The ID of participant whose audio is revoked/resumed.</param>
		/// <param name="revoke">Set to LMI_TRUE to stop the participant's video. Video cannot be resumed until another call with revoke set to LMI_FALSE.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean RevokeVideoForParticipant(String userId, Boolean revoke, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nUserId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(userId ?? string.Empty);
			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomRevokeVideoForParticipantNative(objPtr, nUserId, revoke, nRequestId);
			Marshal.FreeHGlobal(nRequestId);
			Marshal.FreeHGlobal(nUserId);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="message"></param>
		public Boolean SendMessage(String message) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoRoomSendMessageNative(objPtr, nMessage);
			Marshal.FreeHGlobal(nMessage);

			return ret;
		}
		/// <summary>
		/// Send the acknowledgement to message in a conference room.
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="messageId">The message id of message being acknowledged.</param>
		public Boolean SendMessageAcknowledged(long messageId) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomSendMessageAcknowledgedNative(objPtr, messageId);

			return ret;
		}
		/// <summary>
		/// Send a typing indication state to all participants of a room.
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="typingIndication">The typing indication state.</param>
		public Boolean SendMessageTypingIndication(ChatMessage.ChatMessageTypingIndication typingIndication) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomSendMessageTypingIndicationNative(objPtr, typingIndication);

			return ret;
		}
		/// <summary>
		/// Send a private message. Only specific participant will receive this.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="participant">The participant which will receive message.</param>
		/// <param name="message">Message that need to be sent.</param>
		public Boolean SendPrivateMessage(Participant participant, String message) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nMessage = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(message ?? string.Empty);
			Boolean ret = VidyoRoomSendPrivateMessageNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nMessage);
			Marshal.FreeHGlobal(nMessage);

			return ret;
		}
		/// <summary>
		/// Set the default profile for all participants. Only one SetRoomProperty request is allowed at a time.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="profile">The default profile for all participants.</param>
		/// <param name="onSetRoomPropertyResult">Callback that is triggered when set property operation completes.</param>
		public Boolean SetDefaultProfile(RoomParticipantProfile profile, ISetDefaultProfile _iISetDefaultProfile) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mISetDefaultProfile = _iISetDefaultProfile;

			Boolean ret = VidyoRoomSetDefaultProfileNative(objPtr, (profile != null) ? profile.GetObjectPtr():IntPtr.Zero, _mOnSetRoomPropertyResult);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="generation"></param>
		/// <param name="x"></param>
		/// <param name="y"></param>
		/// <param name="width"></param>
		/// <param name="height"></param>
		/// <param name="frameInterval"></param>
		public Boolean SetDynamicGenerationPosition(uint generation, int x, int y, uint width, uint height, ulong frameInterval) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomSetDynamicGenerationPositionNative(objPtr, generation, x, y, width, height, frameInterval);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="renderer"></param>
		public Boolean SetDynamicLocalRenderer(LocalRenderer renderer) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomSetDynamicLocalRendererNative(objPtr, (renderer != null) ? renderer.GetObjectPtr():IntPtr.Zero);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		/// <param name="isFavorite"></param>
		/// <param name="onSetFavoriteResult">Callback that is triggered when set favorite operation completes.</param>
		public void SetFavorite(Boolean isFavorite, ISetFavorite _iISetFavorite) {
			if (objPtr == IntPtr.Zero) { return; }
			_mISetFavorite = _iISetFavorite;

			VidyoRoomSetFavoriteNative(objPtr, isFavorite, _mOnSetFavoriteResult);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="count"></param>
		public Boolean SetMaxAudioSources(uint count) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomSetMaxAudioSourcesNative(objPtr, count);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="bitRate">The maximum receiving bit rate request sent to server, in bps.</param>
		public void SetMaxReceiveBitRate(uint bitRate) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomSetMaxReceiveBitRateNative(objPtr, bitRate);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r">The room object.</param>
		/// <param name="bitRate">The maximum send bit rate request sent to server, in bps.</param>
		public void SetMaxSendBitRate(uint bitRate) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomSetMaxSendBitRateNative(objPtr, bitRate);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="count"></param>
		public Boolean SetMaxVideoSources(uint count) {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomSetMaxVideoSourcesNative(objPtr, count);

			return ret;
		}
		/// <summary>
		/// Set the profiles for specific participants. Only one SetRoomProperty request is allowed at a time.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="profiles">Set the profiles for specific participants.</param>
		/// <param name="onSetRoomPropertyResult">Callback that is triggered when set property operation completes.</param>
		public Boolean SetParticipantProfiles(List<RoomParticipantProfile> profiles, ISetDefaultProfile _iISetDefaultProfile) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mISetDefaultProfile = _iISetDefaultProfile;

			IntPtr nListProfiles = VidyoRoomVectorVidyoRoomParticipantProfileAllocateNative();

			IntPtr nProfiles = Marshal.AllocHGlobal(Marshal.SizeOf<IntPtr>() * profiles.Count);
			int nProfilesSize = 0;
			foreach (RoomParticipantProfile iter in profiles) {
				Marshal.WriteIntPtr(nProfiles + (nProfilesSize * Marshal.SizeOf<IntPtr>()), iter.GetObjectPtr());
				nProfilesSize++;
			}
			VidyoRoomSetParticipantProfilesSetprofilesArrayNative(nListProfiles, nProfiles, nProfilesSize);
			Marshal.FreeHGlobal(nProfiles);
			Boolean ret = VidyoRoomSetParticipantProfilesNative(objPtr, nListProfiles, _mOnSetRoomPropertyResult);
			VidyoRoomVectorVidyoRoomParticipantProfileDeallocateNative(nListProfiles);

			return ret;
		}
		/// <summary>
		/// Set a specific participant as a presenter.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="participant">The VidyoParticipant object who will be a new presenter.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean SetPresenter(Participant participant, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomSetPresenterNative(objPtr, (participant != null) ? participant.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This API provides the ability to allow a room owner to set an authentication scheme for moderator functionality. The same authentication scheme must be used by other participants who calls VidyoRoomRequestRoleChange to control remote source transmitting
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="role">VidyoRole that provided auth is assoicted with.</param>
		/// <param name="auth">Represent the authentication scheme (e.g use passCode to obtain moderator functionality).</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean SetRoleChangeAuthorization(Role role, RoleAuthorization auth, String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomSetRoleChangeAuthorizationNative(objPtr, role, (auth != null) ? auth.GetObjectPtr():IntPtr.Zero, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This api provides the ability to set the room pin. Once room pin is set, all other users are required to enter this room pin to join this conference room.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="roomPIN">Pin to be set as room pin or set NULL to remove existing room pin.</param>
		/// <param name="onSetRoomPINResult">Callback to be triggered for set room pin result.</param>
		public Boolean SetRoomPIN(String roomPIN, ISetRoomPIN _iISetRoomPIN) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mISetRoomPIN = _iISetRoomPIN;

			IntPtr nRoomPIN = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(roomPIN ?? string.Empty);
			Boolean ret = VidyoRoomSetRoomPINNative(objPtr, nRoomPIN, _mOnSetRoomPINResult);
			Marshal.FreeHGlobal(nRoomPIN);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="roomProperties"></param>
		/// <param name="onSetRoomPropertiesResult">Callback that is triggered when set properties operation completes.</param>
		public Boolean SetRoomProperties(RoomProperties roomProperties, ISetRoomProperties _iISetRoomProperties) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mISetRoomProperties = _iISetRoomProperties;

			Boolean ret = VidyoRoomSetRoomPropertiesNative(objPtr, (roomProperties != null) ? roomProperties.GetObjectPtr():IntPtr.Zero, _mOnSetRoomPropertiesResult);

			return ret;
		}
		/// <summary>
		/// Set show throttle type.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="t">The throttle type.</param>
		public void SetShowThrottle(RoomShowThrottle t) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomSetShowThrottleNative(objPtr, t);
		}
		/// <summary>
		/// Set show throttle timer interval.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="seconds">The time interval in between shows.</param>
		public void SetShowThrottleTimerInterval(uint seconds) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomSetShowThrottleTimerIntervalNative(objPtr, seconds);
		}
		/// <summary>
		/// Set show throttle window size change threshold.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="percentage">The threshold as a percentage of window size change.</param>
		public void SetShowThrottleWindowSizeChangeThreshold(uint percentage) {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomSetShowThrottleWindowSizeChangeThresholdNative(objPtr, percentage);
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="r"></param>
		/// <param name="subject"></param>
		public Boolean SetSubject(String subject) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nSubject = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(subject ?? string.Empty);
			Boolean ret = VidyoRoomSetSubjectNative(objPtr, nSubject);
			Marshal.FreeHGlobal(nSubject);

			return ret;
		}
		/// <summary>
		/// Shows statistics for a room.
		/// </summary>
		/// <param name="r">Vidyo room object.</param>
		public void ShowStatisticsDialog() {
			if (objPtr == IntPtr.Zero) { return; }

			VidyoRoomShowStatisticsDialogNative(objPtr);
		}
		/// <summary>
		/// Switch room mode to the Lecture mode.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean StartLectureMode(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomStartLectureModeNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Asynchronously starts recording a conference using the specified recording profile. Must be called on behalf of a moderator. Fails in case another recording is in progress. Calls a callback upon completion.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="recordingProfilePrefix">Recording profile prefix to start the recording with.</param>
		/// <param name="onRecordingServiceStartCallback">Callback called upon completion.</param>
		public Boolean StartRecording(String recordingProfilePrefix, IStartRecording _iIStartRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIStartRecording = _iIStartRecording;

			IntPtr nRecordingProfilePrefix = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(recordingProfilePrefix ?? string.Empty);
			Boolean ret = VidyoRoomStartRecordingNative(objPtr, nRecordingProfilePrefix, _mOnRecordingServiceStartResult);
			Marshal.FreeHGlobal(nRecordingProfilePrefix);

			return ret;
		}
		/// <summary>
		/// Switch room mode to the Group mode.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean StopLectureMode(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomStopLectureModeNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// Asynchronously stops recording a conference. Must be called on behalf of a moderator. Fails in case there is no recording in progress. Calls a callback upon completion.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="onRecordingServiceStopResultCallback">Callback called upon completion.</param>
		public Boolean StopRecording(IStopRecording _iIStopRecording) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIStopRecording = _iIStopRecording;

			Boolean ret = VidyoRoomStopRecordingNative(objPtr, _mOnRecordingServiceStopResult);

			return ret;
		}
		/// <summary>
		/// This api provides the ability unlock the current room.
		/// </summary>
		/// <param name="r">VidyoRoom object.</param>
		/// <param name="onUnlockRoomResult">Callback to be triggered for unlock room result.</param>
		public Boolean UnlockRoom(IUnlockRoom _iIUnlockRoom) {
			if (objPtr == IntPtr.Zero) { return default; }
			_mIUnlockRoom = _iIUnlockRoom;

			Boolean ret = VidyoRoomUnlockRoomNative(objPtr, _mOnUnlockRoomResult);

			return ret;
		}
		/// <summary>
		/// Each participant can send a moderation request to remove his raised hand to cancel the request to be unmuted.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		/// <param name="requestId">Application provide identifier to track this request.</param>
		public Boolean UnraiseHand(String requestId) {
			if (objPtr == IntPtr.Zero) { return default; }

			IntPtr nRequestId = MarshalPtrToUtf8.GetInstance().MarshalManagedToNative(requestId ?? string.Empty);
			Boolean ret = VidyoRoomUnraiseHandNative(objPtr, nRequestId);
			Marshal.FreeHGlobal(nRequestId);

			return ret;
		}
		/// <summary>
		/// This is a synchronous interface. Application can unregister callback to stop bot participant event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterBotEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterBotEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// UnRegisters callbacks to get notified about conference mode events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterConferenceModeEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterConferenceModeEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters event listener, application will not receive an event about connection properties changes.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterConnectionPropertiesEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterConnectionPropertiesEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// UnRegisters callbacks to get notified about host joining or leaving events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterHostEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterHostEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters callback for in call events.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterInCallEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterInCallEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		public Boolean UnregisterLectureModeEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterLectureModeEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters message event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterMessageEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterMessageEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregister a callback to do not receive moderation commands sent from the server.
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		public Boolean UnregisterModerationCommandEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterModerationCommandEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// 
		/// </summary>
		/// <param name="room">Vidyo room object.</param>
		public Boolean UnregisterModerationResultEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterModerationResultEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters participant event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterParticipantEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterParticipantEventListenerNative(objPtr);
			_mIRegisterParticipantEventListener = null;

			return ret;
		}
		/// <summary>
		/// Unregisters recorder in call event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterPipEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterPipEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters recorder in call event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterRecorderInCallEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterRecorderInCallEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters resource manager event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterResourceManagerEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterResourceManagerEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters room properties event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterRoomPropertiesEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterRoomPropertiesEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// Unregisters subject event notifications.
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterSubjectEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterSubjectEventListenerNative(objPtr);

			return ret;
		}
		/// <summary>
		/// .
		/// </summary>
		/// <param name="r">The VidyoRoom object.</param>
		public Boolean UnregisterUnprocessedAudioEventListener() {
			if (objPtr == IntPtr.Zero) { return default; }

			Boolean ret = VidyoRoomUnregisterUnprocessedAudioEventListenerNative(objPtr);

			return ret;
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnAvailableResourcesChanged))]
#endif
		private static void OnAvailableResourcesChangedDelegate(IntPtr room, uint cpuEncode, uint cpuDecode, uint bandwidthSend, uint bandwidthReceive){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterResourceManagerEventListener?.OnAvailableResourcesChanged(cpuEncode, cpuDecode, bandwidthSend, bandwidthReceive);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnBotJoined))]
#endif
		private static void OnBotJoinedDelegate(IntPtr r, IntPtr info){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			RoomBotInfo csInfo = new RoomBotInfo(info);
			csR?._mIRegisterBotEventListener?.OnBotJoined(csInfo);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnBotLeft))]
#endif
		private static void OnBotLeftDelegate(IntPtr r, IntPtr info){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			RoomBotInfo csInfo = new RoomBotInfo(info);
			csR?._mIRegisterBotEventListener?.OnBotLeft(csInfo);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConferenceHostStatusChanged))]
#endif
		private static void OnConferenceHostStatusChangedDelegate(IntPtr r, IntPtr host, RoomConferenceHostState hostState){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			Participant csHost = null;
			if(host != IntPtr.Zero) {
				var csHostPtr = Participant.VidyoParticipantGetUserDataNative(host);
				if (csHostPtr == IntPtr.Zero) {
					csHost = new Participant(host);
					if (csHost != null) {
						csR?.objects?.Add(new WeakReference(csHost));
					}
				} else {
					csHost = (Participant)GCHandle.FromIntPtr(csHostPtr).Target;
				}
			}

			csR?._mIRegisterHostEventListener?.OnConferenceHostStatusChanged(csHost, hostState);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConferenceModeChanged))]
#endif
		private static void OnConferenceModeChangedDelegate(IntPtr r, RoomConferenceMode mode){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIRegisterConferenceModeEventListener?.OnConferenceModeChanged(mode);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnConnectionPropertiesChanged))]
#endif
		private static void OnConnectionPropertiesChangedDelegate(IntPtr r, IntPtr connectionProperties){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			RoomConnectionProperties csConnectionProperties = new RoomConnectionProperties(connectionProperties);
			csR?._mIRegisterConnectionPropertiesEventListener?.OnConnectionPropertiesChanged(csConnectionProperties);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnDeleteResult))]
#endif
		private static void OnDeleteResultDelegate(IntPtr room, RoomDeleteResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIDelete?.OnDeleteResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnDynamicParticipantChanged))]
#endif
		private static void OnDynamicParticipantChangedDelegate(IntPtr room, IntPtr selectedParticipants){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			List<Participant> csSelectedParticipants = new List<Participant>();
			var nSelectedParticipantsSize = 0;
			var nSelectedParticipants = VidyoRoomOnDynamicParticipantChangedGetselectedParticipantsArrayNative(selectedParticipants, ref nSelectedParticipantsSize);
			var nSelectedParticipantsIndex = 0;
			while (nSelectedParticipantsIndex < nSelectedParticipantsSize) {
				Participant csTselectedParticipants = null;
				if(Marshal.ReadIntPtr(nSelectedParticipants + (nSelectedParticipantsIndex * Marshal.SizeOf(nSelectedParticipants))) != IntPtr.Zero) {
					var csTselectedParticipantsPtr = Participant.VidyoParticipantGetUserDataNative(Marshal.ReadIntPtr(nSelectedParticipants + (nSelectedParticipantsIndex * Marshal.SizeOf(nSelectedParticipants))));
					if (csTselectedParticipantsPtr == IntPtr.Zero) {
						csTselectedParticipants = new Participant(Marshal.ReadIntPtr(nSelectedParticipants + (nSelectedParticipantsIndex * Marshal.SizeOf(nSelectedParticipants))));
						if (csTselectedParticipants != null) {
							csRoom?.objects?.Add(new WeakReference(csTselectedParticipants));
						}
					} else {
						csTselectedParticipants = (Participant)GCHandle.FromIntPtr(csTselectedParticipantsPtr).Target;
					}
				}

				csSelectedParticipants.Add(csTselectedParticipants);
				nSelectedParticipantsIndex++;
			}

			csRoom?._mIRegisterParticipantEventListener?.OnDynamicParticipantChanged(csSelectedParticipants);
			VidyoRoomOnDynamicParticipantChangedFreeselectedParticipantsArrayNative(nSelectedParticipants, nSelectedParticipantsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnEntered))]
#endif
		private static void OnEnteredDelegate(IntPtr room, RoomEnterResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIEnter?.OnEntered(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnExited))]
#endif
		private static void OnExitedDelegate(IntPtr room, RoomExitReason reason){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIEnter?.OnExited(reason);
			csRoom?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetHistoryResults))]
#endif
		private static void OnGetHistoryResultsDelegate(IntPtr room, IntPtr records, long historySize, RoomSearchResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			List<ChatMessage> csRecords = new List<ChatMessage>();
			var nRecordsSize = 0;
			var nRecords = VidyoRoomOnGetHistoryResultsGetrecordsArrayNative(records, ref nRecordsSize);
			var nRecordsIndex = 0;
			while (nRecordsIndex < nRecordsSize) {
				ChatMessage csTrecords = new ChatMessage(Marshal.ReadIntPtr(nRecords + (nRecordsIndex * Marshal.SizeOf(nRecords))));
				csRecords.Add(csTrecords);
				nRecordsIndex++;
			}

			csRoom?._mIGetHistory?.OnGetHistoryResults(csRecords, historySize, result);
			VidyoRoomOnGetHistoryResultsFreerecordsArrayNative(nRecords, nRecordsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetRoomPropertiesResult))]
#endif
		private static void OnGetRoomPropertiesResultDelegate(IntPtr room, RoomGetPropertiesResult result, IntPtr roomProperties){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			RoomProperties csRoomProperties = new RoomProperties(roomProperties);
			csRoom?._mIGetRoomProperties?.OnGetRoomPropertiesResult(result, csRoomProperties);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetSelectedLocalCamerasComplete))]
#endif
		private static void OnGetSelectedLocalCamerasCompleteDelegate(IntPtr r, IntPtr cameras){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			List<LocalCamera> csCameras = new List<LocalCamera>();
			var nCamerasSize = 0;
			var nCameras = VidyoRoomOnGetSelectedLocalCamerasCompleteGetcamerasArrayNative(cameras, ref nCamerasSize);
			var nCamerasIndex = 0;
			while (nCamerasIndex < nCamerasSize) {
				LocalCamera csTcameras = null;
				if(Marshal.ReadIntPtr(nCameras + (nCamerasIndex * Marshal.SizeOf(nCameras))) != IntPtr.Zero) {
					var csTcamerasPtr = LocalCamera.VidyoLocalCameraGetUserDataNative(Marshal.ReadIntPtr(nCameras + (nCamerasIndex * Marshal.SizeOf(nCameras))));
					if (csTcamerasPtr == IntPtr.Zero) {
						csTcameras = new LocalCamera(Marshal.ReadIntPtr(nCameras + (nCamerasIndex * Marshal.SizeOf(nCameras))));
						if (csTcameras != null) {
							csR?.objects?.Add(new WeakReference(csTcameras));
						}
					} else {
						csTcameras = (LocalCamera)GCHandle.FromIntPtr(csTcamerasPtr).Target;
					}
				}

				csCameras.Add(csTcameras);
				nCamerasIndex++;
			}

			csR?._mIGetSelectedLocalCameras?.OnGetSelectedLocalCamerasComplete(csCameras);
			VidyoRoomOnGetSelectedLocalCamerasCompleteFreecamerasArrayNative(nCameras, nCamerasSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetSelectedLocalMicrophonesComplete))]
#endif
		private static void OnGetSelectedLocalMicrophonesCompleteDelegate(IntPtr r, IntPtr microphones){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			List<LocalMicrophone> csMicrophones = new List<LocalMicrophone>();
			var nMicrophonesSize = 0;
			var nMicrophones = VidyoRoomOnGetSelectedLocalMicrophonesCompleteGetmicrophonesArrayNative(microphones, ref nMicrophonesSize);
			var nMicrophonesIndex = 0;
			while (nMicrophonesIndex < nMicrophonesSize) {
				LocalMicrophone csTmicrophones = null;
				if(Marshal.ReadIntPtr(nMicrophones + (nMicrophonesIndex * Marshal.SizeOf(nMicrophones))) != IntPtr.Zero) {
					var csTmicrophonesPtr = LocalMicrophone.VidyoLocalMicrophoneGetUserDataNative(Marshal.ReadIntPtr(nMicrophones + (nMicrophonesIndex * Marshal.SizeOf(nMicrophones))));
					if (csTmicrophonesPtr == IntPtr.Zero) {
						csTmicrophones = new LocalMicrophone(Marshal.ReadIntPtr(nMicrophones + (nMicrophonesIndex * Marshal.SizeOf(nMicrophones))));
						if (csTmicrophones != null) {
							csR?.objects?.Add(new WeakReference(csTmicrophones));
						}
					} else {
						csTmicrophones = (LocalMicrophone)GCHandle.FromIntPtr(csTmicrophonesPtr).Target;
					}
				}

				csMicrophones.Add(csTmicrophones);
				nMicrophonesIndex++;
			}

			csR?._mIGetSelectedLocalMicrophones?.OnGetSelectedLocalMicrophonesComplete(csMicrophones);
			VidyoRoomOnGetSelectedLocalMicrophonesCompleteFreemicrophonesArrayNative(nMicrophones, nMicrophonesSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetSelectedLocalMonitorsComplete))]
#endif
		private static void OnGetSelectedLocalMonitorsCompleteDelegate(IntPtr r, IntPtr monitors){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			List<LocalMonitor> csMonitors = new List<LocalMonitor>();
			var nMonitorsSize = 0;
			var nMonitors = VidyoRoomOnGetSelectedLocalMonitorsCompleteGetmonitorsArrayNative(monitors, ref nMonitorsSize);
			var nMonitorsIndex = 0;
			while (nMonitorsIndex < nMonitorsSize) {
				LocalMonitor csTmonitors = null;
				if(Marshal.ReadIntPtr(nMonitors + (nMonitorsIndex * Marshal.SizeOf(nMonitors))) != IntPtr.Zero) {
					var csTmonitorsPtr = LocalMonitor.VidyoLocalMonitorGetUserDataNative(Marshal.ReadIntPtr(nMonitors + (nMonitorsIndex * Marshal.SizeOf(nMonitors))));
					if (csTmonitorsPtr == IntPtr.Zero) {
						csTmonitors = new LocalMonitor(Marshal.ReadIntPtr(nMonitors + (nMonitorsIndex * Marshal.SizeOf(nMonitors))));
						if (csTmonitors != null) {
							csR?.objects?.Add(new WeakReference(csTmonitors));
						}
					} else {
						csTmonitors = (LocalMonitor)GCHandle.FromIntPtr(csTmonitorsPtr).Target;
					}
				}

				csMonitors.Add(csTmonitors);
				nMonitorsIndex++;
			}

			csR?._mIGetSelectedLocalMonitors?.OnGetSelectedLocalMonitorsComplete(csMonitors);
			VidyoRoomOnGetSelectedLocalMonitorsCompleteFreemonitorsArrayNative(nMonitors, nMonitorsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetSelectedLocalRenderersComplete))]
#endif
		private static void OnGetSelectedLocalRenderersCompleteDelegate(IntPtr r, IntPtr renderers){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			List<LocalRenderer> csRenderers = new List<LocalRenderer>();
			var nRenderersSize = 0;
			var nRenderers = VidyoRoomOnGetSelectedLocalRenderersCompleteGetrenderersArrayNative(renderers, ref nRenderersSize);
			var nRenderersIndex = 0;
			while (nRenderersIndex < nRenderersSize) {
				LocalRenderer csTrenderers = null;
				if(Marshal.ReadIntPtr(nRenderers + (nRenderersIndex * Marshal.SizeOf(nRenderers))) != IntPtr.Zero) {
					var csTrenderersPtr = LocalRenderer.VidyoLocalRendererGetUserDataNative(Marshal.ReadIntPtr(nRenderers + (nRenderersIndex * Marshal.SizeOf(nRenderers))));
					if (csTrenderersPtr == IntPtr.Zero) {
						csTrenderers = new LocalRenderer(Marshal.ReadIntPtr(nRenderers + (nRenderersIndex * Marshal.SizeOf(nRenderers))));
						if (csTrenderers != null) {
							csR?.objects?.Add(new WeakReference(csTrenderers));
						}
					} else {
						csTrenderers = (LocalRenderer)GCHandle.FromIntPtr(csTrenderersPtr).Target;
					}
				}

				csRenderers.Add(csTrenderers);
				nRenderersIndex++;
			}

			csR?._mIGetSelectedLocalRenderers?.OnGetSelectedLocalRenderersComplete(csRenderers);
			VidyoRoomOnGetSelectedLocalRenderersCompleteFreerenderersArrayNative(nRenderers, nRenderersSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetSelectedLocalSpeakersComplete))]
#endif
		private static void OnGetSelectedLocalSpeakersCompleteDelegate(IntPtr r, IntPtr speakers){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			List<LocalSpeaker> csSpeakers = new List<LocalSpeaker>();
			var nSpeakersSize = 0;
			var nSpeakers = VidyoRoomOnGetSelectedLocalSpeakersCompleteGetspeakersArrayNative(speakers, ref nSpeakersSize);
			var nSpeakersIndex = 0;
			while (nSpeakersIndex < nSpeakersSize) {
				LocalSpeaker csTspeakers = null;
				if(Marshal.ReadIntPtr(nSpeakers + (nSpeakersIndex * Marshal.SizeOf(nSpeakers))) != IntPtr.Zero) {
					var csTspeakersPtr = LocalSpeaker.VidyoLocalSpeakerGetUserDataNative(Marshal.ReadIntPtr(nSpeakers + (nSpeakersIndex * Marshal.SizeOf(nSpeakers))));
					if (csTspeakersPtr == IntPtr.Zero) {
						csTspeakers = new LocalSpeaker(Marshal.ReadIntPtr(nSpeakers + (nSpeakersIndex * Marshal.SizeOf(nSpeakers))));
						if (csTspeakers != null) {
							csR?.objects?.Add(new WeakReference(csTspeakers));
						}
					} else {
						csTspeakers = (LocalSpeaker)GCHandle.FromIntPtr(csTspeakersPtr).Target;
					}
				}

				csSpeakers.Add(csTspeakers);
				nSpeakersIndex++;
			}

			csR?._mIGetSelectedLocalSpeakers?.OnGetSelectedLocalSpeakersComplete(csSpeakers);
			VidyoRoomOnGetSelectedLocalSpeakersCompleteFreespeakersArrayNative(nSpeakers, nSpeakersSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnGetSelectedLocalWindowSharesComplete))]
#endif
		private static void OnGetSelectedLocalWindowSharesCompleteDelegate(IntPtr r, IntPtr windowShares){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			List<LocalWindowShare> csWindowShares = new List<LocalWindowShare>();
			var nWindowSharesSize = 0;
			var nWindowShares = VidyoRoomOnGetSelectedLocalWindowSharesCompleteGetwindowSharesArrayNative(windowShares, ref nWindowSharesSize);
			var nWindowSharesIndex = 0;
			while (nWindowSharesIndex < nWindowSharesSize) {
				LocalWindowShare csTwindowShares = null;
				if(Marshal.ReadIntPtr(nWindowShares + (nWindowSharesIndex * Marshal.SizeOf(nWindowShares))) != IntPtr.Zero) {
					var csTwindowSharesPtr = LocalWindowShare.VidyoLocalWindowShareGetUserDataNative(Marshal.ReadIntPtr(nWindowShares + (nWindowSharesIndex * Marshal.SizeOf(nWindowShares))));
					if (csTwindowSharesPtr == IntPtr.Zero) {
						csTwindowShares = new LocalWindowShare(Marshal.ReadIntPtr(nWindowShares + (nWindowSharesIndex * Marshal.SizeOf(nWindowShares))));
						if (csTwindowShares != null) {
							csR?.objects?.Add(new WeakReference(csTwindowShares));
						}
					} else {
						csTwindowShares = (LocalWindowShare)GCHandle.FromIntPtr(csTwindowSharesPtr).Target;
					}
				}

				csWindowShares.Add(csTwindowShares);
				nWindowSharesIndex++;
			}

			csR?._mIGetSelectedLocalWindowShares?.OnGetSelectedLocalWindowSharesComplete(csWindowShares);
			VidyoRoomOnGetSelectedLocalWindowSharesCompleteFreewindowSharesArrayNative(nWindowShares, nWindowSharesSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnHandRaised))]
#endif
		private static void OnHandRaisedDelegate(IntPtr room, IntPtr participant){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			List<Participant> csParticipant = new List<Participant>();
			var nParticipantSize = 0;
			var nParticipant = VidyoRoomOnHandRaisedGetparticipantArrayNative(participant, ref nParticipantSize);
			var nParticipantIndex = 0;
			while (nParticipantIndex < nParticipantSize) {
				Participant csTparticipant = null;
				if(Marshal.ReadIntPtr(nParticipant + (nParticipantIndex * Marshal.SizeOf(nParticipant))) != IntPtr.Zero) {
					var csTparticipantPtr = Participant.VidyoParticipantGetUserDataNative(Marshal.ReadIntPtr(nParticipant + (nParticipantIndex * Marshal.SizeOf(nParticipant))));
					if (csTparticipantPtr == IntPtr.Zero) {
						csTparticipant = new Participant(Marshal.ReadIntPtr(nParticipant + (nParticipantIndex * Marshal.SizeOf(nParticipant))));
						if (csTparticipant != null) {
							csRoom?.objects?.Add(new WeakReference(csTparticipant));
						}
					} else {
						csTparticipant = (Participant)GCHandle.FromIntPtr(csTparticipantPtr).Target;
					}
				}

				csParticipant.Add(csTparticipant);
				nParticipantIndex++;
			}

			csRoom?._mIRegisterLectureModeEventListener?.OnHandRaised(csParticipant);
			VidyoRoomOnHandRaisedFreeparticipantArrayNative(nParticipant, nParticipantSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnInCallEvents))]
#endif
		private static void OnInCallEventsDelegate(IntPtr r, IntPtr ev){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			RoomInCallEvent csEv = new RoomInCallEvent(ev);
			csR?._mIRegisterInCallEventListener?.OnInCallEvents(csEv);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnIncomingEntered))]
#endif
		private static void OnIncomingEnteredDelegate(IntPtr room, RoomEnterResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIAcceptIncoming?.OnIncomingEntered(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnIncomingExited))]
#endif
		private static void OnIncomingExitedDelegate(IntPtr room, RoomExitReason reason){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIAcceptIncoming?.OnIncomingExited(reason);
			csRoom?.objects?.RemoveAll(item => (!item.IsAlive || item.Target == null));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnInviteResult))]
#endif
		private static void OnInviteResultDelegate(IntPtr room, IntPtr inviteeId, RoomInviteResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			var n_inviteeId = VidyoRoomOnInviteResultGetinviteeIdCStr(inviteeId);

			csRoom?._mIInvite?.OnInviteResult((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_inviteeId), result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLockRoomResult))]
#endif
		private static void OnLockRoomResultDelegate(IntPtr room, RoomSetPropertiesResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mILockRoom?.OnLockRoomResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnLoudestParticipantChanged))]
#endif
		private static void OnLoudestParticipantChangedDelegate(IntPtr room, IntPtr participant, Boolean isAudioOnly, Boolean isStatic){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csRoom?._mIRegisterParticipantEventListener?.OnLoudestParticipantChanged(csParticipant, isAudioOnly, isStatic);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMaxRemoteSourcesChanged))]
#endif
		private static void OnMaxRemoteSourcesChangedDelegate(IntPtr room, uint maxRemoteSources){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterResourceManagerEventListener?.OnMaxRemoteSourcesChanged(maxRemoteSources);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMediaDisabled))]
#endif
		private static void OnMediaDisabledDelegate(IntPtr room, RoomMediaDisableReason reason){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIEnableMedia?.OnMediaDisabled(reason);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMediaEnabled))]
#endif
		private static void OnMediaEnabledDelegate(IntPtr room){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIEnableMedia?.OnMediaEnabled();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMediaFailed))]
#endif
		private static void OnMediaFailedDelegate(IntPtr room, RoomMediaFailReason reason){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIEnableMedia?.OnMediaFailed(reason);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMediaRouteAcquireFailed))]
#endif
		private static void OnMediaRouteAcquireFailedDelegate(IntPtr room, RoomMediaFailReason reason){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIAcquireMediaRoute?.OnMediaRouteAcquireFailed(reason);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMediaRouteAcquired))]
#endif
		private static void OnMediaRouteAcquiredDelegate(IntPtr room){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIAcquireMediaRoute?.OnMediaRouteAcquired();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMessageAcknowledged))]
#endif
		private static void OnMessageAcknowledgedDelegate(IntPtr room, IntPtr chatMessage){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			ChatMessage csChatMessage = new ChatMessage(chatMessage);
			csRoom?._mIRegisterMessageEventListener?.OnMessageAcknowledged(csChatMessage);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMessageRead))]
#endif
		private static void OnMessageReadDelegate(IntPtr room, IntPtr participant, long messageId){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csRoom?._mIRegisterMessageEventListener?.OnMessageRead(csParticipant, messageId);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMessageReceived))]
#endif
		private static void OnMessageReceivedDelegate(IntPtr room, IntPtr participant, IntPtr chatMessage){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			ChatMessage csChatMessage = new ChatMessage(chatMessage);
			csRoom?._mIRegisterMessageEventListener?.OnMessageReceived(csParticipant, csChatMessage);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMessageSearchResults))]
#endif
		private static void OnMessageSearchResultsDelegate(IntPtr room, IntPtr searchText, IntPtr records, RoomSearchResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			List<ChatMessage> csRecords = new List<ChatMessage>();
			var nRecordsSize = 0;
			var nRecords = VidyoRoomOnMessageSearchResultsGetrecordsArrayNative(records, ref nRecordsSize);
			var nRecordsIndex = 0;
			while (nRecordsIndex < nRecordsSize) {
				ChatMessage csTrecords = new ChatMessage(Marshal.ReadIntPtr(nRecords + (nRecordsIndex * Marshal.SizeOf(nRecords))));
				csRecords.Add(csTrecords);
				nRecordsIndex++;
			}

			csRoom?._mIMessageSearch?.OnMessageSearchResults((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(searchText), csRecords, result);
			VidyoRoomOnMessageSearchResultsFreerecordsArrayNative(nRecords, nRecordsSize);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnMessageTypingIndication))]
#endif
		private static void OnMessageTypingIndicationDelegate(IntPtr room, IntPtr participant, ChatMessage.ChatMessageTypingIndication typingIndication){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csRoom?._mIRegisterMessageEventListener?.OnMessageTypingIndication(csParticipant, typingIndication);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnModerationCommandReceived))]
#endif
		private static void OnModerationCommandReceivedDelegate(IntPtr room, Device.DeviceType deviceType, RoomModerationType moderationType, Boolean state){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterModerationCommandEventListener?.OnModerationCommandReceived(deviceType, moderationType, state);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnModerationResult))]
#endif
		private static void OnModerationResultDelegate(IntPtr room, IntPtr participant, RoomModerationResult result, RoomModerationActionType actionType, IntPtr requestId){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			var n_requestId = VidyoRoomOnModerationResultGetrequestIdCStr(requestId);

			csRoom?._mIRegisterModerationResultEventListener?.OnModerationResult(csParticipant, result, actionType, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_requestId));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnParticipantJoined))]
#endif
		private static void OnParticipantJoinedDelegate(IntPtr room, IntPtr participant){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}
			if(csRoom != null && csParticipant != null)
				csRoom.GetParticipantsMap()[csParticipant.GetId()] = csParticipant;

			csRoom?._mIRegisterParticipantEventListener?.OnParticipantJoined(csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnParticipantLeft))]
#endif
		private static void OnParticipantLeftDelegate(IntPtr room, IntPtr participant){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}
			csRoom?.GetParticipantsMap()?.Remove(csParticipant?.GetId() ?? string.Empty);

			csRoom?._mIRegisterParticipantEventListener?.OnParticipantLeft(csParticipant);
			if(csRoom?._mIRegisterParticipantEventListener == null) csParticipant?.Dispose();
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPipLocationChanged))]
#endif
		private static void OnPipLocationChangedDelegate(IntPtr room, int x, int y, uint width, uint height, Boolean isExpanded){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterPipEventListener?.OnPipLocationChanged(x, y, width, height, isExpanded);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnPresenterChanged))]
#endif
		private static void OnPresenterChangedDelegate(IntPtr room, IntPtr participant){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			Participant csParticipant = null;
			if(participant != IntPtr.Zero) {
				var csParticipantPtr = Participant.VidyoParticipantGetUserDataNative(participant);
				if (csParticipantPtr == IntPtr.Zero) {
					csParticipant = new Participant(participant);
					if (csParticipant != null) {
						csRoom?.objects?.Add(new WeakReference(csParticipant));
					}
				} else {
					csParticipant = (Participant)GCHandle.FromIntPtr(csParticipantPtr).Target;
				}
			}

			csRoom?._mIRegisterLectureModeEventListener?.OnPresenterChanged(csParticipant);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRaiseHandResponse))]
#endif
		private static void OnRaiseHandResponseDelegate(IntPtr r, Participant.ParticipantHandState handState){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIRaiseHand?.OnRaiseHandResponse(handState);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServicePauseResult))]
#endif
		private static void OnRecordingServicePauseResultDelegate(IntPtr r, RoomSetPropertiesResult result){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIPauseRecording?.OnRecordingServicePauseResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServiceResumeResult))]
#endif
		private static void OnRecordingServiceResumeResultDelegate(IntPtr r, RoomSetPropertiesResult result){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIResumeRecording?.OnRecordingServiceResumeResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServiceStartResult))]
#endif
		private static void OnRecordingServiceStartResultDelegate(IntPtr r, RoomSetPropertiesResult result){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIStartRecording?.OnRecordingServiceStartResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRecordingServiceStopResult))]
#endif
		private static void OnRecordingServiceStopResultDelegate(IntPtr r, RoomSetPropertiesResult result){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIStopRecording?.OnRecordingServiceStopResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRemoveRoomPINResult))]
#endif
		private static void OnRemoveRoomPINResultDelegate(IntPtr room, RoomSetPropertiesResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRemoveRoomPIN?.OnRemoveRoomPINResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRequestRoleChangeResult))]
#endif
		private static void OnRequestRoleChangeResultDelegate(IntPtr room, RoomRequestRoleChangeResult result, IntPtr requestId){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			var n_requestId = VidyoRoomOnRequestRoleChangeResultGetrequestIdCStr(requestId);

			csRoom?._mIRequestRoleChange?.OnRequestRoleChangeResult(result, (string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(n_requestId));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnRoomPropertiesChanged))]
#endif
		private static void OnRoomPropertiesChangedDelegate(IntPtr room, IntPtr roomProperties){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			RoomProperties csRoomProperties = new RoomProperties(roomProperties);
			csRoom?._mIRegisterRoomPropertiesEventListener?.OnRoomPropertiesChanged(csRoomProperties);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSetFavoriteResult))]
#endif
		private static void OnSetFavoriteResultDelegate(IntPtr room, Boolean isFavorite, RoomSetFavoriteResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mISetFavorite?.OnSetFavoriteResult(isFavorite, result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSetRoomPINResult))]
#endif
		private static void OnSetRoomPINResultDelegate(IntPtr room, RoomSetPropertiesResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mISetRoomPIN?.OnSetRoomPINResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSetRoomPropertiesResult))]
#endif
		private static void OnSetRoomPropertiesResultDelegate(IntPtr room, RoomSetPropertiesResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mISetRoomProperties?.OnSetRoomPropertiesResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSetRoomPropertyResult))]
#endif
		private static void OnSetRoomPropertyResultDelegate(IntPtr room, RoomSetPropertiesResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mISetDefaultProfile?.OnSetRoomPropertyResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnSetSubject))]
#endif
		private static void OnSetSubjectDelegate(IntPtr room, IntPtr subject){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterSubjectEventListener?.OnSetSubject((string)MarshalPtrToUtf8.GetInstance().MarshalNativeToManaged(subject));
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUnlockRoomResult))]
#endif
		private static void OnUnlockRoomResultDelegate(IntPtr room, RoomSetPropertiesResult result){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIUnlockRoom?.OnUnlockRoomResult(result);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUnprocessedAudioStarted))]
#endif
		private static void OnUnprocessedAudioStartedDelegate(IntPtr room, Boolean started){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterUnprocessedAudioEventListener?.OnUnprocessedAudioStarted(started);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(OnUnprocessedAudioSupportChanged))]
#endif
		private static void OnUnprocessedAudioSupportChangedDelegate(IntPtr room, Boolean supported){
			var csRoomPtr = room != IntPtr.Zero ? VidyoRoomGetUserDataNative(room) : IntPtr.Zero;
			if(csRoomPtr == IntPtr.Zero) return;
			var csRoom = (Room)GCHandle.FromIntPtr(csRoomPtr).Target;

			csRoom?._mIRegisterUnprocessedAudioEventListener?.OnUnprocessedAudioSupportChanged(supported);
		}
#if __IOS__
[ObjCRuntime.MonoPInvokeCallback(typeof(RecorderInCall))]
#endif
		private static void RecorderInCallDelegate(IntPtr r, Boolean hasRecorder, Boolean isPaused){
			var csRPtr = r != IntPtr.Zero ? VidyoRoomGetUserDataNative(r) : IntPtr.Zero;
			if(csRPtr == IntPtr.Zero) return;
			var csR = (Room)GCHandle.FromIntPtr(csRPtr).Target;

			csR?._mIRegisterRecorderInCallEventListener?.RecorderInCall(hasRecorder, isPaused);
		}
	};
}
