'use strict';

const prefabs = require("bnb_js/prefabs");
const default_threshold = 0.95;
const default_contour = 0.5;
const default_weakness = 0.5;
const default_multiplier = 1.5;
const default_alpha = 0.7;

class LipsGlare extends prefabs.Base {
    constructor() {
        super();

        this.params = new bnb.FeatureParameter(default_threshold, default_contour, default_weakness);

        const assets = bnb.scene.getAssetManager();
        this.material = assets.findMaterial("shaders/lips_glare");
        this.max_brightness_param = this.material.findParameter("lips_glare_max_brightness");
        this.multiplier_alpha_param = this.material.findParameter("lips_glare_multiplier_alpha");

        this.multiplier_value = default_multiplier;
        this.alpha_value = default_alpha;

        bnb.eventListener.on("onLateUpdate", (fd)=> {
            const lg_param = fd.getLipsGlareMaxBrightness();
            this.max_brightness_param.setVector4(new bnb.Vec4(lg_param, 0.0, 0.0, 0.0));
        });
    }
    
    threshold(value) {
        this.params.x = value;
        bnb.scene.addFeatureParam(bnb.FeatureID.LIPS_GLARE, [this.params]);
    }
    
    contour(value) {
        this.params.y = value;
        bnb.scene.addFeatureParam(bnb.FeatureID.LIPS_GLARE, [this.params]);
    }
    
    weakness(value) {
        this.params.z = value;
        bnb.scene.addFeatureParam(bnb.FeatureID.LIPS_GLARE, [this.params]);
    }

    multiplier(value) {
        this.multiplier_value = value;
        this.multiplier_alpha_param.setVector4(new bnb.Vec4(this.multiplier_value, this.alpha_value, 0.0, 0.0));
    }
    
    alpha(value) {
        this.alpha_value = value;
        this.multiplier_alpha_param.setVector4(new bnb.Vec4(this.multiplier_value, this.alpha_value, 0.0, 0.0));
    }
    
    clear() {
        this.max_brightness_param.setVector4(new bnb.Vec4(0.0, 0.0, 0.0, 0.0));
        this.multiplier(default_multiplier);
        this.alpha(default_alpha);
        
        this.params.x = default_threshold;
        this.params.y = default_contour;
        this.params.z = default_weakness;
        bnb.scene.addFeatureParam(bnb.FeatureID.LIPS_GLARE, [this.params]);
    }
}

exports = {
    LipsGlare
}
